/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a <code>FunnelChartVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunnelChartConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FunnelChartConfiguration.Builder, FunnelChartConfiguration> {
    private static final SdkField<FunnelChartFieldWells> FIELD_WELLS_FIELD = SdkField
            .<FunnelChartFieldWells> builder(MarshallingType.SDK_POJO).memberName("FieldWells")
            .getter(getter(FunnelChartConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(FunnelChartFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<FunnelChartSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField
            .<FunnelChartSortConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortConfiguration")
            .getter(getter(FunnelChartConfiguration::sortConfiguration)).setter(setter(Builder::sortConfiguration))
            .constructor(FunnelChartSortConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()).build();

    private static final SdkField<ChartAxisLabelOptions> CATEGORY_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("CategoryLabelOptions")
            .getter(getter(FunnelChartConfiguration::categoryLabelOptions)).setter(setter(Builder::categoryLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryLabelOptions").build())
            .build();

    private static final SdkField<ChartAxisLabelOptions> VALUE_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("ValueLabelOptions")
            .getter(getter(FunnelChartConfiguration::valueLabelOptions)).setter(setter(Builder::valueLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueLabelOptions").build()).build();

    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.<TooltipOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Tooltip").getter(getter(FunnelChartConfiguration::tooltip)).setter(setter(Builder::tooltip))
            .constructor(TooltipOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()).build();

    private static final SdkField<FunnelChartDataLabelOptions> DATA_LABEL_OPTIONS_FIELD = SdkField
            .<FunnelChartDataLabelOptions> builder(MarshallingType.SDK_POJO).memberName("DataLabelOptions")
            .getter(getter(FunnelChartConfiguration::dataLabelOptions)).setter(setter(Builder::dataLabelOptions))
            .constructor(FunnelChartDataLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLabelOptions").build()).build();

    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField
            .<VisualPalette> builder(MarshallingType.SDK_POJO).memberName("VisualPalette")
            .getter(getter(FunnelChartConfiguration::visualPalette)).setter(setter(Builder::visualPalette))
            .constructor(VisualPalette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()).build();

    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField
            .<VisualInteractionOptions> builder(MarshallingType.SDK_POJO).memberName("Interactions")
            .getter(getter(FunnelChartConfiguration::interactions)).setter(setter(Builder::interactions))
            .constructor(VisualInteractionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            SORT_CONFIGURATION_FIELD, CATEGORY_LABEL_OPTIONS_FIELD, VALUE_LABEL_OPTIONS_FIELD, TOOLTIP_FIELD,
            DATA_LABEL_OPTIONS_FIELD, VISUAL_PALETTE_FIELD, INTERACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FunnelChartFieldWells fieldWells;

    private final FunnelChartSortConfiguration sortConfiguration;

    private final ChartAxisLabelOptions categoryLabelOptions;

    private final ChartAxisLabelOptions valueLabelOptions;

    private final TooltipOptions tooltip;

    private final FunnelChartDataLabelOptions dataLabelOptions;

    private final VisualPalette visualPalette;

    private final VisualInteractionOptions interactions;

    private FunnelChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.categoryLabelOptions = builder.categoryLabelOptions;
        this.valueLabelOptions = builder.valueLabelOptions;
        this.tooltip = builder.tooltip;
        this.dataLabelOptions = builder.dataLabelOptions;
        this.visualPalette = builder.visualPalette;
        this.interactions = builder.interactions;
    }

    /**
     * <p>
     * The field well configuration of a <code>FunnelChartVisual</code>.
     * </p>
     * 
     * @return The field well configuration of a <code>FunnelChartVisual</code>.
     */
    public final FunnelChartFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The sort configuration of a <code>FunnelChartVisual</code>.
     * </p>
     * 
     * @return The sort configuration of a <code>FunnelChartVisual</code>.
     */
    public final FunnelChartSortConfiguration sortConfiguration() {
        return sortConfiguration;
    }

    /**
     * <p>
     * The label options of the categories that are displayed in a <code>FunnelChartVisual</code>.
     * </p>
     * 
     * @return The label options of the categories that are displayed in a <code>FunnelChartVisual</code>.
     */
    public final ChartAxisLabelOptions categoryLabelOptions() {
        return categoryLabelOptions;
    }

    /**
     * <p>
     * The label options for the values that are displayed in a <code>FunnelChartVisual</code>.
     * </p>
     * 
     * @return The label options for the values that are displayed in a <code>FunnelChartVisual</code>.
     */
    public final ChartAxisLabelOptions valueLabelOptions() {
        return valueLabelOptions;
    }

    /**
     * <p>
     * The tooltip configuration of a <code>FunnelChartVisual</code>.
     * </p>
     * 
     * @return The tooltip configuration of a <code>FunnelChartVisual</code>.
     */
    public final TooltipOptions tooltip() {
        return tooltip;
    }

    /**
     * <p>
     * The options that determine the presentation of the data labels.
     * </p>
     * 
     * @return The options that determine the presentation of the data labels.
     */
    public final FunnelChartDataLabelOptions dataLabelOptions() {
        return dataLabelOptions;
    }

    /**
     * <p>
     * The visual palette configuration of a <code>FunnelChartVisual</code>.
     * </p>
     * 
     * @return The visual palette configuration of a <code>FunnelChartVisual</code>.
     */
    public final VisualPalette visualPalette() {
        return visualPalette;
    }

    /**
     * <p>
     * The general visual interactions setup for a visual.
     * </p>
     * 
     * @return The general visual interactions setup for a visual.
     */
    public final VisualInteractionOptions interactions() {
        return interactions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(categoryLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(valueLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(dataLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(visualPalette());
        hashCode = 31 * hashCode + Objects.hashCode(interactions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunnelChartConfiguration)) {
            return false;
        }
        FunnelChartConfiguration other = (FunnelChartConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells()) && Objects.equals(sortConfiguration(), other.sortConfiguration())
                && Objects.equals(categoryLabelOptions(), other.categoryLabelOptions())
                && Objects.equals(valueLabelOptions(), other.valueLabelOptions()) && Objects.equals(tooltip(), other.tooltip())
                && Objects.equals(dataLabelOptions(), other.dataLabelOptions())
                && Objects.equals(visualPalette(), other.visualPalette()) && Objects.equals(interactions(), other.interactions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FunnelChartConfiguration").add("FieldWells", fieldWells())
                .add("SortConfiguration", sortConfiguration()).add("CategoryLabelOptions", categoryLabelOptions())
                .add("ValueLabelOptions", valueLabelOptions()).add("Tooltip", tooltip())
                .add("DataLabelOptions", dataLabelOptions()).add("VisualPalette", visualPalette())
                .add("Interactions", interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "SortConfiguration":
            return Optional.ofNullable(clazz.cast(sortConfiguration()));
        case "CategoryLabelOptions":
            return Optional.ofNullable(clazz.cast(categoryLabelOptions()));
        case "ValueLabelOptions":
            return Optional.ofNullable(clazz.cast(valueLabelOptions()));
        case "Tooltip":
            return Optional.ofNullable(clazz.cast(tooltip()));
        case "DataLabelOptions":
            return Optional.ofNullable(clazz.cast(dataLabelOptions()));
        case "VisualPalette":
            return Optional.ofNullable(clazz.cast(visualPalette()));
        case "Interactions":
            return Optional.ofNullable(clazz.cast(interactions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldWells", FIELD_WELLS_FIELD);
        map.put("SortConfiguration", SORT_CONFIGURATION_FIELD);
        map.put("CategoryLabelOptions", CATEGORY_LABEL_OPTIONS_FIELD);
        map.put("ValueLabelOptions", VALUE_LABEL_OPTIONS_FIELD);
        map.put("Tooltip", TOOLTIP_FIELD);
        map.put("DataLabelOptions", DATA_LABEL_OPTIONS_FIELD);
        map.put("VisualPalette", VISUAL_PALETTE_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FunnelChartConfiguration, T> g) {
        return obj -> g.apply((FunnelChartConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunnelChartConfiguration> {
        /**
         * <p>
         * The field well configuration of a <code>FunnelChartVisual</code>.
         * </p>
         * 
         * @param fieldWells
         *        The field well configuration of a <code>FunnelChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(FunnelChartFieldWells fieldWells);

        /**
         * <p>
         * The field well configuration of a <code>FunnelChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link FunnelChartFieldWells.Builder} avoiding
         * the need to create one manually via {@link FunnelChartFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunnelChartFieldWells.Builder#build()} is called immediately and
         * its result is passed to {@link #fieldWells(FunnelChartFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link FunnelChartFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(FunnelChartFieldWells)
         */
        default Builder fieldWells(Consumer<FunnelChartFieldWells.Builder> fieldWells) {
            return fieldWells(FunnelChartFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The sort configuration of a <code>FunnelChartVisual</code>.
         * </p>
         * 
         * @param sortConfiguration
         *        The sort configuration of a <code>FunnelChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortConfiguration(FunnelChartSortConfiguration sortConfiguration);

        /**
         * <p>
         * The sort configuration of a <code>FunnelChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link FunnelChartSortConfiguration.Builder}
         * avoiding the need to create one manually via {@link FunnelChartSortConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunnelChartSortConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sortConfiguration(FunnelChartSortConfiguration)}.
         * 
         * @param sortConfiguration
         *        a consumer that will call methods on {@link FunnelChartSortConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortConfiguration(FunnelChartSortConfiguration)
         */
        default Builder sortConfiguration(Consumer<FunnelChartSortConfiguration.Builder> sortConfiguration) {
            return sortConfiguration(FunnelChartSortConfiguration.builder().applyMutation(sortConfiguration).build());
        }

        /**
         * <p>
         * The label options of the categories that are displayed in a <code>FunnelChartVisual</code>.
         * </p>
         * 
         * @param categoryLabelOptions
         *        The label options of the categories that are displayed in a <code>FunnelChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions);

        /**
         * <p>
         * The label options of the categories that are displayed in a <code>FunnelChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #categoryLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param categoryLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryLabelOptions(ChartAxisLabelOptions)
         */
        default Builder categoryLabelOptions(Consumer<ChartAxisLabelOptions.Builder> categoryLabelOptions) {
            return categoryLabelOptions(ChartAxisLabelOptions.builder().applyMutation(categoryLabelOptions).build());
        }

        /**
         * <p>
         * The label options for the values that are displayed in a <code>FunnelChartVisual</code>.
         * </p>
         * 
         * @param valueLabelOptions
         *        The label options for the values that are displayed in a <code>FunnelChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueLabelOptions(ChartAxisLabelOptions valueLabelOptions);

        /**
         * <p>
         * The label options for the values that are displayed in a <code>FunnelChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #valueLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param valueLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueLabelOptions(ChartAxisLabelOptions)
         */
        default Builder valueLabelOptions(Consumer<ChartAxisLabelOptions.Builder> valueLabelOptions) {
            return valueLabelOptions(ChartAxisLabelOptions.builder().applyMutation(valueLabelOptions).build());
        }

        /**
         * <p>
         * The tooltip configuration of a <code>FunnelChartVisual</code>.
         * </p>
         * 
         * @param tooltip
         *        The tooltip configuration of a <code>FunnelChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooltip(TooltipOptions tooltip);

        /**
         * <p>
         * The tooltip configuration of a <code>FunnelChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TooltipOptions.Builder} avoiding the need
         * to create one manually via {@link TooltipOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TooltipOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #tooltip(TooltipOptions)}.
         * 
         * @param tooltip
         *        a consumer that will call methods on {@link TooltipOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tooltip(TooltipOptions)
         */
        default Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return tooltip(TooltipOptions.builder().applyMutation(tooltip).build());
        }

        /**
         * <p>
         * The options that determine the presentation of the data labels.
         * </p>
         * 
         * @param dataLabelOptions
         *        The options that determine the presentation of the data labels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLabelOptions(FunnelChartDataLabelOptions dataLabelOptions);

        /**
         * <p>
         * The options that determine the presentation of the data labels.
         * </p>
         * This is a convenience method that creates an instance of the {@link FunnelChartDataLabelOptions.Builder}
         * avoiding the need to create one manually via {@link FunnelChartDataLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunnelChartDataLabelOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #dataLabelOptions(FunnelChartDataLabelOptions)}.
         * 
         * @param dataLabelOptions
         *        a consumer that will call methods on {@link FunnelChartDataLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataLabelOptions(FunnelChartDataLabelOptions)
         */
        default Builder dataLabelOptions(Consumer<FunnelChartDataLabelOptions.Builder> dataLabelOptions) {
            return dataLabelOptions(FunnelChartDataLabelOptions.builder().applyMutation(dataLabelOptions).build());
        }

        /**
         * <p>
         * The visual palette configuration of a <code>FunnelChartVisual</code>.
         * </p>
         * 
         * @param visualPalette
         *        The visual palette configuration of a <code>FunnelChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualPalette(VisualPalette visualPalette);

        /**
         * <p>
         * The visual palette configuration of a <code>FunnelChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualPalette.Builder} avoiding the need
         * to create one manually via {@link VisualPalette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualPalette.Builder#build()} is called immediately and its
         * result is passed to {@link #visualPalette(VisualPalette)}.
         * 
         * @param visualPalette
         *        a consumer that will call methods on {@link VisualPalette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualPalette(VisualPalette)
         */
        default Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return visualPalette(VisualPalette.builder().applyMutation(visualPalette).build());
        }

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * 
         * @param interactions
         *        The general visual interactions setup for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactions(VisualInteractionOptions interactions);

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualInteractionOptions.Builder}
         * avoiding the need to create one manually via {@link VisualInteractionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualInteractionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #interactions(VisualInteractionOptions)}.
         * 
         * @param interactions
         *        a consumer that will call methods on {@link VisualInteractionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interactions(VisualInteractionOptions)
         */
        default Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return interactions(VisualInteractionOptions.builder().applyMutation(interactions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FunnelChartFieldWells fieldWells;

        private FunnelChartSortConfiguration sortConfiguration;

        private ChartAxisLabelOptions categoryLabelOptions;

        private ChartAxisLabelOptions valueLabelOptions;

        private TooltipOptions tooltip;

        private FunnelChartDataLabelOptions dataLabelOptions;

        private VisualPalette visualPalette;

        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(FunnelChartConfiguration model) {
            fieldWells(model.fieldWells);
            sortConfiguration(model.sortConfiguration);
            categoryLabelOptions(model.categoryLabelOptions);
            valueLabelOptions(model.valueLabelOptions);
            tooltip(model.tooltip);
            dataLabelOptions(model.dataLabelOptions);
            visualPalette(model.visualPalette);
            interactions(model.interactions);
        }

        public final FunnelChartFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(FunnelChartFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(FunnelChartFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final FunnelChartSortConfiguration.Builder getSortConfiguration() {
            return sortConfiguration != null ? sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(FunnelChartSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(FunnelChartSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getCategoryLabelOptions() {
            return categoryLabelOptions != null ? categoryLabelOptions.toBuilder() : null;
        }

        public final void setCategoryLabelOptions(ChartAxisLabelOptions.BuilderImpl categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions != null ? categoryLabelOptions.build() : null;
        }

        @Override
        public final Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getValueLabelOptions() {
            return valueLabelOptions != null ? valueLabelOptions.toBuilder() : null;
        }

        public final void setValueLabelOptions(ChartAxisLabelOptions.BuilderImpl valueLabelOptions) {
            this.valueLabelOptions = valueLabelOptions != null ? valueLabelOptions.build() : null;
        }

        @Override
        public final Builder valueLabelOptions(ChartAxisLabelOptions valueLabelOptions) {
            this.valueLabelOptions = valueLabelOptions;
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return tooltip != null ? tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final FunnelChartDataLabelOptions.Builder getDataLabelOptions() {
            return dataLabelOptions != null ? dataLabelOptions.toBuilder() : null;
        }

        public final void setDataLabelOptions(FunnelChartDataLabelOptions.BuilderImpl dataLabelOptions) {
            this.dataLabelOptions = dataLabelOptions != null ? dataLabelOptions.build() : null;
        }

        @Override
        public final Builder dataLabelOptions(FunnelChartDataLabelOptions dataLabelOptions) {
            this.dataLabelOptions = dataLabelOptions;
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return visualPalette != null ? visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return interactions != null ? interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        @Override
        public FunnelChartConfiguration build() {
            return new FunnelChartConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
