/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateEmbedUrlForAnonymousUserRequest extends QuickSightRequest implements
        ToCopyableBuilder<GenerateEmbedUrlForAnonymousUserRequest.Builder, GenerateEmbedUrlForAnonymousUserRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(GenerateEmbedUrlForAnonymousUserRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<Long> SESSION_LIFETIME_IN_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SessionLifetimeInMinutes")
            .getter(getter(GenerateEmbedUrlForAnonymousUserRequest::sessionLifetimeInMinutes))
            .setter(setter(Builder::sessionLifetimeInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionLifetimeInMinutes").build())
            .build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(GenerateEmbedUrlForAnonymousUserRequest::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<List<SessionTag>> SESSION_TAGS_FIELD = SdkField
            .<List<SessionTag>> builder(MarshallingType.LIST)
            .memberName("SessionTags")
            .getter(getter(GenerateEmbedUrlForAnonymousUserRequest::sessionTags))
            .setter(setter(Builder::sessionTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SessionTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(SessionTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AUTHORIZED_RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AuthorizedResourceArns")
            .getter(getter(GenerateEmbedUrlForAnonymousUserRequest::authorizedResourceArns))
            .setter(setter(Builder::authorizedResourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedResourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AnonymousUserEmbeddingExperienceConfiguration> EXPERIENCE_CONFIGURATION_FIELD = SdkField
            .<AnonymousUserEmbeddingExperienceConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ExperienceConfiguration")
            .getter(getter(GenerateEmbedUrlForAnonymousUserRequest::experienceConfiguration))
            .setter(setter(Builder::experienceConfiguration)).constructor(AnonymousUserEmbeddingExperienceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperienceConfiguration").build())
            .build();

    private static final SdkField<List<String>> ALLOWED_DOMAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedDomains")
            .getter(getter(GenerateEmbedUrlForAnonymousUserRequest::allowedDomains))
            .setter(setter(Builder::allowedDomains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedDomains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            SESSION_LIFETIME_IN_MINUTES_FIELD, NAMESPACE_FIELD, SESSION_TAGS_FIELD, AUTHORIZED_RESOURCE_ARNS_FIELD,
            EXPERIENCE_CONFIGURATION_FIELD, ALLOWED_DOMAINS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final Long sessionLifetimeInMinutes;

    private final String namespace;

    private final List<SessionTag> sessionTags;

    private final List<String> authorizedResourceArns;

    private final AnonymousUserEmbeddingExperienceConfiguration experienceConfiguration;

    private final List<String> allowedDomains;

    private GenerateEmbedUrlForAnonymousUserRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.sessionLifetimeInMinutes = builder.sessionLifetimeInMinutes;
        this.namespace = builder.namespace;
        this.sessionTags = builder.sessionTags;
        this.authorizedResourceArns = builder.authorizedResourceArns;
        this.experienceConfiguration = builder.experienceConfiguration;
        this.allowedDomains = builder.allowedDomains;
    }

    /**
     * <p>
     * The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
     * </p>
     * 
     * @return The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.
     * </p>
     * 
     * @return How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.
     */
    public final Long sessionLifetimeInMinutes() {
        return sessionLifetimeInMinutes;
    }

    /**
     * <p>
     * The Amazon QuickSight namespace that the anonymous user virtually belongs to. If you are not using an Amazon
     * QuickSight custom namespace, set this to <code>default</code>.
     * </p>
     * 
     * @return The Amazon QuickSight namespace that the anonymous user virtually belongs to. If you are not using an
     *         Amazon QuickSight custom namespace, set this to <code>default</code>.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * For responses, this returns true if the service returned a value for the SessionTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSessionTags() {
        return sessionTags != null && !(sessionTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The session tags used for row-level security. Before you use this parameter, make sure that you have configured
     * the relevant datasets using the <code>DataSet$RowLevelPermissionTagConfiguration</code> parameter so that session
     * tags can be used to provide row-level security.
     * </p>
     * <p>
     * These are not the tags used for the Amazon Web Services resource tagging feature. For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level Security
     * (RLS) with Tags</a>in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSessionTags} method.
     * </p>
     * 
     * @return The session tags used for row-level security. Before you use this parameter, make sure that you have
     *         configured the relevant datasets using the <code>DataSet$RowLevelPermissionTagConfiguration</code>
     *         parameter so that session tags can be used to provide row-level security.</p>
     *         <p>
     *         These are not the tags used for the Amazon Web Services resource tagging feature. For more information,
     *         see <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using
     *         Row-Level Security (RLS) with Tags</a>in the <i>Amazon QuickSight User Guide</i>.
     */
    public final List<SessionTag> sessionTags() {
        return sessionTags;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorizedResourceArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAuthorizedResourceArns() {
        return authorizedResourceArns != null && !(authorizedResourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) for the Amazon QuickSight resources that the user is authorized to access during
     * the lifetime of the session.
     * </p>
     * <p>
     * If you choose <code>Dashboard</code> embedding experience, pass the list of dashboard ARNs in the account that
     * you want the user to be able to view.
     * </p>
     * <p>
     * If you want to make changes to the theme of your embedded content, pass a list of theme ARNs that the anonymous
     * users need access to.
     * </p>
     * <p>
     * Currently, you can pass up to 25 theme ARNs in each API call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizedResourceArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) for the Amazon QuickSight resources that the user is authorized to
     *         access during the lifetime of the session.</p>
     *         <p>
     *         If you choose <code>Dashboard</code> embedding experience, pass the list of dashboard ARNs in the account
     *         that you want the user to be able to view.
     *         </p>
     *         <p>
     *         If you want to make changes to the theme of your embedded content, pass a list of theme ARNs that the
     *         anonymous users need access to.
     *         </p>
     *         <p>
     *         Currently, you can pass up to 25 theme ARNs in each API call.
     */
    public final List<String> authorizedResourceArns() {
        return authorizedResourceArns;
    }

    /**
     * <p>
     * The configuration of the experience that you are embedding.
     * </p>
     * 
     * @return The configuration of the experience that you are embedding.
     */
    public final AnonymousUserEmbeddingExperienceConfiguration experienceConfiguration() {
        return experienceConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedDomains property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedDomains() {
        return allowedDomains != null && !(allowedDomains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The domains that you want to add to the allow list for access to the generated URL that is then embedded. This
     * optional parameter overrides the static domains that are configured in the Manage QuickSight menu in the Amazon
     * QuickSight console. Instead, it allows only the domains that you include in this parameter. You can list up to
     * three domains or subdomains in each API call.
     * </p>
     * <p>
     * To include all subdomains under a specific domain to the allow list, use <code>*</code>. For example,
     * <code>https://*.sapp.amazon.com</code> includes all subdomains under <code>https://sapp.amazon.com</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedDomains} method.
     * </p>
     * 
     * @return The domains that you want to add to the allow list for access to the generated URL that is then embedded.
     *         This optional parameter overrides the static domains that are configured in the Manage QuickSight menu in
     *         the Amazon QuickSight console. Instead, it allows only the domains that you include in this parameter.
     *         You can list up to three domains or subdomains in each API call.</p>
     *         <p>
     *         To include all subdomains under a specific domain to the allow list, use <code>*</code>. For example,
     *         <code>https://*.sapp.amazon.com</code> includes all subdomains under <code>https://sapp.amazon.com</code>.
     */
    public final List<String> allowedDomains() {
        return allowedDomains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionLifetimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(hasSessionTags() ? sessionTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizedResourceArns() ? authorizedResourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(experienceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedDomains() ? allowedDomains() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateEmbedUrlForAnonymousUserRequest)) {
            return false;
        }
        GenerateEmbedUrlForAnonymousUserRequest other = (GenerateEmbedUrlForAnonymousUserRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(sessionLifetimeInMinutes(), other.sessionLifetimeInMinutes())
                && Objects.equals(namespace(), other.namespace()) && hasSessionTags() == other.hasSessionTags()
                && Objects.equals(sessionTags(), other.sessionTags())
                && hasAuthorizedResourceArns() == other.hasAuthorizedResourceArns()
                && Objects.equals(authorizedResourceArns(), other.authorizedResourceArns())
                && Objects.equals(experienceConfiguration(), other.experienceConfiguration())
                && hasAllowedDomains() == other.hasAllowedDomains() && Objects.equals(allowedDomains(), other.allowedDomains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateEmbedUrlForAnonymousUserRequest").add("AwsAccountId", awsAccountId())
                .add("SessionLifetimeInMinutes", sessionLifetimeInMinutes()).add("Namespace", namespace())
                .add("SessionTags", hasSessionTags() ? sessionTags() : null)
                .add("AuthorizedResourceArns", hasAuthorizedResourceArns() ? authorizedResourceArns() : null)
                .add("ExperienceConfiguration", experienceConfiguration())
                .add("AllowedDomains", hasAllowedDomains() ? allowedDomains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "SessionLifetimeInMinutes":
            return Optional.ofNullable(clazz.cast(sessionLifetimeInMinutes()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "SessionTags":
            return Optional.ofNullable(clazz.cast(sessionTags()));
        case "AuthorizedResourceArns":
            return Optional.ofNullable(clazz.cast(authorizedResourceArns()));
        case "ExperienceConfiguration":
            return Optional.ofNullable(clazz.cast(experienceConfiguration()));
        case "AllowedDomains":
            return Optional.ofNullable(clazz.cast(allowedDomains()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("SessionLifetimeInMinutes", SESSION_LIFETIME_IN_MINUTES_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("SessionTags", SESSION_TAGS_FIELD);
        map.put("AuthorizedResourceArns", AUTHORIZED_RESOURCE_ARNS_FIELD);
        map.put("ExperienceConfiguration", EXPERIENCE_CONFIGURATION_FIELD);
        map.put("AllowedDomains", ALLOWED_DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateEmbedUrlForAnonymousUserRequest, T> g) {
        return obj -> g.apply((GenerateEmbedUrlForAnonymousUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GenerateEmbedUrlForAnonymousUserRequest> {
        /**
         * <p>
         * The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
         * </p>
         * 
         * @param awsAccountId
         *        The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.
         * </p>
         * 
         * @param sessionLifetimeInMinutes
         *        How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionLifetimeInMinutes(Long sessionLifetimeInMinutes);

        /**
         * <p>
         * The Amazon QuickSight namespace that the anonymous user virtually belongs to. If you are not using an Amazon
         * QuickSight custom namespace, set this to <code>default</code>.
         * </p>
         * 
         * @param namespace
         *        The Amazon QuickSight namespace that the anonymous user virtually belongs to. If you are not using an
         *        Amazon QuickSight custom namespace, set this to <code>default</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The session tags used for row-level security. Before you use this parameter, make sure that you have
         * configured the relevant datasets using the <code>DataSet$RowLevelPermissionTagConfiguration</code> parameter
         * so that session tags can be used to provide row-level security.
         * </p>
         * <p>
         * These are not the tags used for the Amazon Web Services resource tagging feature. For more information, see
         * <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level
         * Security (RLS) with Tags</a>in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * 
         * @param sessionTags
         *        The session tags used for row-level security. Before you use this parameter, make sure that you have
         *        configured the relevant datasets using the <code>DataSet$RowLevelPermissionTagConfiguration</code>
         *        parameter so that session tags can be used to provide row-level security.</p>
         *        <p>
         *        These are not the tags used for the Amazon Web Services resource tagging feature. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level
         *        Security (RLS) with Tags</a>in the <i>Amazon QuickSight User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionTags(Collection<SessionTag> sessionTags);

        /**
         * <p>
         * The session tags used for row-level security. Before you use this parameter, make sure that you have
         * configured the relevant datasets using the <code>DataSet$RowLevelPermissionTagConfiguration</code> parameter
         * so that session tags can be used to provide row-level security.
         * </p>
         * <p>
         * These are not the tags used for the Amazon Web Services resource tagging feature. For more information, see
         * <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level
         * Security (RLS) with Tags</a>in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * 
         * @param sessionTags
         *        The session tags used for row-level security. Before you use this parameter, make sure that you have
         *        configured the relevant datasets using the <code>DataSet$RowLevelPermissionTagConfiguration</code>
         *        parameter so that session tags can be used to provide row-level security.</p>
         *        <p>
         *        These are not the tags used for the Amazon Web Services resource tagging feature. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level
         *        Security (RLS) with Tags</a>in the <i>Amazon QuickSight User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionTags(SessionTag... sessionTags);

        /**
         * <p>
         * The session tags used for row-level security. Before you use this parameter, make sure that you have
         * configured the relevant datasets using the <code>DataSet$RowLevelPermissionTagConfiguration</code> parameter
         * so that session tags can be used to provide row-level security.
         * </p>
         * <p>
         * These are not the tags used for the Amazon Web Services resource tagging feature. For more information, see
         * <a href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html">Using Row-Level
         * Security (RLS) with Tags</a>in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SessionTag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.SessionTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SessionTag.Builder#build()} is called immediately and
         * its result is passed to {@link #sessionTags(List<SessionTag>)}.
         * 
         * @param sessionTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SessionTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionTags(java.util.Collection<SessionTag>)
         */
        Builder sessionTags(Consumer<SessionTag.Builder>... sessionTags);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) for the Amazon QuickSight resources that the user is authorized to access
         * during the lifetime of the session.
         * </p>
         * <p>
         * If you choose <code>Dashboard</code> embedding experience, pass the list of dashboard ARNs in the account
         * that you want the user to be able to view.
         * </p>
         * <p>
         * If you want to make changes to the theme of your embedded content, pass a list of theme ARNs that the
         * anonymous users need access to.
         * </p>
         * <p>
         * Currently, you can pass up to 25 theme ARNs in each API call.
         * </p>
         * 
         * @param authorizedResourceArns
         *        The Amazon Resource Names (ARNs) for the Amazon QuickSight resources that the user is authorized to
         *        access during the lifetime of the session.</p>
         *        <p>
         *        If you choose <code>Dashboard</code> embedding experience, pass the list of dashboard ARNs in the
         *        account that you want the user to be able to view.
         *        </p>
         *        <p>
         *        If you want to make changes to the theme of your embedded content, pass a list of theme ARNs that the
         *        anonymous users need access to.
         *        </p>
         *        <p>
         *        Currently, you can pass up to 25 theme ARNs in each API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedResourceArns(Collection<String> authorizedResourceArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) for the Amazon QuickSight resources that the user is authorized to access
         * during the lifetime of the session.
         * </p>
         * <p>
         * If you choose <code>Dashboard</code> embedding experience, pass the list of dashboard ARNs in the account
         * that you want the user to be able to view.
         * </p>
         * <p>
         * If you want to make changes to the theme of your embedded content, pass a list of theme ARNs that the
         * anonymous users need access to.
         * </p>
         * <p>
         * Currently, you can pass up to 25 theme ARNs in each API call.
         * </p>
         * 
         * @param authorizedResourceArns
         *        The Amazon Resource Names (ARNs) for the Amazon QuickSight resources that the user is authorized to
         *        access during the lifetime of the session.</p>
         *        <p>
         *        If you choose <code>Dashboard</code> embedding experience, pass the list of dashboard ARNs in the
         *        account that you want the user to be able to view.
         *        </p>
         *        <p>
         *        If you want to make changes to the theme of your embedded content, pass a list of theme ARNs that the
         *        anonymous users need access to.
         *        </p>
         *        <p>
         *        Currently, you can pass up to 25 theme ARNs in each API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedResourceArns(String... authorizedResourceArns);

        /**
         * <p>
         * The configuration of the experience that you are embedding.
         * </p>
         * 
         * @param experienceConfiguration
         *        The configuration of the experience that you are embedding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experienceConfiguration(AnonymousUserEmbeddingExperienceConfiguration experienceConfiguration);

        /**
         * <p>
         * The configuration of the experience that you are embedding.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AnonymousUserEmbeddingExperienceConfiguration.Builder} avoiding the need to create one manually via
         * {@link AnonymousUserEmbeddingExperienceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnonymousUserEmbeddingExperienceConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #experienceConfiguration(AnonymousUserEmbeddingExperienceConfiguration)}.
         * 
         * @param experienceConfiguration
         *        a consumer that will call methods on {@link AnonymousUserEmbeddingExperienceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #experienceConfiguration(AnonymousUserEmbeddingExperienceConfiguration)
         */
        default Builder experienceConfiguration(
                Consumer<AnonymousUserEmbeddingExperienceConfiguration.Builder> experienceConfiguration) {
            return experienceConfiguration(AnonymousUserEmbeddingExperienceConfiguration.builder()
                    .applyMutation(experienceConfiguration).build());
        }

        /**
         * <p>
         * The domains that you want to add to the allow list for access to the generated URL that is then embedded.
         * This optional parameter overrides the static domains that are configured in the Manage QuickSight menu in the
         * Amazon QuickSight console. Instead, it allows only the domains that you include in this parameter. You can
         * list up to three domains or subdomains in each API call.
         * </p>
         * <p>
         * To include all subdomains under a specific domain to the allow list, use <code>*</code>. For example,
         * <code>https://*.sapp.amazon.com</code> includes all subdomains under <code>https://sapp.amazon.com</code>.
         * </p>
         * 
         * @param allowedDomains
         *        The domains that you want to add to the allow list for access to the generated URL that is then
         *        embedded. This optional parameter overrides the static domains that are configured in the Manage
         *        QuickSight menu in the Amazon QuickSight console. Instead, it allows only the domains that you include
         *        in this parameter. You can list up to three domains or subdomains in each API call.</p>
         *        <p>
         *        To include all subdomains under a specific domain to the allow list, use <code>*</code>. For example,
         *        <code>https://*.sapp.amazon.com</code> includes all subdomains under
         *        <code>https://sapp.amazon.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedDomains(Collection<String> allowedDomains);

        /**
         * <p>
         * The domains that you want to add to the allow list for access to the generated URL that is then embedded.
         * This optional parameter overrides the static domains that are configured in the Manage QuickSight menu in the
         * Amazon QuickSight console. Instead, it allows only the domains that you include in this parameter. You can
         * list up to three domains or subdomains in each API call.
         * </p>
         * <p>
         * To include all subdomains under a specific domain to the allow list, use <code>*</code>. For example,
         * <code>https://*.sapp.amazon.com</code> includes all subdomains under <code>https://sapp.amazon.com</code>.
         * </p>
         * 
         * @param allowedDomains
         *        The domains that you want to add to the allow list for access to the generated URL that is then
         *        embedded. This optional parameter overrides the static domains that are configured in the Manage
         *        QuickSight menu in the Amazon QuickSight console. Instead, it allows only the domains that you include
         *        in this parameter. You can list up to three domains or subdomains in each API call.</p>
         *        <p>
         *        To include all subdomains under a specific domain to the allow list, use <code>*</code>. For example,
         *        <code>https://*.sapp.amazon.com</code> includes all subdomains under
         *        <code>https://sapp.amazon.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedDomains(String... allowedDomains);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private Long sessionLifetimeInMinutes;

        private String namespace;

        private List<SessionTag> sessionTags = DefaultSdkAutoConstructList.getInstance();

        private List<String> authorizedResourceArns = DefaultSdkAutoConstructList.getInstance();

        private AnonymousUserEmbeddingExperienceConfiguration experienceConfiguration;

        private List<String> allowedDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateEmbedUrlForAnonymousUserRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            sessionLifetimeInMinutes(model.sessionLifetimeInMinutes);
            namespace(model.namespace);
            sessionTags(model.sessionTags);
            authorizedResourceArns(model.authorizedResourceArns);
            experienceConfiguration(model.experienceConfiguration);
            allowedDomains(model.allowedDomains);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final Long getSessionLifetimeInMinutes() {
            return sessionLifetimeInMinutes;
        }

        public final void setSessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
            this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
        }

        @Override
        public final Builder sessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
            this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final List<SessionTag.Builder> getSessionTags() {
            List<SessionTag.Builder> result = SessionTagListCopier.copyToBuilder(this.sessionTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessionTags(Collection<SessionTag.BuilderImpl> sessionTags) {
            this.sessionTags = SessionTagListCopier.copyFromBuilder(sessionTags);
        }

        @Override
        public final Builder sessionTags(Collection<SessionTag> sessionTags) {
            this.sessionTags = SessionTagListCopier.copy(sessionTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionTags(SessionTag... sessionTags) {
            sessionTags(Arrays.asList(sessionTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionTags(Consumer<SessionTag.Builder>... sessionTags) {
            sessionTags(Stream.of(sessionTags).map(c -> SessionTag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAuthorizedResourceArns() {
            if (authorizedResourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return authorizedResourceArns;
        }

        public final void setAuthorizedResourceArns(Collection<String> authorizedResourceArns) {
            this.authorizedResourceArns = ArnListCopier.copy(authorizedResourceArns);
        }

        @Override
        public final Builder authorizedResourceArns(Collection<String> authorizedResourceArns) {
            this.authorizedResourceArns = ArnListCopier.copy(authorizedResourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedResourceArns(String... authorizedResourceArns) {
            authorizedResourceArns(Arrays.asList(authorizedResourceArns));
            return this;
        }

        public final AnonymousUserEmbeddingExperienceConfiguration.Builder getExperienceConfiguration() {
            return experienceConfiguration != null ? experienceConfiguration.toBuilder() : null;
        }

        public final void setExperienceConfiguration(
                AnonymousUserEmbeddingExperienceConfiguration.BuilderImpl experienceConfiguration) {
            this.experienceConfiguration = experienceConfiguration != null ? experienceConfiguration.build() : null;
        }

        @Override
        public final Builder experienceConfiguration(AnonymousUserEmbeddingExperienceConfiguration experienceConfiguration) {
            this.experienceConfiguration = experienceConfiguration;
            return this;
        }

        public final Collection<String> getAllowedDomains() {
            if (allowedDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedDomains;
        }

        public final void setAllowedDomains(Collection<String> allowedDomains) {
            this.allowedDomains = StringListCopier.copy(allowedDomains);
        }

        @Override
        public final Builder allowedDomains(Collection<String> allowedDomains) {
            this.allowedDomains = StringListCopier.copy(allowedDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedDomains(String... allowedDomains) {
            allowedDomains(Arrays.asList(allowedDomains));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateEmbedUrlForAnonymousUserRequest build() {
            return new GenerateEmbedUrlForAnonymousUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
