/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The color scale specification for the heatmap point style.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialHeatmapColorScale implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialHeatmapColorScale.Builder, GeospatialHeatmapColorScale> {
    private static final SdkField<List<GeospatialHeatmapDataColor>> COLORS_FIELD = SdkField
            .<List<GeospatialHeatmapDataColor>> builder(MarshallingType.LIST)
            .memberName("Colors")
            .getter(getter(GeospatialHeatmapColorScale::colors))
            .setter(setter(Builder::colors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Colors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GeospatialHeatmapDataColor> builder(MarshallingType.SDK_POJO)
                                            .constructor(GeospatialHeatmapDataColor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<GeospatialHeatmapDataColor> colors;

    private GeospatialHeatmapColorScale(BuilderImpl builder) {
        this.colors = builder.colors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Colors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasColors() {
        return colors != null && !(colors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of colors to be used in heatmap point style.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColors} method.
     * </p>
     * 
     * @return The list of colors to be used in heatmap point style.
     */
    public final List<GeospatialHeatmapDataColor> colors() {
        return colors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasColors() ? colors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialHeatmapColorScale)) {
            return false;
        }
        GeospatialHeatmapColorScale other = (GeospatialHeatmapColorScale) obj;
        return hasColors() == other.hasColors() && Objects.equals(colors(), other.colors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialHeatmapColorScale").add("Colors", hasColors() ? colors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Colors":
            return Optional.ofNullable(clazz.cast(colors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Colors", COLORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialHeatmapColorScale, T> g) {
        return obj -> g.apply((GeospatialHeatmapColorScale) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialHeatmapColorScale> {
        /**
         * <p>
         * The list of colors to be used in heatmap point style.
         * </p>
         * 
         * @param colors
         *        The list of colors to be used in heatmap point style.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colors(Collection<GeospatialHeatmapDataColor> colors);

        /**
         * <p>
         * The list of colors to be used in heatmap point style.
         * </p>
         * 
         * @param colors
         *        The list of colors to be used in heatmap point style.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colors(GeospatialHeatmapDataColor... colors);

        /**
         * <p>
         * The list of colors to be used in heatmap point style.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.GeospatialHeatmapDataColor.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.GeospatialHeatmapDataColor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.GeospatialHeatmapDataColor.Builder#build()} is called
         * immediately and its result is passed to {@link #colors(List<GeospatialHeatmapDataColor>)}.
         * 
         * @param colors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.GeospatialHeatmapDataColor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colors(java.util.Collection<GeospatialHeatmapDataColor>)
         */
        Builder colors(Consumer<GeospatialHeatmapDataColor.Builder>... colors);
    }

    static final class BuilderImpl implements Builder {
        private List<GeospatialHeatmapDataColor> colors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialHeatmapColorScale model) {
            colors(model.colors);
        }

        public final List<GeospatialHeatmapDataColor.Builder> getColors() {
            List<GeospatialHeatmapDataColor.Builder> result = GeospatialHeatmapDataColorListCopier.copyToBuilder(this.colors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColors(Collection<GeospatialHeatmapDataColor.BuilderImpl> colors) {
            this.colors = GeospatialHeatmapDataColorListCopier.copyFromBuilder(colors);
        }

        @Override
        public final Builder colors(Collection<GeospatialHeatmapDataColor> colors) {
            this.colors = GeospatialHeatmapDataColorListCopier.copy(colors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colors(GeospatialHeatmapDataColor... colors) {
            colors(Arrays.asList(colors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colors(Consumer<GeospatialHeatmapDataColor.Builder>... colors) {
            colors(Stream.of(colors).map(c -> GeospatialHeatmapDataColor.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GeospatialHeatmapColorScale build() {
            return new GeospatialHeatmapColorScale(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
