/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The custom actions for a layer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialLayerJoinDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialLayerJoinDefinition.Builder, GeospatialLayerJoinDefinition> {
    private static final SdkField<String> SHAPE_KEY_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShapeKeyField").getter(getter(GeospatialLayerJoinDefinition::shapeKeyField))
            .setter(setter(Builder::shapeKeyField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShapeKeyField").build()).build();

    private static final SdkField<UnaggregatedField> DATASET_KEY_FIELD_FIELD = SdkField
            .<UnaggregatedField> builder(MarshallingType.SDK_POJO).memberName("DatasetKeyField")
            .getter(getter(GeospatialLayerJoinDefinition::datasetKeyField)).setter(setter(Builder::datasetKeyField))
            .constructor(UnaggregatedField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetKeyField").build()).build();

    private static final SdkField<GeospatialLayerColorField> COLOR_FIELD_FIELD = SdkField
            .<GeospatialLayerColorField> builder(MarshallingType.SDK_POJO).memberName("ColorField")
            .getter(getter(GeospatialLayerJoinDefinition::colorField)).setter(setter(Builder::colorField))
            .constructor(GeospatialLayerColorField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorField").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHAPE_KEY_FIELD_FIELD,
            DATASET_KEY_FIELD_FIELD, COLOR_FIELD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String shapeKeyField;

    private final UnaggregatedField datasetKeyField;

    private final GeospatialLayerColorField colorField;

    private GeospatialLayerJoinDefinition(BuilderImpl builder) {
        this.shapeKeyField = builder.shapeKeyField;
        this.datasetKeyField = builder.datasetKeyField;
        this.colorField = builder.colorField;
    }

    /**
     * <p>
     * The name of the field or property in the geospatial data source.
     * </p>
     * 
     * @return The name of the field or property in the geospatial data source.
     */
    public final String shapeKeyField() {
        return shapeKeyField;
    }

    /**
     * Returns the value of the DatasetKeyField property for this object.
     * 
     * @return The value of the DatasetKeyField property for this object.
     */
    public final UnaggregatedField datasetKeyField() {
        return datasetKeyField;
    }

    /**
     * <p>
     * The geospatial color field for the join definition.
     * </p>
     * 
     * @return The geospatial color field for the join definition.
     */
    public final GeospatialLayerColorField colorField() {
        return colorField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shapeKeyField());
        hashCode = 31 * hashCode + Objects.hashCode(datasetKeyField());
        hashCode = 31 * hashCode + Objects.hashCode(colorField());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialLayerJoinDefinition)) {
            return false;
        }
        GeospatialLayerJoinDefinition other = (GeospatialLayerJoinDefinition) obj;
        return Objects.equals(shapeKeyField(), other.shapeKeyField())
                && Objects.equals(datasetKeyField(), other.datasetKeyField()) && Objects.equals(colorField(), other.colorField());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialLayerJoinDefinition").add("ShapeKeyField", shapeKeyField())
                .add("DatasetKeyField", datasetKeyField()).add("ColorField", colorField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShapeKeyField":
            return Optional.ofNullable(clazz.cast(shapeKeyField()));
        case "DatasetKeyField":
            return Optional.ofNullable(clazz.cast(datasetKeyField()));
        case "ColorField":
            return Optional.ofNullable(clazz.cast(colorField()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ShapeKeyField", SHAPE_KEY_FIELD_FIELD);
        map.put("DatasetKeyField", DATASET_KEY_FIELD_FIELD);
        map.put("ColorField", COLOR_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialLayerJoinDefinition, T> g) {
        return obj -> g.apply((GeospatialLayerJoinDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialLayerJoinDefinition> {
        /**
         * <p>
         * The name of the field or property in the geospatial data source.
         * </p>
         * 
         * @param shapeKeyField
         *        The name of the field or property in the geospatial data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shapeKeyField(String shapeKeyField);

        /**
         * Sets the value of the DatasetKeyField property for this object.
         *
         * @param datasetKeyField
         *        The new value for the DatasetKeyField property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetKeyField(UnaggregatedField datasetKeyField);

        /**
         * Sets the value of the DatasetKeyField property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UnaggregatedField.Builder} avoiding the
         * need to create one manually via {@link UnaggregatedField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnaggregatedField.Builder#build()} is called immediately and its
         * result is passed to {@link #datasetKeyField(UnaggregatedField)}.
         * 
         * @param datasetKeyField
         *        a consumer that will call methods on {@link UnaggregatedField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetKeyField(UnaggregatedField)
         */
        default Builder datasetKeyField(Consumer<UnaggregatedField.Builder> datasetKeyField) {
            return datasetKeyField(UnaggregatedField.builder().applyMutation(datasetKeyField).build());
        }

        /**
         * <p>
         * The geospatial color field for the join definition.
         * </p>
         * 
         * @param colorField
         *        The geospatial color field for the join definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder colorField(GeospatialLayerColorField colorField);

        /**
         * <p>
         * The geospatial color field for the join definition.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialLayerColorField.Builder}
         * avoiding the need to create one manually via {@link GeospatialLayerColorField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialLayerColorField.Builder#build()} is called immediately
         * and its result is passed to {@link #colorField(GeospatialLayerColorField)}.
         * 
         * @param colorField
         *        a consumer that will call methods on {@link GeospatialLayerColorField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #colorField(GeospatialLayerColorField)
         */
        default Builder colorField(Consumer<GeospatialLayerColorField.Builder> colorField) {
            return colorField(GeospatialLayerColorField.builder().applyMutation(colorField).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String shapeKeyField;

        private UnaggregatedField datasetKeyField;

        private GeospatialLayerColorField colorField;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialLayerJoinDefinition model) {
            shapeKeyField(model.shapeKeyField);
            datasetKeyField(model.datasetKeyField);
            colorField(model.colorField);
        }

        public final String getShapeKeyField() {
            return shapeKeyField;
        }

        public final void setShapeKeyField(String shapeKeyField) {
            this.shapeKeyField = shapeKeyField;
        }

        @Override
        public final Builder shapeKeyField(String shapeKeyField) {
            this.shapeKeyField = shapeKeyField;
            return this;
        }

        public final UnaggregatedField.Builder getDatasetKeyField() {
            return datasetKeyField != null ? datasetKeyField.toBuilder() : null;
        }

        public final void setDatasetKeyField(UnaggregatedField.BuilderImpl datasetKeyField) {
            this.datasetKeyField = datasetKeyField != null ? datasetKeyField.build() : null;
        }

        @Override
        public final Builder datasetKeyField(UnaggregatedField datasetKeyField) {
            this.datasetKeyField = datasetKeyField;
            return this;
        }

        public final GeospatialLayerColorField.Builder getColorField() {
            return colorField != null ? colorField.toBuilder() : null;
        }

        public final void setColorField(GeospatialLayerColorField.BuilderImpl colorField) {
            this.colorField = colorField != null ? colorField.build() : null;
        }

        @Override
        public final Builder colorField(GeospatialLayerColorField colorField) {
            this.colorField = colorField;
            return this;
        }

        @Override
        public GeospatialLayerJoinDefinition build() {
            return new GeospatialLayerJoinDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
