/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a header or footer section.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HeaderFooterSectionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<HeaderFooterSectionConfiguration.Builder, HeaderFooterSectionConfiguration> {
    private static final SdkField<String> SECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SectionId").getter(getter(HeaderFooterSectionConfiguration::sectionId))
            .setter(setter(Builder::sectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SectionId").build()).build();

    private static final SdkField<SectionLayoutConfiguration> LAYOUT_FIELD = SdkField
            .<SectionLayoutConfiguration> builder(MarshallingType.SDK_POJO).memberName("Layout")
            .getter(getter(HeaderFooterSectionConfiguration::layout)).setter(setter(Builder::layout))
            .constructor(SectionLayoutConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layout").build()).build();

    private static final SdkField<SectionStyle> STYLE_FIELD = SdkField.<SectionStyle> builder(MarshallingType.SDK_POJO)
            .memberName("Style").getter(getter(HeaderFooterSectionConfiguration::style)).setter(setter(Builder::style))
            .constructor(SectionStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Style").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECTION_ID_FIELD,
            LAYOUT_FIELD, STYLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sectionId;

    private final SectionLayoutConfiguration layout;

    private final SectionStyle style;

    private HeaderFooterSectionConfiguration(BuilderImpl builder) {
        this.sectionId = builder.sectionId;
        this.layout = builder.layout;
        this.style = builder.style;
    }

    /**
     * <p>
     * The unique identifier of the header or footer section.
     * </p>
     * 
     * @return The unique identifier of the header or footer section.
     */
    public final String sectionId() {
        return sectionId;
    }

    /**
     * <p>
     * The layout configuration of the header or footer section.
     * </p>
     * 
     * @return The layout configuration of the header or footer section.
     */
    public final SectionLayoutConfiguration layout() {
        return layout;
    }

    /**
     * <p>
     * The style options of a header or footer section.
     * </p>
     * 
     * @return The style options of a header or footer section.
     */
    public final SectionStyle style() {
        return style;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sectionId());
        hashCode = 31 * hashCode + Objects.hashCode(layout());
        hashCode = 31 * hashCode + Objects.hashCode(style());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HeaderFooterSectionConfiguration)) {
            return false;
        }
        HeaderFooterSectionConfiguration other = (HeaderFooterSectionConfiguration) obj;
        return Objects.equals(sectionId(), other.sectionId()) && Objects.equals(layout(), other.layout())
                && Objects.equals(style(), other.style());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HeaderFooterSectionConfiguration").add("SectionId", sectionId()).add("Layout", layout())
                .add("Style", style()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SectionId":
            return Optional.ofNullable(clazz.cast(sectionId()));
        case "Layout":
            return Optional.ofNullable(clazz.cast(layout()));
        case "Style":
            return Optional.ofNullable(clazz.cast(style()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SectionId", SECTION_ID_FIELD);
        map.put("Layout", LAYOUT_FIELD);
        map.put("Style", STYLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HeaderFooterSectionConfiguration, T> g) {
        return obj -> g.apply((HeaderFooterSectionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HeaderFooterSectionConfiguration> {
        /**
         * <p>
         * The unique identifier of the header or footer section.
         * </p>
         * 
         * @param sectionId
         *        The unique identifier of the header or footer section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sectionId(String sectionId);

        /**
         * <p>
         * The layout configuration of the header or footer section.
         * </p>
         * 
         * @param layout
         *        The layout configuration of the header or footer section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layout(SectionLayoutConfiguration layout);

        /**
         * <p>
         * The layout configuration of the header or footer section.
         * </p>
         * This is a convenience method that creates an instance of the {@link SectionLayoutConfiguration.Builder}
         * avoiding the need to create one manually via {@link SectionLayoutConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SectionLayoutConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #layout(SectionLayoutConfiguration)}.
         * 
         * @param layout
         *        a consumer that will call methods on {@link SectionLayoutConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #layout(SectionLayoutConfiguration)
         */
        default Builder layout(Consumer<SectionLayoutConfiguration.Builder> layout) {
            return layout(SectionLayoutConfiguration.builder().applyMutation(layout).build());
        }

        /**
         * <p>
         * The style options of a header or footer section.
         * </p>
         * 
         * @param style
         *        The style options of a header or footer section.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder style(SectionStyle style);

        /**
         * <p>
         * The style options of a header or footer section.
         * </p>
         * This is a convenience method that creates an instance of the {@link SectionStyle.Builder} avoiding the need
         * to create one manually via {@link SectionStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SectionStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #style(SectionStyle)}.
         * 
         * @param style
         *        a consumer that will call methods on {@link SectionStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #style(SectionStyle)
         */
        default Builder style(Consumer<SectionStyle.Builder> style) {
            return style(SectionStyle.builder().applyMutation(style).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sectionId;

        private SectionLayoutConfiguration layout;

        private SectionStyle style;

        private BuilderImpl() {
        }

        private BuilderImpl(HeaderFooterSectionConfiguration model) {
            sectionId(model.sectionId);
            layout(model.layout);
            style(model.style);
        }

        public final String getSectionId() {
            return sectionId;
        }

        public final void setSectionId(String sectionId) {
            this.sectionId = sectionId;
        }

        @Override
        public final Builder sectionId(String sectionId) {
            this.sectionId = sectionId;
            return this;
        }

        public final SectionLayoutConfiguration.Builder getLayout() {
            return layout != null ? layout.toBuilder() : null;
        }

        public final void setLayout(SectionLayoutConfiguration.BuilderImpl layout) {
            this.layout = layout != null ? layout.build() : null;
        }

        @Override
        public final Builder layout(SectionLayoutConfiguration layout) {
            this.layout = layout;
            return this;
        }

        public final SectionStyle.Builder getStyle() {
            return style != null ? style.toBuilder() : null;
        }

        public final void setStyle(SectionStyle.BuilderImpl style) {
            this.style = style != null ? style.build() : null;
        }

        @Override
        public final Builder style(SectionStyle style) {
            this.style = style;
            return this;
        }

        @Override
        public HeaderFooterSectionConfiguration build() {
            return new HeaderFooterSectionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
