/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field well configuration of a heat map.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HeatMapFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<HeatMapFieldWells.Builder, HeatMapFieldWells> {
    private static final SdkField<HeatMapAggregatedFieldWells> HEAT_MAP_AGGREGATED_FIELD_WELLS_FIELD = SdkField
            .<HeatMapAggregatedFieldWells> builder(MarshallingType.SDK_POJO)
            .memberName("HeatMapAggregatedFieldWells")
            .getter(getter(HeatMapFieldWells::heatMapAggregatedFieldWells))
            .setter(setter(Builder::heatMapAggregatedFieldWells))
            .constructor(HeatMapAggregatedFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeatMapAggregatedFieldWells")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(HEAT_MAP_AGGREGATED_FIELD_WELLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final HeatMapAggregatedFieldWells heatMapAggregatedFieldWells;

    private HeatMapFieldWells(BuilderImpl builder) {
        this.heatMapAggregatedFieldWells = builder.heatMapAggregatedFieldWells;
    }

    /**
     * <p>
     * The aggregated field wells of a heat map.
     * </p>
     * 
     * @return The aggregated field wells of a heat map.
     */
    public final HeatMapAggregatedFieldWells heatMapAggregatedFieldWells() {
        return heatMapAggregatedFieldWells;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(heatMapAggregatedFieldWells());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HeatMapFieldWells)) {
            return false;
        }
        HeatMapFieldWells other = (HeatMapFieldWells) obj;
        return Objects.equals(heatMapAggregatedFieldWells(), other.heatMapAggregatedFieldWells());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HeatMapFieldWells").add("HeatMapAggregatedFieldWells", heatMapAggregatedFieldWells()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HeatMapAggregatedFieldWells":
            return Optional.ofNullable(clazz.cast(heatMapAggregatedFieldWells()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HeatMapAggregatedFieldWells", HEAT_MAP_AGGREGATED_FIELD_WELLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HeatMapFieldWells, T> g) {
        return obj -> g.apply((HeatMapFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HeatMapFieldWells> {
        /**
         * <p>
         * The aggregated field wells of a heat map.
         * </p>
         * 
         * @param heatMapAggregatedFieldWells
         *        The aggregated field wells of a heat map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heatMapAggregatedFieldWells(HeatMapAggregatedFieldWells heatMapAggregatedFieldWells);

        /**
         * <p>
         * The aggregated field wells of a heat map.
         * </p>
         * This is a convenience method that creates an instance of the {@link HeatMapAggregatedFieldWells.Builder}
         * avoiding the need to create one manually via {@link HeatMapAggregatedFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HeatMapAggregatedFieldWells.Builder#build()} is called
         * immediately and its result is passed to {@link #heatMapAggregatedFieldWells(HeatMapAggregatedFieldWells)}.
         * 
         * @param heatMapAggregatedFieldWells
         *        a consumer that will call methods on {@link HeatMapAggregatedFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #heatMapAggregatedFieldWells(HeatMapAggregatedFieldWells)
         */
        default Builder heatMapAggregatedFieldWells(Consumer<HeatMapAggregatedFieldWells.Builder> heatMapAggregatedFieldWells) {
            return heatMapAggregatedFieldWells(HeatMapAggregatedFieldWells.builder().applyMutation(heatMapAggregatedFieldWells)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HeatMapAggregatedFieldWells heatMapAggregatedFieldWells;

        private BuilderImpl() {
        }

        private BuilderImpl(HeatMapFieldWells model) {
            heatMapAggregatedFieldWells(model.heatMapAggregatedFieldWells);
        }

        public final HeatMapAggregatedFieldWells.Builder getHeatMapAggregatedFieldWells() {
            return heatMapAggregatedFieldWells != null ? heatMapAggregatedFieldWells.toBuilder() : null;
        }

        public final void setHeatMapAggregatedFieldWells(HeatMapAggregatedFieldWells.BuilderImpl heatMapAggregatedFieldWells) {
            this.heatMapAggregatedFieldWells = heatMapAggregatedFieldWells != null ? heatMapAggregatedFieldWells.build() : null;
        }

        @Override
        public final Builder heatMapAggregatedFieldWells(HeatMapAggregatedFieldWells heatMapAggregatedFieldWells) {
            this.heatMapAggregatedFieldWells = heatMapAggregatedFieldWells;
            return this;
        }

        @Override
        public HeatMapFieldWells build() {
            return new HeatMapFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
