/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a KPI visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KPIConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KPIConfiguration.Builder, KPIConfiguration> {
    private static final SdkField<KPIFieldWells> FIELD_WELLS_FIELD = SdkField.<KPIFieldWells> builder(MarshallingType.SDK_POJO)
            .memberName("FieldWells").getter(getter(KPIConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(KPIFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<KPISortConfiguration> SORT_CONFIGURATION_FIELD = SdkField
            .<KPISortConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortConfiguration")
            .getter(getter(KPIConfiguration::sortConfiguration)).setter(setter(Builder::sortConfiguration))
            .constructor(KPISortConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()).build();

    private static final SdkField<KPIOptions> KPI_OPTIONS_FIELD = SdkField.<KPIOptions> builder(MarshallingType.SDK_POJO)
            .memberName("KPIOptions").getter(getter(KPIConfiguration::kpiOptions)).setter(setter(Builder::kpiOptions))
            .constructor(KPIOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KPIOptions").build()).build();

    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField
            .<VisualInteractionOptions> builder(MarshallingType.SDK_POJO).memberName("Interactions")
            .getter(getter(KPIConfiguration::interactions)).setter(setter(Builder::interactions))
            .constructor(VisualInteractionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD,
            SORT_CONFIGURATION_FIELD, KPI_OPTIONS_FIELD, INTERACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final KPIFieldWells fieldWells;

    private final KPISortConfiguration sortConfiguration;

    private final KPIOptions kpiOptions;

    private final VisualInteractionOptions interactions;

    private KPIConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.kpiOptions = builder.kpiOptions;
        this.interactions = builder.interactions;
    }

    /**
     * <p>
     * The field well configuration of a KPI visual.
     * </p>
     * 
     * @return The field well configuration of a KPI visual.
     */
    public final KPIFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The sort configuration of a KPI visual.
     * </p>
     * 
     * @return The sort configuration of a KPI visual.
     */
    public final KPISortConfiguration sortConfiguration() {
        return sortConfiguration;
    }

    /**
     * <p>
     * The options that determine the presentation of a KPI visual.
     * </p>
     * 
     * @return The options that determine the presentation of a KPI visual.
     */
    public final KPIOptions kpiOptions() {
        return kpiOptions;
    }

    /**
     * <p>
     * The general visual interactions setup for a visual.
     * </p>
     * 
     * @return The general visual interactions setup for a visual.
     */
    public final VisualInteractionOptions interactions() {
        return interactions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(kpiOptions());
        hashCode = 31 * hashCode + Objects.hashCode(interactions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KPIConfiguration)) {
            return false;
        }
        KPIConfiguration other = (KPIConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells()) && Objects.equals(sortConfiguration(), other.sortConfiguration())
                && Objects.equals(kpiOptions(), other.kpiOptions()) && Objects.equals(interactions(), other.interactions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KPIConfiguration").add("FieldWells", fieldWells()).add("SortConfiguration", sortConfiguration())
                .add("KPIOptions", kpiOptions()).add("Interactions", interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "SortConfiguration":
            return Optional.ofNullable(clazz.cast(sortConfiguration()));
        case "KPIOptions":
            return Optional.ofNullable(clazz.cast(kpiOptions()));
        case "Interactions":
            return Optional.ofNullable(clazz.cast(interactions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldWells", FIELD_WELLS_FIELD);
        map.put("SortConfiguration", SORT_CONFIGURATION_FIELD);
        map.put("KPIOptions", KPI_OPTIONS_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KPIConfiguration, T> g) {
        return obj -> g.apply((KPIConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KPIConfiguration> {
        /**
         * <p>
         * The field well configuration of a KPI visual.
         * </p>
         * 
         * @param fieldWells
         *        The field well configuration of a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(KPIFieldWells fieldWells);

        /**
         * <p>
         * The field well configuration of a KPI visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link KPIFieldWells.Builder} avoiding the need
         * to create one manually via {@link KPIFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KPIFieldWells.Builder#build()} is called immediately and its
         * result is passed to {@link #fieldWells(KPIFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link KPIFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(KPIFieldWells)
         */
        default Builder fieldWells(Consumer<KPIFieldWells.Builder> fieldWells) {
            return fieldWells(KPIFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The sort configuration of a KPI visual.
         * </p>
         * 
         * @param sortConfiguration
         *        The sort configuration of a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortConfiguration(KPISortConfiguration sortConfiguration);

        /**
         * <p>
         * The sort configuration of a KPI visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link KPISortConfiguration.Builder} avoiding
         * the need to create one manually via {@link KPISortConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KPISortConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #sortConfiguration(KPISortConfiguration)}.
         * 
         * @param sortConfiguration
         *        a consumer that will call methods on {@link KPISortConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortConfiguration(KPISortConfiguration)
         */
        default Builder sortConfiguration(Consumer<KPISortConfiguration.Builder> sortConfiguration) {
            return sortConfiguration(KPISortConfiguration.builder().applyMutation(sortConfiguration).build());
        }

        /**
         * <p>
         * The options that determine the presentation of a KPI visual.
         * </p>
         * 
         * @param kpiOptions
         *        The options that determine the presentation of a KPI visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kpiOptions(KPIOptions kpiOptions);

        /**
         * <p>
         * The options that determine the presentation of a KPI visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link KPIOptions.Builder} avoiding the need to
         * create one manually via {@link KPIOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KPIOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #kpiOptions(KPIOptions)}.
         * 
         * @param kpiOptions
         *        a consumer that will call methods on {@link KPIOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kpiOptions(KPIOptions)
         */
        default Builder kpiOptions(Consumer<KPIOptions.Builder> kpiOptions) {
            return kpiOptions(KPIOptions.builder().applyMutation(kpiOptions).build());
        }

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * 
         * @param interactions
         *        The general visual interactions setup for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactions(VisualInteractionOptions interactions);

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualInteractionOptions.Builder}
         * avoiding the need to create one manually via {@link VisualInteractionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualInteractionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #interactions(VisualInteractionOptions)}.
         * 
         * @param interactions
         *        a consumer that will call methods on {@link VisualInteractionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interactions(VisualInteractionOptions)
         */
        default Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return interactions(VisualInteractionOptions.builder().applyMutation(interactions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KPIFieldWells fieldWells;

        private KPISortConfiguration sortConfiguration;

        private KPIOptions kpiOptions;

        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(KPIConfiguration model) {
            fieldWells(model.fieldWells);
            sortConfiguration(model.sortConfiguration);
            kpiOptions(model.kpiOptions);
            interactions(model.interactions);
        }

        public final KPIFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(KPIFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(KPIFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final KPISortConfiguration.Builder getSortConfiguration() {
            return sortConfiguration != null ? sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(KPISortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(KPISortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final KPIOptions.Builder getKpiOptions() {
            return kpiOptions != null ? kpiOptions.toBuilder() : null;
        }

        public final void setKpiOptions(KPIOptions.BuilderImpl kpiOptions) {
            this.kpiOptions = kpiOptions != null ? kpiOptions.build() : null;
        }

        @Override
        public final Builder kpiOptions(KPIOptions kpiOptions) {
            this.kpiOptions = kpiOptions;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return interactions != null ? interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        @Override
        public KPIConfiguration build() {
            return new KPIConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
