/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a line chart.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineChartConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LineChartConfiguration.Builder, LineChartConfiguration> {
    private static final SdkField<LineChartFieldWells> FIELD_WELLS_FIELD = SdkField
            .<LineChartFieldWells> builder(MarshallingType.SDK_POJO).memberName("FieldWells")
            .getter(getter(LineChartConfiguration::fieldWells)).setter(setter(Builder::fieldWells))
            .constructor(LineChartFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()).build();

    private static final SdkField<LineChartSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField
            .<LineChartSortConfiguration> builder(MarshallingType.SDK_POJO).memberName("SortConfiguration")
            .getter(getter(LineChartConfiguration::sortConfiguration)).setter(setter(Builder::sortConfiguration))
            .constructor(LineChartSortConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()).build();

    private static final SdkField<List<ForecastConfiguration>> FORECAST_CONFIGURATIONS_FIELD = SdkField
            .<List<ForecastConfiguration>> builder(MarshallingType.LIST)
            .memberName("ForecastConfigurations")
            .getter(getter(LineChartConfiguration::forecastConfigurations))
            .setter(setter(Builder::forecastConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ForecastConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ForecastConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(LineChartConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<SmallMultiplesOptions> SMALL_MULTIPLES_OPTIONS_FIELD = SdkField
            .<SmallMultiplesOptions> builder(MarshallingType.SDK_POJO).memberName("SmallMultiplesOptions")
            .getter(getter(LineChartConfiguration::smallMultiplesOptions)).setter(setter(Builder::smallMultiplesOptions))
            .constructor(SmallMultiplesOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmallMultiplesOptions").build())
            .build();

    private static final SdkField<AxisDisplayOptions> X_AXIS_DISPLAY_OPTIONS_FIELD = SdkField
            .<AxisDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("XAxisDisplayOptions")
            .getter(getter(LineChartConfiguration::xAxisDisplayOptions)).setter(setter(Builder::xAxisDisplayOptions))
            .constructor(AxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAxisDisplayOptions").build())
            .build();

    private static final SdkField<ChartAxisLabelOptions> X_AXIS_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("XAxisLabelOptions")
            .getter(getter(LineChartConfiguration::xAxisLabelOptions)).setter(setter(Builder::xAxisLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAxisLabelOptions").build()).build();

    private static final SdkField<LineSeriesAxisDisplayOptions> PRIMARY_Y_AXIS_DISPLAY_OPTIONS_FIELD = SdkField
            .<LineSeriesAxisDisplayOptions> builder(MarshallingType.SDK_POJO)
            .memberName("PrimaryYAxisDisplayOptions")
            .getter(getter(LineChartConfiguration::primaryYAxisDisplayOptions))
            .setter(setter(Builder::primaryYAxisDisplayOptions))
            .constructor(LineSeriesAxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryYAxisDisplayOptions").build())
            .build();

    private static final SdkField<ChartAxisLabelOptions> PRIMARY_Y_AXIS_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO).memberName("PrimaryYAxisLabelOptions")
            .getter(getter(LineChartConfiguration::primaryYAxisLabelOptions)).setter(setter(Builder::primaryYAxisLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryYAxisLabelOptions").build())
            .build();

    private static final SdkField<LineSeriesAxisDisplayOptions> SECONDARY_Y_AXIS_DISPLAY_OPTIONS_FIELD = SdkField
            .<LineSeriesAxisDisplayOptions> builder(MarshallingType.SDK_POJO)
            .memberName("SecondaryYAxisDisplayOptions")
            .getter(getter(LineChartConfiguration::secondaryYAxisDisplayOptions))
            .setter(setter(Builder::secondaryYAxisDisplayOptions))
            .constructor(LineSeriesAxisDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryYAxisDisplayOptions")
                    .build()).build();

    private static final SdkField<ChartAxisLabelOptions> SECONDARY_Y_AXIS_LABEL_OPTIONS_FIELD = SdkField
            .<ChartAxisLabelOptions> builder(MarshallingType.SDK_POJO)
            .memberName("SecondaryYAxisLabelOptions")
            .getter(getter(LineChartConfiguration::secondaryYAxisLabelOptions))
            .setter(setter(Builder::secondaryYAxisLabelOptions))
            .constructor(ChartAxisLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryYAxisLabelOptions").build())
            .build();

    private static final SdkField<SingleAxisOptions> SINGLE_AXIS_OPTIONS_FIELD = SdkField
            .<SingleAxisOptions> builder(MarshallingType.SDK_POJO).memberName("SingleAxisOptions")
            .getter(getter(LineChartConfiguration::singleAxisOptions)).setter(setter(Builder::singleAxisOptions))
            .constructor(SingleAxisOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleAxisOptions").build()).build();

    private static final SdkField<LineChartDefaultSeriesSettings> DEFAULT_SERIES_SETTINGS_FIELD = SdkField
            .<LineChartDefaultSeriesSettings> builder(MarshallingType.SDK_POJO).memberName("DefaultSeriesSettings")
            .getter(getter(LineChartConfiguration::defaultSeriesSettings)).setter(setter(Builder::defaultSeriesSettings))
            .constructor(LineChartDefaultSeriesSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSeriesSettings").build())
            .build();

    private static final SdkField<List<SeriesItem>> SERIES_FIELD = SdkField
            .<List<SeriesItem>> builder(MarshallingType.LIST)
            .memberName("Series")
            .getter(getter(LineChartConfiguration::series))
            .setter(setter(Builder::series))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Series").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SeriesItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(SeriesItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.<LegendOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Legend").getter(getter(LineChartConfiguration::legend)).setter(setter(Builder::legend))
            .constructor(LegendOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()).build();

    private static final SdkField<DataLabelOptions> DATA_LABELS_FIELD = SdkField
            .<DataLabelOptions> builder(MarshallingType.SDK_POJO).memberName("DataLabels")
            .getter(getter(LineChartConfiguration::dataLabels)).setter(setter(Builder::dataLabels))
            .constructor(DataLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLabels").build()).build();

    private static final SdkField<List<ReferenceLine>> REFERENCE_LINES_FIELD = SdkField
            .<List<ReferenceLine>> builder(MarshallingType.LIST)
            .memberName("ReferenceLines")
            .getter(getter(LineChartConfiguration::referenceLines))
            .setter(setter(Builder::referenceLines))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceLines").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReferenceLine> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReferenceLine::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.<TooltipOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Tooltip").getter(getter(LineChartConfiguration::tooltip)).setter(setter(Builder::tooltip))
            .constructor(TooltipOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()).build();

    private static final SdkField<List<ContributionAnalysisDefault>> CONTRIBUTION_ANALYSIS_DEFAULTS_FIELD = SdkField
            .<List<ContributionAnalysisDefault>> builder(MarshallingType.LIST)
            .memberName("ContributionAnalysisDefaults")
            .getter(getter(LineChartConfiguration::contributionAnalysisDefaults))
            .setter(setter(Builder::contributionAnalysisDefaults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributionAnalysisDefaults")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContributionAnalysisDefault> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContributionAnalysisDefault::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField
            .<VisualPalette> builder(MarshallingType.SDK_POJO).memberName("VisualPalette")
            .getter(getter(LineChartConfiguration::visualPalette)).setter(setter(Builder::visualPalette))
            .constructor(VisualPalette::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()).build();

    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField
            .<VisualInteractionOptions> builder(MarshallingType.SDK_POJO).memberName("Interactions")
            .getter(getter(LineChartConfiguration::interactions)).setter(setter(Builder::interactions))
            .constructor(VisualInteractionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD, SORT_CONFIGURATION_FIELD, FORECAST_CONFIGURATIONS_FIELD,
                    TYPE_FIELD, SMALL_MULTIPLES_OPTIONS_FIELD, X_AXIS_DISPLAY_OPTIONS_FIELD, X_AXIS_LABEL_OPTIONS_FIELD,
                    PRIMARY_Y_AXIS_DISPLAY_OPTIONS_FIELD, PRIMARY_Y_AXIS_LABEL_OPTIONS_FIELD,
                    SECONDARY_Y_AXIS_DISPLAY_OPTIONS_FIELD, SECONDARY_Y_AXIS_LABEL_OPTIONS_FIELD, SINGLE_AXIS_OPTIONS_FIELD,
                    DEFAULT_SERIES_SETTINGS_FIELD, SERIES_FIELD, LEGEND_FIELD, DATA_LABELS_FIELD, REFERENCE_LINES_FIELD,
                    TOOLTIP_FIELD, CONTRIBUTION_ANALYSIS_DEFAULTS_FIELD, VISUAL_PALETTE_FIELD, INTERACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LineChartFieldWells fieldWells;

    private final LineChartSortConfiguration sortConfiguration;

    private final List<ForecastConfiguration> forecastConfigurations;

    private final String type;

    private final SmallMultiplesOptions smallMultiplesOptions;

    private final AxisDisplayOptions xAxisDisplayOptions;

    private final ChartAxisLabelOptions xAxisLabelOptions;

    private final LineSeriesAxisDisplayOptions primaryYAxisDisplayOptions;

    private final ChartAxisLabelOptions primaryYAxisLabelOptions;

    private final LineSeriesAxisDisplayOptions secondaryYAxisDisplayOptions;

    private final ChartAxisLabelOptions secondaryYAxisLabelOptions;

    private final SingleAxisOptions singleAxisOptions;

    private final LineChartDefaultSeriesSettings defaultSeriesSettings;

    private final List<SeriesItem> series;

    private final LegendOptions legend;

    private final DataLabelOptions dataLabels;

    private final List<ReferenceLine> referenceLines;

    private final TooltipOptions tooltip;

    private final List<ContributionAnalysisDefault> contributionAnalysisDefaults;

    private final VisualPalette visualPalette;

    private final VisualInteractionOptions interactions;

    private LineChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.forecastConfigurations = builder.forecastConfigurations;
        this.type = builder.type;
        this.smallMultiplesOptions = builder.smallMultiplesOptions;
        this.xAxisDisplayOptions = builder.xAxisDisplayOptions;
        this.xAxisLabelOptions = builder.xAxisLabelOptions;
        this.primaryYAxisDisplayOptions = builder.primaryYAxisDisplayOptions;
        this.primaryYAxisLabelOptions = builder.primaryYAxisLabelOptions;
        this.secondaryYAxisDisplayOptions = builder.secondaryYAxisDisplayOptions;
        this.secondaryYAxisLabelOptions = builder.secondaryYAxisLabelOptions;
        this.singleAxisOptions = builder.singleAxisOptions;
        this.defaultSeriesSettings = builder.defaultSeriesSettings;
        this.series = builder.series;
        this.legend = builder.legend;
        this.dataLabels = builder.dataLabels;
        this.referenceLines = builder.referenceLines;
        this.tooltip = builder.tooltip;
        this.contributionAnalysisDefaults = builder.contributionAnalysisDefaults;
        this.visualPalette = builder.visualPalette;
        this.interactions = builder.interactions;
    }

    /**
     * <p>
     * The field well configuration of a line chart.
     * </p>
     * 
     * @return The field well configuration of a line chart.
     */
    public final LineChartFieldWells fieldWells() {
        return fieldWells;
    }

    /**
     * <p>
     * The sort configuration of a line chart.
     * </p>
     * 
     * @return The sort configuration of a line chart.
     */
    public final LineChartSortConfiguration sortConfiguration() {
        return sortConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ForecastConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasForecastConfigurations() {
        return forecastConfigurations != null && !(forecastConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The forecast configuration of a line chart.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasForecastConfigurations} method.
     * </p>
     * 
     * @return The forecast configuration of a line chart.
     */
    public final List<ForecastConfiguration> forecastConfigurations() {
        return forecastConfigurations;
    }

    /**
     * <p>
     * Determines the type of the line chart.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LineChartType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Determines the type of the line chart.
     * @see LineChartType
     */
    public final LineChartType type() {
        return LineChartType.fromValue(type);
    }

    /**
     * <p>
     * Determines the type of the line chart.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LineChartType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Determines the type of the line chart.
     * @see LineChartType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The small multiples setup for the visual.
     * </p>
     * 
     * @return The small multiples setup for the visual.
     */
    public final SmallMultiplesOptions smallMultiplesOptions() {
        return smallMultiplesOptions;
    }

    /**
     * <p>
     * The options that determine the presentation of the x-axis.
     * </p>
     * 
     * @return The options that determine the presentation of the x-axis.
     */
    public final AxisDisplayOptions xAxisDisplayOptions() {
        return xAxisDisplayOptions;
    }

    /**
     * <p>
     * The options that determine the presentation of the x-axis label.
     * </p>
     * 
     * @return The options that determine the presentation of the x-axis label.
     */
    public final ChartAxisLabelOptions xAxisLabelOptions() {
        return xAxisLabelOptions;
    }

    /**
     * <p>
     * The series axis configuration of a line chart.
     * </p>
     * 
     * @return The series axis configuration of a line chart.
     */
    public final LineSeriesAxisDisplayOptions primaryYAxisDisplayOptions() {
        return primaryYAxisDisplayOptions;
    }

    /**
     * <p>
     * The options that determine the presentation of the y-axis label.
     * </p>
     * 
     * @return The options that determine the presentation of the y-axis label.
     */
    public final ChartAxisLabelOptions primaryYAxisLabelOptions() {
        return primaryYAxisLabelOptions;
    }

    /**
     * <p>
     * The series axis configuration of a line chart.
     * </p>
     * 
     * @return The series axis configuration of a line chart.
     */
    public final LineSeriesAxisDisplayOptions secondaryYAxisDisplayOptions() {
        return secondaryYAxisDisplayOptions;
    }

    /**
     * <p>
     * The options that determine the presentation of the secondary y-axis label.
     * </p>
     * 
     * @return The options that determine the presentation of the secondary y-axis label.
     */
    public final ChartAxisLabelOptions secondaryYAxisLabelOptions() {
        return secondaryYAxisLabelOptions;
    }

    /**
     * Returns the value of the SingleAxisOptions property for this object.
     * 
     * @return The value of the SingleAxisOptions property for this object.
     */
    public final SingleAxisOptions singleAxisOptions() {
        return singleAxisOptions;
    }

    /**
     * <p>
     * The options that determine the default presentation of all line series in <code>LineChartVisual</code>.
     * </p>
     * 
     * @return The options that determine the default presentation of all line series in <code>LineChartVisual</code>.
     */
    public final LineChartDefaultSeriesSettings defaultSeriesSettings() {
        return defaultSeriesSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Series property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSeries() {
        return series != null && !(series instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The series item configuration of a line chart.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSeries} method.
     * </p>
     * 
     * @return The series item configuration of a line chart.
     */
    public final List<SeriesItem> series() {
        return series;
    }

    /**
     * <p>
     * The legend configuration of a line chart.
     * </p>
     * 
     * @return The legend configuration of a line chart.
     */
    public final LegendOptions legend() {
        return legend;
    }

    /**
     * <p>
     * The data label configuration of a line chart.
     * </p>
     * 
     * @return The data label configuration of a line chart.
     */
    public final DataLabelOptions dataLabels() {
        return dataLabels;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReferenceLines property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReferenceLines() {
        return referenceLines != null && !(referenceLines instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The reference lines configuration of a line chart.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferenceLines} method.
     * </p>
     * 
     * @return The reference lines configuration of a line chart.
     */
    public final List<ReferenceLine> referenceLines() {
        return referenceLines;
    }

    /**
     * <p>
     * The tooltip configuration of a line chart.
     * </p>
     * 
     * @return The tooltip configuration of a line chart.
     */
    public final TooltipOptions tooltip() {
        return tooltip;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContributionAnalysisDefaults property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasContributionAnalysisDefaults() {
        return contributionAnalysisDefaults != null && !(contributionAnalysisDefaults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The default configuration of a line chart's contribution analysis.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContributionAnalysisDefaults} method.
     * </p>
     * 
     * @return The default configuration of a line chart's contribution analysis.
     */
    public final List<ContributionAnalysisDefault> contributionAnalysisDefaults() {
        return contributionAnalysisDefaults;
    }

    /**
     * <p>
     * The visual palette configuration of a line chart.
     * </p>
     * 
     * @return The visual palette configuration of a line chart.
     */
    public final VisualPalette visualPalette() {
        return visualPalette;
    }

    /**
     * <p>
     * The general visual interactions setup for a visual.
     * </p>
     * 
     * @return The general visual interactions setup for a visual.
     */
    public final VisualInteractionOptions interactions() {
        return interactions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasForecastConfigurations() ? forecastConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(smallMultiplesOptions());
        hashCode = 31 * hashCode + Objects.hashCode(xAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(xAxisLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(primaryYAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(primaryYAxisLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryYAxisDisplayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryYAxisLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(singleAxisOptions());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSeriesSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasSeries() ? series() : null);
        hashCode = 31 * hashCode + Objects.hashCode(legend());
        hashCode = 31 * hashCode + Objects.hashCode(dataLabels());
        hashCode = 31 * hashCode + Objects.hashCode(hasReferenceLines() ? referenceLines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(hasContributionAnalysisDefaults() ? contributionAnalysisDefaults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(visualPalette());
        hashCode = 31 * hashCode + Objects.hashCode(interactions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineChartConfiguration)) {
            return false;
        }
        LineChartConfiguration other = (LineChartConfiguration) obj;
        return Objects.equals(fieldWells(), other.fieldWells()) && Objects.equals(sortConfiguration(), other.sortConfiguration())
                && hasForecastConfigurations() == other.hasForecastConfigurations()
                && Objects.equals(forecastConfigurations(), other.forecastConfigurations())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(smallMultiplesOptions(), other.smallMultiplesOptions())
                && Objects.equals(xAxisDisplayOptions(), other.xAxisDisplayOptions())
                && Objects.equals(xAxisLabelOptions(), other.xAxisLabelOptions())
                && Objects.equals(primaryYAxisDisplayOptions(), other.primaryYAxisDisplayOptions())
                && Objects.equals(primaryYAxisLabelOptions(), other.primaryYAxisLabelOptions())
                && Objects.equals(secondaryYAxisDisplayOptions(), other.secondaryYAxisDisplayOptions())
                && Objects.equals(secondaryYAxisLabelOptions(), other.secondaryYAxisLabelOptions())
                && Objects.equals(singleAxisOptions(), other.singleAxisOptions())
                && Objects.equals(defaultSeriesSettings(), other.defaultSeriesSettings()) && hasSeries() == other.hasSeries()
                && Objects.equals(series(), other.series()) && Objects.equals(legend(), other.legend())
                && Objects.equals(dataLabels(), other.dataLabels()) && hasReferenceLines() == other.hasReferenceLines()
                && Objects.equals(referenceLines(), other.referenceLines()) && Objects.equals(tooltip(), other.tooltip())
                && hasContributionAnalysisDefaults() == other.hasContributionAnalysisDefaults()
                && Objects.equals(contributionAnalysisDefaults(), other.contributionAnalysisDefaults())
                && Objects.equals(visualPalette(), other.visualPalette()) && Objects.equals(interactions(), other.interactions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineChartConfiguration").add("FieldWells", fieldWells())
                .add("SortConfiguration", sortConfiguration())
                .add("ForecastConfigurations", hasForecastConfigurations() ? forecastConfigurations() : null)
                .add("Type", typeAsString()).add("SmallMultiplesOptions", smallMultiplesOptions())
                .add("XAxisDisplayOptions", xAxisDisplayOptions()).add("XAxisLabelOptions", xAxisLabelOptions())
                .add("PrimaryYAxisDisplayOptions", primaryYAxisDisplayOptions())
                .add("PrimaryYAxisLabelOptions", primaryYAxisLabelOptions())
                .add("SecondaryYAxisDisplayOptions", secondaryYAxisDisplayOptions())
                .add("SecondaryYAxisLabelOptions", secondaryYAxisLabelOptions()).add("SingleAxisOptions", singleAxisOptions())
                .add("DefaultSeriesSettings", defaultSeriesSettings()).add("Series", hasSeries() ? series() : null)
                .add("Legend", legend()).add("DataLabels", dataLabels())
                .add("ReferenceLines", hasReferenceLines() ? referenceLines() : null).add("Tooltip", tooltip())
                .add("ContributionAnalysisDefaults", hasContributionAnalysisDefaults() ? contributionAnalysisDefaults() : null)
                .add("VisualPalette", visualPalette()).add("Interactions", interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldWells":
            return Optional.ofNullable(clazz.cast(fieldWells()));
        case "SortConfiguration":
            return Optional.ofNullable(clazz.cast(sortConfiguration()));
        case "ForecastConfigurations":
            return Optional.ofNullable(clazz.cast(forecastConfigurations()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "SmallMultiplesOptions":
            return Optional.ofNullable(clazz.cast(smallMultiplesOptions()));
        case "XAxisDisplayOptions":
            return Optional.ofNullable(clazz.cast(xAxisDisplayOptions()));
        case "XAxisLabelOptions":
            return Optional.ofNullable(clazz.cast(xAxisLabelOptions()));
        case "PrimaryYAxisDisplayOptions":
            return Optional.ofNullable(clazz.cast(primaryYAxisDisplayOptions()));
        case "PrimaryYAxisLabelOptions":
            return Optional.ofNullable(clazz.cast(primaryYAxisLabelOptions()));
        case "SecondaryYAxisDisplayOptions":
            return Optional.ofNullable(clazz.cast(secondaryYAxisDisplayOptions()));
        case "SecondaryYAxisLabelOptions":
            return Optional.ofNullable(clazz.cast(secondaryYAxisLabelOptions()));
        case "SingleAxisOptions":
            return Optional.ofNullable(clazz.cast(singleAxisOptions()));
        case "DefaultSeriesSettings":
            return Optional.ofNullable(clazz.cast(defaultSeriesSettings()));
        case "Series":
            return Optional.ofNullable(clazz.cast(series()));
        case "Legend":
            return Optional.ofNullable(clazz.cast(legend()));
        case "DataLabels":
            return Optional.ofNullable(clazz.cast(dataLabels()));
        case "ReferenceLines":
            return Optional.ofNullable(clazz.cast(referenceLines()));
        case "Tooltip":
            return Optional.ofNullable(clazz.cast(tooltip()));
        case "ContributionAnalysisDefaults":
            return Optional.ofNullable(clazz.cast(contributionAnalysisDefaults()));
        case "VisualPalette":
            return Optional.ofNullable(clazz.cast(visualPalette()));
        case "Interactions":
            return Optional.ofNullable(clazz.cast(interactions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldWells", FIELD_WELLS_FIELD);
        map.put("SortConfiguration", SORT_CONFIGURATION_FIELD);
        map.put("ForecastConfigurations", FORECAST_CONFIGURATIONS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("SmallMultiplesOptions", SMALL_MULTIPLES_OPTIONS_FIELD);
        map.put("XAxisDisplayOptions", X_AXIS_DISPLAY_OPTIONS_FIELD);
        map.put("XAxisLabelOptions", X_AXIS_LABEL_OPTIONS_FIELD);
        map.put("PrimaryYAxisDisplayOptions", PRIMARY_Y_AXIS_DISPLAY_OPTIONS_FIELD);
        map.put("PrimaryYAxisLabelOptions", PRIMARY_Y_AXIS_LABEL_OPTIONS_FIELD);
        map.put("SecondaryYAxisDisplayOptions", SECONDARY_Y_AXIS_DISPLAY_OPTIONS_FIELD);
        map.put("SecondaryYAxisLabelOptions", SECONDARY_Y_AXIS_LABEL_OPTIONS_FIELD);
        map.put("SingleAxisOptions", SINGLE_AXIS_OPTIONS_FIELD);
        map.put("DefaultSeriesSettings", DEFAULT_SERIES_SETTINGS_FIELD);
        map.put("Series", SERIES_FIELD);
        map.put("Legend", LEGEND_FIELD);
        map.put("DataLabels", DATA_LABELS_FIELD);
        map.put("ReferenceLines", REFERENCE_LINES_FIELD);
        map.put("Tooltip", TOOLTIP_FIELD);
        map.put("ContributionAnalysisDefaults", CONTRIBUTION_ANALYSIS_DEFAULTS_FIELD);
        map.put("VisualPalette", VISUAL_PALETTE_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineChartConfiguration, T> g) {
        return obj -> g.apply((LineChartConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineChartConfiguration> {
        /**
         * <p>
         * The field well configuration of a line chart.
         * </p>
         * 
         * @param fieldWells
         *        The field well configuration of a line chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldWells(LineChartFieldWells fieldWells);

        /**
         * <p>
         * The field well configuration of a line chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link LineChartFieldWells.Builder} avoiding the
         * need to create one manually via {@link LineChartFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LineChartFieldWells.Builder#build()} is called immediately and
         * its result is passed to {@link #fieldWells(LineChartFieldWells)}.
         * 
         * @param fieldWells
         *        a consumer that will call methods on {@link LineChartFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldWells(LineChartFieldWells)
         */
        default Builder fieldWells(Consumer<LineChartFieldWells.Builder> fieldWells) {
            return fieldWells(LineChartFieldWells.builder().applyMutation(fieldWells).build());
        }

        /**
         * <p>
         * The sort configuration of a line chart.
         * </p>
         * 
         * @param sortConfiguration
         *        The sort configuration of a line chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortConfiguration(LineChartSortConfiguration sortConfiguration);

        /**
         * <p>
         * The sort configuration of a line chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link LineChartSortConfiguration.Builder}
         * avoiding the need to create one manually via {@link LineChartSortConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LineChartSortConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #sortConfiguration(LineChartSortConfiguration)}.
         * 
         * @param sortConfiguration
         *        a consumer that will call methods on {@link LineChartSortConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortConfiguration(LineChartSortConfiguration)
         */
        default Builder sortConfiguration(Consumer<LineChartSortConfiguration.Builder> sortConfiguration) {
            return sortConfiguration(LineChartSortConfiguration.builder().applyMutation(sortConfiguration).build());
        }

        /**
         * <p>
         * The forecast configuration of a line chart.
         * </p>
         * 
         * @param forecastConfigurations
         *        The forecast configuration of a line chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastConfigurations(Collection<ForecastConfiguration> forecastConfigurations);

        /**
         * <p>
         * The forecast configuration of a line chart.
         * </p>
         * 
         * @param forecastConfigurations
         *        The forecast configuration of a line chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastConfigurations(ForecastConfiguration... forecastConfigurations);

        /**
         * <p>
         * The forecast configuration of a line chart.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ForecastConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.ForecastConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ForecastConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #forecastConfigurations(List<ForecastConfiguration>)}.
         * 
         * @param forecastConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ForecastConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forecastConfigurations(java.util.Collection<ForecastConfiguration>)
         */
        Builder forecastConfigurations(Consumer<ForecastConfiguration.Builder>... forecastConfigurations);

        /**
         * <p>
         * Determines the type of the line chart.
         * </p>
         * 
         * @param type
         *        Determines the type of the line chart.
         * @see LineChartType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineChartType
         */
        Builder type(String type);

        /**
         * <p>
         * Determines the type of the line chart.
         * </p>
         * 
         * @param type
         *        Determines the type of the line chart.
         * @see LineChartType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineChartType
         */
        Builder type(LineChartType type);

        /**
         * <p>
         * The small multiples setup for the visual.
         * </p>
         * 
         * @param smallMultiplesOptions
         *        The small multiples setup for the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smallMultiplesOptions(SmallMultiplesOptions smallMultiplesOptions);

        /**
         * <p>
         * The small multiples setup for the visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link SmallMultiplesOptions.Builder} avoiding
         * the need to create one manually via {@link SmallMultiplesOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SmallMultiplesOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #smallMultiplesOptions(SmallMultiplesOptions)}.
         * 
         * @param smallMultiplesOptions
         *        a consumer that will call methods on {@link SmallMultiplesOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #smallMultiplesOptions(SmallMultiplesOptions)
         */
        default Builder smallMultiplesOptions(Consumer<SmallMultiplesOptions.Builder> smallMultiplesOptions) {
            return smallMultiplesOptions(SmallMultiplesOptions.builder().applyMutation(smallMultiplesOptions).build());
        }

        /**
         * <p>
         * The options that determine the presentation of the x-axis.
         * </p>
         * 
         * @param xAxisDisplayOptions
         *        The options that determine the presentation of the x-axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xAxisDisplayOptions(AxisDisplayOptions xAxisDisplayOptions);

        /**
         * <p>
         * The options that determine the presentation of the x-axis.
         * </p>
         * This is a convenience method that creates an instance of the {@link AxisDisplayOptions.Builder} avoiding the
         * need to create one manually via {@link AxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AxisDisplayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #xAxisDisplayOptions(AxisDisplayOptions)}.
         * 
         * @param xAxisDisplayOptions
         *        a consumer that will call methods on {@link AxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xAxisDisplayOptions(AxisDisplayOptions)
         */
        default Builder xAxisDisplayOptions(Consumer<AxisDisplayOptions.Builder> xAxisDisplayOptions) {
            return xAxisDisplayOptions(AxisDisplayOptions.builder().applyMutation(xAxisDisplayOptions).build());
        }

        /**
         * <p>
         * The options that determine the presentation of the x-axis label.
         * </p>
         * 
         * @param xAxisLabelOptions
         *        The options that determine the presentation of the x-axis label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xAxisLabelOptions(ChartAxisLabelOptions xAxisLabelOptions);

        /**
         * <p>
         * The options that determine the presentation of the x-axis label.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #xAxisLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param xAxisLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xAxisLabelOptions(ChartAxisLabelOptions)
         */
        default Builder xAxisLabelOptions(Consumer<ChartAxisLabelOptions.Builder> xAxisLabelOptions) {
            return xAxisLabelOptions(ChartAxisLabelOptions.builder().applyMutation(xAxisLabelOptions).build());
        }

        /**
         * <p>
         * The series axis configuration of a line chart.
         * </p>
         * 
         * @param primaryYAxisDisplayOptions
         *        The series axis configuration of a line chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions primaryYAxisDisplayOptions);

        /**
         * <p>
         * The series axis configuration of a line chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link LineSeriesAxisDisplayOptions.Builder}
         * avoiding the need to create one manually via {@link LineSeriesAxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LineSeriesAxisDisplayOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #primaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions)}.
         * 
         * @param primaryYAxisDisplayOptions
         *        a consumer that will call methods on {@link LineSeriesAxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions)
         */
        default Builder primaryYAxisDisplayOptions(Consumer<LineSeriesAxisDisplayOptions.Builder> primaryYAxisDisplayOptions) {
            return primaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions.builder().applyMutation(primaryYAxisDisplayOptions)
                    .build());
        }

        /**
         * <p>
         * The options that determine the presentation of the y-axis label.
         * </p>
         * 
         * @param primaryYAxisLabelOptions
         *        The options that determine the presentation of the y-axis label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryYAxisLabelOptions(ChartAxisLabelOptions primaryYAxisLabelOptions);

        /**
         * <p>
         * The options that determine the presentation of the y-axis label.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #primaryYAxisLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param primaryYAxisLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryYAxisLabelOptions(ChartAxisLabelOptions)
         */
        default Builder primaryYAxisLabelOptions(Consumer<ChartAxisLabelOptions.Builder> primaryYAxisLabelOptions) {
            return primaryYAxisLabelOptions(ChartAxisLabelOptions.builder().applyMutation(primaryYAxisLabelOptions).build());
        }

        /**
         * <p>
         * The series axis configuration of a line chart.
         * </p>
         * 
         * @param secondaryYAxisDisplayOptions
         *        The series axis configuration of a line chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions secondaryYAxisDisplayOptions);

        /**
         * <p>
         * The series axis configuration of a line chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link LineSeriesAxisDisplayOptions.Builder}
         * avoiding the need to create one manually via {@link LineSeriesAxisDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LineSeriesAxisDisplayOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #secondaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions)}.
         * 
         * @param secondaryYAxisDisplayOptions
         *        a consumer that will call methods on {@link LineSeriesAxisDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions)
         */
        default Builder secondaryYAxisDisplayOptions(Consumer<LineSeriesAxisDisplayOptions.Builder> secondaryYAxisDisplayOptions) {
            return secondaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions.builder()
                    .applyMutation(secondaryYAxisDisplayOptions).build());
        }

        /**
         * <p>
         * The options that determine the presentation of the secondary y-axis label.
         * </p>
         * 
         * @param secondaryYAxisLabelOptions
         *        The options that determine the presentation of the secondary y-axis label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryYAxisLabelOptions(ChartAxisLabelOptions secondaryYAxisLabelOptions);

        /**
         * <p>
         * The options that determine the presentation of the secondary y-axis label.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChartAxisLabelOptions.Builder} avoiding
         * the need to create one manually via {@link ChartAxisLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChartAxisLabelOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #secondaryYAxisLabelOptions(ChartAxisLabelOptions)}.
         * 
         * @param secondaryYAxisLabelOptions
         *        a consumer that will call methods on {@link ChartAxisLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondaryYAxisLabelOptions(ChartAxisLabelOptions)
         */
        default Builder secondaryYAxisLabelOptions(Consumer<ChartAxisLabelOptions.Builder> secondaryYAxisLabelOptions) {
            return secondaryYAxisLabelOptions(ChartAxisLabelOptions.builder().applyMutation(secondaryYAxisLabelOptions).build());
        }

        /**
         * Sets the value of the SingleAxisOptions property for this object.
         *
         * @param singleAxisOptions
         *        The new value for the SingleAxisOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleAxisOptions(SingleAxisOptions singleAxisOptions);

        /**
         * Sets the value of the SingleAxisOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SingleAxisOptions.Builder} avoiding the
         * need to create one manually via {@link SingleAxisOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SingleAxisOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #singleAxisOptions(SingleAxisOptions)}.
         * 
         * @param singleAxisOptions
         *        a consumer that will call methods on {@link SingleAxisOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singleAxisOptions(SingleAxisOptions)
         */
        default Builder singleAxisOptions(Consumer<SingleAxisOptions.Builder> singleAxisOptions) {
            return singleAxisOptions(SingleAxisOptions.builder().applyMutation(singleAxisOptions).build());
        }

        /**
         * <p>
         * The options that determine the default presentation of all line series in <code>LineChartVisual</code>.
         * </p>
         * 
         * @param defaultSeriesSettings
         *        The options that determine the default presentation of all line series in <code>LineChartVisual</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSeriesSettings(LineChartDefaultSeriesSettings defaultSeriesSettings);

        /**
         * <p>
         * The options that determine the default presentation of all line series in <code>LineChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link LineChartDefaultSeriesSettings.Builder}
         * avoiding the need to create one manually via {@link LineChartDefaultSeriesSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LineChartDefaultSeriesSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #defaultSeriesSettings(LineChartDefaultSeriesSettings)}.
         * 
         * @param defaultSeriesSettings
         *        a consumer that will call methods on {@link LineChartDefaultSeriesSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultSeriesSettings(LineChartDefaultSeriesSettings)
         */
        default Builder defaultSeriesSettings(Consumer<LineChartDefaultSeriesSettings.Builder> defaultSeriesSettings) {
            return defaultSeriesSettings(LineChartDefaultSeriesSettings.builder().applyMutation(defaultSeriesSettings).build());
        }

        /**
         * <p>
         * The series item configuration of a line chart.
         * </p>
         * 
         * @param series
         *        The series item configuration of a line chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder series(Collection<SeriesItem> series);

        /**
         * <p>
         * The series item configuration of a line chart.
         * </p>
         * 
         * @param series
         *        The series item configuration of a line chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder series(SeriesItem... series);

        /**
         * <p>
         * The series item configuration of a line chart.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SeriesItem.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.SeriesItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SeriesItem.Builder#build()} is called immediately and
         * its result is passed to {@link #series(List<SeriesItem>)}.
         * 
         * @param series
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SeriesItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #series(java.util.Collection<SeriesItem>)
         */
        Builder series(Consumer<SeriesItem.Builder>... series);

        /**
         * <p>
         * The legend configuration of a line chart.
         * </p>
         * 
         * @param legend
         *        The legend configuration of a line chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legend(LegendOptions legend);

        /**
         * <p>
         * The legend configuration of a line chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link LegendOptions.Builder} avoiding the need
         * to create one manually via {@link LegendOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LegendOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #legend(LegendOptions)}.
         * 
         * @param legend
         *        a consumer that will call methods on {@link LegendOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legend(LegendOptions)
         */
        default Builder legend(Consumer<LegendOptions.Builder> legend) {
            return legend(LegendOptions.builder().applyMutation(legend).build());
        }

        /**
         * <p>
         * The data label configuration of a line chart.
         * </p>
         * 
         * @param dataLabels
         *        The data label configuration of a line chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLabels(DataLabelOptions dataLabels);

        /**
         * <p>
         * The data label configuration of a line chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLabelOptions.Builder} avoiding the
         * need to create one manually via {@link DataLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #dataLabels(DataLabelOptions)}.
         * 
         * @param dataLabels
         *        a consumer that will call methods on {@link DataLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataLabels(DataLabelOptions)
         */
        default Builder dataLabels(Consumer<DataLabelOptions.Builder> dataLabels) {
            return dataLabels(DataLabelOptions.builder().applyMutation(dataLabels).build());
        }

        /**
         * <p>
         * The reference lines configuration of a line chart.
         * </p>
         * 
         * @param referenceLines
         *        The reference lines configuration of a line chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceLines(Collection<ReferenceLine> referenceLines);

        /**
         * <p>
         * The reference lines configuration of a line chart.
         * </p>
         * 
         * @param referenceLines
         *        The reference lines configuration of a line chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceLines(ReferenceLine... referenceLines);

        /**
         * <p>
         * The reference lines configuration of a line chart.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ReferenceLine.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.ReferenceLine#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ReferenceLine.Builder#build()} is called immediately
         * and its result is passed to {@link #referenceLines(List<ReferenceLine>)}.
         * 
         * @param referenceLines
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ReferenceLine.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referenceLines(java.util.Collection<ReferenceLine>)
         */
        Builder referenceLines(Consumer<ReferenceLine.Builder>... referenceLines);

        /**
         * <p>
         * The tooltip configuration of a line chart.
         * </p>
         * 
         * @param tooltip
         *        The tooltip configuration of a line chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooltip(TooltipOptions tooltip);

        /**
         * <p>
         * The tooltip configuration of a line chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link TooltipOptions.Builder} avoiding the need
         * to create one manually via {@link TooltipOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TooltipOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #tooltip(TooltipOptions)}.
         * 
         * @param tooltip
         *        a consumer that will call methods on {@link TooltipOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tooltip(TooltipOptions)
         */
        default Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return tooltip(TooltipOptions.builder().applyMutation(tooltip).build());
        }

        /**
         * <p>
         * The default configuration of a line chart's contribution analysis.
         * </p>
         * 
         * @param contributionAnalysisDefaults
         *        The default configuration of a line chart's contribution analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributionAnalysisDefaults(Collection<ContributionAnalysisDefault> contributionAnalysisDefaults);

        /**
         * <p>
         * The default configuration of a line chart's contribution analysis.
         * </p>
         * 
         * @param contributionAnalysisDefaults
         *        The default configuration of a line chart's contribution analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributionAnalysisDefaults(ContributionAnalysisDefault... contributionAnalysisDefaults);

        /**
         * <p>
         * The default configuration of a line chart's contribution analysis.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ContributionAnalysisDefault.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.ContributionAnalysisDefault#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ContributionAnalysisDefault.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #contributionAnalysisDefaults(List<ContributionAnalysisDefault>)}.
         * 
         * @param contributionAnalysisDefaults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ContributionAnalysisDefault.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contributionAnalysisDefaults(java.util.Collection<ContributionAnalysisDefault>)
         */
        Builder contributionAnalysisDefaults(Consumer<ContributionAnalysisDefault.Builder>... contributionAnalysisDefaults);

        /**
         * <p>
         * The visual palette configuration of a line chart.
         * </p>
         * 
         * @param visualPalette
         *        The visual palette configuration of a line chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualPalette(VisualPalette visualPalette);

        /**
         * <p>
         * The visual palette configuration of a line chart.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualPalette.Builder} avoiding the need
         * to create one manually via {@link VisualPalette#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualPalette.Builder#build()} is called immediately and its
         * result is passed to {@link #visualPalette(VisualPalette)}.
         * 
         * @param visualPalette
         *        a consumer that will call methods on {@link VisualPalette.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visualPalette(VisualPalette)
         */
        default Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return visualPalette(VisualPalette.builder().applyMutation(visualPalette).build());
        }

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * 
         * @param interactions
         *        The general visual interactions setup for a visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interactions(VisualInteractionOptions interactions);

        /**
         * <p>
         * The general visual interactions setup for a visual.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualInteractionOptions.Builder}
         * avoiding the need to create one manually via {@link VisualInteractionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualInteractionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #interactions(VisualInteractionOptions)}.
         * 
         * @param interactions
         *        a consumer that will call methods on {@link VisualInteractionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interactions(VisualInteractionOptions)
         */
        default Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return interactions(VisualInteractionOptions.builder().applyMutation(interactions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LineChartFieldWells fieldWells;

        private LineChartSortConfiguration sortConfiguration;

        private List<ForecastConfiguration> forecastConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private SmallMultiplesOptions smallMultiplesOptions;

        private AxisDisplayOptions xAxisDisplayOptions;

        private ChartAxisLabelOptions xAxisLabelOptions;

        private LineSeriesAxisDisplayOptions primaryYAxisDisplayOptions;

        private ChartAxisLabelOptions primaryYAxisLabelOptions;

        private LineSeriesAxisDisplayOptions secondaryYAxisDisplayOptions;

        private ChartAxisLabelOptions secondaryYAxisLabelOptions;

        private SingleAxisOptions singleAxisOptions;

        private LineChartDefaultSeriesSettings defaultSeriesSettings;

        private List<SeriesItem> series = DefaultSdkAutoConstructList.getInstance();

        private LegendOptions legend;

        private DataLabelOptions dataLabels;

        private List<ReferenceLine> referenceLines = DefaultSdkAutoConstructList.getInstance();

        private TooltipOptions tooltip;

        private List<ContributionAnalysisDefault> contributionAnalysisDefaults = DefaultSdkAutoConstructList.getInstance();

        private VisualPalette visualPalette;

        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(LineChartConfiguration model) {
            fieldWells(model.fieldWells);
            sortConfiguration(model.sortConfiguration);
            forecastConfigurations(model.forecastConfigurations);
            type(model.type);
            smallMultiplesOptions(model.smallMultiplesOptions);
            xAxisDisplayOptions(model.xAxisDisplayOptions);
            xAxisLabelOptions(model.xAxisLabelOptions);
            primaryYAxisDisplayOptions(model.primaryYAxisDisplayOptions);
            primaryYAxisLabelOptions(model.primaryYAxisLabelOptions);
            secondaryYAxisDisplayOptions(model.secondaryYAxisDisplayOptions);
            secondaryYAxisLabelOptions(model.secondaryYAxisLabelOptions);
            singleAxisOptions(model.singleAxisOptions);
            defaultSeriesSettings(model.defaultSeriesSettings);
            series(model.series);
            legend(model.legend);
            dataLabels(model.dataLabels);
            referenceLines(model.referenceLines);
            tooltip(model.tooltip);
            contributionAnalysisDefaults(model.contributionAnalysisDefaults);
            visualPalette(model.visualPalette);
            interactions(model.interactions);
        }

        public final LineChartFieldWells.Builder getFieldWells() {
            return fieldWells != null ? fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(LineChartFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(LineChartFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final LineChartSortConfiguration.Builder getSortConfiguration() {
            return sortConfiguration != null ? sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(LineChartSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(LineChartSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final List<ForecastConfiguration.Builder> getForecastConfigurations() {
            List<ForecastConfiguration.Builder> result = ForecastConfigurationListCopier
                    .copyToBuilder(this.forecastConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setForecastConfigurations(Collection<ForecastConfiguration.BuilderImpl> forecastConfigurations) {
            this.forecastConfigurations = ForecastConfigurationListCopier.copyFromBuilder(forecastConfigurations);
        }

        @Override
        public final Builder forecastConfigurations(Collection<ForecastConfiguration> forecastConfigurations) {
            this.forecastConfigurations = ForecastConfigurationListCopier.copy(forecastConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastConfigurations(ForecastConfiguration... forecastConfigurations) {
            forecastConfigurations(Arrays.asList(forecastConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forecastConfigurations(Consumer<ForecastConfiguration.Builder>... forecastConfigurations) {
            forecastConfigurations(Stream.of(forecastConfigurations)
                    .map(c -> ForecastConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LineChartType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final SmallMultiplesOptions.Builder getSmallMultiplesOptions() {
            return smallMultiplesOptions != null ? smallMultiplesOptions.toBuilder() : null;
        }

        public final void setSmallMultiplesOptions(SmallMultiplesOptions.BuilderImpl smallMultiplesOptions) {
            this.smallMultiplesOptions = smallMultiplesOptions != null ? smallMultiplesOptions.build() : null;
        }

        @Override
        public final Builder smallMultiplesOptions(SmallMultiplesOptions smallMultiplesOptions) {
            this.smallMultiplesOptions = smallMultiplesOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getXAxisDisplayOptions() {
            return xAxisDisplayOptions != null ? xAxisDisplayOptions.toBuilder() : null;
        }

        public final void setXAxisDisplayOptions(AxisDisplayOptions.BuilderImpl xAxisDisplayOptions) {
            this.xAxisDisplayOptions = xAxisDisplayOptions != null ? xAxisDisplayOptions.build() : null;
        }

        @Override
        public final Builder xAxisDisplayOptions(AxisDisplayOptions xAxisDisplayOptions) {
            this.xAxisDisplayOptions = xAxisDisplayOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getXAxisLabelOptions() {
            return xAxisLabelOptions != null ? xAxisLabelOptions.toBuilder() : null;
        }

        public final void setXAxisLabelOptions(ChartAxisLabelOptions.BuilderImpl xAxisLabelOptions) {
            this.xAxisLabelOptions = xAxisLabelOptions != null ? xAxisLabelOptions.build() : null;
        }

        @Override
        public final Builder xAxisLabelOptions(ChartAxisLabelOptions xAxisLabelOptions) {
            this.xAxisLabelOptions = xAxisLabelOptions;
            return this;
        }

        public final LineSeriesAxisDisplayOptions.Builder getPrimaryYAxisDisplayOptions() {
            return primaryYAxisDisplayOptions != null ? primaryYAxisDisplayOptions.toBuilder() : null;
        }

        public final void setPrimaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions.BuilderImpl primaryYAxisDisplayOptions) {
            this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions != null ? primaryYAxisDisplayOptions.build() : null;
        }

        @Override
        public final Builder primaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions primaryYAxisDisplayOptions) {
            this.primaryYAxisDisplayOptions = primaryYAxisDisplayOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getPrimaryYAxisLabelOptions() {
            return primaryYAxisLabelOptions != null ? primaryYAxisLabelOptions.toBuilder() : null;
        }

        public final void setPrimaryYAxisLabelOptions(ChartAxisLabelOptions.BuilderImpl primaryYAxisLabelOptions) {
            this.primaryYAxisLabelOptions = primaryYAxisLabelOptions != null ? primaryYAxisLabelOptions.build() : null;
        }

        @Override
        public final Builder primaryYAxisLabelOptions(ChartAxisLabelOptions primaryYAxisLabelOptions) {
            this.primaryYAxisLabelOptions = primaryYAxisLabelOptions;
            return this;
        }

        public final LineSeriesAxisDisplayOptions.Builder getSecondaryYAxisDisplayOptions() {
            return secondaryYAxisDisplayOptions != null ? secondaryYAxisDisplayOptions.toBuilder() : null;
        }

        public final void setSecondaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions.BuilderImpl secondaryYAxisDisplayOptions) {
            this.secondaryYAxisDisplayOptions = secondaryYAxisDisplayOptions != null ? secondaryYAxisDisplayOptions.build()
                    : null;
        }

        @Override
        public final Builder secondaryYAxisDisplayOptions(LineSeriesAxisDisplayOptions secondaryYAxisDisplayOptions) {
            this.secondaryYAxisDisplayOptions = secondaryYAxisDisplayOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getSecondaryYAxisLabelOptions() {
            return secondaryYAxisLabelOptions != null ? secondaryYAxisLabelOptions.toBuilder() : null;
        }

        public final void setSecondaryYAxisLabelOptions(ChartAxisLabelOptions.BuilderImpl secondaryYAxisLabelOptions) {
            this.secondaryYAxisLabelOptions = secondaryYAxisLabelOptions != null ? secondaryYAxisLabelOptions.build() : null;
        }

        @Override
        public final Builder secondaryYAxisLabelOptions(ChartAxisLabelOptions secondaryYAxisLabelOptions) {
            this.secondaryYAxisLabelOptions = secondaryYAxisLabelOptions;
            return this;
        }

        public final SingleAxisOptions.Builder getSingleAxisOptions() {
            return singleAxisOptions != null ? singleAxisOptions.toBuilder() : null;
        }

        public final void setSingleAxisOptions(SingleAxisOptions.BuilderImpl singleAxisOptions) {
            this.singleAxisOptions = singleAxisOptions != null ? singleAxisOptions.build() : null;
        }

        @Override
        public final Builder singleAxisOptions(SingleAxisOptions singleAxisOptions) {
            this.singleAxisOptions = singleAxisOptions;
            return this;
        }

        public final LineChartDefaultSeriesSettings.Builder getDefaultSeriesSettings() {
            return defaultSeriesSettings != null ? defaultSeriesSettings.toBuilder() : null;
        }

        public final void setDefaultSeriesSettings(LineChartDefaultSeriesSettings.BuilderImpl defaultSeriesSettings) {
            this.defaultSeriesSettings = defaultSeriesSettings != null ? defaultSeriesSettings.build() : null;
        }

        @Override
        public final Builder defaultSeriesSettings(LineChartDefaultSeriesSettings defaultSeriesSettings) {
            this.defaultSeriesSettings = defaultSeriesSettings;
            return this;
        }

        public final List<SeriesItem.Builder> getSeries() {
            List<SeriesItem.Builder> result = SeriesItemListCopier.copyToBuilder(this.series);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSeries(Collection<SeriesItem.BuilderImpl> series) {
            this.series = SeriesItemListCopier.copyFromBuilder(series);
        }

        @Override
        public final Builder series(Collection<SeriesItem> series) {
            this.series = SeriesItemListCopier.copy(series);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder series(SeriesItem... series) {
            series(Arrays.asList(series));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder series(Consumer<SeriesItem.Builder>... series) {
            series(Stream.of(series).map(c -> SeriesItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final LegendOptions.Builder getLegend() {
            return legend != null ? legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        public final DataLabelOptions.Builder getDataLabels() {
            return dataLabels != null ? dataLabels.toBuilder() : null;
        }

        public final void setDataLabels(DataLabelOptions.BuilderImpl dataLabels) {
            this.dataLabels = dataLabels != null ? dataLabels.build() : null;
        }

        @Override
        public final Builder dataLabels(DataLabelOptions dataLabels) {
            this.dataLabels = dataLabels;
            return this;
        }

        public final List<ReferenceLine.Builder> getReferenceLines() {
            List<ReferenceLine.Builder> result = ReferenceLineListCopier.copyToBuilder(this.referenceLines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferenceLines(Collection<ReferenceLine.BuilderImpl> referenceLines) {
            this.referenceLines = ReferenceLineListCopier.copyFromBuilder(referenceLines);
        }

        @Override
        public final Builder referenceLines(Collection<ReferenceLine> referenceLines) {
            this.referenceLines = ReferenceLineListCopier.copy(referenceLines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLines(ReferenceLine... referenceLines) {
            referenceLines(Arrays.asList(referenceLines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLines(Consumer<ReferenceLine.Builder>... referenceLines) {
            referenceLines(Stream.of(referenceLines).map(c -> ReferenceLine.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return tooltip != null ? tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final List<ContributionAnalysisDefault.Builder> getContributionAnalysisDefaults() {
            List<ContributionAnalysisDefault.Builder> result = ContributionAnalysisDefaultListCopier
                    .copyToBuilder(this.contributionAnalysisDefaults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContributionAnalysisDefaults(
                Collection<ContributionAnalysisDefault.BuilderImpl> contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults = ContributionAnalysisDefaultListCopier
                    .copyFromBuilder(contributionAnalysisDefaults);
        }

        @Override
        public final Builder contributionAnalysisDefaults(Collection<ContributionAnalysisDefault> contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults = ContributionAnalysisDefaultListCopier.copy(contributionAnalysisDefaults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributionAnalysisDefaults(ContributionAnalysisDefault... contributionAnalysisDefaults) {
            contributionAnalysisDefaults(Arrays.asList(contributionAnalysisDefaults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributionAnalysisDefaults(
                Consumer<ContributionAnalysisDefault.Builder>... contributionAnalysisDefaults) {
            contributionAnalysisDefaults(Stream.of(contributionAnalysisDefaults)
                    .map(c -> ContributionAnalysisDefault.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return visualPalette != null ? visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return interactions != null ? interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        @Override
        public LineChartConfiguration build() {
            return new LineChartConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
