/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration options that determine how missing data is treated during the rendering of a line chart.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MissingDataConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MissingDataConfiguration.Builder, MissingDataConfiguration> {
    private static final SdkField<String> TREATMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TreatmentOption").getter(getter(MissingDataConfiguration::treatmentOptionAsString))
            .setter(setter(Builder::treatmentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatmentOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TREATMENT_OPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String treatmentOption;

    private MissingDataConfiguration(BuilderImpl builder) {
        this.treatmentOption = builder.treatmentOption;
    }

    /**
     * <p>
     * The treatment option that determines how missing data should be rendered. Choose from the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INTERPOLATE</code>: Interpolate missing values between the prior and the next known value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SHOW_AS_ZERO</code>: Show missing values as the value <code>0</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SHOW_AS_BLANK</code>: Display a blank space when rendering missing data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #treatmentOption}
     * will return {@link MissingDataTreatmentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #treatmentOptionAsString}.
     * </p>
     * 
     * @return The treatment option that determines how missing data should be rendered. Choose from the following
     *         options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INTERPOLATE</code>: Interpolate missing values between the prior and the next known value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SHOW_AS_ZERO</code>: Show missing values as the value <code>0</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SHOW_AS_BLANK</code>: Display a blank space when rendering missing data.
     *         </p>
     *         </li>
     * @see MissingDataTreatmentOption
     */
    public final MissingDataTreatmentOption treatmentOption() {
        return MissingDataTreatmentOption.fromValue(treatmentOption);
    }

    /**
     * <p>
     * The treatment option that determines how missing data should be rendered. Choose from the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INTERPOLATE</code>: Interpolate missing values between the prior and the next known value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SHOW_AS_ZERO</code>: Show missing values as the value <code>0</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SHOW_AS_BLANK</code>: Display a blank space when rendering missing data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #treatmentOption}
     * will return {@link MissingDataTreatmentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #treatmentOptionAsString}.
     * </p>
     * 
     * @return The treatment option that determines how missing data should be rendered. Choose from the following
     *         options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INTERPOLATE</code>: Interpolate missing values between the prior and the next known value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SHOW_AS_ZERO</code>: Show missing values as the value <code>0</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SHOW_AS_BLANK</code>: Display a blank space when rendering missing data.
     *         </p>
     *         </li>
     * @see MissingDataTreatmentOption
     */
    public final String treatmentOptionAsString() {
        return treatmentOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(treatmentOptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MissingDataConfiguration)) {
            return false;
        }
        MissingDataConfiguration other = (MissingDataConfiguration) obj;
        return Objects.equals(treatmentOptionAsString(), other.treatmentOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MissingDataConfiguration").add("TreatmentOption", treatmentOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TreatmentOption":
            return Optional.ofNullable(clazz.cast(treatmentOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TreatmentOption", TREATMENT_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MissingDataConfiguration, T> g) {
        return obj -> g.apply((MissingDataConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MissingDataConfiguration> {
        /**
         * <p>
         * The treatment option that determines how missing data should be rendered. Choose from the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INTERPOLATE</code>: Interpolate missing values between the prior and the next known value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SHOW_AS_ZERO</code>: Show missing values as the value <code>0</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SHOW_AS_BLANK</code>: Display a blank space when rendering missing data.
         * </p>
         * </li>
         * </ul>
         * 
         * @param treatmentOption
         *        The treatment option that determines how missing data should be rendered. Choose from the following
         *        options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INTERPOLATE</code>: Interpolate missing values between the prior and the next known value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SHOW_AS_ZERO</code>: Show missing values as the value <code>0</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SHOW_AS_BLANK</code>: Display a blank space when rendering missing data.
         *        </p>
         *        </li>
         * @see MissingDataTreatmentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MissingDataTreatmentOption
         */
        Builder treatmentOption(String treatmentOption);

        /**
         * <p>
         * The treatment option that determines how missing data should be rendered. Choose from the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INTERPOLATE</code>: Interpolate missing values between the prior and the next known value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SHOW_AS_ZERO</code>: Show missing values as the value <code>0</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SHOW_AS_BLANK</code>: Display a blank space when rendering missing data.
         * </p>
         * </li>
         * </ul>
         * 
         * @param treatmentOption
         *        The treatment option that determines how missing data should be rendered. Choose from the following
         *        options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INTERPOLATE</code>: Interpolate missing values between the prior and the next known value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SHOW_AS_ZERO</code>: Show missing values as the value <code>0</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SHOW_AS_BLANK</code>: Display a blank space when rendering missing data.
         *        </p>
         *        </li>
         * @see MissingDataTreatmentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MissingDataTreatmentOption
         */
        Builder treatmentOption(MissingDataTreatmentOption treatmentOption);
    }

    static final class BuilderImpl implements Builder {
        private String treatmentOption;

        private BuilderImpl() {
        }

        private BuilderImpl(MissingDataConfiguration model) {
            treatmentOption(model.treatmentOption);
        }

        public final String getTreatmentOption() {
            return treatmentOption;
        }

        public final void setTreatmentOption(String treatmentOption) {
            this.treatmentOption = treatmentOption;
        }

        @Override
        public final Builder treatmentOption(String treatmentOption) {
            this.treatmentOption = treatmentOption;
            return this;
        }

        @Override
        public final Builder treatmentOption(MissingDataTreatmentOption treatmentOption) {
            this.treatmentOption(treatmentOption == null ? null : treatmentOption.toString());
            return this;
        }

        @Override
        public MissingDataConfiguration build() {
            return new MissingDataConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
