/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A flexible visualization type that allows engineers to create new custom charts in Amazon QuickSight.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PluginVisual implements SdkPojo, Serializable, ToCopyableBuilder<PluginVisual.Builder, PluginVisual> {
    private static final SdkField<String> VISUAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VisualId").getter(getter(PluginVisual::visualId)).setter(setter(Builder::visualId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualId").build()).build();

    private static final SdkField<String> PLUGIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PluginArn").getter(getter(PluginVisual::pluginArn)).setter(setter(Builder::pluginArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginArn").build()).build();

    private static final SdkField<VisualTitleLabelOptions> TITLE_FIELD = SdkField
            .<VisualTitleLabelOptions> builder(MarshallingType.SDK_POJO).memberName("Title").getter(getter(PluginVisual::title))
            .setter(setter(Builder::title)).constructor(VisualTitleLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<VisualSubtitleLabelOptions> SUBTITLE_FIELD = SdkField
            .<VisualSubtitleLabelOptions> builder(MarshallingType.SDK_POJO).memberName("Subtitle")
            .getter(getter(PluginVisual::subtitle)).setter(setter(Builder::subtitle))
            .constructor(VisualSubtitleLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subtitle").build()).build();

    private static final SdkField<PluginVisualConfiguration> CHART_CONFIGURATION_FIELD = SdkField
            .<PluginVisualConfiguration> builder(MarshallingType.SDK_POJO).memberName("ChartConfiguration")
            .getter(getter(PluginVisual::chartConfiguration)).setter(setter(Builder::chartConfiguration))
            .constructor(PluginVisualConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChartConfiguration").build())
            .build();

    private static final SdkField<String> VISUAL_CONTENT_ALT_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VisualContentAltText").getter(getter(PluginVisual::visualContentAltText))
            .setter(setter(Builder::visualContentAltText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualContentAltText").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISUAL_ID_FIELD,
            PLUGIN_ARN_FIELD, TITLE_FIELD, SUBTITLE_FIELD, CHART_CONFIGURATION_FIELD, VISUAL_CONTENT_ALT_TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String visualId;

    private final String pluginArn;

    private final VisualTitleLabelOptions title;

    private final VisualSubtitleLabelOptions subtitle;

    private final PluginVisualConfiguration chartConfiguration;

    private final String visualContentAltText;

    private PluginVisual(BuilderImpl builder) {
        this.visualId = builder.visualId;
        this.pluginArn = builder.pluginArn;
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.chartConfiguration = builder.chartConfiguration;
        this.visualContentAltText = builder.visualContentAltText;
    }

    /**
     * <p>
     * The ID of the visual that you want to use.
     * </p>
     * 
     * @return The ID of the visual that you want to use.
     */
    public final String visualId() {
        return visualId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that reflects the plugin and version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that reflects the plugin and version.
     */
    public final String pluginArn() {
        return pluginArn;
    }

    /**
     * Returns the value of the Title property for this object.
     * 
     * @return The value of the Title property for this object.
     */
    public final VisualTitleLabelOptions title() {
        return title;
    }

    /**
     * Returns the value of the Subtitle property for this object.
     * 
     * @return The value of the Subtitle property for this object.
     */
    public final VisualSubtitleLabelOptions subtitle() {
        return subtitle;
    }

    /**
     * <p>
     * A description of the plugin field wells and their persisted properties.
     * </p>
     * 
     * @return A description of the plugin field wells and their persisted properties.
     */
    public final PluginVisualConfiguration chartConfiguration() {
        return chartConfiguration;
    }

    /**
     * <p>
     * The alt text for the visual.
     * </p>
     * 
     * @return The alt text for the visual.
     */
    public final String visualContentAltText() {
        return visualContentAltText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(visualId());
        hashCode = 31 * hashCode + Objects.hashCode(pluginArn());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(subtitle());
        hashCode = 31 * hashCode + Objects.hashCode(chartConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(visualContentAltText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PluginVisual)) {
            return false;
        }
        PluginVisual other = (PluginVisual) obj;
        return Objects.equals(visualId(), other.visualId()) && Objects.equals(pluginArn(), other.pluginArn())
                && Objects.equals(title(), other.title()) && Objects.equals(subtitle(), other.subtitle())
                && Objects.equals(chartConfiguration(), other.chartConfiguration())
                && Objects.equals(visualContentAltText(), other.visualContentAltText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PluginVisual").add("VisualId", visualId()).add("PluginArn", pluginArn()).add("Title", title())
                .add("Subtitle", subtitle()).add("ChartConfiguration", chartConfiguration())
                .add("VisualContentAltText", visualContentAltText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VisualId":
            return Optional.ofNullable(clazz.cast(visualId()));
        case "PluginArn":
            return Optional.ofNullable(clazz.cast(pluginArn()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Subtitle":
            return Optional.ofNullable(clazz.cast(subtitle()));
        case "ChartConfiguration":
            return Optional.ofNullable(clazz.cast(chartConfiguration()));
        case "VisualContentAltText":
            return Optional.ofNullable(clazz.cast(visualContentAltText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VisualId", VISUAL_ID_FIELD);
        map.put("PluginArn", PLUGIN_ARN_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Subtitle", SUBTITLE_FIELD);
        map.put("ChartConfiguration", CHART_CONFIGURATION_FIELD);
        map.put("VisualContentAltText", VISUAL_CONTENT_ALT_TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PluginVisual, T> g) {
        return obj -> g.apply((PluginVisual) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PluginVisual> {
        /**
         * <p>
         * The ID of the visual that you want to use.
         * </p>
         * 
         * @param visualId
         *        The ID of the visual that you want to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualId(String visualId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that reflects the plugin and version.
         * </p>
         * 
         * @param pluginArn
         *        The Amazon Resource Name (ARN) that reflects the plugin and version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginArn(String pluginArn);

        /**
         * Sets the value of the Title property for this object.
         *
         * @param title
         *        The new value for the Title property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(VisualTitleLabelOptions title);

        /**
         * Sets the value of the Title property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VisualTitleLabelOptions.Builder} avoiding
         * the need to create one manually via {@link VisualTitleLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualTitleLabelOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #title(VisualTitleLabelOptions)}.
         * 
         * @param title
         *        a consumer that will call methods on {@link VisualTitleLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #title(VisualTitleLabelOptions)
         */
        default Builder title(Consumer<VisualTitleLabelOptions.Builder> title) {
            return title(VisualTitleLabelOptions.builder().applyMutation(title).build());
        }

        /**
         * Sets the value of the Subtitle property for this object.
         *
         * @param subtitle
         *        The new value for the Subtitle property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subtitle(VisualSubtitleLabelOptions subtitle);

        /**
         * Sets the value of the Subtitle property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VisualSubtitleLabelOptions.Builder}
         * avoiding the need to create one manually via {@link VisualSubtitleLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualSubtitleLabelOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #subtitle(VisualSubtitleLabelOptions)}.
         * 
         * @param subtitle
         *        a consumer that will call methods on {@link VisualSubtitleLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subtitle(VisualSubtitleLabelOptions)
         */
        default Builder subtitle(Consumer<VisualSubtitleLabelOptions.Builder> subtitle) {
            return subtitle(VisualSubtitleLabelOptions.builder().applyMutation(subtitle).build());
        }

        /**
         * <p>
         * A description of the plugin field wells and their persisted properties.
         * </p>
         * 
         * @param chartConfiguration
         *        A description of the plugin field wells and their persisted properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chartConfiguration(PluginVisualConfiguration chartConfiguration);

        /**
         * <p>
         * A description of the plugin field wells and their persisted properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link PluginVisualConfiguration.Builder}
         * avoiding the need to create one manually via {@link PluginVisualConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PluginVisualConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #chartConfiguration(PluginVisualConfiguration)}.
         * 
         * @param chartConfiguration
         *        a consumer that will call methods on {@link PluginVisualConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chartConfiguration(PluginVisualConfiguration)
         */
        default Builder chartConfiguration(Consumer<PluginVisualConfiguration.Builder> chartConfiguration) {
            return chartConfiguration(PluginVisualConfiguration.builder().applyMutation(chartConfiguration).build());
        }

        /**
         * <p>
         * The alt text for the visual.
         * </p>
         * 
         * @param visualContentAltText
         *        The alt text for the visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualContentAltText(String visualContentAltText);
    }

    static final class BuilderImpl implements Builder {
        private String visualId;

        private String pluginArn;

        private VisualTitleLabelOptions title;

        private VisualSubtitleLabelOptions subtitle;

        private PluginVisualConfiguration chartConfiguration;

        private String visualContentAltText;

        private BuilderImpl() {
        }

        private BuilderImpl(PluginVisual model) {
            visualId(model.visualId);
            pluginArn(model.pluginArn);
            title(model.title);
            subtitle(model.subtitle);
            chartConfiguration(model.chartConfiguration);
            visualContentAltText(model.visualContentAltText);
        }

        public final String getVisualId() {
            return visualId;
        }

        public final void setVisualId(String visualId) {
            this.visualId = visualId;
        }

        @Override
        public final Builder visualId(String visualId) {
            this.visualId = visualId;
            return this;
        }

        public final String getPluginArn() {
            return pluginArn;
        }

        public final void setPluginArn(String pluginArn) {
            this.pluginArn = pluginArn;
        }

        @Override
        public final Builder pluginArn(String pluginArn) {
            this.pluginArn = pluginArn;
            return this;
        }

        public final VisualTitleLabelOptions.Builder getTitle() {
            return title != null ? title.toBuilder() : null;
        }

        public final void setTitle(VisualTitleLabelOptions.BuilderImpl title) {
            this.title = title != null ? title.build() : null;
        }

        @Override
        public final Builder title(VisualTitleLabelOptions title) {
            this.title = title;
            return this;
        }

        public final VisualSubtitleLabelOptions.Builder getSubtitle() {
            return subtitle != null ? subtitle.toBuilder() : null;
        }

        public final void setSubtitle(VisualSubtitleLabelOptions.BuilderImpl subtitle) {
            this.subtitle = subtitle != null ? subtitle.build() : null;
        }

        @Override
        public final Builder subtitle(VisualSubtitleLabelOptions subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public final PluginVisualConfiguration.Builder getChartConfiguration() {
            return chartConfiguration != null ? chartConfiguration.toBuilder() : null;
        }

        public final void setChartConfiguration(PluginVisualConfiguration.BuilderImpl chartConfiguration) {
            this.chartConfiguration = chartConfiguration != null ? chartConfiguration.build() : null;
        }

        @Override
        public final Builder chartConfiguration(PluginVisualConfiguration chartConfiguration) {
            this.chartConfiguration = chartConfiguration;
            return this;
        }

        public final String getVisualContentAltText() {
            return visualContentAltText;
        }

        public final void setVisualContentAltText(String visualContentAltText) {
            this.visualContentAltText = visualContentAltText;
        }

        @Override
        public final Builder visualContentAltText(String visualContentAltText) {
            this.visualContentAltText = visualContentAltText;
            return this;
        }

        @Override
        public PluginVisual build() {
            return new PluginVisual(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
