/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictQaResultsRequest extends QuickSightRequest implements
        ToCopyableBuilder<PredictQaResultsRequest.Builder, PredictQaResultsRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(PredictQaResultsRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> QUERY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryText").getter(getter(PredictQaResultsRequest::queryText)).setter(setter(Builder::queryText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryText").build()).build();

    private static final SdkField<String> INCLUDE_QUICK_SIGHT_Q_INDEX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IncludeQuickSightQIndex").getter(getter(PredictQaResultsRequest::includeQuickSightQIndexAsString))
            .setter(setter(Builder::includeQuickSightQIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeQuickSightQIndex").build())
            .build();

    private static final SdkField<String> INCLUDE_GENERATED_ANSWER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IncludeGeneratedAnswer").getter(getter(PredictQaResultsRequest::includeGeneratedAnswerAsString))
            .setter(setter(Builder::includeGeneratedAnswer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeGeneratedAnswer").build())
            .build();

    private static final SdkField<Integer> MAX_TOPICS_TO_CONSIDER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxTopicsToConsider").getter(getter(PredictQaResultsRequest::maxTopicsToConsider))
            .setter(setter(Builder::maxTopicsToConsider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxTopicsToConsider").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            QUERY_TEXT_FIELD, INCLUDE_QUICK_SIGHT_Q_INDEX_FIELD, INCLUDE_GENERATED_ANSWER_FIELD, MAX_TOPICS_TO_CONSIDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String queryText;

    private final String includeQuickSightQIndex;

    private final String includeGeneratedAnswer;

    private final Integer maxTopicsToConsider;

    private PredictQaResultsRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.queryText = builder.queryText;
        this.includeQuickSightQIndex = builder.includeQuickSightQIndex;
        this.includeGeneratedAnswer = builder.includeGeneratedAnswer;
        this.maxTopicsToConsider = builder.maxTopicsToConsider;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that the user wants to execute Predict QA results in.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that the user wants to execute Predict QA results in.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The query text to be used to predict QA results.
     * </p>
     * 
     * @return The query text to be used to predict QA results.
     */
    public final String queryText() {
        return queryText;
    }

    /**
     * <p>
     * Indicates whether Q indicies are included or excluded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #includeQuickSightQIndex} will return {@link IncludeQuickSightQIndex#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #includeQuickSightQIndexAsString}.
     * </p>
     * 
     * @return Indicates whether Q indicies are included or excluded.
     * @see IncludeQuickSightQIndex
     */
    public final IncludeQuickSightQIndex includeQuickSightQIndex() {
        return IncludeQuickSightQIndex.fromValue(includeQuickSightQIndex);
    }

    /**
     * <p>
     * Indicates whether Q indicies are included or excluded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #includeQuickSightQIndex} will return {@link IncludeQuickSightQIndex#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #includeQuickSightQIndexAsString}.
     * </p>
     * 
     * @return Indicates whether Q indicies are included or excluded.
     * @see IncludeQuickSightQIndex
     */
    public final String includeQuickSightQIndexAsString() {
        return includeQuickSightQIndex;
    }

    /**
     * <p>
     * Indicates whether generated answers are included or excluded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #includeGeneratedAnswer} will return {@link IncludeGeneratedAnswer#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #includeGeneratedAnswerAsString}.
     * </p>
     * 
     * @return Indicates whether generated answers are included or excluded.
     * @see IncludeGeneratedAnswer
     */
    public final IncludeGeneratedAnswer includeGeneratedAnswer() {
        return IncludeGeneratedAnswer.fromValue(includeGeneratedAnswer);
    }

    /**
     * <p>
     * Indicates whether generated answers are included or excluded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #includeGeneratedAnswer} will return {@link IncludeGeneratedAnswer#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #includeGeneratedAnswerAsString}.
     * </p>
     * 
     * @return Indicates whether generated answers are included or excluded.
     * @see IncludeGeneratedAnswer
     */
    public final String includeGeneratedAnswerAsString() {
        return includeGeneratedAnswer;
    }

    /**
     * <p>
     * The number of maximum topics to be considered to predict QA results.
     * </p>
     * 
     * @return The number of maximum topics to be considered to predict QA results.
     */
    public final Integer maxTopicsToConsider() {
        return maxTopicsToConsider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(queryText());
        hashCode = 31 * hashCode + Objects.hashCode(includeQuickSightQIndexAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includeGeneratedAnswerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxTopicsToConsider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictQaResultsRequest)) {
            return false;
        }
        PredictQaResultsRequest other = (PredictQaResultsRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(queryText(), other.queryText())
                && Objects.equals(includeQuickSightQIndexAsString(), other.includeQuickSightQIndexAsString())
                && Objects.equals(includeGeneratedAnswerAsString(), other.includeGeneratedAnswerAsString())
                && Objects.equals(maxTopicsToConsider(), other.maxTopicsToConsider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredictQaResultsRequest").add("AwsAccountId", awsAccountId())
                .add("QueryText", queryText() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IncludeQuickSightQIndex", includeQuickSightQIndexAsString())
                .add("IncludeGeneratedAnswer", includeGeneratedAnswerAsString())
                .add("MaxTopicsToConsider", maxTopicsToConsider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "QueryText":
            return Optional.ofNullable(clazz.cast(queryText()));
        case "IncludeQuickSightQIndex":
            return Optional.ofNullable(clazz.cast(includeQuickSightQIndexAsString()));
        case "IncludeGeneratedAnswer":
            return Optional.ofNullable(clazz.cast(includeGeneratedAnswerAsString()));
        case "MaxTopicsToConsider":
            return Optional.ofNullable(clazz.cast(maxTopicsToConsider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("QueryText", QUERY_TEXT_FIELD);
        map.put("IncludeQuickSightQIndex", INCLUDE_QUICK_SIGHT_Q_INDEX_FIELD);
        map.put("IncludeGeneratedAnswer", INCLUDE_GENERATED_ANSWER_FIELD);
        map.put("MaxTopicsToConsider", MAX_TOPICS_TO_CONSIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredictQaResultsRequest, T> g) {
        return obj -> g.apply((PredictQaResultsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, PredictQaResultsRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that the user wants to execute Predict QA results in.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that the user wants to execute Predict QA results in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The query text to be used to predict QA results.
         * </p>
         * 
         * @param queryText
         *        The query text to be used to predict QA results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryText(String queryText);

        /**
         * <p>
         * Indicates whether Q indicies are included or excluded.
         * </p>
         * 
         * @param includeQuickSightQIndex
         *        Indicates whether Q indicies are included or excluded.
         * @see IncludeQuickSightQIndex
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncludeQuickSightQIndex
         */
        Builder includeQuickSightQIndex(String includeQuickSightQIndex);

        /**
         * <p>
         * Indicates whether Q indicies are included or excluded.
         * </p>
         * 
         * @param includeQuickSightQIndex
         *        Indicates whether Q indicies are included or excluded.
         * @see IncludeQuickSightQIndex
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncludeQuickSightQIndex
         */
        Builder includeQuickSightQIndex(IncludeQuickSightQIndex includeQuickSightQIndex);

        /**
         * <p>
         * Indicates whether generated answers are included or excluded.
         * </p>
         * 
         * @param includeGeneratedAnswer
         *        Indicates whether generated answers are included or excluded.
         * @see IncludeGeneratedAnswer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncludeGeneratedAnswer
         */
        Builder includeGeneratedAnswer(String includeGeneratedAnswer);

        /**
         * <p>
         * Indicates whether generated answers are included or excluded.
         * </p>
         * 
         * @param includeGeneratedAnswer
         *        Indicates whether generated answers are included or excluded.
         * @see IncludeGeneratedAnswer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncludeGeneratedAnswer
         */
        Builder includeGeneratedAnswer(IncludeGeneratedAnswer includeGeneratedAnswer);

        /**
         * <p>
         * The number of maximum topics to be considered to predict QA results.
         * </p>
         * 
         * @param maxTopicsToConsider
         *        The number of maximum topics to be considered to predict QA results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxTopicsToConsider(Integer maxTopicsToConsider);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String queryText;

        private String includeQuickSightQIndex;

        private String includeGeneratedAnswer;

        private Integer maxTopicsToConsider;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictQaResultsRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            queryText(model.queryText);
            includeQuickSightQIndex(model.includeQuickSightQIndex);
            includeGeneratedAnswer(model.includeGeneratedAnswer);
            maxTopicsToConsider(model.maxTopicsToConsider);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getQueryText() {
            return queryText;
        }

        public final void setQueryText(String queryText) {
            this.queryText = queryText;
        }

        @Override
        public final Builder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        public final String getIncludeQuickSightQIndex() {
            return includeQuickSightQIndex;
        }

        public final void setIncludeQuickSightQIndex(String includeQuickSightQIndex) {
            this.includeQuickSightQIndex = includeQuickSightQIndex;
        }

        @Override
        public final Builder includeQuickSightQIndex(String includeQuickSightQIndex) {
            this.includeQuickSightQIndex = includeQuickSightQIndex;
            return this;
        }

        @Override
        public final Builder includeQuickSightQIndex(IncludeQuickSightQIndex includeQuickSightQIndex) {
            this.includeQuickSightQIndex(includeQuickSightQIndex == null ? null : includeQuickSightQIndex.toString());
            return this;
        }

        public final String getIncludeGeneratedAnswer() {
            return includeGeneratedAnswer;
        }

        public final void setIncludeGeneratedAnswer(String includeGeneratedAnswer) {
            this.includeGeneratedAnswer = includeGeneratedAnswer;
        }

        @Override
        public final Builder includeGeneratedAnswer(String includeGeneratedAnswer) {
            this.includeGeneratedAnswer = includeGeneratedAnswer;
            return this;
        }

        @Override
        public final Builder includeGeneratedAnswer(IncludeGeneratedAnswer includeGeneratedAnswer) {
            this.includeGeneratedAnswer(includeGeneratedAnswer == null ? null : includeGeneratedAnswer.toString());
            return this;
        }

        public final Integer getMaxTopicsToConsider() {
            return maxTopicsToConsider;
        }

        public final void setMaxTopicsToConsider(Integer maxTopicsToConsider) {
            this.maxTopicsToConsider = maxTopicsToConsider;
        }

        @Override
        public final Builder maxTopicsToConsider(Integer maxTopicsToConsider) {
            this.maxTopicsToConsider = maxTopicsToConsider;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PredictQaResultsRequest build() {
            return new PredictQaResultsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
