/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The QA result that is made from the <code>DashboardVisual</code> or <code>GeneratedAnswer</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QAResult implements SdkPojo, Serializable, ToCopyableBuilder<QAResult.Builder, QAResult> {
    private static final SdkField<String> RESULT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultType").getter(getter(QAResult::resultTypeAsString)).setter(setter(Builder::resultType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultType").build()).build();

    private static final SdkField<DashboardVisualResult> DASHBOARD_VISUAL_FIELD = SdkField
            .<DashboardVisualResult> builder(MarshallingType.SDK_POJO).memberName("DashboardVisual")
            .getter(getter(QAResult::dashboardVisual)).setter(setter(Builder::dashboardVisual))
            .constructor(DashboardVisualResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardVisual").build()).build();

    private static final SdkField<GeneratedAnswerResult> GENERATED_ANSWER_FIELD = SdkField
            .<GeneratedAnswerResult> builder(MarshallingType.SDK_POJO).memberName("GeneratedAnswer")
            .getter(getter(QAResult::generatedAnswer)).setter(setter(Builder::generatedAnswer))
            .constructor(GeneratedAnswerResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedAnswer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_TYPE_FIELD,
            DASHBOARD_VISUAL_FIELD, GENERATED_ANSWER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resultType;

    private final DashboardVisualResult dashboardVisual;

    private final GeneratedAnswerResult generatedAnswer;

    private QAResult(BuilderImpl builder) {
        this.resultType = builder.resultType;
        this.dashboardVisual = builder.dashboardVisual;
        this.generatedAnswer = builder.generatedAnswer;
    }

    /**
     * <p>
     * The type of QA result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultType} will
     * return {@link QAResultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultTypeAsString}.
     * </p>
     * 
     * @return The type of QA result.
     * @see QAResultType
     */
    public final QAResultType resultType() {
        return QAResultType.fromValue(resultType);
    }

    /**
     * <p>
     * The type of QA result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultType} will
     * return {@link QAResultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultTypeAsString}.
     * </p>
     * 
     * @return The type of QA result.
     * @see QAResultType
     */
    public final String resultTypeAsString() {
        return resultType;
    }

    /**
     * <p>
     * The representation of a dashboard visual result.
     * </p>
     * 
     * @return The representation of a dashboard visual result.
     */
    public final DashboardVisualResult dashboardVisual() {
        return dashboardVisual;
    }

    /**
     * <p>
     * The representation of a generated answer result.
     * </p>
     * 
     * @return The representation of a generated answer result.
     */
    public final GeneratedAnswerResult generatedAnswer() {
        return generatedAnswer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resultTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardVisual());
        hashCode = 31 * hashCode + Objects.hashCode(generatedAnswer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QAResult)) {
            return false;
        }
        QAResult other = (QAResult) obj;
        return Objects.equals(resultTypeAsString(), other.resultTypeAsString())
                && Objects.equals(dashboardVisual(), other.dashboardVisual())
                && Objects.equals(generatedAnswer(), other.generatedAnswer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QAResult").add("ResultType", resultTypeAsString()).add("DashboardVisual", dashboardVisual())
                .add("GeneratedAnswer", generatedAnswer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResultType":
            return Optional.ofNullable(clazz.cast(resultTypeAsString()));
        case "DashboardVisual":
            return Optional.ofNullable(clazz.cast(dashboardVisual()));
        case "GeneratedAnswer":
            return Optional.ofNullable(clazz.cast(generatedAnswer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResultType", RESULT_TYPE_FIELD);
        map.put("DashboardVisual", DASHBOARD_VISUAL_FIELD);
        map.put("GeneratedAnswer", GENERATED_ANSWER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QAResult, T> g) {
        return obj -> g.apply((QAResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QAResult> {
        /**
         * <p>
         * The type of QA result.
         * </p>
         * 
         * @param resultType
         *        The type of QA result.
         * @see QAResultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QAResultType
         */
        Builder resultType(String resultType);

        /**
         * <p>
         * The type of QA result.
         * </p>
         * 
         * @param resultType
         *        The type of QA result.
         * @see QAResultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QAResultType
         */
        Builder resultType(QAResultType resultType);

        /**
         * <p>
         * The representation of a dashboard visual result.
         * </p>
         * 
         * @param dashboardVisual
         *        The representation of a dashboard visual result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardVisual(DashboardVisualResult dashboardVisual);

        /**
         * <p>
         * The representation of a dashboard visual result.
         * </p>
         * This is a convenience method that creates an instance of the {@link DashboardVisualResult.Builder} avoiding
         * the need to create one manually via {@link DashboardVisualResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DashboardVisualResult.Builder#build()} is called immediately and
         * its result is passed to {@link #dashboardVisual(DashboardVisualResult)}.
         * 
         * @param dashboardVisual
         *        a consumer that will call methods on {@link DashboardVisualResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboardVisual(DashboardVisualResult)
         */
        default Builder dashboardVisual(Consumer<DashboardVisualResult.Builder> dashboardVisual) {
            return dashboardVisual(DashboardVisualResult.builder().applyMutation(dashboardVisual).build());
        }

        /**
         * <p>
         * The representation of a generated answer result.
         * </p>
         * 
         * @param generatedAnswer
         *        The representation of a generated answer result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedAnswer(GeneratedAnswerResult generatedAnswer);

        /**
         * <p>
         * The representation of a generated answer result.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeneratedAnswerResult.Builder} avoiding
         * the need to create one manually via {@link GeneratedAnswerResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeneratedAnswerResult.Builder#build()} is called immediately and
         * its result is passed to {@link #generatedAnswer(GeneratedAnswerResult)}.
         * 
         * @param generatedAnswer
         *        a consumer that will call methods on {@link GeneratedAnswerResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generatedAnswer(GeneratedAnswerResult)
         */
        default Builder generatedAnswer(Consumer<GeneratedAnswerResult.Builder> generatedAnswer) {
            return generatedAnswer(GeneratedAnswerResult.builder().applyMutation(generatedAnswer).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String resultType;

        private DashboardVisualResult dashboardVisual;

        private GeneratedAnswerResult generatedAnswer;

        private BuilderImpl() {
        }

        private BuilderImpl(QAResult model) {
            resultType(model.resultType);
            dashboardVisual(model.dashboardVisual);
            generatedAnswer(model.generatedAnswer);
        }

        public final String getResultType() {
            return resultType;
        }

        public final void setResultType(String resultType) {
            this.resultType = resultType;
        }

        @Override
        public final Builder resultType(String resultType) {
            this.resultType = resultType;
            return this;
        }

        @Override
        public final Builder resultType(QAResultType resultType) {
            this.resultType(resultType == null ? null : resultType.toString());
            return this;
        }

        public final DashboardVisualResult.Builder getDashboardVisual() {
            return dashboardVisual != null ? dashboardVisual.toBuilder() : null;
        }

        public final void setDashboardVisual(DashboardVisualResult.BuilderImpl dashboardVisual) {
            this.dashboardVisual = dashboardVisual != null ? dashboardVisual.build() : null;
        }

        @Override
        public final Builder dashboardVisual(DashboardVisualResult dashboardVisual) {
            this.dashboardVisual = dashboardVisual;
            return this;
        }

        public final GeneratedAnswerResult.Builder getGeneratedAnswer() {
            return generatedAnswer != null ? generatedAnswer.toBuilder() : null;
        }

        public final void setGeneratedAnswer(GeneratedAnswerResult.BuilderImpl generatedAnswer) {
            this.generatedAnswer = generatedAnswer != null ? generatedAnswer.build() : null;
        }

        @Override
        public final Builder generatedAnswer(GeneratedAnswerResult generatedAnswer) {
            this.generatedAnswer = generatedAnswer;
            return this;
        }

        @Override
        public QAResult build() {
            return new QAResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
