/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a custom label on a <code>ReferenceLine</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferenceLineCustomLabelConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ReferenceLineCustomLabelConfiguration.Builder, ReferenceLineCustomLabelConfiguration> {
    private static final SdkField<String> CUSTOM_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomLabel").getter(getter(ReferenceLineCustomLabelConfiguration::customLabel))
            .setter(setter(Builder::customLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLabel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_LABEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String customLabel;

    private ReferenceLineCustomLabelConfiguration(BuilderImpl builder) {
        this.customLabel = builder.customLabel;
    }

    /**
     * <p>
     * The string text of the custom label.
     * </p>
     * 
     * @return The string text of the custom label.
     */
    public final String customLabel() {
        return customLabel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customLabel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceLineCustomLabelConfiguration)) {
            return false;
        }
        ReferenceLineCustomLabelConfiguration other = (ReferenceLineCustomLabelConfiguration) obj;
        return Objects.equals(customLabel(), other.customLabel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferenceLineCustomLabelConfiguration").add("CustomLabel", customLabel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomLabel":
            return Optional.ofNullable(clazz.cast(customLabel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CustomLabel", CUSTOM_LABEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReferenceLineCustomLabelConfiguration, T> g) {
        return obj -> g.apply((ReferenceLineCustomLabelConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferenceLineCustomLabelConfiguration> {
        /**
         * <p>
         * The string text of the custom label.
         * </p>
         * 
         * @param customLabel
         *        The string text of the custom label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLabel(String customLabel);
    }

    static final class BuilderImpl implements Builder {
        private String customLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceLineCustomLabelConfiguration model) {
            customLabel(model.customLabel);
        }

        public final String getCustomLabel() {
            return customLabel;
        }

        public final void setCustomLabel(String customLabel) {
            this.customLabel = customLabel;
        }

        @Override
        public final Builder customLabel(String customLabel) {
            this.customLabel = customLabel;
            return this;
        }

        @Override
        public ReferenceLineCustomLabelConfiguration build() {
            return new ReferenceLineCustomLabelConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
