/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An optional structure that contains the Amazon S3 bucket configuration that the generated snapshots are stored in. If
 * you don't provide this information, generated snapshots are stored in the default Amazon QuickSight bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3BucketConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<S3BucketConfiguration.Builder, S3BucketConfiguration> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketName").getter(getter(S3BucketConfiguration::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()).build();

    private static final SdkField<String> BUCKET_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketPrefix").getter(getter(S3BucketConfiguration::bucketPrefix)).setter(setter(Builder::bucketPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketPrefix").build()).build();

    private static final SdkField<String> BUCKET_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketRegion").getter(getter(S3BucketConfiguration::bucketRegion)).setter(setter(Builder::bucketRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            BUCKET_PREFIX_FIELD, BUCKET_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bucketName;

    private final String bucketPrefix;

    private final String bucketRegion;

    private S3BucketConfiguration(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.bucketPrefix = builder.bucketPrefix;
        this.bucketRegion = builder.bucketRegion;
    }

    /**
     * <p>
     * The name of an existing Amazon S3 bucket where the generated snapshot artifacts are sent.
     * </p>
     * 
     * @return The name of an existing Amazon S3 bucket where the generated snapshot artifacts are sent.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The prefix of the Amazon S3 bucket that the generated snapshots are stored in.
     * </p>
     * 
     * @return The prefix of the Amazon S3 bucket that the generated snapshots are stored in.
     */
    public final String bucketPrefix() {
        return bucketPrefix;
    }

    /**
     * <p>
     * The region that the Amazon S3 bucket is located in. The bucket must be located in the same region that the
     * <code>StartDashboardSnapshotJob</code> API call is made.
     * </p>
     * 
     * @return The region that the Amazon S3 bucket is located in. The bucket must be located in the same region that
     *         the <code>StartDashboardSnapshotJob</code> API call is made.
     */
    public final String bucketRegion() {
        return bucketRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(bucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(bucketRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketConfiguration)) {
            return false;
        }
        S3BucketConfiguration other = (S3BucketConfiguration) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(bucketPrefix(), other.bucketPrefix())
                && Objects.equals(bucketRegion(), other.bucketRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3BucketConfiguration").add("BucketName", bucketName()).add("BucketPrefix", bucketPrefix())
                .add("BucketRegion", bucketRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "BucketPrefix":
            return Optional.ofNullable(clazz.cast(bucketPrefix()));
        case "BucketRegion":
            return Optional.ofNullable(clazz.cast(bucketRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BucketName", BUCKET_NAME_FIELD);
        map.put("BucketPrefix", BUCKET_PREFIX_FIELD);
        map.put("BucketRegion", BUCKET_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3BucketConfiguration, T> g) {
        return obj -> g.apply((S3BucketConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3BucketConfiguration> {
        /**
         * <p>
         * The name of an existing Amazon S3 bucket where the generated snapshot artifacts are sent.
         * </p>
         * 
         * @param bucketName
         *        The name of an existing Amazon S3 bucket where the generated snapshot artifacts are sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The prefix of the Amazon S3 bucket that the generated snapshots are stored in.
         * </p>
         * 
         * @param bucketPrefix
         *        The prefix of the Amazon S3 bucket that the generated snapshots are stored in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketPrefix(String bucketPrefix);

        /**
         * <p>
         * The region that the Amazon S3 bucket is located in. The bucket must be located in the same region that the
         * <code>StartDashboardSnapshotJob</code> API call is made.
         * </p>
         * 
         * @param bucketRegion
         *        The region that the Amazon S3 bucket is located in. The bucket must be located in the same region that
         *        the <code>StartDashboardSnapshotJob</code> API call is made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketRegion(String bucketRegion);
    }

    static final class BuilderImpl implements Builder {
        private String bucketName;

        private String bucketPrefix;

        private String bucketRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketConfiguration model) {
            bucketName(model.bucketName);
            bucketPrefix(model.bucketPrefix);
            bucketRegion(model.bucketRegion);
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getBucketPrefix() {
            return bucketPrefix;
        }

        public final void setBucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
        }

        @Override
        public final Builder bucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        public final String getBucketRegion() {
            return bucketRegion;
        }

        public final void setBucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
        }

        @Override
        public final Builder bucketRegion(String bucketRegion) {
            this.bucketRegion = bucketRegion;
            return this;
        }

        @Override
        public S3BucketConfiguration build() {
            return new S3BucketConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
