/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A physical table type for an S3 data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Source implements SdkPojo, Serializable, ToCopyableBuilder<S3Source.Builder, S3Source> {
    private static final SdkField<String> DATA_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceArn").getter(getter(S3Source::dataSourceArn)).setter(setter(Builder::dataSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceArn").build()).build();

    private static final SdkField<UploadSettings> UPLOAD_SETTINGS_FIELD = SdkField
            .<UploadSettings> builder(MarshallingType.SDK_POJO).memberName("UploadSettings")
            .getter(getter(S3Source::uploadSettings)).setter(setter(Builder::uploadSettings))
            .constructor(UploadSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadSettings").build()).build();

    private static final SdkField<List<InputColumn>> INPUT_COLUMNS_FIELD = SdkField
            .<List<InputColumn>> builder(MarshallingType.LIST)
            .memberName("InputColumns")
            .getter(getter(S3Source::inputColumns))
            .setter(setter(Builder::inputColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputColumn> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputColumn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ARN_FIELD,
            UPLOAD_SETTINGS_FIELD, INPUT_COLUMNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataSourceArn;

    private final UploadSettings uploadSettings;

    private final List<InputColumn> inputColumns;

    private S3Source(BuilderImpl builder) {
        this.dataSourceArn = builder.dataSourceArn;
        this.uploadSettings = builder.uploadSettings;
        this.inputColumns = builder.inputColumns;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the data source.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the data source.
     */
    public final String dataSourceArn() {
        return dataSourceArn;
    }

    /**
     * <p>
     * Information about the format for the S3 source file or files.
     * </p>
     * 
     * @return Information about the format for the S3 source file or files.
     */
    public final UploadSettings uploadSettings() {
        return uploadSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputColumns() {
        return inputColumns != null && !(inputColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A physical table type for an S3 data source.
     * </p>
     * <note>
     * <p>
     * For files that aren't JSON, only <code>STRING</code> data types are supported in input columns.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputColumns} method.
     * </p>
     * 
     * @return A physical table type for an S3 data source.</p> <note>
     *         <p>
     *         For files that aren't JSON, only <code>STRING</code> data types are supported in input columns.
     *         </p>
     */
    public final List<InputColumn> inputColumns() {
        return inputColumns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(uploadSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputColumns() ? inputColumns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Source)) {
            return false;
        }
        S3Source other = (S3Source) obj;
        return Objects.equals(dataSourceArn(), other.dataSourceArn()) && Objects.equals(uploadSettings(), other.uploadSettings())
                && hasInputColumns() == other.hasInputColumns() && Objects.equals(inputColumns(), other.inputColumns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Source").add("DataSourceArn", dataSourceArn()).add("UploadSettings", uploadSettings())
                .add("InputColumns", hasInputColumns() ? inputColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSourceArn":
            return Optional.ofNullable(clazz.cast(dataSourceArn()));
        case "UploadSettings":
            return Optional.ofNullable(clazz.cast(uploadSettings()));
        case "InputColumns":
            return Optional.ofNullable(clazz.cast(inputColumns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataSourceArn", DATA_SOURCE_ARN_FIELD);
        map.put("UploadSettings", UPLOAD_SETTINGS_FIELD);
        map.put("InputColumns", INPUT_COLUMNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Source, T> g) {
        return obj -> g.apply((S3Source) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Source> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the data source.
         * </p>
         * 
         * @param dataSourceArn
         *        The Amazon Resource Name (ARN) for the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceArn(String dataSourceArn);

        /**
         * <p>
         * Information about the format for the S3 source file or files.
         * </p>
         * 
         * @param uploadSettings
         *        Information about the format for the S3 source file or files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadSettings(UploadSettings uploadSettings);

        /**
         * <p>
         * Information about the format for the S3 source file or files.
         * </p>
         * This is a convenience method that creates an instance of the {@link UploadSettings.Builder} avoiding the need
         * to create one manually via {@link UploadSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UploadSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #uploadSettings(UploadSettings)}.
         * 
         * @param uploadSettings
         *        a consumer that will call methods on {@link UploadSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uploadSettings(UploadSettings)
         */
        default Builder uploadSettings(Consumer<UploadSettings.Builder> uploadSettings) {
            return uploadSettings(UploadSettings.builder().applyMutation(uploadSettings).build());
        }

        /**
         * <p>
         * A physical table type for an S3 data source.
         * </p>
         * <note>
         * <p>
         * For files that aren't JSON, only <code>STRING</code> data types are supported in input columns.
         * </p>
         * </note>
         * 
         * @param inputColumns
         *        A physical table type for an S3 data source.</p> <note>
         *        <p>
         *        For files that aren't JSON, only <code>STRING</code> data types are supported in input columns.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputColumns(Collection<InputColumn> inputColumns);

        /**
         * <p>
         * A physical table type for an S3 data source.
         * </p>
         * <note>
         * <p>
         * For files that aren't JSON, only <code>STRING</code> data types are supported in input columns.
         * </p>
         * </note>
         * 
         * @param inputColumns
         *        A physical table type for an S3 data source.</p> <note>
         *        <p>
         *        For files that aren't JSON, only <code>STRING</code> data types are supported in input columns.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputColumns(InputColumn... inputColumns);

        /**
         * <p>
         * A physical table type for an S3 data source.
         * </p>
         * <note>
         * <p>
         * For files that aren't JSON, only <code>STRING</code> data types are supported in input columns.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.InputColumn.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.InputColumn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.InputColumn.Builder#build()} is called immediately
         * and its result is passed to {@link #inputColumns(List<InputColumn>)}.
         * 
         * @param inputColumns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.InputColumn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputColumns(java.util.Collection<InputColumn>)
         */
        Builder inputColumns(Consumer<InputColumn.Builder>... inputColumns);
    }

    static final class BuilderImpl implements Builder {
        private String dataSourceArn;

        private UploadSettings uploadSettings;

        private List<InputColumn> inputColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3Source model) {
            dataSourceArn(model.dataSourceArn);
            uploadSettings(model.uploadSettings);
            inputColumns(model.inputColumns);
        }

        public final String getDataSourceArn() {
            return dataSourceArn;
        }

        public final void setDataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
        }

        @Override
        public final Builder dataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
            return this;
        }

        public final UploadSettings.Builder getUploadSettings() {
            return uploadSettings != null ? uploadSettings.toBuilder() : null;
        }

        public final void setUploadSettings(UploadSettings.BuilderImpl uploadSettings) {
            this.uploadSettings = uploadSettings != null ? uploadSettings.build() : null;
        }

        @Override
        public final Builder uploadSettings(UploadSettings uploadSettings) {
            this.uploadSettings = uploadSettings;
            return this;
        }

        public final List<InputColumn.Builder> getInputColumns() {
            List<InputColumn.Builder> result = InputColumnListCopier.copyToBuilder(this.inputColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputColumns(Collection<InputColumn.BuilderImpl> inputColumns) {
            this.inputColumns = InputColumnListCopier.copyFromBuilder(inputColumns);
        }

        @Override
        public final Builder inputColumns(Collection<InputColumn> inputColumns) {
            this.inputColumns = InputColumnListCopier.copy(inputColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputColumns(InputColumn... inputColumns) {
            inputColumns(Arrays.asList(inputColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputColumns(Consumer<InputColumn.Builder>... inputColumns) {
            inputColumns(Stream.of(inputColumns).map(c -> InputColumn.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public S3Source build() {
            return new S3Source(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
