/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for applying a filter to specific sheets or visuals. You can apply this filter to multiple visuals
 * that are on one sheet or to all visuals on a sheet.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SelectedSheetsFilterScopeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SelectedSheetsFilterScopeConfiguration.Builder, SelectedSheetsFilterScopeConfiguration> {
    private static final SdkField<List<SheetVisualScopingConfiguration>> SHEET_VISUAL_SCOPING_CONFIGURATIONS_FIELD = SdkField
            .<List<SheetVisualScopingConfiguration>> builder(MarshallingType.LIST)
            .memberName("SheetVisualScopingConfigurations")
            .getter(getter(SelectedSheetsFilterScopeConfiguration::sheetVisualScopingConfigurations))
            .setter(setter(Builder::sheetVisualScopingConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetVisualScopingConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SheetVisualScopingConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SheetVisualScopingConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SHEET_VISUAL_SCOPING_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SheetVisualScopingConfiguration> sheetVisualScopingConfigurations;

    private SelectedSheetsFilterScopeConfiguration(BuilderImpl builder) {
        this.sheetVisualScopingConfigurations = builder.sheetVisualScopingConfigurations;
    }

    /**
     * For responses, this returns true if the service returned a value for the SheetVisualScopingConfigurations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasSheetVisualScopingConfigurations() {
        return sheetVisualScopingConfigurations != null && !(sheetVisualScopingConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sheet ID and visual IDs of the sheet and visuals that the filter is applied to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSheetVisualScopingConfigurations}
     * method.
     * </p>
     * 
     * @return The sheet ID and visual IDs of the sheet and visuals that the filter is applied to.
     */
    public final List<SheetVisualScopingConfiguration> sheetVisualScopingConfigurations() {
        return sheetVisualScopingConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSheetVisualScopingConfigurations() ? sheetVisualScopingConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectedSheetsFilterScopeConfiguration)) {
            return false;
        }
        SelectedSheetsFilterScopeConfiguration other = (SelectedSheetsFilterScopeConfiguration) obj;
        return hasSheetVisualScopingConfigurations() == other.hasSheetVisualScopingConfigurations()
                && Objects.equals(sheetVisualScopingConfigurations(), other.sheetVisualScopingConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("SelectedSheetsFilterScopeConfiguration")
                .add("SheetVisualScopingConfigurations",
                        hasSheetVisualScopingConfigurations() ? sheetVisualScopingConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SheetVisualScopingConfigurations":
            return Optional.ofNullable(clazz.cast(sheetVisualScopingConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SheetVisualScopingConfigurations", SHEET_VISUAL_SCOPING_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SelectedSheetsFilterScopeConfiguration, T> g) {
        return obj -> g.apply((SelectedSheetsFilterScopeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SelectedSheetsFilterScopeConfiguration> {
        /**
         * <p>
         * The sheet ID and visual IDs of the sheet and visuals that the filter is applied to.
         * </p>
         * 
         * @param sheetVisualScopingConfigurations
         *        The sheet ID and visual IDs of the sheet and visuals that the filter is applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheetVisualScopingConfigurations(Collection<SheetVisualScopingConfiguration> sheetVisualScopingConfigurations);

        /**
         * <p>
         * The sheet ID and visual IDs of the sheet and visuals that the filter is applied to.
         * </p>
         * 
         * @param sheetVisualScopingConfigurations
         *        The sheet ID and visual IDs of the sheet and visuals that the filter is applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheetVisualScopingConfigurations(SheetVisualScopingConfiguration... sheetVisualScopingConfigurations);

        /**
         * <p>
         * The sheet ID and visual IDs of the sheet and visuals that the filter is applied to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SheetVisualScopingConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.SheetVisualScopingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SheetVisualScopingConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #sheetVisualScopingConfigurations(List<SheetVisualScopingConfiguration>)}.
         * 
         * @param sheetVisualScopingConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SheetVisualScopingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sheetVisualScopingConfigurations(java.util.Collection<SheetVisualScopingConfiguration>)
         */
        Builder sheetVisualScopingConfigurations(
                Consumer<SheetVisualScopingConfiguration.Builder>... sheetVisualScopingConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private List<SheetVisualScopingConfiguration> sheetVisualScopingConfigurations = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SelectedSheetsFilterScopeConfiguration model) {
            sheetVisualScopingConfigurations(model.sheetVisualScopingConfigurations);
        }

        public final List<SheetVisualScopingConfiguration.Builder> getSheetVisualScopingConfigurations() {
            List<SheetVisualScopingConfiguration.Builder> result = SheetVisualScopingConfigurationsCopier
                    .copyToBuilder(this.sheetVisualScopingConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSheetVisualScopingConfigurations(
                Collection<SheetVisualScopingConfiguration.BuilderImpl> sheetVisualScopingConfigurations) {
            this.sheetVisualScopingConfigurations = SheetVisualScopingConfigurationsCopier
                    .copyFromBuilder(sheetVisualScopingConfigurations);
        }

        @Override
        public final Builder sheetVisualScopingConfigurations(
                Collection<SheetVisualScopingConfiguration> sheetVisualScopingConfigurations) {
            this.sheetVisualScopingConfigurations = SheetVisualScopingConfigurationsCopier.copy(sheetVisualScopingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheetVisualScopingConfigurations(SheetVisualScopingConfiguration... sheetVisualScopingConfigurations) {
            sheetVisualScopingConfigurations(Arrays.asList(sheetVisualScopingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheetVisualScopingConfigurations(
                Consumer<SheetVisualScopingConfiguration.Builder>... sheetVisualScopingConfigurations) {
            sheetVisualScopingConfigurations(Stream.of(sheetVisualScopingConfigurations)
                    .map(c -> SheetVisualScopingConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SelectedSheetsFilterScopeConfiguration build() {
            return new SelectedSheetsFilterScopeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
