/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A sheet is an object that contains a set of visuals that are viewed together on one page in a paginated report. Every
 * analysis and dashboard must contain at least one sheet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SheetDefinition implements SdkPojo, Serializable, ToCopyableBuilder<SheetDefinition.Builder, SheetDefinition> {
    private static final SdkField<String> SHEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SheetId").getter(getter(SheetDefinition::sheetId)).setter(setter(Builder::sheetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetId").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(SheetDefinition::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(SheetDefinition::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SheetDefinition::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<ParameterControl>> PARAMETER_CONTROLS_FIELD = SdkField
            .<List<ParameterControl>> builder(MarshallingType.LIST)
            .memberName("ParameterControls")
            .getter(getter(SheetDefinition::parameterControls))
            .setter(setter(Builder::parameterControls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterControls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterControl> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterControl::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FilterControl>> FILTER_CONTROLS_FIELD = SdkField
            .<List<FilterControl>> builder(MarshallingType.LIST)
            .memberName("FilterControls")
            .getter(getter(SheetDefinition::filterControls))
            .setter(setter(Builder::filterControls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterControls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterControl> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterControl::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Visual>> VISUALS_FIELD = SdkField
            .<List<Visual>> builder(MarshallingType.LIST)
            .memberName("Visuals")
            .getter(getter(SheetDefinition::visuals))
            .setter(setter(Builder::visuals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visuals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Visual> builder(MarshallingType.SDK_POJO)
                                            .constructor(Visual::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SheetTextBox>> TEXT_BOXES_FIELD = SdkField
            .<List<SheetTextBox>> builder(MarshallingType.LIST)
            .memberName("TextBoxes")
            .getter(getter(SheetDefinition::textBoxes))
            .setter(setter(Builder::textBoxes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextBoxes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SheetTextBox> builder(MarshallingType.SDK_POJO)
                                            .constructor(SheetTextBox::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SheetImage>> IMAGES_FIELD = SdkField
            .<List<SheetImage>> builder(MarshallingType.LIST)
            .memberName("Images")
            .getter(getter(SheetDefinition::images))
            .setter(setter(Builder::images))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Images").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SheetImage> builder(MarshallingType.SDK_POJO)
                                            .constructor(SheetImage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Layout>> LAYOUTS_FIELD = SdkField
            .<List<Layout>> builder(MarshallingType.LIST)
            .memberName("Layouts")
            .getter(getter(SheetDefinition::layouts))
            .setter(setter(Builder::layouts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layouts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Layout> builder(MarshallingType.SDK_POJO)
                                            .constructor(Layout::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SheetControlLayout>> SHEET_CONTROL_LAYOUTS_FIELD = SdkField
            .<List<SheetControlLayout>> builder(MarshallingType.LIST)
            .memberName("SheetControlLayouts")
            .getter(getter(SheetDefinition::sheetControlLayouts))
            .setter(setter(Builder::sheetControlLayouts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetControlLayouts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SheetControlLayout> builder(MarshallingType.SDK_POJO)
                                            .constructor(SheetControlLayout::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(SheetDefinition::contentTypeAsString)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final SdkField<VisualCustomActionDefaults> CUSTOM_ACTION_DEFAULTS_FIELD = SdkField
            .<VisualCustomActionDefaults> builder(MarshallingType.SDK_POJO).memberName("CustomActionDefaults")
            .getter(getter(SheetDefinition::customActionDefaults)).setter(setter(Builder::customActionDefaults))
            .constructor(VisualCustomActionDefaults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomActionDefaults").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHEET_ID_FIELD, TITLE_FIELD,
            DESCRIPTION_FIELD, NAME_FIELD, PARAMETER_CONTROLS_FIELD, FILTER_CONTROLS_FIELD, VISUALS_FIELD, TEXT_BOXES_FIELD,
            IMAGES_FIELD, LAYOUTS_FIELD, SHEET_CONTROL_LAYOUTS_FIELD, CONTENT_TYPE_FIELD, CUSTOM_ACTION_DEFAULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sheetId;

    private final String title;

    private final String description;

    private final String name;

    private final List<ParameterControl> parameterControls;

    private final List<FilterControl> filterControls;

    private final List<Visual> visuals;

    private final List<SheetTextBox> textBoxes;

    private final List<SheetImage> images;

    private final List<Layout> layouts;

    private final List<SheetControlLayout> sheetControlLayouts;

    private final String contentType;

    private final VisualCustomActionDefaults customActionDefaults;

    private SheetDefinition(BuilderImpl builder) {
        this.sheetId = builder.sheetId;
        this.title = builder.title;
        this.description = builder.description;
        this.name = builder.name;
        this.parameterControls = builder.parameterControls;
        this.filterControls = builder.filterControls;
        this.visuals = builder.visuals;
        this.textBoxes = builder.textBoxes;
        this.images = builder.images;
        this.layouts = builder.layouts;
        this.sheetControlLayouts = builder.sheetControlLayouts;
        this.contentType = builder.contentType;
        this.customActionDefaults = builder.customActionDefaults;
    }

    /**
     * <p>
     * The unique identifier of a sheet.
     * </p>
     * 
     * @return The unique identifier of a sheet.
     */
    public final String sheetId() {
        return sheetId;
    }

    /**
     * <p>
     * The title of the sheet.
     * </p>
     * 
     * @return The title of the sheet.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * A description of the sheet.
     * </p>
     * 
     * @return A description of the sheet.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the sheet. This name is displayed on the sheet's tab in the Amazon QuickSight console.
     * </p>
     * 
     * @return The name of the sheet. This name is displayed on the sheet's tab in the Amazon QuickSight console.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParameterControls property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParameterControls() {
        return parameterControls != null && !(parameterControls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of parameter controls that are on a sheet.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-controls.html">Using a Control with a
     * Parameter in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameterControls} method.
     * </p>
     * 
     * @return The list of parameter controls that are on a sheet.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-controls.html">Using a Control with a
     *         Parameter in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
     */
    public final List<ParameterControl> parameterControls() {
        return parameterControls;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterControls property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilterControls() {
        return filterControls != null && !(filterControls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of filter controls that are on a sheet.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/filter-controls.html">Adding filter controls to analysis
     * sheets</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterControls} method.
     * </p>
     * 
     * @return The list of filter controls that are on a sheet.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/filter-controls.html">Adding filter controls to
     *         analysis sheets</a> in the <i>Amazon QuickSight User Guide</i>.
     */
    public final List<FilterControl> filterControls() {
        return filterControls;
    }

    /**
     * For responses, this returns true if the service returned a value for the Visuals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVisuals() {
        return visuals != null && !(visuals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the visuals that are on a sheet. Visual placement is determined by the layout of the sheet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVisuals} method.
     * </p>
     * 
     * @return A list of the visuals that are on a sheet. Visual placement is determined by the layout of the sheet.
     */
    public final List<Visual> visuals() {
        return visuals;
    }

    /**
     * For responses, this returns true if the service returned a value for the TextBoxes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTextBoxes() {
        return textBoxes != null && !(textBoxes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The text boxes that are on a sheet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTextBoxes} method.
     * </p>
     * 
     * @return The text boxes that are on a sheet.
     */
    public final List<SheetTextBox> textBoxes() {
        return textBoxes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Images property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImages() {
        return images != null && !(images instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of images on a sheet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImages} method.
     * </p>
     * 
     * @return A list of images on a sheet.
     */
    public final List<SheetImage> images() {
        return images;
    }

    /**
     * For responses, this returns true if the service returned a value for the Layouts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLayouts() {
        return layouts != null && !(layouts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Layouts define how the components of a sheet are arranged.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/quicksight/latest/user/types-of-layout.html">Types
     * of layout</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLayouts} method.
     * </p>
     * 
     * @return Layouts define how the components of a sheet are arranged.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/types-of-layout.html">Types of layout</a> in the
     *         <i>Amazon QuickSight User Guide</i>.
     */
    public final List<Layout> layouts() {
        return layouts;
    }

    /**
     * For responses, this returns true if the service returned a value for the SheetControlLayouts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSheetControlLayouts() {
        return sheetControlLayouts != null && !(sheetControlLayouts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The control layouts of the sheet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSheetControlLayouts} method.
     * </p>
     * 
     * @return The control layouts of the sheet.
     */
    public final List<SheetControlLayout> sheetControlLayouts() {
        return sheetControlLayouts;
    }

    /**
     * <p>
     * The layout content type of the sheet. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PAGINATED</code>: Creates a sheet for a paginated report.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTERACTIVE</code>: Creates a sheet for an interactive dashboard.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link SheetContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The layout content type of the sheet. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PAGINATED</code>: Creates a sheet for a paginated report.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTERACTIVE</code>: Creates a sheet for an interactive dashboard.
     *         </p>
     *         </li>
     * @see SheetContentType
     */
    public final SheetContentType contentType() {
        return SheetContentType.fromValue(contentType);
    }

    /**
     * <p>
     * The layout content type of the sheet. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PAGINATED</code>: Creates a sheet for a paginated report.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTERACTIVE</code>: Creates a sheet for an interactive dashboard.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link SheetContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The layout content type of the sheet. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PAGINATED</code>: Creates a sheet for a paginated report.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTERACTIVE</code>: Creates a sheet for an interactive dashboard.
     *         </p>
     *         </li>
     * @see SheetContentType
     */
    public final String contentTypeAsString() {
        return contentType;
    }

    /**
     * <p>
     * A list of visual custom actions for the sheet.
     * </p>
     * 
     * @return A list of visual custom actions for the sheet.
     */
    public final VisualCustomActionDefaults customActionDefaults() {
        return customActionDefaults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sheetId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterControls() ? parameterControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterControls() ? filterControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVisuals() ? visuals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTextBoxes() ? textBoxes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasImages() ? images() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLayouts() ? layouts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSheetControlLayouts() ? sheetControlLayouts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customActionDefaults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetDefinition)) {
            return false;
        }
        SheetDefinition other = (SheetDefinition) obj;
        return Objects.equals(sheetId(), other.sheetId()) && Objects.equals(title(), other.title())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && hasParameterControls() == other.hasParameterControls()
                && Objects.equals(parameterControls(), other.parameterControls())
                && hasFilterControls() == other.hasFilterControls() && Objects.equals(filterControls(), other.filterControls())
                && hasVisuals() == other.hasVisuals() && Objects.equals(visuals(), other.visuals())
                && hasTextBoxes() == other.hasTextBoxes() && Objects.equals(textBoxes(), other.textBoxes())
                && hasImages() == other.hasImages() && Objects.equals(images(), other.images())
                && hasLayouts() == other.hasLayouts() && Objects.equals(layouts(), other.layouts())
                && hasSheetControlLayouts() == other.hasSheetControlLayouts()
                && Objects.equals(sheetControlLayouts(), other.sheetControlLayouts())
                && Objects.equals(contentTypeAsString(), other.contentTypeAsString())
                && Objects.equals(customActionDefaults(), other.customActionDefaults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SheetDefinition").add("SheetId", sheetId()).add("Title", title())
                .add("Description", description()).add("Name", name())
                .add("ParameterControls", hasParameterControls() ? parameterControls() : null)
                .add("FilterControls", hasFilterControls() ? filterControls() : null)
                .add("Visuals", hasVisuals() ? visuals() : null).add("TextBoxes", hasTextBoxes() ? textBoxes() : null)
                .add("Images", hasImages() ? images() : null).add("Layouts", hasLayouts() ? layouts() : null)
                .add("SheetControlLayouts", hasSheetControlLayouts() ? sheetControlLayouts() : null)
                .add("ContentType", contentTypeAsString()).add("CustomActionDefaults", customActionDefaults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SheetId":
            return Optional.ofNullable(clazz.cast(sheetId()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ParameterControls":
            return Optional.ofNullable(clazz.cast(parameterControls()));
        case "FilterControls":
            return Optional.ofNullable(clazz.cast(filterControls()));
        case "Visuals":
            return Optional.ofNullable(clazz.cast(visuals()));
        case "TextBoxes":
            return Optional.ofNullable(clazz.cast(textBoxes()));
        case "Images":
            return Optional.ofNullable(clazz.cast(images()));
        case "Layouts":
            return Optional.ofNullable(clazz.cast(layouts()));
        case "SheetControlLayouts":
            return Optional.ofNullable(clazz.cast(sheetControlLayouts()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentTypeAsString()));
        case "CustomActionDefaults":
            return Optional.ofNullable(clazz.cast(customActionDefaults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SheetId", SHEET_ID_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ParameterControls", PARAMETER_CONTROLS_FIELD);
        map.put("FilterControls", FILTER_CONTROLS_FIELD);
        map.put("Visuals", VISUALS_FIELD);
        map.put("TextBoxes", TEXT_BOXES_FIELD);
        map.put("Images", IMAGES_FIELD);
        map.put("Layouts", LAYOUTS_FIELD);
        map.put("SheetControlLayouts", SHEET_CONTROL_LAYOUTS_FIELD);
        map.put("ContentType", CONTENT_TYPE_FIELD);
        map.put("CustomActionDefaults", CUSTOM_ACTION_DEFAULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SheetDefinition, T> g) {
        return obj -> g.apply((SheetDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SheetDefinition> {
        /**
         * <p>
         * The unique identifier of a sheet.
         * </p>
         * 
         * @param sheetId
         *        The unique identifier of a sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheetId(String sheetId);

        /**
         * <p>
         * The title of the sheet.
         * </p>
         * 
         * @param title
         *        The title of the sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * A description of the sheet.
         * </p>
         * 
         * @param description
         *        A description of the sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the sheet. This name is displayed on the sheet's tab in the Amazon QuickSight console.
         * </p>
         * 
         * @param name
         *        The name of the sheet. This name is displayed on the sheet's tab in the Amazon QuickSight console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The list of parameter controls that are on a sheet.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-controls.html">Using a Control with a
         * Parameter in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * 
         * @param parameterControls
         *        The list of parameter controls that are on a sheet.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-controls.html">Using a Control
         *        with a Parameter in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterControls(Collection<ParameterControl> parameterControls);

        /**
         * <p>
         * The list of parameter controls that are on a sheet.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-controls.html">Using a Control with a
         * Parameter in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * 
         * @param parameterControls
         *        The list of parameter controls that are on a sheet.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-controls.html">Using a Control
         *        with a Parameter in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterControls(ParameterControl... parameterControls);

        /**
         * <p>
         * The list of parameter controls that are on a sheet.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-controls.html">Using a Control with a
         * Parameter in Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ParameterControl.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.ParameterControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ParameterControl.Builder#build()} is called
         * immediately and its result is passed to {@link #parameterControls(List<ParameterControl>)}.
         * 
         * @param parameterControls
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ParameterControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterControls(java.util.Collection<ParameterControl>)
         */
        Builder parameterControls(Consumer<ParameterControl.Builder>... parameterControls);

        /**
         * <p>
         * The list of filter controls that are on a sheet.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/filter-controls.html">Adding filter controls to
         * analysis sheets</a> in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * 
         * @param filterControls
         *        The list of filter controls that are on a sheet.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/filter-controls.html">Adding filter controls
         *        to analysis sheets</a> in the <i>Amazon QuickSight User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterControls(Collection<FilterControl> filterControls);

        /**
         * <p>
         * The list of filter controls that are on a sheet.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/filter-controls.html">Adding filter controls to
         * analysis sheets</a> in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * 
         * @param filterControls
         *        The list of filter controls that are on a sheet.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/filter-controls.html">Adding filter controls
         *        to analysis sheets</a> in the <i>Amazon QuickSight User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterControls(FilterControl... filterControls);

        /**
         * <p>
         * The list of filter controls that are on a sheet.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/filter-controls.html">Adding filter controls to
         * analysis sheets</a> in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.FilterControl.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.FilterControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.FilterControl.Builder#build()} is called immediately
         * and its result is passed to {@link #filterControls(List<FilterControl>)}.
         * 
         * @param filterControls
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.FilterControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterControls(java.util.Collection<FilterControl>)
         */
        Builder filterControls(Consumer<FilterControl.Builder>... filterControls);

        /**
         * <p>
         * A list of the visuals that are on a sheet. Visual placement is determined by the layout of the sheet.
         * </p>
         * 
         * @param visuals
         *        A list of the visuals that are on a sheet. Visual placement is determined by the layout of the sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visuals(Collection<Visual> visuals);

        /**
         * <p>
         * A list of the visuals that are on a sheet. Visual placement is determined by the layout of the sheet.
         * </p>
         * 
         * @param visuals
         *        A list of the visuals that are on a sheet. Visual placement is determined by the layout of the sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visuals(Visual... visuals);

        /**
         * <p>
         * A list of the visuals that are on a sheet. Visual placement is determined by the layout of the sheet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.Visual.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.Visual#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.Visual.Builder#build()} is called immediately and its
         * result is passed to {@link #visuals(List<Visual>)}.
         * 
         * @param visuals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.Visual.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #visuals(java.util.Collection<Visual>)
         */
        Builder visuals(Consumer<Visual.Builder>... visuals);

        /**
         * <p>
         * The text boxes that are on a sheet.
         * </p>
         * 
         * @param textBoxes
         *        The text boxes that are on a sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textBoxes(Collection<SheetTextBox> textBoxes);

        /**
         * <p>
         * The text boxes that are on a sheet.
         * </p>
         * 
         * @param textBoxes
         *        The text boxes that are on a sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textBoxes(SheetTextBox... textBoxes);

        /**
         * <p>
         * The text boxes that are on a sheet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SheetTextBox.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.SheetTextBox#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SheetTextBox.Builder#build()} is called immediately
         * and its result is passed to {@link #textBoxes(List<SheetTextBox>)}.
         * 
         * @param textBoxes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SheetTextBox.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textBoxes(java.util.Collection<SheetTextBox>)
         */
        Builder textBoxes(Consumer<SheetTextBox.Builder>... textBoxes);

        /**
         * <p>
         * A list of images on a sheet.
         * </p>
         * 
         * @param images
         *        A list of images on a sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(Collection<SheetImage> images);

        /**
         * <p>
         * A list of images on a sheet.
         * </p>
         * 
         * @param images
         *        A list of images on a sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(SheetImage... images);

        /**
         * <p>
         * A list of images on a sheet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SheetImage.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.SheetImage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SheetImage.Builder#build()} is called immediately and
         * its result is passed to {@link #images(List<SheetImage>)}.
         * 
         * @param images
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SheetImage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #images(java.util.Collection<SheetImage>)
         */
        Builder images(Consumer<SheetImage.Builder>... images);

        /**
         * <p>
         * Layouts define how the components of a sheet are arranged.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/types-of-layout.html">Types of layout</a> in the
         * <i>Amazon QuickSight User Guide</i>.
         * </p>
         * 
         * @param layouts
         *        Layouts define how the components of a sheet are arranged.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/types-of-layout.html">Types of layout</a> in
         *        the <i>Amazon QuickSight User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layouts(Collection<Layout> layouts);

        /**
         * <p>
         * Layouts define how the components of a sheet are arranged.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/types-of-layout.html">Types of layout</a> in the
         * <i>Amazon QuickSight User Guide</i>.
         * </p>
         * 
         * @param layouts
         *        Layouts define how the components of a sheet are arranged.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/types-of-layout.html">Types of layout</a> in
         *        the <i>Amazon QuickSight User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layouts(Layout... layouts);

        /**
         * <p>
         * Layouts define how the components of a sheet are arranged.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/types-of-layout.html">Types of layout</a> in the
         * <i>Amazon QuickSight User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.Layout.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.Layout#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.Layout.Builder#build()} is called immediately and its
         * result is passed to {@link #layouts(List<Layout>)}.
         * 
         * @param layouts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.Layout.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #layouts(java.util.Collection<Layout>)
         */
        Builder layouts(Consumer<Layout.Builder>... layouts);

        /**
         * <p>
         * The control layouts of the sheet.
         * </p>
         * 
         * @param sheetControlLayouts
         *        The control layouts of the sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheetControlLayouts(Collection<SheetControlLayout> sheetControlLayouts);

        /**
         * <p>
         * The control layouts of the sheet.
         * </p>
         * 
         * @param sheetControlLayouts
         *        The control layouts of the sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheetControlLayouts(SheetControlLayout... sheetControlLayouts);

        /**
         * <p>
         * The control layouts of the sheet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SheetControlLayout.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.quicksight.model.SheetControlLayout#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SheetControlLayout.Builder#build()} is called
         * immediately and its result is passed to {@link #sheetControlLayouts(List<SheetControlLayout>)}.
         * 
         * @param sheetControlLayouts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SheetControlLayout.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sheetControlLayouts(java.util.Collection<SheetControlLayout>)
         */
        Builder sheetControlLayouts(Consumer<SheetControlLayout.Builder>... sheetControlLayouts);

        /**
         * <p>
         * The layout content type of the sheet. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PAGINATED</code>: Creates a sheet for a paginated report.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTERACTIVE</code>: Creates a sheet for an interactive dashboard.
         * </p>
         * </li>
         * </ul>
         * 
         * @param contentType
         *        The layout content type of the sheet. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PAGINATED</code>: Creates a sheet for a paginated report.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTERACTIVE</code>: Creates a sheet for an interactive dashboard.
         *        </p>
         *        </li>
         * @see SheetContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetContentType
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The layout content type of the sheet. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PAGINATED</code>: Creates a sheet for a paginated report.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTERACTIVE</code>: Creates a sheet for an interactive dashboard.
         * </p>
         * </li>
         * </ul>
         * 
         * @param contentType
         *        The layout content type of the sheet. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PAGINATED</code>: Creates a sheet for a paginated report.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTERACTIVE</code>: Creates a sheet for an interactive dashboard.
         *        </p>
         *        </li>
         * @see SheetContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SheetContentType
         */
        Builder contentType(SheetContentType contentType);

        /**
         * <p>
         * A list of visual custom actions for the sheet.
         * </p>
         * 
         * @param customActionDefaults
         *        A list of visual custom actions for the sheet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customActionDefaults(VisualCustomActionDefaults customActionDefaults);

        /**
         * <p>
         * A list of visual custom actions for the sheet.
         * </p>
         * This is a convenience method that creates an instance of the {@link VisualCustomActionDefaults.Builder}
         * avoiding the need to create one manually via {@link VisualCustomActionDefaults#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VisualCustomActionDefaults.Builder#build()} is called immediately
         * and its result is passed to {@link #customActionDefaults(VisualCustomActionDefaults)}.
         * 
         * @param customActionDefaults
         *        a consumer that will call methods on {@link VisualCustomActionDefaults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customActionDefaults(VisualCustomActionDefaults)
         */
        default Builder customActionDefaults(Consumer<VisualCustomActionDefaults.Builder> customActionDefaults) {
            return customActionDefaults(VisualCustomActionDefaults.builder().applyMutation(customActionDefaults).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sheetId;

        private String title;

        private String description;

        private String name;

        private List<ParameterControl> parameterControls = DefaultSdkAutoConstructList.getInstance();

        private List<FilterControl> filterControls = DefaultSdkAutoConstructList.getInstance();

        private List<Visual> visuals = DefaultSdkAutoConstructList.getInstance();

        private List<SheetTextBox> textBoxes = DefaultSdkAutoConstructList.getInstance();

        private List<SheetImage> images = DefaultSdkAutoConstructList.getInstance();

        private List<Layout> layouts = DefaultSdkAutoConstructList.getInstance();

        private List<SheetControlLayout> sheetControlLayouts = DefaultSdkAutoConstructList.getInstance();

        private String contentType;

        private VisualCustomActionDefaults customActionDefaults;

        private BuilderImpl() {
        }

        private BuilderImpl(SheetDefinition model) {
            sheetId(model.sheetId);
            title(model.title);
            description(model.description);
            name(model.name);
            parameterControls(model.parameterControls);
            filterControls(model.filterControls);
            visuals(model.visuals);
            textBoxes(model.textBoxes);
            images(model.images);
            layouts(model.layouts);
            sheetControlLayouts(model.sheetControlLayouts);
            contentType(model.contentType);
            customActionDefaults(model.customActionDefaults);
        }

        public final String getSheetId() {
            return sheetId;
        }

        public final void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        @Override
        public final Builder sheetId(String sheetId) {
            this.sheetId = sheetId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ParameterControl.Builder> getParameterControls() {
            List<ParameterControl.Builder> result = ParameterControlListCopier.copyToBuilder(this.parameterControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterControls(Collection<ParameterControl.BuilderImpl> parameterControls) {
            this.parameterControls = ParameterControlListCopier.copyFromBuilder(parameterControls);
        }

        @Override
        public final Builder parameterControls(Collection<ParameterControl> parameterControls) {
            this.parameterControls = ParameterControlListCopier.copy(parameterControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterControls(ParameterControl... parameterControls) {
            parameterControls(Arrays.asList(parameterControls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterControls(Consumer<ParameterControl.Builder>... parameterControls) {
            parameterControls(Stream.of(parameterControls).map(c -> ParameterControl.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FilterControl.Builder> getFilterControls() {
            List<FilterControl.Builder> result = FilterControlListCopier.copyToBuilder(this.filterControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterControls(Collection<FilterControl.BuilderImpl> filterControls) {
            this.filterControls = FilterControlListCopier.copyFromBuilder(filterControls);
        }

        @Override
        public final Builder filterControls(Collection<FilterControl> filterControls) {
            this.filterControls = FilterControlListCopier.copy(filterControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterControls(FilterControl... filterControls) {
            filterControls(Arrays.asList(filterControls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterControls(Consumer<FilterControl.Builder>... filterControls) {
            filterControls(Stream.of(filterControls).map(c -> FilterControl.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Visual.Builder> getVisuals() {
            List<Visual.Builder> result = VisualListCopier.copyToBuilder(this.visuals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVisuals(Collection<Visual.BuilderImpl> visuals) {
            this.visuals = VisualListCopier.copyFromBuilder(visuals);
        }

        @Override
        public final Builder visuals(Collection<Visual> visuals) {
            this.visuals = VisualListCopier.copy(visuals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder visuals(Visual... visuals) {
            visuals(Arrays.asList(visuals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder visuals(Consumer<Visual.Builder>... visuals) {
            visuals(Stream.of(visuals).map(c -> Visual.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SheetTextBox.Builder> getTextBoxes() {
            List<SheetTextBox.Builder> result = SheetTextBoxListCopier.copyToBuilder(this.textBoxes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTextBoxes(Collection<SheetTextBox.BuilderImpl> textBoxes) {
            this.textBoxes = SheetTextBoxListCopier.copyFromBuilder(textBoxes);
        }

        @Override
        public final Builder textBoxes(Collection<SheetTextBox> textBoxes) {
            this.textBoxes = SheetTextBoxListCopier.copy(textBoxes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textBoxes(SheetTextBox... textBoxes) {
            textBoxes(Arrays.asList(textBoxes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textBoxes(Consumer<SheetTextBox.Builder>... textBoxes) {
            textBoxes(Stream.of(textBoxes).map(c -> SheetTextBox.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SheetImage.Builder> getImages() {
            List<SheetImage.Builder> result = SheetImageListCopier.copyToBuilder(this.images);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImages(Collection<SheetImage.BuilderImpl> images) {
            this.images = SheetImageListCopier.copyFromBuilder(images);
        }

        @Override
        public final Builder images(Collection<SheetImage> images) {
            this.images = SheetImageListCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(SheetImage... images) {
            images(Arrays.asList(images));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Consumer<SheetImage.Builder>... images) {
            images(Stream.of(images).map(c -> SheetImage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Layout.Builder> getLayouts() {
            List<Layout.Builder> result = LayoutListCopier.copyToBuilder(this.layouts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLayouts(Collection<Layout.BuilderImpl> layouts) {
            this.layouts = LayoutListCopier.copyFromBuilder(layouts);
        }

        @Override
        public final Builder layouts(Collection<Layout> layouts) {
            this.layouts = LayoutListCopier.copy(layouts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layouts(Layout... layouts) {
            layouts(Arrays.asList(layouts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layouts(Consumer<Layout.Builder>... layouts) {
            layouts(Stream.of(layouts).map(c -> Layout.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SheetControlLayout.Builder> getSheetControlLayouts() {
            List<SheetControlLayout.Builder> result = SheetControlLayoutListCopier.copyToBuilder(this.sheetControlLayouts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSheetControlLayouts(Collection<SheetControlLayout.BuilderImpl> sheetControlLayouts) {
            this.sheetControlLayouts = SheetControlLayoutListCopier.copyFromBuilder(sheetControlLayouts);
        }

        @Override
        public final Builder sheetControlLayouts(Collection<SheetControlLayout> sheetControlLayouts) {
            this.sheetControlLayouts = SheetControlLayoutListCopier.copy(sheetControlLayouts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheetControlLayouts(SheetControlLayout... sheetControlLayouts) {
            sheetControlLayouts(Arrays.asList(sheetControlLayouts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheetControlLayouts(Consumer<SheetControlLayout.Builder>... sheetControlLayouts) {
            sheetControlLayouts(Stream.of(sheetControlLayouts).map(c -> SheetControlLayout.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(SheetContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final VisualCustomActionDefaults.Builder getCustomActionDefaults() {
            return customActionDefaults != null ? customActionDefaults.toBuilder() : null;
        }

        public final void setCustomActionDefaults(VisualCustomActionDefaults.BuilderImpl customActionDefaults) {
            this.customActionDefaults = customActionDefaults != null ? customActionDefaults.build() : null;
        }

        @Override
        public final Builder customActionDefaults(VisualCustomActionDefaults customActionDefaults) {
            this.customActionDefaults = customActionDefaults;
            return this;
        }

        @Override
        public SheetDefinition build() {
            return new SheetDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
