/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The display options of a control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SliderControlDisplayOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<SliderControlDisplayOptions.Builder, SliderControlDisplayOptions> {
    private static final SdkField<LabelOptions> TITLE_OPTIONS_FIELD = SdkField.<LabelOptions> builder(MarshallingType.SDK_POJO)
            .memberName("TitleOptions").getter(getter(SliderControlDisplayOptions::titleOptions))
            .setter(setter(Builder::titleOptions)).constructor(LabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TitleOptions").build()).build();

    private static final SdkField<SheetControlInfoIconLabelOptions> INFO_ICON_LABEL_OPTIONS_FIELD = SdkField
            .<SheetControlInfoIconLabelOptions> builder(MarshallingType.SDK_POJO).memberName("InfoIconLabelOptions")
            .getter(getter(SliderControlDisplayOptions::infoIconLabelOptions)).setter(setter(Builder::infoIconLabelOptions))
            .constructor(SheetControlInfoIconLabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfoIconLabelOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_OPTIONS_FIELD,
            INFO_ICON_LABEL_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LabelOptions titleOptions;

    private final SheetControlInfoIconLabelOptions infoIconLabelOptions;

    private SliderControlDisplayOptions(BuilderImpl builder) {
        this.titleOptions = builder.titleOptions;
        this.infoIconLabelOptions = builder.infoIconLabelOptions;
    }

    /**
     * <p>
     * The options to configure the title visibility, name, and font size.
     * </p>
     * 
     * @return The options to configure the title visibility, name, and font size.
     */
    public final LabelOptions titleOptions() {
        return titleOptions;
    }

    /**
     * <p>
     * The configuration of info icon label options.
     * </p>
     * 
     * @return The configuration of info icon label options.
     */
    public final SheetControlInfoIconLabelOptions infoIconLabelOptions() {
        return infoIconLabelOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(titleOptions());
        hashCode = 31 * hashCode + Objects.hashCode(infoIconLabelOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SliderControlDisplayOptions)) {
            return false;
        }
        SliderControlDisplayOptions other = (SliderControlDisplayOptions) obj;
        return Objects.equals(titleOptions(), other.titleOptions())
                && Objects.equals(infoIconLabelOptions(), other.infoIconLabelOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SliderControlDisplayOptions").add("TitleOptions", titleOptions())
                .add("InfoIconLabelOptions", infoIconLabelOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TitleOptions":
            return Optional.ofNullable(clazz.cast(titleOptions()));
        case "InfoIconLabelOptions":
            return Optional.ofNullable(clazz.cast(infoIconLabelOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TitleOptions", TITLE_OPTIONS_FIELD);
        map.put("InfoIconLabelOptions", INFO_ICON_LABEL_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SliderControlDisplayOptions, T> g) {
        return obj -> g.apply((SliderControlDisplayOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SliderControlDisplayOptions> {
        /**
         * <p>
         * The options to configure the title visibility, name, and font size.
         * </p>
         * 
         * @param titleOptions
         *        The options to configure the title visibility, name, and font size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder titleOptions(LabelOptions titleOptions);

        /**
         * <p>
         * The options to configure the title visibility, name, and font size.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelOptions.Builder} avoiding the need
         * to create one manually via {@link LabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #titleOptions(LabelOptions)}.
         * 
         * @param titleOptions
         *        a consumer that will call methods on {@link LabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #titleOptions(LabelOptions)
         */
        default Builder titleOptions(Consumer<LabelOptions.Builder> titleOptions) {
            return titleOptions(LabelOptions.builder().applyMutation(titleOptions).build());
        }

        /**
         * <p>
         * The configuration of info icon label options.
         * </p>
         * 
         * @param infoIconLabelOptions
         *        The configuration of info icon label options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infoIconLabelOptions(SheetControlInfoIconLabelOptions infoIconLabelOptions);

        /**
         * <p>
         * The configuration of info icon label options.
         * </p>
         * This is a convenience method that creates an instance of the {@link SheetControlInfoIconLabelOptions.Builder}
         * avoiding the need to create one manually via {@link SheetControlInfoIconLabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SheetControlInfoIconLabelOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #infoIconLabelOptions(SheetControlInfoIconLabelOptions)}.
         * 
         * @param infoIconLabelOptions
         *        a consumer that will call methods on {@link SheetControlInfoIconLabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #infoIconLabelOptions(SheetControlInfoIconLabelOptions)
         */
        default Builder infoIconLabelOptions(Consumer<SheetControlInfoIconLabelOptions.Builder> infoIconLabelOptions) {
            return infoIconLabelOptions(SheetControlInfoIconLabelOptions.builder().applyMutation(infoIconLabelOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LabelOptions titleOptions;

        private SheetControlInfoIconLabelOptions infoIconLabelOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(SliderControlDisplayOptions model) {
            titleOptions(model.titleOptions);
            infoIconLabelOptions(model.infoIconLabelOptions);
        }

        public final LabelOptions.Builder getTitleOptions() {
            return titleOptions != null ? titleOptions.toBuilder() : null;
        }

        public final void setTitleOptions(LabelOptions.BuilderImpl titleOptions) {
            this.titleOptions = titleOptions != null ? titleOptions.build() : null;
        }

        @Override
        public final Builder titleOptions(LabelOptions titleOptions) {
            this.titleOptions = titleOptions;
            return this;
        }

        public final SheetControlInfoIconLabelOptions.Builder getInfoIconLabelOptions() {
            return infoIconLabelOptions != null ? infoIconLabelOptions.toBuilder() : null;
        }

        public final void setInfoIconLabelOptions(SheetControlInfoIconLabelOptions.BuilderImpl infoIconLabelOptions) {
            this.infoIconLabelOptions = infoIconLabelOptions != null ? infoIconLabelOptions.build() : null;
        }

        @Override
        public final Builder infoIconLabelOptions(SheetControlInfoIconLabelOptions infoIconLabelOptions) {
            this.infoIconLabelOptions = infoIconLabelOptions;
            return this;
        }

        @Override
        public SliderControlDisplayOptions build() {
            return new SliderControlDisplayOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
