/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options that determine the layout and display options of a chart's small multiples.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SmallMultiplesOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<SmallMultiplesOptions.Builder, SmallMultiplesOptions> {
    private static final SdkField<Long> MAX_VISIBLE_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaxVisibleRows").getter(getter(SmallMultiplesOptions::maxVisibleRows))
            .setter(setter(Builder::maxVisibleRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxVisibleRows").build()).build();

    private static final SdkField<Long> MAX_VISIBLE_COLUMNS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaxVisibleColumns").getter(getter(SmallMultiplesOptions::maxVisibleColumns))
            .setter(setter(Builder::maxVisibleColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxVisibleColumns").build()).build();

    private static final SdkField<PanelConfiguration> PANEL_CONFIGURATION_FIELD = SdkField
            .<PanelConfiguration> builder(MarshallingType.SDK_POJO).memberName("PanelConfiguration")
            .getter(getter(SmallMultiplesOptions::panelConfiguration)).setter(setter(Builder::panelConfiguration))
            .constructor(PanelConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PanelConfiguration").build())
            .build();

    private static final SdkField<SmallMultiplesAxisProperties> X_AXIS_FIELD = SdkField
            .<SmallMultiplesAxisProperties> builder(MarshallingType.SDK_POJO).memberName("XAxis")
            .getter(getter(SmallMultiplesOptions::xAxis)).setter(setter(Builder::xAxis))
            .constructor(SmallMultiplesAxisProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAxis").build()).build();

    private static final SdkField<SmallMultiplesAxisProperties> Y_AXIS_FIELD = SdkField
            .<SmallMultiplesAxisProperties> builder(MarshallingType.SDK_POJO).memberName("YAxis")
            .getter(getter(SmallMultiplesOptions::yAxis)).setter(setter(Builder::yAxis))
            .constructor(SmallMultiplesAxisProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("YAxis").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_VISIBLE_ROWS_FIELD,
            MAX_VISIBLE_COLUMNS_FIELD, PANEL_CONFIGURATION_FIELD, X_AXIS_FIELD, Y_AXIS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long maxVisibleRows;

    private final Long maxVisibleColumns;

    private final PanelConfiguration panelConfiguration;

    private final SmallMultiplesAxisProperties xAxis;

    private final SmallMultiplesAxisProperties yAxis;

    private SmallMultiplesOptions(BuilderImpl builder) {
        this.maxVisibleRows = builder.maxVisibleRows;
        this.maxVisibleColumns = builder.maxVisibleColumns;
        this.panelConfiguration = builder.panelConfiguration;
        this.xAxis = builder.xAxis;
        this.yAxis = builder.yAxis;
    }

    /**
     * <p>
     * Sets the maximum number of visible rows to display in the grid of small multiples panels.
     * </p>
     * <p>
     * The default value is <code>Auto</code>, which automatically adjusts the rows in the grid to fit the overall
     * layout and size of the given chart.
     * </p>
     * 
     * @return Sets the maximum number of visible rows to display in the grid of small multiples panels.</p>
     *         <p>
     *         The default value is <code>Auto</code>, which automatically adjusts the rows in the grid to fit the
     *         overall layout and size of the given chart.
     */
    public final Long maxVisibleRows() {
        return maxVisibleRows;
    }

    /**
     * <p>
     * Sets the maximum number of visible columns to display in the grid of small multiples panels.
     * </p>
     * <p>
     * The default is <code>Auto</code>, which automatically adjusts the columns in the grid to fit the overall layout
     * and size of the given chart.
     * </p>
     * 
     * @return Sets the maximum number of visible columns to display in the grid of small multiples panels.</p>
     *         <p>
     *         The default is <code>Auto</code>, which automatically adjusts the columns in the grid to fit the overall
     *         layout and size of the given chart.
     */
    public final Long maxVisibleColumns() {
        return maxVisibleColumns;
    }

    /**
     * <p>
     * Configures the display options for each small multiples panel.
     * </p>
     * 
     * @return Configures the display options for each small multiples panel.
     */
    public final PanelConfiguration panelConfiguration() {
        return panelConfiguration;
    }

    /**
     * <p>
     * The properties of a small multiples X axis.
     * </p>
     * 
     * @return The properties of a small multiples X axis.
     */
    public final SmallMultiplesAxisProperties xAxis() {
        return xAxis;
    }

    /**
     * <p>
     * The properties of a small multiples Y axis.
     * </p>
     * 
     * @return The properties of a small multiples Y axis.
     */
    public final SmallMultiplesAxisProperties yAxis() {
        return yAxis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxVisibleRows());
        hashCode = 31 * hashCode + Objects.hashCode(maxVisibleColumns());
        hashCode = 31 * hashCode + Objects.hashCode(panelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(xAxis());
        hashCode = 31 * hashCode + Objects.hashCode(yAxis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SmallMultiplesOptions)) {
            return false;
        }
        SmallMultiplesOptions other = (SmallMultiplesOptions) obj;
        return Objects.equals(maxVisibleRows(), other.maxVisibleRows())
                && Objects.equals(maxVisibleColumns(), other.maxVisibleColumns())
                && Objects.equals(panelConfiguration(), other.panelConfiguration()) && Objects.equals(xAxis(), other.xAxis())
                && Objects.equals(yAxis(), other.yAxis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SmallMultiplesOptions").add("MaxVisibleRows", maxVisibleRows())
                .add("MaxVisibleColumns", maxVisibleColumns()).add("PanelConfiguration", panelConfiguration())
                .add("XAxis", xAxis()).add("YAxis", yAxis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxVisibleRows":
            return Optional.ofNullable(clazz.cast(maxVisibleRows()));
        case "MaxVisibleColumns":
            return Optional.ofNullable(clazz.cast(maxVisibleColumns()));
        case "PanelConfiguration":
            return Optional.ofNullable(clazz.cast(panelConfiguration()));
        case "XAxis":
            return Optional.ofNullable(clazz.cast(xAxis()));
        case "YAxis":
            return Optional.ofNullable(clazz.cast(yAxis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaxVisibleRows", MAX_VISIBLE_ROWS_FIELD);
        map.put("MaxVisibleColumns", MAX_VISIBLE_COLUMNS_FIELD);
        map.put("PanelConfiguration", PANEL_CONFIGURATION_FIELD);
        map.put("XAxis", X_AXIS_FIELD);
        map.put("YAxis", Y_AXIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SmallMultiplesOptions, T> g) {
        return obj -> g.apply((SmallMultiplesOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SmallMultiplesOptions> {
        /**
         * <p>
         * Sets the maximum number of visible rows to display in the grid of small multiples panels.
         * </p>
         * <p>
         * The default value is <code>Auto</code>, which automatically adjusts the rows in the grid to fit the overall
         * layout and size of the given chart.
         * </p>
         * 
         * @param maxVisibleRows
         *        Sets the maximum number of visible rows to display in the grid of small multiples panels.</p>
         *        <p>
         *        The default value is <code>Auto</code>, which automatically adjusts the rows in the grid to fit the
         *        overall layout and size of the given chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxVisibleRows(Long maxVisibleRows);

        /**
         * <p>
         * Sets the maximum number of visible columns to display in the grid of small multiples panels.
         * </p>
         * <p>
         * The default is <code>Auto</code>, which automatically adjusts the columns in the grid to fit the overall
         * layout and size of the given chart.
         * </p>
         * 
         * @param maxVisibleColumns
         *        Sets the maximum number of visible columns to display in the grid of small multiples panels.</p>
         *        <p>
         *        The default is <code>Auto</code>, which automatically adjusts the columns in the grid to fit the
         *        overall layout and size of the given chart.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxVisibleColumns(Long maxVisibleColumns);

        /**
         * <p>
         * Configures the display options for each small multiples panel.
         * </p>
         * 
         * @param panelConfiguration
         *        Configures the display options for each small multiples panel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder panelConfiguration(PanelConfiguration panelConfiguration);

        /**
         * <p>
         * Configures the display options for each small multiples panel.
         * </p>
         * This is a convenience method that creates an instance of the {@link PanelConfiguration.Builder} avoiding the
         * need to create one manually via {@link PanelConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PanelConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #panelConfiguration(PanelConfiguration)}.
         * 
         * @param panelConfiguration
         *        a consumer that will call methods on {@link PanelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #panelConfiguration(PanelConfiguration)
         */
        default Builder panelConfiguration(Consumer<PanelConfiguration.Builder> panelConfiguration) {
            return panelConfiguration(PanelConfiguration.builder().applyMutation(panelConfiguration).build());
        }

        /**
         * <p>
         * The properties of a small multiples X axis.
         * </p>
         * 
         * @param xAxis
         *        The properties of a small multiples X axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xAxis(SmallMultiplesAxisProperties xAxis);

        /**
         * <p>
         * The properties of a small multiples X axis.
         * </p>
         * This is a convenience method that creates an instance of the {@link SmallMultiplesAxisProperties.Builder}
         * avoiding the need to create one manually via {@link SmallMultiplesAxisProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SmallMultiplesAxisProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #xAxis(SmallMultiplesAxisProperties)}.
         * 
         * @param xAxis
         *        a consumer that will call methods on {@link SmallMultiplesAxisProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xAxis(SmallMultiplesAxisProperties)
         */
        default Builder xAxis(Consumer<SmallMultiplesAxisProperties.Builder> xAxis) {
            return xAxis(SmallMultiplesAxisProperties.builder().applyMutation(xAxis).build());
        }

        /**
         * <p>
         * The properties of a small multiples Y axis.
         * </p>
         * 
         * @param yAxis
         *        The properties of a small multiples Y axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yAxis(SmallMultiplesAxisProperties yAxis);

        /**
         * <p>
         * The properties of a small multiples Y axis.
         * </p>
         * This is a convenience method that creates an instance of the {@link SmallMultiplesAxisProperties.Builder}
         * avoiding the need to create one manually via {@link SmallMultiplesAxisProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SmallMultiplesAxisProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #yAxis(SmallMultiplesAxisProperties)}.
         * 
         * @param yAxis
         *        a consumer that will call methods on {@link SmallMultiplesAxisProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #yAxis(SmallMultiplesAxisProperties)
         */
        default Builder yAxis(Consumer<SmallMultiplesAxisProperties.Builder> yAxis) {
            return yAxis(SmallMultiplesAxisProperties.builder().applyMutation(yAxis).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long maxVisibleRows;

        private Long maxVisibleColumns;

        private PanelConfiguration panelConfiguration;

        private SmallMultiplesAxisProperties xAxis;

        private SmallMultiplesAxisProperties yAxis;

        private BuilderImpl() {
        }

        private BuilderImpl(SmallMultiplesOptions model) {
            maxVisibleRows(model.maxVisibleRows);
            maxVisibleColumns(model.maxVisibleColumns);
            panelConfiguration(model.panelConfiguration);
            xAxis(model.xAxis);
            yAxis(model.yAxis);
        }

        public final Long getMaxVisibleRows() {
            return maxVisibleRows;
        }

        public final void setMaxVisibleRows(Long maxVisibleRows) {
            this.maxVisibleRows = maxVisibleRows;
        }

        @Override
        public final Builder maxVisibleRows(Long maxVisibleRows) {
            this.maxVisibleRows = maxVisibleRows;
            return this;
        }

        public final Long getMaxVisibleColumns() {
            return maxVisibleColumns;
        }

        public final void setMaxVisibleColumns(Long maxVisibleColumns) {
            this.maxVisibleColumns = maxVisibleColumns;
        }

        @Override
        public final Builder maxVisibleColumns(Long maxVisibleColumns) {
            this.maxVisibleColumns = maxVisibleColumns;
            return this;
        }

        public final PanelConfiguration.Builder getPanelConfiguration() {
            return panelConfiguration != null ? panelConfiguration.toBuilder() : null;
        }

        public final void setPanelConfiguration(PanelConfiguration.BuilderImpl panelConfiguration) {
            this.panelConfiguration = panelConfiguration != null ? panelConfiguration.build() : null;
        }

        @Override
        public final Builder panelConfiguration(PanelConfiguration panelConfiguration) {
            this.panelConfiguration = panelConfiguration;
            return this;
        }

        public final SmallMultiplesAxisProperties.Builder getXAxis() {
            return xAxis != null ? xAxis.toBuilder() : null;
        }

        public final void setXAxis(SmallMultiplesAxisProperties.BuilderImpl xAxis) {
            this.xAxis = xAxis != null ? xAxis.build() : null;
        }

        @Override
        public final Builder xAxis(SmallMultiplesAxisProperties xAxis) {
            this.xAxis = xAxis;
            return this;
        }

        public final SmallMultiplesAxisProperties.Builder getYAxis() {
            return yAxis != null ? yAxis.toBuilder() : null;
        }

        public final void setYAxis(SmallMultiplesAxisProperties.BuilderImpl yAxis) {
            this.yAxis = yAxis != null ? yAxis.build() : null;
        }

        @Override
        public final Builder yAxis(SmallMultiplesAxisProperties yAxis) {
            this.yAxis = yAxis;
            return this;
        }

        @Override
        public SmallMultiplesOptions build() {
            return new SmallMultiplesOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
