/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDashboardSnapshotJobScheduleRequest extends QuickSightRequest implements
        ToCopyableBuilder<StartDashboardSnapshotJobScheduleRequest.Builder, StartDashboardSnapshotJobScheduleRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(StartDashboardSnapshotJobScheduleRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardId").getter(getter(StartDashboardSnapshotJobScheduleRequest::dashboardId))
            .setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DashboardId").build()).build();

    private static final SdkField<String> SCHEDULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleId").getter(getter(StartDashboardSnapshotJobScheduleRequest::scheduleId))
            .setter(setter(Builder::scheduleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ScheduleId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            DASHBOARD_ID_FIELD, SCHEDULE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String dashboardId;

    private final String scheduleId;

    private StartDashboardSnapshotJobScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dashboardId = builder.dashboardId;
        this.scheduleId = builder.scheduleId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID of the dashboard that you want to start a snapshot job schedule for.
     * </p>
     * 
     * @return The ID of the dashboard that you want to start a snapshot job schedule for.
     */
    public final String dashboardId() {
        return dashboardId;
    }

    /**
     * <p>
     * The ID of the schedule that you want to start a snapshot job schedule for. The schedule ID can be found in the
     * Amazon QuickSight console in the <b>Schedules</b> pane of the dashboard that the schedule is configured for.
     * </p>
     * 
     * @return The ID of the schedule that you want to start a snapshot job schedule for. The schedule ID can be found
     *         in the Amazon QuickSight console in the <b>Schedules</b> pane of the dashboard that the schedule is
     *         configured for.
     */
    public final String scheduleId() {
        return scheduleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDashboardSnapshotJobScheduleRequest)) {
            return false;
        }
        StartDashboardSnapshotJobScheduleRequest other = (StartDashboardSnapshotJobScheduleRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(dashboardId(), other.dashboardId())
                && Objects.equals(scheduleId(), other.scheduleId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDashboardSnapshotJobScheduleRequest").add("AwsAccountId", awsAccountId())
                .add("DashboardId", dashboardId()).add("ScheduleId", scheduleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "DashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "ScheduleId":
            return Optional.ofNullable(clazz.cast(scheduleId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("DashboardId", DASHBOARD_ID_FIELD);
        map.put("ScheduleId", SCHEDULE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDashboardSnapshotJobScheduleRequest, T> g) {
        return obj -> g.apply((StartDashboardSnapshotJobScheduleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartDashboardSnapshotJobScheduleRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that the dashboard snapshot job is executed in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID of the dashboard that you want to start a snapshot job schedule for.
         * </p>
         * 
         * @param dashboardId
         *        The ID of the dashboard that you want to start a snapshot job schedule for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * The ID of the schedule that you want to start a snapshot job schedule for. The schedule ID can be found in
         * the Amazon QuickSight console in the <b>Schedules</b> pane of the dashboard that the schedule is configured
         * for.
         * </p>
         * 
         * @param scheduleId
         *        The ID of the schedule that you want to start a snapshot job schedule for. The schedule ID can be
         *        found in the Amazon QuickSight console in the <b>Schedules</b> pane of the dashboard that the schedule
         *        is configured for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleId(String scheduleId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String dashboardId;

        private String scheduleId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDashboardSnapshotJobScheduleRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            dashboardId(model.dashboardId);
            scheduleId(model.scheduleId);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final String getScheduleId() {
            return scheduleId;
        }

        public final void setScheduleId(String scheduleId) {
            this.scheduleId = scheduleId;
        }

        @Override
        public final Builder scheduleId(String scheduleId) {
            this.scheduleId = scheduleId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDashboardSnapshotJobScheduleRequest build() {
            return new StartDashboardSnapshotJobScheduleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
