/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A success entry that occurs when a <code>KeyRegistration</code> job is successfully applied to the Amazon QuickSight
 * account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuccessfulKeyRegistrationEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<SuccessfulKeyRegistrationEntry.Builder, SuccessfulKeyRegistrationEntry> {
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KeyArn")
            .getter(getter(SuccessfulKeyRegistrationEntry::keyArn)).setter(setter(Builder::keyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyArn").build()).build();

    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StatusCode").getter(getter(SuccessfulKeyRegistrationEntry::statusCode))
            .setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ARN_FIELD,
            STATUS_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String keyArn;

    private final Integer statusCode;

    private SuccessfulKeyRegistrationEntry(BuilderImpl builder) {
        this.keyArn = builder.keyArn;
        this.statusCode = builder.statusCode;
    }

    /**
     * <p>
     * The ARN of the KMS key that is associated with the <code>SuccessfulKeyRegistrationEntry</code> entry.
     * </p>
     * 
     * @return The ARN of the KMS key that is associated with the <code>SuccessfulKeyRegistrationEntry</code> entry.
     */
    public final String keyArn() {
        return keyArn;
    }

    /**
     * <p>
     * The HTTP status of a <code>SuccessfulKeyRegistrationEntry</code> entry.
     * </p>
     * 
     * @return The HTTP status of a <code>SuccessfulKeyRegistrationEntry</code> entry.
     */
    public final Integer statusCode() {
        return statusCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuccessfulKeyRegistrationEntry)) {
            return false;
        }
        SuccessfulKeyRegistrationEntry other = (SuccessfulKeyRegistrationEntry) obj;
        return Objects.equals(keyArn(), other.keyArn()) && Objects.equals(statusCode(), other.statusCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuccessfulKeyRegistrationEntry").add("KeyArn", keyArn()).add("StatusCode", statusCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyArn":
            return Optional.ofNullable(clazz.cast(keyArn()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyArn", KEY_ARN_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SuccessfulKeyRegistrationEntry, T> g) {
        return obj -> g.apply((SuccessfulKeyRegistrationEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuccessfulKeyRegistrationEntry> {
        /**
         * <p>
         * The ARN of the KMS key that is associated with the <code>SuccessfulKeyRegistrationEntry</code> entry.
         * </p>
         * 
         * @param keyArn
         *        The ARN of the KMS key that is associated with the <code>SuccessfulKeyRegistrationEntry</code> entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyArn(String keyArn);

        /**
         * <p>
         * The HTTP status of a <code>SuccessfulKeyRegistrationEntry</code> entry.
         * </p>
         * 
         * @param statusCode
         *        The HTTP status of a <code>SuccessfulKeyRegistrationEntry</code> entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCode);
    }

    static final class BuilderImpl implements Builder {
        private String keyArn;

        private Integer statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(SuccessfulKeyRegistrationEntry model) {
            keyArn(model.keyArn);
            statusCode(model.statusCode);
        }

        public final String getKeyArn() {
            return keyArn;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public final Integer getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public SuccessfulKeyRegistrationEntry build() {
            return new SuccessfulKeyRegistrationEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
