/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for the pinned columns of a table visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TablePinnedFieldOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<TablePinnedFieldOptions.Builder, TablePinnedFieldOptions> {
    private static final SdkField<List<String>> PINNED_LEFT_FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PinnedLeftFields")
            .getter(getter(TablePinnedFieldOptions::pinnedLeftFields))
            .setter(setter(Builder::pinnedLeftFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinnedLeftFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PINNED_LEFT_FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> pinnedLeftFields;

    private TablePinnedFieldOptions(BuilderImpl builder) {
        this.pinnedLeftFields = builder.pinnedLeftFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the PinnedLeftFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPinnedLeftFields() {
        return pinnedLeftFields != null && !(pinnedLeftFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of columns to be pinned to the left of a table visual.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPinnedLeftFields} method.
     * </p>
     * 
     * @return A list of columns to be pinned to the left of a table visual.
     */
    public final List<String> pinnedLeftFields() {
        return pinnedLeftFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPinnedLeftFields() ? pinnedLeftFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TablePinnedFieldOptions)) {
            return false;
        }
        TablePinnedFieldOptions other = (TablePinnedFieldOptions) obj;
        return hasPinnedLeftFields() == other.hasPinnedLeftFields()
                && Objects.equals(pinnedLeftFields(), other.pinnedLeftFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TablePinnedFieldOptions")
                .add("PinnedLeftFields", hasPinnedLeftFields() ? pinnedLeftFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PinnedLeftFields":
            return Optional.ofNullable(clazz.cast(pinnedLeftFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PinnedLeftFields", PINNED_LEFT_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TablePinnedFieldOptions, T> g) {
        return obj -> g.apply((TablePinnedFieldOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TablePinnedFieldOptions> {
        /**
         * <p>
         * A list of columns to be pinned to the left of a table visual.
         * </p>
         * 
         * @param pinnedLeftFields
         *        A list of columns to be pinned to the left of a table visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pinnedLeftFields(Collection<String> pinnedLeftFields);

        /**
         * <p>
         * A list of columns to be pinned to the left of a table visual.
         * </p>
         * 
         * @param pinnedLeftFields
         *        A list of columns to be pinned to the left of a table visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pinnedLeftFields(String... pinnedLeftFields);
    }

    static final class BuilderImpl implements Builder {
        private List<String> pinnedLeftFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TablePinnedFieldOptions model) {
            pinnedLeftFields(model.pinnedLeftFields);
        }

        public final Collection<String> getPinnedLeftFields() {
            if (pinnedLeftFields instanceof SdkAutoConstructList) {
                return null;
            }
            return pinnedLeftFields;
        }

        public final void setPinnedLeftFields(Collection<String> pinnedLeftFields) {
            this.pinnedLeftFields = TableFieldOrderListCopier.copy(pinnedLeftFields);
        }

        @Override
        public final Builder pinnedLeftFields(Collection<String> pinnedLeftFields) {
            this.pinnedLeftFields = TableFieldOrderListCopier.copy(pinnedLeftFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pinnedLeftFields(String... pinnedLeftFields) {
            pinnedLeftFields(Arrays.asList(pinnedLeftFields));
            return this;
        }

        @Override
        public TablePinnedFieldOptions build() {
            return new TablePinnedFieldOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
