/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value of a time range filter.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeRangeFilterValue implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeRangeFilterValue.Builder, TimeRangeFilterValue> {
    private static final SdkField<Instant> STATIC_VALUE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StaticValue").getter(getter(TimeRangeFilterValue::staticValue)).setter(setter(Builder::staticValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticValue").build()).build();

    private static final SdkField<RollingDateConfiguration> ROLLING_DATE_FIELD = SdkField
            .<RollingDateConfiguration> builder(MarshallingType.SDK_POJO).memberName("RollingDate")
            .getter(getter(TimeRangeFilterValue::rollingDate)).setter(setter(Builder::rollingDate))
            .constructor(RollingDateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollingDate").build()).build();

    private static final SdkField<String> PARAMETER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Parameter").getter(getter(TimeRangeFilterValue::parameter)).setter(setter(Builder::parameter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_VALUE_FIELD,
            ROLLING_DATE_FIELD, PARAMETER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant staticValue;

    private final RollingDateConfiguration rollingDate;

    private final String parameter;

    private TimeRangeFilterValue(BuilderImpl builder) {
        this.staticValue = builder.staticValue;
        this.rollingDate = builder.rollingDate;
        this.parameter = builder.parameter;
    }

    /**
     * <p>
     * The static input value.
     * </p>
     * 
     * @return The static input value.
     */
    public final Instant staticValue() {
        return staticValue;
    }

    /**
     * <p>
     * The rolling date input value.
     * </p>
     * 
     * @return The rolling date input value.
     */
    public final RollingDateConfiguration rollingDate() {
        return rollingDate;
    }

    /**
     * <p>
     * The parameter type input value.
     * </p>
     * 
     * @return The parameter type input value.
     */
    public final String parameter() {
        return parameter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(staticValue());
        hashCode = 31 * hashCode + Objects.hashCode(rollingDate());
        hashCode = 31 * hashCode + Objects.hashCode(parameter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeRangeFilterValue)) {
            return false;
        }
        TimeRangeFilterValue other = (TimeRangeFilterValue) obj;
        return Objects.equals(staticValue(), other.staticValue()) && Objects.equals(rollingDate(), other.rollingDate())
                && Objects.equals(parameter(), other.parameter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeRangeFilterValue").add("StaticValue", staticValue()).add("RollingDate", rollingDate())
                .add("Parameter", parameter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StaticValue":
            return Optional.ofNullable(clazz.cast(staticValue()));
        case "RollingDate":
            return Optional.ofNullable(clazz.cast(rollingDate()));
        case "Parameter":
            return Optional.ofNullable(clazz.cast(parameter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StaticValue", STATIC_VALUE_FIELD);
        map.put("RollingDate", ROLLING_DATE_FIELD);
        map.put("Parameter", PARAMETER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeRangeFilterValue, T> g) {
        return obj -> g.apply((TimeRangeFilterValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeRangeFilterValue> {
        /**
         * <p>
         * The static input value.
         * </p>
         * 
         * @param staticValue
         *        The static input value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticValue(Instant staticValue);

        /**
         * <p>
         * The rolling date input value.
         * </p>
         * 
         * @param rollingDate
         *        The rolling date input value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollingDate(RollingDateConfiguration rollingDate);

        /**
         * <p>
         * The rolling date input value.
         * </p>
         * This is a convenience method that creates an instance of the {@link RollingDateConfiguration.Builder}
         * avoiding the need to create one manually via {@link RollingDateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RollingDateConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #rollingDate(RollingDateConfiguration)}.
         * 
         * @param rollingDate
         *        a consumer that will call methods on {@link RollingDateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rollingDate(RollingDateConfiguration)
         */
        default Builder rollingDate(Consumer<RollingDateConfiguration.Builder> rollingDate) {
            return rollingDate(RollingDateConfiguration.builder().applyMutation(rollingDate).build());
        }

        /**
         * <p>
         * The parameter type input value.
         * </p>
         * 
         * @param parameter
         *        The parameter type input value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameter(String parameter);
    }

    static final class BuilderImpl implements Builder {
        private Instant staticValue;

        private RollingDateConfiguration rollingDate;

        private String parameter;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeRangeFilterValue model) {
            staticValue(model.staticValue);
            rollingDate(model.rollingDate);
            parameter(model.parameter);
        }

        public final Instant getStaticValue() {
            return staticValue;
        }

        public final void setStaticValue(Instant staticValue) {
            this.staticValue = staticValue;
        }

        @Override
        public final Builder staticValue(Instant staticValue) {
            this.staticValue = staticValue;
            return this;
        }

        public final RollingDateConfiguration.Builder getRollingDate() {
            return rollingDate != null ? rollingDate.toBuilder() : null;
        }

        public final void setRollingDate(RollingDateConfiguration.BuilderImpl rollingDate) {
            this.rollingDate = rollingDate != null ? rollingDate.build() : null;
        }

        @Override
        public final Builder rollingDate(RollingDateConfiguration rollingDate) {
            this.rollingDate = rollingDate;
            return this;
        }

        public final String getParameter() {
            return parameter;
        }

        public final void setParameter(String parameter) {
            this.parameter = parameter;
        }

        @Override
        public final Builder parameter(String parameter) {
            this.parameter = parameter;
            return this;
        }

        @Override
        public TimeRangeFilterValue build() {
            return new TimeRangeFilterValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
