/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a category filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicCategoryFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicCategoryFilter.Builder, TopicCategoryFilter> {
    private static final SdkField<String> CATEGORY_FILTER_FUNCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CategoryFilterFunction").getter(getter(TopicCategoryFilter::categoryFilterFunctionAsString))
            .setter(setter(Builder::categoryFilterFunction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryFilterFunction").build())
            .build();

    private static final SdkField<String> CATEGORY_FILTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CategoryFilterType").getter(getter(TopicCategoryFilter::categoryFilterTypeAsString))
            .setter(setter(Builder::categoryFilterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryFilterType").build())
            .build();

    private static final SdkField<TopicCategoryFilterConstant> CONSTANT_FIELD = SdkField
            .<TopicCategoryFilterConstant> builder(MarshallingType.SDK_POJO).memberName("Constant")
            .getter(getter(TopicCategoryFilter::constant)).setter(setter(Builder::constant))
            .constructor(TopicCategoryFilterConstant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constant").build()).build();

    private static final SdkField<Boolean> INVERSE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Inverse").getter(getter(TopicCategoryFilter::inverse)).setter(setter(Builder::inverse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inverse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CATEGORY_FILTER_FUNCTION_FIELD, CATEGORY_FILTER_TYPE_FIELD, CONSTANT_FIELD, INVERSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String categoryFilterFunction;

    private final String categoryFilterType;

    private final TopicCategoryFilterConstant constant;

    private final Boolean inverse;

    private TopicCategoryFilter(BuilderImpl builder) {
        this.categoryFilterFunction = builder.categoryFilterFunction;
        this.categoryFilterType = builder.categoryFilterType;
        this.constant = builder.constant;
        this.inverse = builder.inverse;
    }

    /**
     * <p>
     * The category filter function. Valid values for this structure are <code>EXACT</code> and <code>CONTAINS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #categoryFilterFunction} will return {@link CategoryFilterFunction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #categoryFilterFunctionAsString}.
     * </p>
     * 
     * @return The category filter function. Valid values for this structure are <code>EXACT</code> and
     *         <code>CONTAINS</code>.
     * @see CategoryFilterFunction
     */
    public final CategoryFilterFunction categoryFilterFunction() {
        return CategoryFilterFunction.fromValue(categoryFilterFunction);
    }

    /**
     * <p>
     * The category filter function. Valid values for this structure are <code>EXACT</code> and <code>CONTAINS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #categoryFilterFunction} will return {@link CategoryFilterFunction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #categoryFilterFunctionAsString}.
     * </p>
     * 
     * @return The category filter function. Valid values for this structure are <code>EXACT</code> and
     *         <code>CONTAINS</code>.
     * @see CategoryFilterFunction
     */
    public final String categoryFilterFunctionAsString() {
        return categoryFilterFunction;
    }

    /**
     * <p>
     * The category filter type. This element is used to specify whether a filter is a simple category filter or an
     * inverse category filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #categoryFilterType} will return {@link CategoryFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #categoryFilterTypeAsString}.
     * </p>
     * 
     * @return The category filter type. This element is used to specify whether a filter is a simple category filter or
     *         an inverse category filter.
     * @see CategoryFilterType
     */
    public final CategoryFilterType categoryFilterType() {
        return CategoryFilterType.fromValue(categoryFilterType);
    }

    /**
     * <p>
     * The category filter type. This element is used to specify whether a filter is a simple category filter or an
     * inverse category filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #categoryFilterType} will return {@link CategoryFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #categoryFilterTypeAsString}.
     * </p>
     * 
     * @return The category filter type. This element is used to specify whether a filter is a simple category filter or
     *         an inverse category filter.
     * @see CategoryFilterType
     */
    public final String categoryFilterTypeAsString() {
        return categoryFilterType;
    }

    /**
     * <p>
     * The constant used in a category filter.
     * </p>
     * 
     * @return The constant used in a category filter.
     */
    public final TopicCategoryFilterConstant constant() {
        return constant;
    }

    /**
     * <p>
     * A Boolean value that indicates if the filter is inverse.
     * </p>
     * 
     * @return A Boolean value that indicates if the filter is inverse.
     */
    public final Boolean inverse() {
        return inverse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(categoryFilterFunctionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(categoryFilterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(constant());
        hashCode = 31 * hashCode + Objects.hashCode(inverse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicCategoryFilter)) {
            return false;
        }
        TopicCategoryFilter other = (TopicCategoryFilter) obj;
        return Objects.equals(categoryFilterFunctionAsString(), other.categoryFilterFunctionAsString())
                && Objects.equals(categoryFilterTypeAsString(), other.categoryFilterTypeAsString())
                && Objects.equals(constant(), other.constant()) && Objects.equals(inverse(), other.inverse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicCategoryFilter").add("CategoryFilterFunction", categoryFilterFunctionAsString())
                .add("CategoryFilterType", categoryFilterTypeAsString())
                .add("Constant", constant() == null ? null : "*** Sensitive Data Redacted ***").add("Inverse", inverse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CategoryFilterFunction":
            return Optional.ofNullable(clazz.cast(categoryFilterFunctionAsString()));
        case "CategoryFilterType":
            return Optional.ofNullable(clazz.cast(categoryFilterTypeAsString()));
        case "Constant":
            return Optional.ofNullable(clazz.cast(constant()));
        case "Inverse":
            return Optional.ofNullable(clazz.cast(inverse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CategoryFilterFunction", CATEGORY_FILTER_FUNCTION_FIELD);
        map.put("CategoryFilterType", CATEGORY_FILTER_TYPE_FIELD);
        map.put("Constant", CONSTANT_FIELD);
        map.put("Inverse", INVERSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicCategoryFilter, T> g) {
        return obj -> g.apply((TopicCategoryFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicCategoryFilter> {
        /**
         * <p>
         * The category filter function. Valid values for this structure are <code>EXACT</code> and
         * <code>CONTAINS</code>.
         * </p>
         * 
         * @param categoryFilterFunction
         *        The category filter function. Valid values for this structure are <code>EXACT</code> and
         *        <code>CONTAINS</code>.
         * @see CategoryFilterFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CategoryFilterFunction
         */
        Builder categoryFilterFunction(String categoryFilterFunction);

        /**
         * <p>
         * The category filter function. Valid values for this structure are <code>EXACT</code> and
         * <code>CONTAINS</code>.
         * </p>
         * 
         * @param categoryFilterFunction
         *        The category filter function. Valid values for this structure are <code>EXACT</code> and
         *        <code>CONTAINS</code>.
         * @see CategoryFilterFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CategoryFilterFunction
         */
        Builder categoryFilterFunction(CategoryFilterFunction categoryFilterFunction);

        /**
         * <p>
         * The category filter type. This element is used to specify whether a filter is a simple category filter or an
         * inverse category filter.
         * </p>
         * 
         * @param categoryFilterType
         *        The category filter type. This element is used to specify whether a filter is a simple category filter
         *        or an inverse category filter.
         * @see CategoryFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CategoryFilterType
         */
        Builder categoryFilterType(String categoryFilterType);

        /**
         * <p>
         * The category filter type. This element is used to specify whether a filter is a simple category filter or an
         * inverse category filter.
         * </p>
         * 
         * @param categoryFilterType
         *        The category filter type. This element is used to specify whether a filter is a simple category filter
         *        or an inverse category filter.
         * @see CategoryFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CategoryFilterType
         */
        Builder categoryFilterType(CategoryFilterType categoryFilterType);

        /**
         * <p>
         * The constant used in a category filter.
         * </p>
         * 
         * @param constant
         *        The constant used in a category filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constant(TopicCategoryFilterConstant constant);

        /**
         * <p>
         * The constant used in a category filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicCategoryFilterConstant.Builder}
         * avoiding the need to create one manually via {@link TopicCategoryFilterConstant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicCategoryFilterConstant.Builder#build()} is called
         * immediately and its result is passed to {@link #constant(TopicCategoryFilterConstant)}.
         * 
         * @param constant
         *        a consumer that will call methods on {@link TopicCategoryFilterConstant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #constant(TopicCategoryFilterConstant)
         */
        default Builder constant(Consumer<TopicCategoryFilterConstant.Builder> constant) {
            return constant(TopicCategoryFilterConstant.builder().applyMutation(constant).build());
        }

        /**
         * <p>
         * A Boolean value that indicates if the filter is inverse.
         * </p>
         * 
         * @param inverse
         *        A Boolean value that indicates if the filter is inverse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inverse(Boolean inverse);
    }

    static final class BuilderImpl implements Builder {
        private String categoryFilterFunction;

        private String categoryFilterType;

        private TopicCategoryFilterConstant constant;

        private Boolean inverse;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicCategoryFilter model) {
            categoryFilterFunction(model.categoryFilterFunction);
            categoryFilterType(model.categoryFilterType);
            constant(model.constant);
            inverse(model.inverse);
        }

        public final String getCategoryFilterFunction() {
            return categoryFilterFunction;
        }

        public final void setCategoryFilterFunction(String categoryFilterFunction) {
            this.categoryFilterFunction = categoryFilterFunction;
        }

        @Override
        public final Builder categoryFilterFunction(String categoryFilterFunction) {
            this.categoryFilterFunction = categoryFilterFunction;
            return this;
        }

        @Override
        public final Builder categoryFilterFunction(CategoryFilterFunction categoryFilterFunction) {
            this.categoryFilterFunction(categoryFilterFunction == null ? null : categoryFilterFunction.toString());
            return this;
        }

        public final String getCategoryFilterType() {
            return categoryFilterType;
        }

        public final void setCategoryFilterType(String categoryFilterType) {
            this.categoryFilterType = categoryFilterType;
        }

        @Override
        public final Builder categoryFilterType(String categoryFilterType) {
            this.categoryFilterType = categoryFilterType;
            return this;
        }

        @Override
        public final Builder categoryFilterType(CategoryFilterType categoryFilterType) {
            this.categoryFilterType(categoryFilterType == null ? null : categoryFilterType.toString());
            return this;
        }

        public final TopicCategoryFilterConstant.Builder getConstant() {
            return constant != null ? constant.toBuilder() : null;
        }

        public final void setConstant(TopicCategoryFilterConstant.BuilderImpl constant) {
            this.constant = constant != null ? constant.build() : null;
        }

        @Override
        public final Builder constant(TopicCategoryFilterConstant constant) {
            this.constant = constant;
            return this;
        }

        public final Boolean getInverse() {
            return inverse;
        }

        public final void setInverse(Boolean inverse) {
            this.inverse = inverse;
        }

        @Override
        public final Builder inverse(Boolean inverse) {
            this.inverse = inverse;
            return this;
        }

        @Override
        public TopicCategoryFilter build() {
            return new TopicCategoryFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
