/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that represents a filter used to select items for a topic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicFilter implements SdkPojo, Serializable, ToCopyableBuilder<TopicFilter.Builder, TopicFilter> {
    private static final SdkField<String> FILTER_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterDescription").getter(getter(TopicFilter::filterDescription))
            .setter(setter(Builder::filterDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterDescription").build()).build();

    private static final SdkField<String> FILTER_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterClass").getter(getter(TopicFilter::filterClassAsString)).setter(setter(Builder::filterClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterClass").build()).build();

    private static final SdkField<String> FILTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterName").getter(getter(TopicFilter::filterName)).setter(setter(Builder::filterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterName").build()).build();

    private static final SdkField<List<String>> FILTER_SYNONYMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FilterSynonyms")
            .getter(getter(TopicFilter::filterSynonyms))
            .setter(setter(Builder::filterSynonyms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterSynonyms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OPERAND_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperandFieldName").getter(getter(TopicFilter::operandFieldName))
            .setter(setter(Builder::operandFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperandFieldName").build()).build();

    private static final SdkField<String> FILTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterType").getter(getter(TopicFilter::filterTypeAsString)).setter(setter(Builder::filterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterType").build()).build();

    private static final SdkField<TopicCategoryFilter> CATEGORY_FILTER_FIELD = SdkField
            .<TopicCategoryFilter> builder(MarshallingType.SDK_POJO).memberName("CategoryFilter")
            .getter(getter(TopicFilter::categoryFilter)).setter(setter(Builder::categoryFilter))
            .constructor(TopicCategoryFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryFilter").build()).build();

    private static final SdkField<TopicNumericEqualityFilter> NUMERIC_EQUALITY_FILTER_FIELD = SdkField
            .<TopicNumericEqualityFilter> builder(MarshallingType.SDK_POJO).memberName("NumericEqualityFilter")
            .getter(getter(TopicFilter::numericEqualityFilter)).setter(setter(Builder::numericEqualityFilter))
            .constructor(TopicNumericEqualityFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericEqualityFilter").build())
            .build();

    private static final SdkField<TopicNumericRangeFilter> NUMERIC_RANGE_FILTER_FIELD = SdkField
            .<TopicNumericRangeFilter> builder(MarshallingType.SDK_POJO).memberName("NumericRangeFilter")
            .getter(getter(TopicFilter::numericRangeFilter)).setter(setter(Builder::numericRangeFilter))
            .constructor(TopicNumericRangeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericRangeFilter").build())
            .build();

    private static final SdkField<TopicDateRangeFilter> DATE_RANGE_FILTER_FIELD = SdkField
            .<TopicDateRangeFilter> builder(MarshallingType.SDK_POJO).memberName("DateRangeFilter")
            .getter(getter(TopicFilter::dateRangeFilter)).setter(setter(Builder::dateRangeFilter))
            .constructor(TopicDateRangeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateRangeFilter").build()).build();

    private static final SdkField<TopicRelativeDateFilter> RELATIVE_DATE_FILTER_FIELD = SdkField
            .<TopicRelativeDateFilter> builder(MarshallingType.SDK_POJO).memberName("RelativeDateFilter")
            .getter(getter(TopicFilter::relativeDateFilter)).setter(setter(Builder::relativeDateFilter))
            .constructor(TopicRelativeDateFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativeDateFilter").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_DESCRIPTION_FIELD,
            FILTER_CLASS_FIELD, FILTER_NAME_FIELD, FILTER_SYNONYMS_FIELD, OPERAND_FIELD_NAME_FIELD, FILTER_TYPE_FIELD,
            CATEGORY_FILTER_FIELD, NUMERIC_EQUALITY_FILTER_FIELD, NUMERIC_RANGE_FILTER_FIELD, DATE_RANGE_FILTER_FIELD,
            RELATIVE_DATE_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filterDescription;

    private final String filterClass;

    private final String filterName;

    private final List<String> filterSynonyms;

    private final String operandFieldName;

    private final String filterType;

    private final TopicCategoryFilter categoryFilter;

    private final TopicNumericEqualityFilter numericEqualityFilter;

    private final TopicNumericRangeFilter numericRangeFilter;

    private final TopicDateRangeFilter dateRangeFilter;

    private final TopicRelativeDateFilter relativeDateFilter;

    private TopicFilter(BuilderImpl builder) {
        this.filterDescription = builder.filterDescription;
        this.filterClass = builder.filterClass;
        this.filterName = builder.filterName;
        this.filterSynonyms = builder.filterSynonyms;
        this.operandFieldName = builder.operandFieldName;
        this.filterType = builder.filterType;
        this.categoryFilter = builder.categoryFilter;
        this.numericEqualityFilter = builder.numericEqualityFilter;
        this.numericRangeFilter = builder.numericRangeFilter;
        this.dateRangeFilter = builder.dateRangeFilter;
        this.relativeDateFilter = builder.relativeDateFilter;
    }

    /**
     * <p>
     * A description of the filter used to select items for a topic.
     * </p>
     * 
     * @return A description of the filter used to select items for a topic.
     */
    public final String filterDescription() {
        return filterDescription;
    }

    /**
     * <p>
     * The class of the filter. Valid values for this structure are <code>ENFORCED_VALUE_FILTER</code>,
     * <code>CONDITIONAL_VALUE_FILTER</code>, and <code>NAMED_VALUE_FILTER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterClass} will
     * return {@link FilterClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterClassAsString}.
     * </p>
     * 
     * @return The class of the filter. Valid values for this structure are <code>ENFORCED_VALUE_FILTER</code>,
     *         <code>CONDITIONAL_VALUE_FILTER</code>, and <code>NAMED_VALUE_FILTER</code>.
     * @see FilterClass
     */
    public final FilterClass filterClass() {
        return FilterClass.fromValue(filterClass);
    }

    /**
     * <p>
     * The class of the filter. Valid values for this structure are <code>ENFORCED_VALUE_FILTER</code>,
     * <code>CONDITIONAL_VALUE_FILTER</code>, and <code>NAMED_VALUE_FILTER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterClass} will
     * return {@link FilterClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterClassAsString}.
     * </p>
     * 
     * @return The class of the filter. Valid values for this structure are <code>ENFORCED_VALUE_FILTER</code>,
     *         <code>CONDITIONAL_VALUE_FILTER</code>, and <code>NAMED_VALUE_FILTER</code>.
     * @see FilterClass
     */
    public final String filterClassAsString() {
        return filterClass;
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * 
     * @return The name of the filter.
     */
    public final String filterName() {
        return filterName;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterSynonyms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilterSynonyms() {
        return filterSynonyms != null && !(filterSynonyms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The other names or aliases for the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterSynonyms} method.
     * </p>
     * 
     * @return The other names or aliases for the filter.
     */
    public final List<String> filterSynonyms() {
        return filterSynonyms;
    }

    /**
     * <p>
     * The name of the field that the filter operates on.
     * </p>
     * 
     * @return The name of the field that the filter operates on.
     */
    public final String operandFieldName() {
        return operandFieldName;
    }

    /**
     * <p>
     * The type of the filter. Valid values for this structure are <code>CATEGORY_FILTER</code>,
     * <code>NUMERIC_EQUALITY_FILTER</code>, <code>NUMERIC_RANGE_FILTER</code>, <code>DATE_RANGE_FILTER</code>, and
     * <code>RELATIVE_DATE_FILTER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterType} will
     * return {@link NamedFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterTypeAsString}.
     * </p>
     * 
     * @return The type of the filter. Valid values for this structure are <code>CATEGORY_FILTER</code>,
     *         <code>NUMERIC_EQUALITY_FILTER</code>, <code>NUMERIC_RANGE_FILTER</code>, <code>DATE_RANGE_FILTER</code>,
     *         and <code>RELATIVE_DATE_FILTER</code>.
     * @see NamedFilterType
     */
    public final NamedFilterType filterType() {
        return NamedFilterType.fromValue(filterType);
    }

    /**
     * <p>
     * The type of the filter. Valid values for this structure are <code>CATEGORY_FILTER</code>,
     * <code>NUMERIC_EQUALITY_FILTER</code>, <code>NUMERIC_RANGE_FILTER</code>, <code>DATE_RANGE_FILTER</code>, and
     * <code>RELATIVE_DATE_FILTER</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterType} will
     * return {@link NamedFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #filterTypeAsString}.
     * </p>
     * 
     * @return The type of the filter. Valid values for this structure are <code>CATEGORY_FILTER</code>,
     *         <code>NUMERIC_EQUALITY_FILTER</code>, <code>NUMERIC_RANGE_FILTER</code>, <code>DATE_RANGE_FILTER</code>,
     *         and <code>RELATIVE_DATE_FILTER</code>.
     * @see NamedFilterType
     */
    public final String filterTypeAsString() {
        return filterType;
    }

    /**
     * <p>
     * The category filter that is associated with this filter.
     * </p>
     * 
     * @return The category filter that is associated with this filter.
     */
    public final TopicCategoryFilter categoryFilter() {
        return categoryFilter;
    }

    /**
     * <p>
     * The numeric equality filter.
     * </p>
     * 
     * @return The numeric equality filter.
     */
    public final TopicNumericEqualityFilter numericEqualityFilter() {
        return numericEqualityFilter;
    }

    /**
     * <p>
     * The numeric range filter.
     * </p>
     * 
     * @return The numeric range filter.
     */
    public final TopicNumericRangeFilter numericRangeFilter() {
        return numericRangeFilter;
    }

    /**
     * <p>
     * The date range filter.
     * </p>
     * 
     * @return The date range filter.
     */
    public final TopicDateRangeFilter dateRangeFilter() {
        return dateRangeFilter;
    }

    /**
     * <p>
     * The relative date filter.
     * </p>
     * 
     * @return The relative date filter.
     */
    public final TopicRelativeDateFilter relativeDateFilter() {
        return relativeDateFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterDescription());
        hashCode = 31 * hashCode + Objects.hashCode(filterClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filterName());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterSynonyms() ? filterSynonyms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operandFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(filterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(categoryFilter());
        hashCode = 31 * hashCode + Objects.hashCode(numericEqualityFilter());
        hashCode = 31 * hashCode + Objects.hashCode(numericRangeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(dateRangeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(relativeDateFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicFilter)) {
            return false;
        }
        TopicFilter other = (TopicFilter) obj;
        return Objects.equals(filterDescription(), other.filterDescription())
                && Objects.equals(filterClassAsString(), other.filterClassAsString())
                && Objects.equals(filterName(), other.filterName()) && hasFilterSynonyms() == other.hasFilterSynonyms()
                && Objects.equals(filterSynonyms(), other.filterSynonyms())
                && Objects.equals(operandFieldName(), other.operandFieldName())
                && Objects.equals(filterTypeAsString(), other.filterTypeAsString())
                && Objects.equals(categoryFilter(), other.categoryFilter())
                && Objects.equals(numericEqualityFilter(), other.numericEqualityFilter())
                && Objects.equals(numericRangeFilter(), other.numericRangeFilter())
                && Objects.equals(dateRangeFilter(), other.dateRangeFilter())
                && Objects.equals(relativeDateFilter(), other.relativeDateFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicFilter").add("FilterDescription", filterDescription())
                .add("FilterClass", filterClassAsString()).add("FilterName", filterName())
                .add("FilterSynonyms", hasFilterSynonyms() ? filterSynonyms() : null).add("OperandFieldName", operandFieldName())
                .add("FilterType", filterTypeAsString()).add("CategoryFilter", categoryFilter())
                .add("NumericEqualityFilter", numericEqualityFilter()).add("NumericRangeFilter", numericRangeFilter())
                .add("DateRangeFilter", dateRangeFilter()).add("RelativeDateFilter", relativeDateFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterDescription":
            return Optional.ofNullable(clazz.cast(filterDescription()));
        case "FilterClass":
            return Optional.ofNullable(clazz.cast(filterClassAsString()));
        case "FilterName":
            return Optional.ofNullable(clazz.cast(filterName()));
        case "FilterSynonyms":
            return Optional.ofNullable(clazz.cast(filterSynonyms()));
        case "OperandFieldName":
            return Optional.ofNullable(clazz.cast(operandFieldName()));
        case "FilterType":
            return Optional.ofNullable(clazz.cast(filterTypeAsString()));
        case "CategoryFilter":
            return Optional.ofNullable(clazz.cast(categoryFilter()));
        case "NumericEqualityFilter":
            return Optional.ofNullable(clazz.cast(numericEqualityFilter()));
        case "NumericRangeFilter":
            return Optional.ofNullable(clazz.cast(numericRangeFilter()));
        case "DateRangeFilter":
            return Optional.ofNullable(clazz.cast(dateRangeFilter()));
        case "RelativeDateFilter":
            return Optional.ofNullable(clazz.cast(relativeDateFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FilterDescription", FILTER_DESCRIPTION_FIELD);
        map.put("FilterClass", FILTER_CLASS_FIELD);
        map.put("FilterName", FILTER_NAME_FIELD);
        map.put("FilterSynonyms", FILTER_SYNONYMS_FIELD);
        map.put("OperandFieldName", OPERAND_FIELD_NAME_FIELD);
        map.put("FilterType", FILTER_TYPE_FIELD);
        map.put("CategoryFilter", CATEGORY_FILTER_FIELD);
        map.put("NumericEqualityFilter", NUMERIC_EQUALITY_FILTER_FIELD);
        map.put("NumericRangeFilter", NUMERIC_RANGE_FILTER_FIELD);
        map.put("DateRangeFilter", DATE_RANGE_FILTER_FIELD);
        map.put("RelativeDateFilter", RELATIVE_DATE_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicFilter, T> g) {
        return obj -> g.apply((TopicFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicFilter> {
        /**
         * <p>
         * A description of the filter used to select items for a topic.
         * </p>
         * 
         * @param filterDescription
         *        A description of the filter used to select items for a topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterDescription(String filterDescription);

        /**
         * <p>
         * The class of the filter. Valid values for this structure are <code>ENFORCED_VALUE_FILTER</code>,
         * <code>CONDITIONAL_VALUE_FILTER</code>, and <code>NAMED_VALUE_FILTER</code>.
         * </p>
         * 
         * @param filterClass
         *        The class of the filter. Valid values for this structure are <code>ENFORCED_VALUE_FILTER</code>,
         *        <code>CONDITIONAL_VALUE_FILTER</code>, and <code>NAMED_VALUE_FILTER</code>.
         * @see FilterClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterClass
         */
        Builder filterClass(String filterClass);

        /**
         * <p>
         * The class of the filter. Valid values for this structure are <code>ENFORCED_VALUE_FILTER</code>,
         * <code>CONDITIONAL_VALUE_FILTER</code>, and <code>NAMED_VALUE_FILTER</code>.
         * </p>
         * 
         * @param filterClass
         *        The class of the filter. Valid values for this structure are <code>ENFORCED_VALUE_FILTER</code>,
         *        <code>CONDITIONAL_VALUE_FILTER</code>, and <code>NAMED_VALUE_FILTER</code>.
         * @see FilterClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterClass
         */
        Builder filterClass(FilterClass filterClass);

        /**
         * <p>
         * The name of the filter.
         * </p>
         * 
         * @param filterName
         *        The name of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterName(String filterName);

        /**
         * <p>
         * The other names or aliases for the filter.
         * </p>
         * 
         * @param filterSynonyms
         *        The other names or aliases for the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterSynonyms(Collection<String> filterSynonyms);

        /**
         * <p>
         * The other names or aliases for the filter.
         * </p>
         * 
         * @param filterSynonyms
         *        The other names or aliases for the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterSynonyms(String... filterSynonyms);

        /**
         * <p>
         * The name of the field that the filter operates on.
         * </p>
         * 
         * @param operandFieldName
         *        The name of the field that the filter operates on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operandFieldName(String operandFieldName);

        /**
         * <p>
         * The type of the filter. Valid values for this structure are <code>CATEGORY_FILTER</code>,
         * <code>NUMERIC_EQUALITY_FILTER</code>, <code>NUMERIC_RANGE_FILTER</code>, <code>DATE_RANGE_FILTER</code>, and
         * <code>RELATIVE_DATE_FILTER</code>.
         * </p>
         * 
         * @param filterType
         *        The type of the filter. Valid values for this structure are <code>CATEGORY_FILTER</code>,
         *        <code>NUMERIC_EQUALITY_FILTER</code>, <code>NUMERIC_RANGE_FILTER</code>,
         *        <code>DATE_RANGE_FILTER</code>, and <code>RELATIVE_DATE_FILTER</code>.
         * @see NamedFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamedFilterType
         */
        Builder filterType(String filterType);

        /**
         * <p>
         * The type of the filter. Valid values for this structure are <code>CATEGORY_FILTER</code>,
         * <code>NUMERIC_EQUALITY_FILTER</code>, <code>NUMERIC_RANGE_FILTER</code>, <code>DATE_RANGE_FILTER</code>, and
         * <code>RELATIVE_DATE_FILTER</code>.
         * </p>
         * 
         * @param filterType
         *        The type of the filter. Valid values for this structure are <code>CATEGORY_FILTER</code>,
         *        <code>NUMERIC_EQUALITY_FILTER</code>, <code>NUMERIC_RANGE_FILTER</code>,
         *        <code>DATE_RANGE_FILTER</code>, and <code>RELATIVE_DATE_FILTER</code>.
         * @see NamedFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamedFilterType
         */
        Builder filterType(NamedFilterType filterType);

        /**
         * <p>
         * The category filter that is associated with this filter.
         * </p>
         * 
         * @param categoryFilter
         *        The category filter that is associated with this filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryFilter(TopicCategoryFilter categoryFilter);

        /**
         * <p>
         * The category filter that is associated with this filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicCategoryFilter.Builder} avoiding the
         * need to create one manually via {@link TopicCategoryFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicCategoryFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #categoryFilter(TopicCategoryFilter)}.
         * 
         * @param categoryFilter
         *        a consumer that will call methods on {@link TopicCategoryFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoryFilter(TopicCategoryFilter)
         */
        default Builder categoryFilter(Consumer<TopicCategoryFilter.Builder> categoryFilter) {
            return categoryFilter(TopicCategoryFilter.builder().applyMutation(categoryFilter).build());
        }

        /**
         * <p>
         * The numeric equality filter.
         * </p>
         * 
         * @param numericEqualityFilter
         *        The numeric equality filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numericEqualityFilter(TopicNumericEqualityFilter numericEqualityFilter);

        /**
         * <p>
         * The numeric equality filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicNumericEqualityFilter.Builder}
         * avoiding the need to create one manually via {@link TopicNumericEqualityFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicNumericEqualityFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #numericEqualityFilter(TopicNumericEqualityFilter)}.
         * 
         * @param numericEqualityFilter
         *        a consumer that will call methods on {@link TopicNumericEqualityFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numericEqualityFilter(TopicNumericEqualityFilter)
         */
        default Builder numericEqualityFilter(Consumer<TopicNumericEqualityFilter.Builder> numericEqualityFilter) {
            return numericEqualityFilter(TopicNumericEqualityFilter.builder().applyMutation(numericEqualityFilter).build());
        }

        /**
         * <p>
         * The numeric range filter.
         * </p>
         * 
         * @param numericRangeFilter
         *        The numeric range filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numericRangeFilter(TopicNumericRangeFilter numericRangeFilter);

        /**
         * <p>
         * The numeric range filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicNumericRangeFilter.Builder} avoiding
         * the need to create one manually via {@link TopicNumericRangeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicNumericRangeFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #numericRangeFilter(TopicNumericRangeFilter)}.
         * 
         * @param numericRangeFilter
         *        a consumer that will call methods on {@link TopicNumericRangeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numericRangeFilter(TopicNumericRangeFilter)
         */
        default Builder numericRangeFilter(Consumer<TopicNumericRangeFilter.Builder> numericRangeFilter) {
            return numericRangeFilter(TopicNumericRangeFilter.builder().applyMutation(numericRangeFilter).build());
        }

        /**
         * <p>
         * The date range filter.
         * </p>
         * 
         * @param dateRangeFilter
         *        The date range filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateRangeFilter(TopicDateRangeFilter dateRangeFilter);

        /**
         * <p>
         * The date range filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicDateRangeFilter.Builder} avoiding
         * the need to create one manually via {@link TopicDateRangeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicDateRangeFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #dateRangeFilter(TopicDateRangeFilter)}.
         * 
         * @param dateRangeFilter
         *        a consumer that will call methods on {@link TopicDateRangeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateRangeFilter(TopicDateRangeFilter)
         */
        default Builder dateRangeFilter(Consumer<TopicDateRangeFilter.Builder> dateRangeFilter) {
            return dateRangeFilter(TopicDateRangeFilter.builder().applyMutation(dateRangeFilter).build());
        }

        /**
         * <p>
         * The relative date filter.
         * </p>
         * 
         * @param relativeDateFilter
         *        The relative date filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relativeDateFilter(TopicRelativeDateFilter relativeDateFilter);

        /**
         * <p>
         * The relative date filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicRelativeDateFilter.Builder} avoiding
         * the need to create one manually via {@link TopicRelativeDateFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicRelativeDateFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #relativeDateFilter(TopicRelativeDateFilter)}.
         * 
         * @param relativeDateFilter
         *        a consumer that will call methods on {@link TopicRelativeDateFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relativeDateFilter(TopicRelativeDateFilter)
         */
        default Builder relativeDateFilter(Consumer<TopicRelativeDateFilter.Builder> relativeDateFilter) {
            return relativeDateFilter(TopicRelativeDateFilter.builder().applyMutation(relativeDateFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String filterDescription;

        private String filterClass;

        private String filterName;

        private List<String> filterSynonyms = DefaultSdkAutoConstructList.getInstance();

        private String operandFieldName;

        private String filterType;

        private TopicCategoryFilter categoryFilter;

        private TopicNumericEqualityFilter numericEqualityFilter;

        private TopicNumericRangeFilter numericRangeFilter;

        private TopicDateRangeFilter dateRangeFilter;

        private TopicRelativeDateFilter relativeDateFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicFilter model) {
            filterDescription(model.filterDescription);
            filterClass(model.filterClass);
            filterName(model.filterName);
            filterSynonyms(model.filterSynonyms);
            operandFieldName(model.operandFieldName);
            filterType(model.filterType);
            categoryFilter(model.categoryFilter);
            numericEqualityFilter(model.numericEqualityFilter);
            numericRangeFilter(model.numericRangeFilter);
            dateRangeFilter(model.dateRangeFilter);
            relativeDateFilter(model.relativeDateFilter);
        }

        public final String getFilterDescription() {
            return filterDescription;
        }

        public final void setFilterDescription(String filterDescription) {
            this.filterDescription = filterDescription;
        }

        @Override
        public final Builder filterDescription(String filterDescription) {
            this.filterDescription = filterDescription;
            return this;
        }

        public final String getFilterClass() {
            return filterClass;
        }

        public final void setFilterClass(String filterClass) {
            this.filterClass = filterClass;
        }

        @Override
        public final Builder filterClass(String filterClass) {
            this.filterClass = filterClass;
            return this;
        }

        @Override
        public final Builder filterClass(FilterClass filterClass) {
            this.filterClass(filterClass == null ? null : filterClass.toString());
            return this;
        }

        public final String getFilterName() {
            return filterName;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final Collection<String> getFilterSynonyms() {
            if (filterSynonyms instanceof SdkAutoConstructList) {
                return null;
            }
            return filterSynonyms;
        }

        public final void setFilterSynonyms(Collection<String> filterSynonyms) {
            this.filterSynonyms = SynonymsCopier.copy(filterSynonyms);
        }

        @Override
        public final Builder filterSynonyms(Collection<String> filterSynonyms) {
            this.filterSynonyms = SynonymsCopier.copy(filterSynonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterSynonyms(String... filterSynonyms) {
            filterSynonyms(Arrays.asList(filterSynonyms));
            return this;
        }

        public final String getOperandFieldName() {
            return operandFieldName;
        }

        public final void setOperandFieldName(String operandFieldName) {
            this.operandFieldName = operandFieldName;
        }

        @Override
        public final Builder operandFieldName(String operandFieldName) {
            this.operandFieldName = operandFieldName;
            return this;
        }

        public final String getFilterType() {
            return filterType;
        }

        public final void setFilterType(String filterType) {
            this.filterType = filterType;
        }

        @Override
        public final Builder filterType(String filterType) {
            this.filterType = filterType;
            return this;
        }

        @Override
        public final Builder filterType(NamedFilterType filterType) {
            this.filterType(filterType == null ? null : filterType.toString());
            return this;
        }

        public final TopicCategoryFilter.Builder getCategoryFilter() {
            return categoryFilter != null ? categoryFilter.toBuilder() : null;
        }

        public final void setCategoryFilter(TopicCategoryFilter.BuilderImpl categoryFilter) {
            this.categoryFilter = categoryFilter != null ? categoryFilter.build() : null;
        }

        @Override
        public final Builder categoryFilter(TopicCategoryFilter categoryFilter) {
            this.categoryFilter = categoryFilter;
            return this;
        }

        public final TopicNumericEqualityFilter.Builder getNumericEqualityFilter() {
            return numericEqualityFilter != null ? numericEqualityFilter.toBuilder() : null;
        }

        public final void setNumericEqualityFilter(TopicNumericEqualityFilter.BuilderImpl numericEqualityFilter) {
            this.numericEqualityFilter = numericEqualityFilter != null ? numericEqualityFilter.build() : null;
        }

        @Override
        public final Builder numericEqualityFilter(TopicNumericEqualityFilter numericEqualityFilter) {
            this.numericEqualityFilter = numericEqualityFilter;
            return this;
        }

        public final TopicNumericRangeFilter.Builder getNumericRangeFilter() {
            return numericRangeFilter != null ? numericRangeFilter.toBuilder() : null;
        }

        public final void setNumericRangeFilter(TopicNumericRangeFilter.BuilderImpl numericRangeFilter) {
            this.numericRangeFilter = numericRangeFilter != null ? numericRangeFilter.build() : null;
        }

        @Override
        public final Builder numericRangeFilter(TopicNumericRangeFilter numericRangeFilter) {
            this.numericRangeFilter = numericRangeFilter;
            return this;
        }

        public final TopicDateRangeFilter.Builder getDateRangeFilter() {
            return dateRangeFilter != null ? dateRangeFilter.toBuilder() : null;
        }

        public final void setDateRangeFilter(TopicDateRangeFilter.BuilderImpl dateRangeFilter) {
            this.dateRangeFilter = dateRangeFilter != null ? dateRangeFilter.build() : null;
        }

        @Override
        public final Builder dateRangeFilter(TopicDateRangeFilter dateRangeFilter) {
            this.dateRangeFilter = dateRangeFilter;
            return this;
        }

        public final TopicRelativeDateFilter.Builder getRelativeDateFilter() {
            return relativeDateFilter != null ? relativeDateFilter.toBuilder() : null;
        }

        public final void setRelativeDateFilter(TopicRelativeDateFilter.BuilderImpl relativeDateFilter) {
            this.relativeDateFilter = relativeDateFilter != null ? relativeDateFilter.build() : null;
        }

        @Override
        public final Builder relativeDateFilter(TopicRelativeDateFilter relativeDateFilter) {
            this.relativeDateFilter = relativeDateFilter;
            return this;
        }

        @Override
        public TopicFilter build() {
            return new TopicFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
