/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition for a <code>TopicIRMetric</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicIRMetric implements SdkPojo, Serializable, ToCopyableBuilder<TopicIRMetric.Builder, TopicIRMetric> {
    private static final SdkField<Identifier> METRIC_ID_FIELD = SdkField.<Identifier> builder(MarshallingType.SDK_POJO)
            .memberName("MetricId").getter(getter(TopicIRMetric::metricId)).setter(setter(Builder::metricId))
            .constructor(Identifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricId").build()).build();

    private static final SdkField<AggFunction> FUNCTION_FIELD = SdkField.<AggFunction> builder(MarshallingType.SDK_POJO)
            .memberName("Function").getter(getter(TopicIRMetric::function)).setter(setter(Builder::function))
            .constructor(AggFunction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Function").build()).build();

    private static final SdkField<List<Identifier>> OPERANDS_FIELD = SdkField
            .<List<Identifier>> builder(MarshallingType.LIST)
            .memberName("Operands")
            .getter(getter(TopicIRMetric::operands))
            .setter(setter(Builder::operands))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operands").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Identifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(Identifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TopicIRComparisonMethod> COMPARISON_METHOD_FIELD = SdkField
            .<TopicIRComparisonMethod> builder(MarshallingType.SDK_POJO).memberName("ComparisonMethod")
            .getter(getter(TopicIRMetric::comparisonMethod)).setter(setter(Builder::comparisonMethod))
            .constructor(TopicIRComparisonMethod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonMethod").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expression").getter(getter(TopicIRMetric::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<List<Identifier>> CALCULATED_FIELD_REFERENCES_FIELD = SdkField
            .<List<Identifier>> builder(MarshallingType.LIST)
            .memberName("CalculatedFieldReferences")
            .getter(getter(TopicIRMetric::calculatedFieldReferences))
            .setter(setter(Builder::calculatedFieldReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedFieldReferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Identifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(Identifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DISPLAY_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayFormat").getter(getter(TopicIRMetric::displayFormatAsString))
            .setter(setter(Builder::displayFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayFormat").build()).build();

    private static final SdkField<DisplayFormatOptions> DISPLAY_FORMAT_OPTIONS_FIELD = SdkField
            .<DisplayFormatOptions> builder(MarshallingType.SDK_POJO).memberName("DisplayFormatOptions")
            .getter(getter(TopicIRMetric::displayFormatOptions)).setter(setter(Builder::displayFormatOptions))
            .constructor(DisplayFormatOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayFormatOptions").build())
            .build();

    private static final SdkField<NamedEntityRef> NAMED_ENTITY_FIELD = SdkField
            .<NamedEntityRef> builder(MarshallingType.SDK_POJO).memberName("NamedEntity")
            .getter(getter(TopicIRMetric::namedEntity)).setter(setter(Builder::namedEntity)).constructor(NamedEntityRef::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamedEntity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_ID_FIELD,
            FUNCTION_FIELD, OPERANDS_FIELD, COMPARISON_METHOD_FIELD, EXPRESSION_FIELD, CALCULATED_FIELD_REFERENCES_FIELD,
            DISPLAY_FORMAT_FIELD, DISPLAY_FORMAT_OPTIONS_FIELD, NAMED_ENTITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Identifier metricId;

    private final AggFunction function;

    private final List<Identifier> operands;

    private final TopicIRComparisonMethod comparisonMethod;

    private final String expression;

    private final List<Identifier> calculatedFieldReferences;

    private final String displayFormat;

    private final DisplayFormatOptions displayFormatOptions;

    private final NamedEntityRef namedEntity;

    private TopicIRMetric(BuilderImpl builder) {
        this.metricId = builder.metricId;
        this.function = builder.function;
        this.operands = builder.operands;
        this.comparisonMethod = builder.comparisonMethod;
        this.expression = builder.expression;
        this.calculatedFieldReferences = builder.calculatedFieldReferences;
        this.displayFormat = builder.displayFormat;
        this.displayFormatOptions = builder.displayFormatOptions;
        this.namedEntity = builder.namedEntity;
    }

    /**
     * <p>
     * The metric ID for the <code>TopicIRMetric</code>.
     * </p>
     * 
     * @return The metric ID for the <code>TopicIRMetric</code>.
     */
    public final Identifier metricId() {
        return metricId;
    }

    /**
     * <p>
     * The function for the <code>TopicIRMetric</code>.
     * </p>
     * 
     * @return The function for the <code>TopicIRMetric</code>.
     */
    public final AggFunction function() {
        return function;
    }

    /**
     * For responses, this returns true if the service returned a value for the Operands property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOperands() {
        return operands != null && !(operands instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The operands for the <code>TopicIRMetric</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperands} method.
     * </p>
     * 
     * @return The operands for the <code>TopicIRMetric</code>.
     */
    public final List<Identifier> operands() {
        return operands;
    }

    /**
     * <p>
     * The comparison method for the <code>TopicIRMetric</code>.
     * </p>
     * 
     * @return The comparison method for the <code>TopicIRMetric</code>.
     */
    public final TopicIRComparisonMethod comparisonMethod() {
        return comparisonMethod;
    }

    /**
     * <p>
     * The expression for the <code>TopicIRMetric</code>.
     * </p>
     * 
     * @return The expression for the <code>TopicIRMetric</code>.
     */
    public final String expression() {
        return expression;
    }

    /**
     * For responses, this returns true if the service returned a value for the CalculatedFieldReferences property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCalculatedFieldReferences() {
        return calculatedFieldReferences != null && !(calculatedFieldReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The calculated field references for the <code>TopicIRMetric</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCalculatedFieldReferences} method.
     * </p>
     * 
     * @return The calculated field references for the <code>TopicIRMetric</code>.
     */
    public final List<Identifier> calculatedFieldReferences() {
        return calculatedFieldReferences;
    }

    /**
     * <p>
     * The display format for the <code>TopicIRMetric</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #displayFormat}
     * will return {@link DisplayFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #displayFormatAsString}.
     * </p>
     * 
     * @return The display format for the <code>TopicIRMetric</code>.
     * @see DisplayFormat
     */
    public final DisplayFormat displayFormat() {
        return DisplayFormat.fromValue(displayFormat);
    }

    /**
     * <p>
     * The display format for the <code>TopicIRMetric</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #displayFormat}
     * will return {@link DisplayFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #displayFormatAsString}.
     * </p>
     * 
     * @return The display format for the <code>TopicIRMetric</code>.
     * @see DisplayFormat
     */
    public final String displayFormatAsString() {
        return displayFormat;
    }

    /**
     * Returns the value of the DisplayFormatOptions property for this object.
     * 
     * @return The value of the DisplayFormatOptions property for this object.
     */
    public final DisplayFormatOptions displayFormatOptions() {
        return displayFormatOptions;
    }

    /**
     * <p>
     * The named entity for the <code>TopicIRMetric</code>.
     * </p>
     * 
     * @return The named entity for the <code>TopicIRMetric</code>.
     */
    public final NamedEntityRef namedEntity() {
        return namedEntity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricId());
        hashCode = 31 * hashCode + Objects.hashCode(function());
        hashCode = 31 * hashCode + Objects.hashCode(hasOperands() ? operands() : null);
        hashCode = 31 * hashCode + Objects.hashCode(comparisonMethod());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(hasCalculatedFieldReferences() ? calculatedFieldReferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(displayFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayFormatOptions());
        hashCode = 31 * hashCode + Objects.hashCode(namedEntity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicIRMetric)) {
            return false;
        }
        TopicIRMetric other = (TopicIRMetric) obj;
        return Objects.equals(metricId(), other.metricId()) && Objects.equals(function(), other.function())
                && hasOperands() == other.hasOperands() && Objects.equals(operands(), other.operands())
                && Objects.equals(comparisonMethod(), other.comparisonMethod())
                && Objects.equals(expression(), other.expression())
                && hasCalculatedFieldReferences() == other.hasCalculatedFieldReferences()
                && Objects.equals(calculatedFieldReferences(), other.calculatedFieldReferences())
                && Objects.equals(displayFormatAsString(), other.displayFormatAsString())
                && Objects.equals(displayFormatOptions(), other.displayFormatOptions())
                && Objects.equals(namedEntity(), other.namedEntity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicIRMetric").add("MetricId", metricId()).add("Function", function())
                .add("Operands", hasOperands() ? operands() : null).add("ComparisonMethod", comparisonMethod())
                .add("Expression", expression() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CalculatedFieldReferences", hasCalculatedFieldReferences() ? calculatedFieldReferences() : null)
                .add("DisplayFormat", displayFormatAsString()).add("DisplayFormatOptions", displayFormatOptions())
                .add("NamedEntity", namedEntity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricId":
            return Optional.ofNullable(clazz.cast(metricId()));
        case "Function":
            return Optional.ofNullable(clazz.cast(function()));
        case "Operands":
            return Optional.ofNullable(clazz.cast(operands()));
        case "ComparisonMethod":
            return Optional.ofNullable(clazz.cast(comparisonMethod()));
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "CalculatedFieldReferences":
            return Optional.ofNullable(clazz.cast(calculatedFieldReferences()));
        case "DisplayFormat":
            return Optional.ofNullable(clazz.cast(displayFormatAsString()));
        case "DisplayFormatOptions":
            return Optional.ofNullable(clazz.cast(displayFormatOptions()));
        case "NamedEntity":
            return Optional.ofNullable(clazz.cast(namedEntity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetricId", METRIC_ID_FIELD);
        map.put("Function", FUNCTION_FIELD);
        map.put("Operands", OPERANDS_FIELD);
        map.put("ComparisonMethod", COMPARISON_METHOD_FIELD);
        map.put("Expression", EXPRESSION_FIELD);
        map.put("CalculatedFieldReferences", CALCULATED_FIELD_REFERENCES_FIELD);
        map.put("DisplayFormat", DISPLAY_FORMAT_FIELD);
        map.put("DisplayFormatOptions", DISPLAY_FORMAT_OPTIONS_FIELD);
        map.put("NamedEntity", NAMED_ENTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicIRMetric, T> g) {
        return obj -> g.apply((TopicIRMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicIRMetric> {
        /**
         * <p>
         * The metric ID for the <code>TopicIRMetric</code>.
         * </p>
         * 
         * @param metricId
         *        The metric ID for the <code>TopicIRMetric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricId(Identifier metricId);

        /**
         * <p>
         * The metric ID for the <code>TopicIRMetric</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Identifier.Builder} avoiding the need to
         * create one manually via {@link Identifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Identifier.Builder#build()} is called immediately and its result
         * is passed to {@link #metricId(Identifier)}.
         * 
         * @param metricId
         *        a consumer that will call methods on {@link Identifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricId(Identifier)
         */
        default Builder metricId(Consumer<Identifier.Builder> metricId) {
            return metricId(Identifier.builder().applyMutation(metricId).build());
        }

        /**
         * <p>
         * The function for the <code>TopicIRMetric</code>.
         * </p>
         * 
         * @param function
         *        The function for the <code>TopicIRMetric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder function(AggFunction function);

        /**
         * <p>
         * The function for the <code>TopicIRMetric</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AggFunction.Builder} avoiding the need to
         * create one manually via {@link AggFunction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggFunction.Builder#build()} is called immediately and its result
         * is passed to {@link #function(AggFunction)}.
         * 
         * @param function
         *        a consumer that will call methods on {@link AggFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #function(AggFunction)
         */
        default Builder function(Consumer<AggFunction.Builder> function) {
            return function(AggFunction.builder().applyMutation(function).build());
        }

        /**
         * <p>
         * The operands for the <code>TopicIRMetric</code>.
         * </p>
         * 
         * @param operands
         *        The operands for the <code>TopicIRMetric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operands(Collection<Identifier> operands);

        /**
         * <p>
         * The operands for the <code>TopicIRMetric</code>.
         * </p>
         * 
         * @param operands
         *        The operands for the <code>TopicIRMetric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operands(Identifier... operands);

        /**
         * <p>
         * The operands for the <code>TopicIRMetric</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.Identifier.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.Identifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.Identifier.Builder#build()} is called immediately and
         * its result is passed to {@link #operands(List<Identifier>)}.
         * 
         * @param operands
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.Identifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operands(java.util.Collection<Identifier>)
         */
        Builder operands(Consumer<Identifier.Builder>... operands);

        /**
         * <p>
         * The comparison method for the <code>TopicIRMetric</code>.
         * </p>
         * 
         * @param comparisonMethod
         *        The comparison method for the <code>TopicIRMetric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparisonMethod(TopicIRComparisonMethod comparisonMethod);

        /**
         * <p>
         * The comparison method for the <code>TopicIRMetric</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicIRComparisonMethod.Builder} avoiding
         * the need to create one manually via {@link TopicIRComparisonMethod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicIRComparisonMethod.Builder#build()} is called immediately
         * and its result is passed to {@link #comparisonMethod(TopicIRComparisonMethod)}.
         * 
         * @param comparisonMethod
         *        a consumer that will call methods on {@link TopicIRComparisonMethod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comparisonMethod(TopicIRComparisonMethod)
         */
        default Builder comparisonMethod(Consumer<TopicIRComparisonMethod.Builder> comparisonMethod) {
            return comparisonMethod(TopicIRComparisonMethod.builder().applyMutation(comparisonMethod).build());
        }

        /**
         * <p>
         * The expression for the <code>TopicIRMetric</code>.
         * </p>
         * 
         * @param expression
         *        The expression for the <code>TopicIRMetric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * The calculated field references for the <code>TopicIRMetric</code>.
         * </p>
         * 
         * @param calculatedFieldReferences
         *        The calculated field references for the <code>TopicIRMetric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedFieldReferences(Collection<Identifier> calculatedFieldReferences);

        /**
         * <p>
         * The calculated field references for the <code>TopicIRMetric</code>.
         * </p>
         * 
         * @param calculatedFieldReferences
         *        The calculated field references for the <code>TopicIRMetric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedFieldReferences(Identifier... calculatedFieldReferences);

        /**
         * <p>
         * The calculated field references for the <code>TopicIRMetric</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.Identifier.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.Identifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.Identifier.Builder#build()} is called immediately and
         * its result is passed to {@link #calculatedFieldReferences(List<Identifier>)}.
         * 
         * @param calculatedFieldReferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.Identifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #calculatedFieldReferences(java.util.Collection<Identifier>)
         */
        Builder calculatedFieldReferences(Consumer<Identifier.Builder>... calculatedFieldReferences);

        /**
         * <p>
         * The display format for the <code>TopicIRMetric</code>.
         * </p>
         * 
         * @param displayFormat
         *        The display format for the <code>TopicIRMetric</code>.
         * @see DisplayFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DisplayFormat
         */
        Builder displayFormat(String displayFormat);

        /**
         * <p>
         * The display format for the <code>TopicIRMetric</code>.
         * </p>
         * 
         * @param displayFormat
         *        The display format for the <code>TopicIRMetric</code>.
         * @see DisplayFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DisplayFormat
         */
        Builder displayFormat(DisplayFormat displayFormat);

        /**
         * Sets the value of the DisplayFormatOptions property for this object.
         *
         * @param displayFormatOptions
         *        The new value for the DisplayFormatOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayFormatOptions(DisplayFormatOptions displayFormatOptions);

        /**
         * Sets the value of the DisplayFormatOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DisplayFormatOptions.Builder} avoiding
         * the need to create one manually via {@link DisplayFormatOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DisplayFormatOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #displayFormatOptions(DisplayFormatOptions)}.
         * 
         * @param displayFormatOptions
         *        a consumer that will call methods on {@link DisplayFormatOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayFormatOptions(DisplayFormatOptions)
         */
        default Builder displayFormatOptions(Consumer<DisplayFormatOptions.Builder> displayFormatOptions) {
            return displayFormatOptions(DisplayFormatOptions.builder().applyMutation(displayFormatOptions).build());
        }

        /**
         * <p>
         * The named entity for the <code>TopicIRMetric</code>.
         * </p>
         * 
         * @param namedEntity
         *        The named entity for the <code>TopicIRMetric</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namedEntity(NamedEntityRef namedEntity);

        /**
         * <p>
         * The named entity for the <code>TopicIRMetric</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link NamedEntityRef.Builder} avoiding the need
         * to create one manually via {@link NamedEntityRef#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NamedEntityRef.Builder#build()} is called immediately and its
         * result is passed to {@link #namedEntity(NamedEntityRef)}.
         * 
         * @param namedEntity
         *        a consumer that will call methods on {@link NamedEntityRef.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #namedEntity(NamedEntityRef)
         */
        default Builder namedEntity(Consumer<NamedEntityRef.Builder> namedEntity) {
            return namedEntity(NamedEntityRef.builder().applyMutation(namedEntity).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Identifier metricId;

        private AggFunction function;

        private List<Identifier> operands = DefaultSdkAutoConstructList.getInstance();

        private TopicIRComparisonMethod comparisonMethod;

        private String expression;

        private List<Identifier> calculatedFieldReferences = DefaultSdkAutoConstructList.getInstance();

        private String displayFormat;

        private DisplayFormatOptions displayFormatOptions;

        private NamedEntityRef namedEntity;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicIRMetric model) {
            metricId(model.metricId);
            function(model.function);
            operands(model.operands);
            comparisonMethod(model.comparisonMethod);
            expression(model.expression);
            calculatedFieldReferences(model.calculatedFieldReferences);
            displayFormat(model.displayFormat);
            displayFormatOptions(model.displayFormatOptions);
            namedEntity(model.namedEntity);
        }

        public final Identifier.Builder getMetricId() {
            return metricId != null ? metricId.toBuilder() : null;
        }

        public final void setMetricId(Identifier.BuilderImpl metricId) {
            this.metricId = metricId != null ? metricId.build() : null;
        }

        @Override
        public final Builder metricId(Identifier metricId) {
            this.metricId = metricId;
            return this;
        }

        public final AggFunction.Builder getFunction() {
            return function != null ? function.toBuilder() : null;
        }

        public final void setFunction(AggFunction.BuilderImpl function) {
            this.function = function != null ? function.build() : null;
        }

        @Override
        public final Builder function(AggFunction function) {
            this.function = function;
            return this;
        }

        public final List<Identifier.Builder> getOperands() {
            List<Identifier.Builder> result = OperandListCopier.copyToBuilder(this.operands);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperands(Collection<Identifier.BuilderImpl> operands) {
            this.operands = OperandListCopier.copyFromBuilder(operands);
        }

        @Override
        public final Builder operands(Collection<Identifier> operands) {
            this.operands = OperandListCopier.copy(operands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operands(Identifier... operands) {
            operands(Arrays.asList(operands));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operands(Consumer<Identifier.Builder>... operands) {
            operands(Stream.of(operands).map(c -> Identifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final TopicIRComparisonMethod.Builder getComparisonMethod() {
            return comparisonMethod != null ? comparisonMethod.toBuilder() : null;
        }

        public final void setComparisonMethod(TopicIRComparisonMethod.BuilderImpl comparisonMethod) {
            this.comparisonMethod = comparisonMethod != null ? comparisonMethod.build() : null;
        }

        @Override
        public final Builder comparisonMethod(TopicIRComparisonMethod comparisonMethod) {
            this.comparisonMethod = comparisonMethod;
            return this;
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final List<Identifier.Builder> getCalculatedFieldReferences() {
            List<Identifier.Builder> result = CalculatedFieldReferenceListCopier.copyToBuilder(this.calculatedFieldReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCalculatedFieldReferences(Collection<Identifier.BuilderImpl> calculatedFieldReferences) {
            this.calculatedFieldReferences = CalculatedFieldReferenceListCopier.copyFromBuilder(calculatedFieldReferences);
        }

        @Override
        public final Builder calculatedFieldReferences(Collection<Identifier> calculatedFieldReferences) {
            this.calculatedFieldReferences = CalculatedFieldReferenceListCopier.copy(calculatedFieldReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedFieldReferences(Identifier... calculatedFieldReferences) {
            calculatedFieldReferences(Arrays.asList(calculatedFieldReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedFieldReferences(Consumer<Identifier.Builder>... calculatedFieldReferences) {
            calculatedFieldReferences(Stream.of(calculatedFieldReferences)
                    .map(c -> Identifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDisplayFormat() {
            return displayFormat;
        }

        public final void setDisplayFormat(String displayFormat) {
            this.displayFormat = displayFormat;
        }

        @Override
        public final Builder displayFormat(String displayFormat) {
            this.displayFormat = displayFormat;
            return this;
        }

        @Override
        public final Builder displayFormat(DisplayFormat displayFormat) {
            this.displayFormat(displayFormat == null ? null : displayFormat.toString());
            return this;
        }

        public final DisplayFormatOptions.Builder getDisplayFormatOptions() {
            return displayFormatOptions != null ? displayFormatOptions.toBuilder() : null;
        }

        public final void setDisplayFormatOptions(DisplayFormatOptions.BuilderImpl displayFormatOptions) {
            this.displayFormatOptions = displayFormatOptions != null ? displayFormatOptions.build() : null;
        }

        @Override
        public final Builder displayFormatOptions(DisplayFormatOptions displayFormatOptions) {
            this.displayFormatOptions = displayFormatOptions;
            return this;
        }

        public final NamedEntityRef.Builder getNamedEntity() {
            return namedEntity != null ? namedEntity.toBuilder() : null;
        }

        public final void setNamedEntity(NamedEntityRef.BuilderImpl namedEntity) {
            this.namedEntity = namedEntity != null ? namedEntity.build() : null;
        }

        @Override
        public final Builder namedEntity(NamedEntityRef namedEntity) {
            this.namedEntity = namedEntity;
            return this;
        }

        @Override
        public TopicIRMetric build() {
            return new TopicIRMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
