/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The unaggregated field for a table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnaggregatedField implements SdkPojo, Serializable,
        ToCopyableBuilder<UnaggregatedField.Builder, UnaggregatedField> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldId").getter(getter(UnaggregatedField::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()).build();

    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.<ColumnIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("Column").getter(getter(UnaggregatedField::column)).setter(setter(Builder::column))
            .constructor(ColumnIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()).build();

    private static final SdkField<FormatConfiguration> FORMAT_CONFIGURATION_FIELD = SdkField
            .<FormatConfiguration> builder(MarshallingType.SDK_POJO).memberName("FormatConfiguration")
            .getter(getter(UnaggregatedField::formatConfiguration)).setter(setter(Builder::formatConfiguration))
            .constructor(FormatConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD, COLUMN_FIELD,
            FORMAT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldId;

    private final ColumnIdentifier column;

    private final FormatConfiguration formatConfiguration;

    private UnaggregatedField(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.column = builder.column;
        this.formatConfiguration = builder.formatConfiguration;
    }

    /**
     * <p>
     * The custom field ID.
     * </p>
     * 
     * @return The custom field ID.
     */
    public final String fieldId() {
        return fieldId;
    }

    /**
     * <p>
     * The column that is used in the <code>UnaggregatedField</code>.
     * </p>
     * 
     * @return The column that is used in the <code>UnaggregatedField</code>.
     */
    public final ColumnIdentifier column() {
        return column;
    }

    /**
     * <p>
     * The format configuration of the field.
     * </p>
     * 
     * @return The format configuration of the field.
     */
    public final FormatConfiguration formatConfiguration() {
        return formatConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(column());
        hashCode = 31 * hashCode + Objects.hashCode(formatConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnaggregatedField)) {
            return false;
        }
        UnaggregatedField other = (UnaggregatedField) obj;
        return Objects.equals(fieldId(), other.fieldId()) && Objects.equals(column(), other.column())
                && Objects.equals(formatConfiguration(), other.formatConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnaggregatedField").add("FieldId", fieldId()).add("Column", column())
                .add("FormatConfiguration", formatConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        case "Column":
            return Optional.ofNullable(clazz.cast(column()));
        case "FormatConfiguration":
            return Optional.ofNullable(clazz.cast(formatConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldId", FIELD_ID_FIELD);
        map.put("Column", COLUMN_FIELD);
        map.put("FormatConfiguration", FORMAT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnaggregatedField, T> g) {
        return obj -> g.apply((UnaggregatedField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnaggregatedField> {
        /**
         * <p>
         * The custom field ID.
         * </p>
         * 
         * @param fieldId
         *        The custom field ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(String fieldId);

        /**
         * <p>
         * The column that is used in the <code>UnaggregatedField</code>.
         * </p>
         * 
         * @param column
         *        The column that is used in the <code>UnaggregatedField</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder column(ColumnIdentifier column);

        /**
         * <p>
         * The column that is used in the <code>UnaggregatedField</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnIdentifier.Builder} avoiding the
         * need to create one manually via {@link ColumnIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #column(ColumnIdentifier)}.
         * 
         * @param column
         *        a consumer that will call methods on {@link ColumnIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #column(ColumnIdentifier)
         */
        default Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return column(ColumnIdentifier.builder().applyMutation(column).build());
        }

        /**
         * <p>
         * The format configuration of the field.
         * </p>
         * 
         * @param formatConfiguration
         *        The format configuration of the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatConfiguration(FormatConfiguration formatConfiguration);

        /**
         * <p>
         * The format configuration of the field.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormatConfiguration.Builder} avoiding the
         * need to create one manually via {@link FormatConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormatConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #formatConfiguration(FormatConfiguration)}.
         * 
         * @param formatConfiguration
         *        a consumer that will call methods on {@link FormatConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #formatConfiguration(FormatConfiguration)
         */
        default Builder formatConfiguration(Consumer<FormatConfiguration.Builder> formatConfiguration) {
            return formatConfiguration(FormatConfiguration.builder().applyMutation(formatConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fieldId;

        private ColumnIdentifier column;

        private FormatConfiguration formatConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UnaggregatedField model) {
            fieldId(model.fieldId);
            column(model.column);
            formatConfiguration(model.formatConfiguration);
        }

        public final String getFieldId() {
            return fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumn() {
            return column != null ? column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final FormatConfiguration.Builder getFormatConfiguration() {
            return formatConfiguration != null ? formatConfiguration.toBuilder() : null;
        }

        public final void setFormatConfiguration(FormatConfiguration.BuilderImpl formatConfiguration) {
            this.formatConfiguration = formatConfiguration != null ? formatConfiguration.build() : null;
        }

        @Override
        public final Builder formatConfiguration(FormatConfiguration formatConfiguration) {
            this.formatConfiguration = formatConfiguration;
            return this;
        }

        @Override
        public UnaggregatedField build() {
            return new UnaggregatedField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
