/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccountCustomizationResponse extends QuickSightResponse implements
        ToCopyableBuilder<UpdateAccountCustomizationResponse.Builder, UpdateAccountCustomizationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateAccountCustomizationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateAccountCustomizationResponse::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(UpdateAccountCustomizationResponse::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespace").build()).build();

    private static final SdkField<AccountCustomization> ACCOUNT_CUSTOMIZATION_FIELD = SdkField
            .<AccountCustomization> builder(MarshallingType.SDK_POJO).memberName("AccountCustomization")
            .getter(getter(UpdateAccountCustomizationResponse::accountCustomization))
            .setter(setter(Builder::accountCustomization)).constructor(AccountCustomization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountCustomization").build())
            .build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(UpdateAccountCustomizationResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(UpdateAccountCustomizationResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            AWS_ACCOUNT_ID_FIELD, NAMESPACE_FIELD, ACCOUNT_CUSTOMIZATION_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String awsAccountId;

    private final String namespace;

    private final AccountCustomization accountCustomization;

    private final String requestId;

    private final Integer status;

    private UpdateAccountCustomizationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.awsAccountId = builder.awsAccountId;
        this.namespace = builder.namespace;
        this.accountCustomization = builder.accountCustomization;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the updated customization for this Amazon Web Services account.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the updated customization for this Amazon Web Services account.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations for.
     * </p>
     * 
     * @return The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations for.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The namespace associated with the customization that you're updating.
     * </p>
     * 
     * @return The namespace associated with the customization that you're updating.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The Amazon QuickSight customizations you're updating in the current Amazon Web Services Region.
     * </p>
     * 
     * @return The Amazon QuickSight customizations you're updating in the current Amazon Web Services Region.
     */
    public final AccountCustomization accountCustomization() {
        return accountCustomization;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(accountCustomization());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountCustomizationResponse)) {
            return false;
        }
        UpdateAccountCustomizationResponse other = (UpdateAccountCustomizationResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(namespace(), other.namespace())
                && Objects.equals(accountCustomization(), other.accountCustomization())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccountCustomizationResponse").add("Arn", arn()).add("AwsAccountId", awsAccountId())
                .add("Namespace", namespace()).add("AccountCustomization", accountCustomization()).add("RequestId", requestId())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "AccountCustomization":
            return Optional.ofNullable(clazz.cast(accountCustomization()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("AccountCustomization", ACCOUNT_CUSTOMIZATION_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountCustomizationResponse, T> g) {
        return obj -> g.apply((UpdateAccountCustomizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAccountCustomizationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the updated customization for this Amazon Web Services account.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the updated customization for this Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations for.
         * </p>
         * 
         * @param awsAccountId
         *        The ID for the Amazon Web Services account that you want to update Amazon QuickSight customizations
         *        for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The namespace associated with the customization that you're updating.
         * </p>
         * 
         * @param namespace
         *        The namespace associated with the customization that you're updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The Amazon QuickSight customizations you're updating in the current Amazon Web Services Region.
         * </p>
         * 
         * @param accountCustomization
         *        The Amazon QuickSight customizations you're updating in the current Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountCustomization(AccountCustomization accountCustomization);

        /**
         * <p>
         * The Amazon QuickSight customizations you're updating in the current Amazon Web Services Region.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountCustomization.Builder} avoiding
         * the need to create one manually via {@link AccountCustomization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountCustomization.Builder#build()} is called immediately and
         * its result is passed to {@link #accountCustomization(AccountCustomization)}.
         * 
         * @param accountCustomization
         *        a consumer that will call methods on {@link AccountCustomization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountCustomization(AccountCustomization)
         */
        default Builder accountCustomization(Consumer<AccountCustomization.Builder> accountCustomization) {
            return accountCustomization(AccountCustomization.builder().applyMutation(accountCustomization).build());
        }

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String arn;

        private String awsAccountId;

        private String namespace;

        private AccountCustomization accountCustomization;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountCustomizationResponse model) {
            super(model);
            arn(model.arn);
            awsAccountId(model.awsAccountId);
            namespace(model.namespace);
            accountCustomization(model.accountCustomization);
            requestId(model.requestId);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final AccountCustomization.Builder getAccountCustomization() {
            return accountCustomization != null ? accountCustomization.toBuilder() : null;
        }

        public final void setAccountCustomization(AccountCustomization.BuilderImpl accountCustomization) {
            this.accountCustomization = accountCustomization != null ? accountCustomization.build() : null;
        }

        @Override
        public final Builder accountCustomization(AccountCustomization accountCustomization) {
            this.accountCustomization = accountCustomization;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public UpdateAccountCustomizationResponse build() {
            return new UpdateAccountCustomizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
