/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines what initiates a highlight operation on a visual, such as a click or hover.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VisualHighlightOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<VisualHighlightOperation.Builder, VisualHighlightOperation> {
    private static final SdkField<String> TRIGGER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Trigger")
            .getter(getter(VisualHighlightOperation::triggerAsString)).setter(setter(Builder::trigger))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trigger").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIGGER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String trigger;

    private VisualHighlightOperation(BuilderImpl builder) {
        this.trigger = builder.trigger;
    }

    /**
     * <p>
     * Specifies whether a highlight operation is initiated by a click or hover, or whether it's disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trigger} will
     * return {@link VisualHighlightTrigger#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #triggerAsString}.
     * </p>
     * 
     * @return Specifies whether a highlight operation is initiated by a click or hover, or whether it's disabled.
     * @see VisualHighlightTrigger
     */
    public final VisualHighlightTrigger trigger() {
        return VisualHighlightTrigger.fromValue(trigger);
    }

    /**
     * <p>
     * Specifies whether a highlight operation is initiated by a click or hover, or whether it's disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trigger} will
     * return {@link VisualHighlightTrigger#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #triggerAsString}.
     * </p>
     * 
     * @return Specifies whether a highlight operation is initiated by a click or hover, or whether it's disabled.
     * @see VisualHighlightTrigger
     */
    public final String triggerAsString() {
        return trigger;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(triggerAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisualHighlightOperation)) {
            return false;
        }
        VisualHighlightOperation other = (VisualHighlightOperation) obj;
        return Objects.equals(triggerAsString(), other.triggerAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VisualHighlightOperation").add("Trigger", triggerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Trigger":
            return Optional.ofNullable(clazz.cast(triggerAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Trigger", TRIGGER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VisualHighlightOperation, T> g) {
        return obj -> g.apply((VisualHighlightOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VisualHighlightOperation> {
        /**
         * <p>
         * Specifies whether a highlight operation is initiated by a click or hover, or whether it's disabled.
         * </p>
         * 
         * @param trigger
         *        Specifies whether a highlight operation is initiated by a click or hover, or whether it's disabled.
         * @see VisualHighlightTrigger
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisualHighlightTrigger
         */
        Builder trigger(String trigger);

        /**
         * <p>
         * Specifies whether a highlight operation is initiated by a click or hover, or whether it's disabled.
         * </p>
         * 
         * @param trigger
         *        Specifies whether a highlight operation is initiated by a click or hover, or whether it's disabled.
         * @see VisualHighlightTrigger
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisualHighlightTrigger
         */
        Builder trigger(VisualHighlightTrigger trigger);
    }

    static final class BuilderImpl implements Builder {
        private String trigger;

        private BuilderImpl() {
        }

        private BuilderImpl(VisualHighlightOperation model) {
            trigger(model.trigger);
        }

        public final String getTrigger() {
            return trigger;
        }

        public final void setTrigger(String trigger) {
            this.trigger = trigger;
        }

        @Override
        public final Builder trigger(String trigger) {
            this.trigger = trigger;
            return this;
        }

        @Override
        public final Builder trigger(VisualHighlightTrigger trigger) {
            this.trigger(trigger == null ? null : trigger.toString());
            return this;
        }

        @Override
        public VisualHighlightOperation build() {
            return new VisualHighlightOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
