/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.BrandStatus;
import software.amazon.awssdk.services.quicksight.model.BrandVersionStatus;
import software.amazon.awssdk.services.quicksight.model.ErrorListCopier;
import software.amazon.awssdk.services.quicksight.model.Logo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BrandDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BrandDetail> {
    private static final SdkField<String> BRAND_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrandId").getter(BrandDetail.getter(BrandDetail::brandId)).setter(BrandDetail.setter(Builder::brandId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(BrandDetail.getter(BrandDetail::arn)).setter(BrandDetail.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> BRAND_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrandStatus").getter(BrandDetail.getter(BrandDetail::brandStatusAsString)).setter(BrandDetail.setter(Builder::brandStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandStatus").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(BrandDetail.getter(BrandDetail::createdTime)).setter(BrandDetail.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(BrandDetail.getter(BrandDetail::lastUpdatedTime)).setter(BrandDetail.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionId").getter(BrandDetail.getter(BrandDetail::versionId)).setter(BrandDetail.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()}).build();
    private static final SdkField<String> VERSION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionStatus").getter(BrandDetail.getter(BrandDetail::versionStatusAsString)).setter(BrandDetail.setter(Builder::versionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionStatus").build()}).build();
    private static final SdkField<List<String>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BrandDetail.getter(BrandDetail::errors)).setter(BrandDetail.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Logo> LOGO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Logo").getter(BrandDetail.getter(BrandDetail::logo)).setter(BrandDetail.setter(Builder::logo)).constructor(Logo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRAND_ID_FIELD, ARN_FIELD, BRAND_STATUS_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, VERSION_ID_FIELD, VERSION_STATUS_FIELD, ERRORS_FIELD, LOGO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BrandDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String brandId;
    private final String arn;
    private final String brandStatus;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;
    private final String versionId;
    private final String versionStatus;
    private final List<String> errors;
    private final Logo logo;

    private BrandDetail(BuilderImpl builder) {
        this.brandId = builder.brandId;
        this.arn = builder.arn;
        this.brandStatus = builder.brandStatus;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.versionId = builder.versionId;
        this.versionStatus = builder.versionStatus;
        this.errors = builder.errors;
        this.logo = builder.logo;
    }

    public final String brandId() {
        return this.brandId;
    }

    public final String arn() {
        return this.arn;
    }

    public final BrandStatus brandStatus() {
        return BrandStatus.fromValue(this.brandStatus);
    }

    public final String brandStatusAsString() {
        return this.brandStatus;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String versionId() {
        return this.versionId;
    }

    public final BrandVersionStatus versionStatus() {
        return BrandVersionStatus.fromValue(this.versionStatus);
    }

    public final String versionStatusAsString() {
        return this.versionStatus;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<String> errors() {
        return this.errors;
    }

    public final Logo logo() {
        return this.logo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brandId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.brandStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrandDetail)) {
            return false;
        }
        BrandDetail other = (BrandDetail)obj;
        return Objects.equals(this.brandId(), other.brandId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.brandStatusAsString(), other.brandStatusAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.versionStatusAsString(), other.versionStatusAsString()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && Objects.equals(this.logo(), other.logo());
    }

    public final String toString() {
        return ToString.builder((String)"BrandDetail").add("BrandId", (Object)this.brandId()).add("Arn", (Object)this.arn()).add("BrandStatus", (Object)this.brandStatusAsString()).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("VersionId", (Object)this.versionId()).add("VersionStatus", (Object)this.versionStatusAsString()).add("Errors", this.hasErrors() ? this.errors() : null).add("Logo", (Object)this.logo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrandId": {
                return Optional.ofNullable(clazz.cast(this.brandId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "BrandStatus": {
                return Optional.ofNullable(clazz.cast(this.brandStatusAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
            case "VersionStatus": {
                return Optional.ofNullable(clazz.cast(this.versionStatusAsString()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "Logo": {
                return Optional.ofNullable(clazz.cast(this.logo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BrandId", BRAND_ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("BrandStatus", BRAND_STATUS_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("VersionId", VERSION_ID_FIELD);
        map.put("VersionStatus", VERSION_STATUS_FIELD);
        map.put("Errors", ERRORS_FIELD);
        map.put("Logo", LOGO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrandDetail, T> g) {
        return obj -> g.apply((BrandDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String brandId;
        private String arn;
        private String brandStatus;
        private Instant createdTime;
        private Instant lastUpdatedTime;
        private String versionId;
        private String versionStatus;
        private List<String> errors = DefaultSdkAutoConstructList.getInstance();
        private Logo logo;

        private BuilderImpl() {
        }

        private BuilderImpl(BrandDetail model) {
            this.brandId(model.brandId);
            this.arn(model.arn);
            this.brandStatus(model.brandStatus);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.versionId(model.versionId);
            this.versionStatus(model.versionStatus);
            this.errors(model.errors);
            this.logo(model.logo);
        }

        public final String getBrandId() {
            return this.brandId;
        }

        public final void setBrandId(String brandId) {
            this.brandId = brandId;
        }

        @Override
        public final Builder brandId(String brandId) {
            this.brandId = brandId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getBrandStatus() {
            return this.brandStatus;
        }

        public final void setBrandStatus(String brandStatus) {
            this.brandStatus = brandStatus;
        }

        @Override
        public final Builder brandStatus(String brandStatus) {
            this.brandStatus = brandStatus;
            return this;
        }

        @Override
        public final Builder brandStatus(BrandStatus brandStatus) {
            this.brandStatus(brandStatus == null ? null : brandStatus.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final String getVersionStatus() {
            return this.versionStatus;
        }

        public final void setVersionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
        }

        @Override
        public final Builder versionStatus(String versionStatus) {
            this.versionStatus = versionStatus;
            return this;
        }

        @Override
        public final Builder versionStatus(BrandVersionStatus versionStatus) {
            this.versionStatus(versionStatus == null ? null : versionStatus.toString());
            return this;
        }

        public final Collection<String> getErrors() {
            if (this.errors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.errors;
        }

        public final void setErrors(Collection<String> errors) {
            this.errors = ErrorListCopier.copy(errors);
        }

        @Override
        public final Builder errors(Collection<String> errors) {
            this.errors = ErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(String ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        public final Logo.Builder getLogo() {
            return this.logo != null ? this.logo.toBuilder() : null;
        }

        public final void setLogo(Logo.BuilderImpl logo) {
            this.logo = logo != null ? logo.build() : null;
        }

        @Override
        public final Builder logo(Logo logo) {
            this.logo = logo;
            return this;
        }

        public BrandDetail build() {
            return new BrandDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BrandDetail> {
        public Builder brandId(String var1);

        public Builder arn(String var1);

        public Builder brandStatus(String var1);

        public Builder brandStatus(BrandStatus var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder versionId(String var1);

        public Builder versionStatus(String var1);

        public Builder versionStatus(BrandVersionStatus var1);

        public Builder errors(Collection<String> var1);

        public Builder errors(String ... var1);

        public Builder logo(Logo var1);

        default public Builder logo(Consumer<Logo.Builder> logo) {
            return this.logo((Logo)((Logo.Builder)Logo.builder().applyMutation(logo)).build());
        }
    }
}

