/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.FieldBasedTooltip;
import software.amazon.awssdk.services.quicksight.model.SelectedTooltipType;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TooltipOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TooltipOptions> {
    private static final SdkField<String> TOOLTIP_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TooltipVisibility").getter(TooltipOptions.getter(TooltipOptions::tooltipVisibilityAsString)).setter(TooltipOptions.setter(Builder::tooltipVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TooltipVisibility").build()}).build();
    private static final SdkField<String> SELECTED_TOOLTIP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectedTooltipType").getter(TooltipOptions.getter(TooltipOptions::selectedTooltipTypeAsString)).setter(TooltipOptions.setter(Builder::selectedTooltipType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedTooltipType").build()}).build();
    private static final SdkField<FieldBasedTooltip> FIELD_BASED_TOOLTIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldBasedTooltip").getter(TooltipOptions.getter(TooltipOptions::fieldBasedTooltip)).setter(TooltipOptions.setter(Builder::fieldBasedTooltip)).constructor(FieldBasedTooltip::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldBasedTooltip").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOOLTIP_VISIBILITY_FIELD, SELECTED_TOOLTIP_TYPE_FIELD, FIELD_BASED_TOOLTIP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TooltipOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tooltipVisibility;
    private final String selectedTooltipType;
    private final FieldBasedTooltip fieldBasedTooltip;

    private TooltipOptions(BuilderImpl builder) {
        this.tooltipVisibility = builder.tooltipVisibility;
        this.selectedTooltipType = builder.selectedTooltipType;
        this.fieldBasedTooltip = builder.fieldBasedTooltip;
    }

    public final Visibility tooltipVisibility() {
        return Visibility.fromValue(this.tooltipVisibility);
    }

    public final String tooltipVisibilityAsString() {
        return this.tooltipVisibility;
    }

    public final SelectedTooltipType selectedTooltipType() {
        return SelectedTooltipType.fromValue(this.selectedTooltipType);
    }

    public final String selectedTooltipTypeAsString() {
        return this.selectedTooltipType;
    }

    public final FieldBasedTooltip fieldBasedTooltip() {
        return this.fieldBasedTooltip;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tooltipVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectedTooltipTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldBasedTooltip());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TooltipOptions)) {
            return false;
        }
        TooltipOptions other = (TooltipOptions)obj;
        return Objects.equals(this.tooltipVisibilityAsString(), other.tooltipVisibilityAsString()) && Objects.equals(this.selectedTooltipTypeAsString(), other.selectedTooltipTypeAsString()) && Objects.equals(this.fieldBasedTooltip(), other.fieldBasedTooltip());
    }

    public final String toString() {
        return ToString.builder((String)"TooltipOptions").add("TooltipVisibility", (Object)this.tooltipVisibilityAsString()).add("SelectedTooltipType", (Object)this.selectedTooltipTypeAsString()).add("FieldBasedTooltip", (Object)this.fieldBasedTooltip()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TooltipVisibility": {
                return Optional.ofNullable(clazz.cast(this.tooltipVisibilityAsString()));
            }
            case "SelectedTooltipType": {
                return Optional.ofNullable(clazz.cast(this.selectedTooltipTypeAsString()));
            }
            case "FieldBasedTooltip": {
                return Optional.ofNullable(clazz.cast(this.fieldBasedTooltip()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TooltipVisibility", TOOLTIP_VISIBILITY_FIELD);
        map.put("SelectedTooltipType", SELECTED_TOOLTIP_TYPE_FIELD);
        map.put("FieldBasedTooltip", FIELD_BASED_TOOLTIP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TooltipOptions, T> g) {
        return obj -> g.apply((TooltipOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tooltipVisibility;
        private String selectedTooltipType;
        private FieldBasedTooltip fieldBasedTooltip;

        private BuilderImpl() {
        }

        private BuilderImpl(TooltipOptions model) {
            this.tooltipVisibility(model.tooltipVisibility);
            this.selectedTooltipType(model.selectedTooltipType);
            this.fieldBasedTooltip(model.fieldBasedTooltip);
        }

        public final String getTooltipVisibility() {
            return this.tooltipVisibility;
        }

        public final void setTooltipVisibility(String tooltipVisibility) {
            this.tooltipVisibility = tooltipVisibility;
        }

        @Override
        public final Builder tooltipVisibility(String tooltipVisibility) {
            this.tooltipVisibility = tooltipVisibility;
            return this;
        }

        @Override
        public final Builder tooltipVisibility(Visibility tooltipVisibility) {
            this.tooltipVisibility(tooltipVisibility == null ? null : tooltipVisibility.toString());
            return this;
        }

        public final String getSelectedTooltipType() {
            return this.selectedTooltipType;
        }

        public final void setSelectedTooltipType(String selectedTooltipType) {
            this.selectedTooltipType = selectedTooltipType;
        }

        @Override
        public final Builder selectedTooltipType(String selectedTooltipType) {
            this.selectedTooltipType = selectedTooltipType;
            return this;
        }

        @Override
        public final Builder selectedTooltipType(SelectedTooltipType selectedTooltipType) {
            this.selectedTooltipType(selectedTooltipType == null ? null : selectedTooltipType.toString());
            return this;
        }

        public final FieldBasedTooltip.Builder getFieldBasedTooltip() {
            return this.fieldBasedTooltip != null ? this.fieldBasedTooltip.toBuilder() : null;
        }

        public final void setFieldBasedTooltip(FieldBasedTooltip.BuilderImpl fieldBasedTooltip) {
            this.fieldBasedTooltip = fieldBasedTooltip != null ? fieldBasedTooltip.build() : null;
        }

        @Override
        public final Builder fieldBasedTooltip(FieldBasedTooltip fieldBasedTooltip) {
            this.fieldBasedTooltip = fieldBasedTooltip;
            return this;
        }

        public TooltipOptions build() {
            return new TooltipOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TooltipOptions> {
        public Builder tooltipVisibility(String var1);

        public Builder tooltipVisibility(Visibility var1);

        public Builder selectedTooltipType(String var1);

        public Builder selectedTooltipType(SelectedTooltipType var1);

        public Builder fieldBasedTooltip(FieldBasedTooltip var1);

        default public Builder fieldBasedTooltip(Consumer<FieldBasedTooltip.Builder> fieldBasedTooltip) {
            return this.fieldBasedTooltip((FieldBasedTooltip)((FieldBasedTooltip.Builder)FieldBasedTooltip.builder().applyMutation(fieldBasedTooltip)).build());
        }
    }
}

