/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ForecastScenario;
import software.amazon.awssdk.services.quicksight.model.TimeBasedForecastProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ForecastConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ForecastConfiguration> {
    private static final SdkField<TimeBasedForecastProperties> FORECAST_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ForecastProperties").getter(ForecastConfiguration.getter(ForecastConfiguration::forecastProperties)).setter(ForecastConfiguration.setter(Builder::forecastProperties)).constructor(TimeBasedForecastProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastProperties").build()}).build();
    private static final SdkField<ForecastScenario> SCENARIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Scenario").getter(ForecastConfiguration.getter(ForecastConfiguration::scenario)).setter(ForecastConfiguration.setter(Builder::scenario)).constructor(ForecastScenario::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scenario").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_PROPERTIES_FIELD, SCENARIO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ForecastConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TimeBasedForecastProperties forecastProperties;
    private final ForecastScenario scenario;

    private ForecastConfiguration(BuilderImpl builder) {
        this.forecastProperties = builder.forecastProperties;
        this.scenario = builder.scenario;
    }

    public final TimeBasedForecastProperties forecastProperties() {
        return this.forecastProperties;
    }

    public final ForecastScenario scenario() {
        return this.scenario;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.scenario());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForecastConfiguration)) {
            return false;
        }
        ForecastConfiguration other = (ForecastConfiguration)obj;
        return Objects.equals(this.forecastProperties(), other.forecastProperties()) && Objects.equals(this.scenario(), other.scenario());
    }

    public final String toString() {
        return ToString.builder((String)"ForecastConfiguration").add("ForecastProperties", (Object)this.forecastProperties()).add("Scenario", (Object)this.scenario()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ForecastProperties": {
                return Optional.ofNullable(clazz.cast(this.forecastProperties()));
            }
            case "Scenario": {
                return Optional.ofNullable(clazz.cast(this.scenario()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ForecastProperties", FORECAST_PROPERTIES_FIELD);
        map.put("Scenario", SCENARIO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ForecastConfiguration, T> g) {
        return obj -> g.apply((ForecastConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TimeBasedForecastProperties forecastProperties;
        private ForecastScenario scenario;

        private BuilderImpl() {
        }

        private BuilderImpl(ForecastConfiguration model) {
            this.forecastProperties(model.forecastProperties);
            this.scenario(model.scenario);
        }

        public final TimeBasedForecastProperties.Builder getForecastProperties() {
            return this.forecastProperties != null ? this.forecastProperties.toBuilder() : null;
        }

        public final void setForecastProperties(TimeBasedForecastProperties.BuilderImpl forecastProperties) {
            this.forecastProperties = forecastProperties != null ? forecastProperties.build() : null;
        }

        @Override
        public final Builder forecastProperties(TimeBasedForecastProperties forecastProperties) {
            this.forecastProperties = forecastProperties;
            return this;
        }

        public final ForecastScenario.Builder getScenario() {
            return this.scenario != null ? this.scenario.toBuilder() : null;
        }

        public final void setScenario(ForecastScenario.BuilderImpl scenario) {
            this.scenario = scenario != null ? scenario.build() : null;
        }

        @Override
        public final Builder scenario(ForecastScenario scenario) {
            this.scenario = scenario;
            return this;
        }

        public ForecastConfiguration build() {
            return new ForecastConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ForecastConfiguration> {
        public Builder forecastProperties(TimeBasedForecastProperties var1);

        default public Builder forecastProperties(Consumer<TimeBasedForecastProperties.Builder> forecastProperties) {
            return this.forecastProperties((TimeBasedForecastProperties)((TimeBasedForecastProperties.Builder)TimeBasedForecastProperties.builder().applyMutation(forecastProperties)).build());
        }

        public Builder scenario(ForecastScenario var1);

        default public Builder scenario(Consumer<ForecastScenario.Builder> scenario) {
            return this.scenario((ForecastScenario)((ForecastScenario.Builder)ForecastScenario.builder().applyMutation(scenario)).build());
        }
    }
}

