/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.SheetControlSliderType;
import software.amazon.awssdk.services.quicksight.model.SliderControlDisplayOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterSliderControl
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterSliderControl> {
    private static final SdkField<String> FILTER_CONTROL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterControlId").getter(FilterSliderControl.getter(FilterSliderControl::filterControlId)).setter(FilterSliderControl.setter(Builder::filterControlId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterControlId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(FilterSliderControl.getter(FilterSliderControl::title)).setter(FilterSliderControl.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> SOURCE_FILTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceFilterId").getter(FilterSliderControl.getter(FilterSliderControl::sourceFilterId)).setter(FilterSliderControl.setter(Builder::sourceFilterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFilterId").build()}).build();
    private static final SdkField<SliderControlDisplayOptions> DISPLAY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisplayOptions").getter(FilterSliderControl.getter(FilterSliderControl::displayOptions)).setter(FilterSliderControl.setter(Builder::displayOptions)).constructor(SliderControlDisplayOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOptions").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(FilterSliderControl.getter(FilterSliderControl::typeAsString)).setter(FilterSliderControl.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Double> MAXIMUM_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaximumValue").getter(FilterSliderControl.getter(FilterSliderControl::maximumValue)).setter(FilterSliderControl.setter(Builder::maximumValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumValue").build()}).build();
    private static final SdkField<Double> MINIMUM_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MinimumValue").getter(FilterSliderControl.getter(FilterSliderControl::minimumValue)).setter(FilterSliderControl.setter(Builder::minimumValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumValue").build()}).build();
    private static final SdkField<Double> STEP_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("StepSize").getter(FilterSliderControl.getter(FilterSliderControl::stepSize)).setter(FilterSliderControl.setter(Builder::stepSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CONTROL_ID_FIELD, TITLE_FIELD, SOURCE_FILTER_ID_FIELD, DISPLAY_OPTIONS_FIELD, TYPE_FIELD, MAXIMUM_VALUE_FIELD, MINIMUM_VALUE_FIELD, STEP_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FilterSliderControl.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String filterControlId;
    private final String title;
    private final String sourceFilterId;
    private final SliderControlDisplayOptions displayOptions;
    private final String type;
    private final Double maximumValue;
    private final Double minimumValue;
    private final Double stepSize;

    private FilterSliderControl(BuilderImpl builder) {
        this.filterControlId = builder.filterControlId;
        this.title = builder.title;
        this.sourceFilterId = builder.sourceFilterId;
        this.displayOptions = builder.displayOptions;
        this.type = builder.type;
        this.maximumValue = builder.maximumValue;
        this.minimumValue = builder.minimumValue;
        this.stepSize = builder.stepSize;
    }

    public final String filterControlId() {
        return this.filterControlId;
    }

    public final String title() {
        return this.title;
    }

    public final String sourceFilterId() {
        return this.sourceFilterId;
    }

    public final SliderControlDisplayOptions displayOptions() {
        return this.displayOptions;
    }

    public final SheetControlSliderType type() {
        return SheetControlSliderType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Double maximumValue() {
        return this.maximumValue;
    }

    public final Double minimumValue() {
        return this.minimumValue;
    }

    public final Double stepSize() {
        return this.stepSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterControlId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterSliderControl)) {
            return false;
        }
        FilterSliderControl other = (FilterSliderControl)obj;
        return Objects.equals(this.filterControlId(), other.filterControlId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.sourceFilterId(), other.sourceFilterId()) && Objects.equals(this.displayOptions(), other.displayOptions()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.maximumValue(), other.maximumValue()) && Objects.equals(this.minimumValue(), other.minimumValue()) && Objects.equals(this.stepSize(), other.stepSize());
    }

    public final String toString() {
        return ToString.builder((String)"FilterSliderControl").add("FilterControlId", (Object)this.filterControlId()).add("Title", (Object)this.title()).add("SourceFilterId", (Object)this.sourceFilterId()).add("DisplayOptions", (Object)this.displayOptions()).add("Type", (Object)this.typeAsString()).add("MaximumValue", (Object)this.maximumValue()).add("MinimumValue", (Object)this.minimumValue()).add("StepSize", (Object)this.stepSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterControlId": {
                return Optional.ofNullable(clazz.cast(this.filterControlId()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "SourceFilterId": {
                return Optional.ofNullable(clazz.cast(this.sourceFilterId()));
            }
            case "DisplayOptions": {
                return Optional.ofNullable(clazz.cast(this.displayOptions()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "MaximumValue": {
                return Optional.ofNullable(clazz.cast(this.maximumValue()));
            }
            case "MinimumValue": {
                return Optional.ofNullable(clazz.cast(this.minimumValue()));
            }
            case "StepSize": {
                return Optional.ofNullable(clazz.cast(this.stepSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FilterControlId", FILTER_CONTROL_ID_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("SourceFilterId", SOURCE_FILTER_ID_FIELD);
        map.put("DisplayOptions", DISPLAY_OPTIONS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("MaximumValue", MAXIMUM_VALUE_FIELD);
        map.put("MinimumValue", MINIMUM_VALUE_FIELD);
        map.put("StepSize", STEP_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterSliderControl, T> g) {
        return obj -> g.apply((FilterSliderControl)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterControlId;
        private String title;
        private String sourceFilterId;
        private SliderControlDisplayOptions displayOptions;
        private String type;
        private Double maximumValue;
        private Double minimumValue;
        private Double stepSize;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterSliderControl model) {
            this.filterControlId(model.filterControlId);
            this.title(model.title);
            this.sourceFilterId(model.sourceFilterId);
            this.displayOptions(model.displayOptions);
            this.type(model.type);
            this.maximumValue(model.maximumValue);
            this.minimumValue(model.minimumValue);
            this.stepSize(model.stepSize);
        }

        public final String getFilterControlId() {
            return this.filterControlId;
        }

        public final void setFilterControlId(String filterControlId) {
            this.filterControlId = filterControlId;
        }

        @Override
        public final Builder filterControlId(String filterControlId) {
            this.filterControlId = filterControlId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSourceFilterId() {
            return this.sourceFilterId;
        }

        public final void setSourceFilterId(String sourceFilterId) {
            this.sourceFilterId = sourceFilterId;
        }

        @Override
        public final Builder sourceFilterId(String sourceFilterId) {
            this.sourceFilterId = sourceFilterId;
            return this;
        }

        public final SliderControlDisplayOptions.Builder getDisplayOptions() {
            return this.displayOptions != null ? this.displayOptions.toBuilder() : null;
        }

        public final void setDisplayOptions(SliderControlDisplayOptions.BuilderImpl displayOptions) {
            this.displayOptions = displayOptions != null ? displayOptions.build() : null;
        }

        @Override
        public final Builder displayOptions(SliderControlDisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SheetControlSliderType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Double getMaximumValue() {
            return this.maximumValue;
        }

        public final void setMaximumValue(Double maximumValue) {
            this.maximumValue = maximumValue;
        }

        @Override
        public final Builder maximumValue(Double maximumValue) {
            this.maximumValue = maximumValue;
            return this;
        }

        public final Double getMinimumValue() {
            return this.minimumValue;
        }

        public final void setMinimumValue(Double minimumValue) {
            this.minimumValue = minimumValue;
        }

        @Override
        public final Builder minimumValue(Double minimumValue) {
            this.minimumValue = minimumValue;
            return this;
        }

        public final Double getStepSize() {
            return this.stepSize;
        }

        public final void setStepSize(Double stepSize) {
            this.stepSize = stepSize;
        }

        @Override
        public final Builder stepSize(Double stepSize) {
            this.stepSize = stepSize;
            return this;
        }

        public FilterSliderControl build() {
            return new FilterSliderControl(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterSliderControl> {
        public Builder filterControlId(String var1);

        public Builder title(String var1);

        public Builder sourceFilterId(String var1);

        public Builder displayOptions(SliderControlDisplayOptions var1);

        default public Builder displayOptions(Consumer<SliderControlDisplayOptions.Builder> displayOptions) {
            return this.displayOptions((SliderControlDisplayOptions)((SliderControlDisplayOptions.Builder)SliderControlDisplayOptions.builder().applyMutation(displayOptions)).build());
        }

        public Builder type(String var1);

        public Builder type(SheetControlSliderType var1);

        public Builder maximumValue(Double var1);

        public Builder minimumValue(Double var1);

        public Builder stepSize(Double var1);
    }
}

