/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ShortFormatText;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VisualTitleLabelOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VisualTitleLabelOptions> {
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(VisualTitleLabelOptions.getter(VisualTitleLabelOptions::visibilityAsString)).setter(VisualTitleLabelOptions.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<ShortFormatText> FORMAT_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FormatText").getter(VisualTitleLabelOptions.getter(VisualTitleLabelOptions::formatText)).setter(VisualTitleLabelOptions.setter(Builder::formatText)).constructor(ShortFormatText::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatText").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISIBILITY_FIELD, FORMAT_TEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VisualTitleLabelOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String visibility;
    private final ShortFormatText formatText;

    private VisualTitleLabelOptions(BuilderImpl builder) {
        this.visibility = builder.visibility;
        this.formatText = builder.formatText;
    }

    public final Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final ShortFormatText formatText() {
        return this.formatText;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatText());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisualTitleLabelOptions)) {
            return false;
        }
        VisualTitleLabelOptions other = (VisualTitleLabelOptions)obj;
        return Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.formatText(), other.formatText());
    }

    public final String toString() {
        return ToString.builder((String)"VisualTitleLabelOptions").add("Visibility", (Object)this.visibilityAsString()).add("FormatText", (Object)this.formatText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "FormatText": {
                return Optional.ofNullable(clazz.cast(this.formatText()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("FormatText", FORMAT_TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VisualTitleLabelOptions, T> g) {
        return obj -> g.apply((VisualTitleLabelOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String visibility;
        private ShortFormatText formatText;

        private BuilderImpl() {
        }

        private BuilderImpl(VisualTitleLabelOptions model) {
            this.visibility(model.visibility);
            this.formatText(model.formatText);
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final ShortFormatText.Builder getFormatText() {
            return this.formatText != null ? this.formatText.toBuilder() : null;
        }

        public final void setFormatText(ShortFormatText.BuilderImpl formatText) {
            this.formatText = formatText != null ? formatText.build() : null;
        }

        @Override
        public final Builder formatText(ShortFormatText formatText) {
            this.formatText = formatText;
            return this;
        }

        public VisualTitleLabelOptions build() {
            return new VisualTitleLabelOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VisualTitleLabelOptions> {
        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);

        public Builder formatText(ShortFormatText var1);

        default public Builder formatText(Consumer<ShortFormatText.Builder> formatText) {
            return this.formatText((ShortFormatText)((ShortFormatText.Builder)ShortFormatText.builder().applyMutation(formatText)).build());
        }
    }
}

