/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ManifestFileLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Parameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Parameters> {
    private static final SdkField<ManifestFileLocation> MANIFEST_FILE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManifestFileLocation").getter(S3Parameters.getter(S3Parameters::manifestFileLocation)).setter(S3Parameters.setter(Builder::manifestFileLocation)).constructor(ManifestFileLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestFileLocation").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(S3Parameters.getter(S3Parameters::roleArn)).setter(S3Parameters.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_FILE_LOCATION_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3Parameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ManifestFileLocation manifestFileLocation;
    private final String roleArn;

    private S3Parameters(BuilderImpl builder) {
        this.manifestFileLocation = builder.manifestFileLocation;
        this.roleArn = builder.roleArn;
    }

    public final ManifestFileLocation manifestFileLocation() {
        return this.manifestFileLocation;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestFileLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Parameters)) {
            return false;
        }
        S3Parameters other = (S3Parameters)obj;
        return Objects.equals(this.manifestFileLocation(), other.manifestFileLocation()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"S3Parameters").add("ManifestFileLocation", (Object)this.manifestFileLocation()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManifestFileLocation": {
                return Optional.ofNullable(clazz.cast(this.manifestFileLocation()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ManifestFileLocation", MANIFEST_FILE_LOCATION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Parameters, T> g) {
        return obj -> g.apply((S3Parameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ManifestFileLocation manifestFileLocation;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Parameters model) {
            this.manifestFileLocation(model.manifestFileLocation);
            this.roleArn(model.roleArn);
        }

        public final ManifestFileLocation.Builder getManifestFileLocation() {
            return this.manifestFileLocation != null ? this.manifestFileLocation.toBuilder() : null;
        }

        public final void setManifestFileLocation(ManifestFileLocation.BuilderImpl manifestFileLocation) {
            this.manifestFileLocation = manifestFileLocation != null ? manifestFileLocation.build() : null;
        }

        @Override
        public final Builder manifestFileLocation(ManifestFileLocation manifestFileLocation) {
            this.manifestFileLocation = manifestFileLocation;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public S3Parameters build() {
            return new S3Parameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Parameters> {
        public Builder manifestFileLocation(ManifestFileLocation var1);

        default public Builder manifestFileLocation(Consumer<ManifestFileLocation.Builder> manifestFileLocation) {
            return this.manifestFileLocation((ManifestFileLocation)((ManifestFileLocation.Builder)ManifestFileLocation.builder().applyMutation(manifestFileLocation)).build());
        }

        public Builder roleArn(String var1);
    }
}

