/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSetReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSetReference> {
    private static final SdkField<String> DATA_SET_PLACEHOLDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetPlaceholder").getter(DataSetReference.getter(DataSetReference::dataSetPlaceholder)).setter(DataSetReference.setter(Builder::dataSetPlaceholder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetPlaceholder").build()}).build();
    private static final SdkField<String> DATA_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetArn").getter(DataSetReference.getter(DataSetReference::dataSetArn)).setter(DataSetReference.setter(Builder::dataSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_PLACEHOLDER_FIELD, DATA_SET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSetReference.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dataSetPlaceholder;
    private final String dataSetArn;

    private DataSetReference(BuilderImpl builder) {
        this.dataSetPlaceholder = builder.dataSetPlaceholder;
        this.dataSetArn = builder.dataSetArn;
    }

    public final String dataSetPlaceholder() {
        return this.dataSetPlaceholder;
    }

    public final String dataSetArn() {
        return this.dataSetArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetPlaceholder());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetReference)) {
            return false;
        }
        DataSetReference other = (DataSetReference)obj;
        return Objects.equals(this.dataSetPlaceholder(), other.dataSetPlaceholder()) && Objects.equals(this.dataSetArn(), other.dataSetArn());
    }

    public final String toString() {
        return ToString.builder((String)"DataSetReference").add("DataSetPlaceholder", (Object)this.dataSetPlaceholder()).add("DataSetArn", (Object)this.dataSetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSetPlaceholder": {
                return Optional.ofNullable(clazz.cast(this.dataSetPlaceholder()));
            }
            case "DataSetArn": {
                return Optional.ofNullable(clazz.cast(this.dataSetArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DataSetPlaceholder", DATA_SET_PLACEHOLDER_FIELD);
        map.put("DataSetArn", DATA_SET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSetReference, T> g) {
        return obj -> g.apply((DataSetReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSetPlaceholder;
        private String dataSetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetReference model) {
            this.dataSetPlaceholder(model.dataSetPlaceholder);
            this.dataSetArn(model.dataSetArn);
        }

        public final String getDataSetPlaceholder() {
            return this.dataSetPlaceholder;
        }

        public final void setDataSetPlaceholder(String dataSetPlaceholder) {
            this.dataSetPlaceholder = dataSetPlaceholder;
        }

        @Override
        public final Builder dataSetPlaceholder(String dataSetPlaceholder) {
            this.dataSetPlaceholder = dataSetPlaceholder;
            return this;
        }

        public final String getDataSetArn() {
            return this.dataSetArn;
        }

        public final void setDataSetArn(String dataSetArn) {
            this.dataSetArn = dataSetArn;
        }

        @Override
        public final Builder dataSetArn(String dataSetArn) {
            this.dataSetArn = dataSetArn;
            return this;
        }

        public DataSetReference build() {
            return new DataSetReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSetReference> {
        public Builder dataSetPlaceholder(String var1);

        public Builder dataSetArn(String var1);
    }
}

