/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGroupMembershipRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, DescribeGroupMembershipRequest> {
    private static final SdkField<String> MEMBER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberName").getter(DescribeGroupMembershipRequest.getter(DescribeGroupMembershipRequest::memberName)).setter(DescribeGroupMembershipRequest.setter(Builder::memberName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("MemberName").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(DescribeGroupMembershipRequest.getter(DescribeGroupMembershipRequest::groupName)).setter(DescribeGroupMembershipRequest.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("GroupName").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(DescribeGroupMembershipRequest.getter(DescribeGroupMembershipRequest::awsAccountId)).setter(DescribeGroupMembershipRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(DescribeGroupMembershipRequest.getter(DescribeGroupMembershipRequest::namespace)).setter(DescribeGroupMembershipRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Namespace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_NAME_FIELD, GROUP_NAME_FIELD, AWS_ACCOUNT_ID_FIELD, NAMESPACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeGroupMembershipRequest.memberNameToFieldInitializer();
    private final String memberName;
    private final String groupName;
    private final String awsAccountId;
    private final String namespace;

    private DescribeGroupMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.memberName = builder.memberName;
        this.groupName = builder.groupName;
        this.awsAccountId = builder.awsAccountId;
        this.namespace = builder.namespace;
    }

    public final String memberName() {
        return this.memberName;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String namespace() {
        return this.namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.memberName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGroupMembershipRequest)) {
            return false;
        }
        DescribeGroupMembershipRequest other = (DescribeGroupMembershipRequest)((Object)obj);
        return Objects.equals(this.memberName(), other.memberName()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.namespace(), other.namespace());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeGroupMembershipRequest").add("MemberName", (Object)this.memberName()).add("GroupName", (Object)this.groupName()).add("AwsAccountId", (Object)this.awsAccountId()).add("Namespace", (Object)this.namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MemberName": {
                return Optional.ofNullable(clazz.cast(this.memberName()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("MemberName", MEMBER_NAME_FIELD);
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGroupMembershipRequest, T> g) {
        return obj -> g.apply((DescribeGroupMembershipRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String memberName;
        private String groupName;
        private String awsAccountId;
        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGroupMembershipRequest model) {
            super(model);
            this.memberName(model.memberName);
            this.groupName(model.groupName);
            this.awsAccountId(model.awsAccountId);
            this.namespace(model.namespace);
        }

        public final String getMemberName() {
            return this.memberName;
        }

        public final void setMemberName(String memberName) {
            this.memberName = memberName;
        }

        @Override
        public final Builder memberName(String memberName) {
            this.memberName = memberName;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeGroupMembershipRequest build() {
            return new DescribeGroupMembershipRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGroupMembershipRequest> {
        public Builder memberName(String var1);

        public Builder groupName(String var1);

        public Builder awsAccountId(String var1);

        public Builder namespace(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

