/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.quicksight.internal.QuickSightServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.quicksight.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.quicksight.model.AccessDeniedException;
import software.amazon.awssdk.services.quicksight.model.BatchCreateTopicReviewedAnswerRequest;
import software.amazon.awssdk.services.quicksight.model.BatchCreateTopicReviewedAnswerResponse;
import software.amazon.awssdk.services.quicksight.model.BatchDeleteTopicReviewedAnswerRequest;
import software.amazon.awssdk.services.quicksight.model.BatchDeleteTopicReviewedAnswerResponse;
import software.amazon.awssdk.services.quicksight.model.CancelIngestionRequest;
import software.amazon.awssdk.services.quicksight.model.CancelIngestionResponse;
import software.amazon.awssdk.services.quicksight.model.ConcurrentUpdatingException;
import software.amazon.awssdk.services.quicksight.model.ConflictException;
import software.amazon.awssdk.services.quicksight.model.CreateAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.CreateAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.CreateAccountSubscriptionRequest;
import software.amazon.awssdk.services.quicksight.model.CreateAccountSubscriptionResponse;
import software.amazon.awssdk.services.quicksight.model.CreateActionConnectorRequest;
import software.amazon.awssdk.services.quicksight.model.CreateActionConnectorResponse;
import software.amazon.awssdk.services.quicksight.model.CreateAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.CreateAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.CreateBrandRequest;
import software.amazon.awssdk.services.quicksight.model.CreateBrandResponse;
import software.amazon.awssdk.services.quicksight.model.CreateCustomPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.CreateCustomPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.CreateDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.CreateDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.CreateDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.CreateDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.CreateFolderMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.CreateFolderMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.CreateFolderRequest;
import software.amazon.awssdk.services.quicksight.model.CreateFolderResponse;
import software.amazon.awssdk.services.quicksight.model.CreateGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.CreateGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.CreateGroupRequest;
import software.amazon.awssdk.services.quicksight.model.CreateGroupResponse;
import software.amazon.awssdk.services.quicksight.model.CreateIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.CreateIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.CreateIngestionRequest;
import software.amazon.awssdk.services.quicksight.model.CreateIngestionResponse;
import software.amazon.awssdk.services.quicksight.model.CreateNamespaceRequest;
import software.amazon.awssdk.services.quicksight.model.CreateNamespaceResponse;
import software.amazon.awssdk.services.quicksight.model.CreateRefreshScheduleRequest;
import software.amazon.awssdk.services.quicksight.model.CreateRefreshScheduleResponse;
import software.amazon.awssdk.services.quicksight.model.CreateRoleMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.CreateRoleMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.CreateThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.CreateThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.CreateThemeRequest;
import software.amazon.awssdk.services.quicksight.model.CreateThemeResponse;
import software.amazon.awssdk.services.quicksight.model.CreateTopicRefreshScheduleRequest;
import software.amazon.awssdk.services.quicksight.model.CreateTopicRefreshScheduleResponse;
import software.amazon.awssdk.services.quicksight.model.CreateTopicRequest;
import software.amazon.awssdk.services.quicksight.model.CreateTopicResponse;
import software.amazon.awssdk.services.quicksight.model.CreateVpcConnectionRequest;
import software.amazon.awssdk.services.quicksight.model.CreateVpcConnectionResponse;
import software.amazon.awssdk.services.quicksight.model.CustomerManagedKeyUnavailableException;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountCustomPermissionRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountCustomPermissionResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountSubscriptionRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountSubscriptionResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteActionConnectorRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteActionConnectorResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteBrandAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteBrandAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteBrandRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteBrandResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteCustomPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteCustomPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSetRefreshPropertiesRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSetRefreshPropertiesResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDefaultQBusinessApplicationRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDefaultQBusinessApplicationResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteFolderMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteFolderMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteFolderRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteFolderResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteIdentityPropagationConfigRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteIdentityPropagationConfigResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteRefreshScheduleRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteRefreshScheduleResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteRoleCustomPermissionRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteRoleCustomPermissionResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteRoleMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteRoleMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteTopicRefreshScheduleRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteTopicRefreshScheduleResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteTopicRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteTopicResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteUserByPrincipalIdRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteUserByPrincipalIdResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteUserCustomPermissionRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteUserCustomPermissionResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteUserRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteUserResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteVpcConnectionRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteVpcConnectionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountCustomPermissionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountCustomPermissionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountSettingsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountSettingsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountSubscriptionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountSubscriptionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeActionConnectorPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeActionConnectorPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeActionConnectorRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeActionConnectorResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisDefinitionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisDefinitionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAssetBundleExportJobRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAssetBundleExportJobResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAssetBundleImportJobRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAssetBundleImportJobResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeBrandAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeBrandAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeBrandPublishedVersionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeBrandPublishedVersionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeBrandRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeBrandResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeCustomPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeCustomPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardDefinitionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardDefinitionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardSnapshotJobRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardSnapshotJobResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardSnapshotJobResultRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardSnapshotJobResultResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardsQaConfigurationRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardsQaConfigurationResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetRefreshPropertiesRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetRefreshPropertiesResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourcePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourcePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDefaultQBusinessApplicationRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDefaultQBusinessApplicationResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderResolvedPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderResolvedPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeIngestionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeIngestionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeIpRestrictionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeIpRestrictionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeKeyRegistrationRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeKeyRegistrationResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeNamespaceRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeNamespaceResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeQPersonalizationConfigurationRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeQPersonalizationConfigurationResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeQuickSightQSearchConfigurationRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeQuickSightQSearchConfigurationResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeRefreshScheduleRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeRefreshScheduleResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeRoleCustomPermissionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeRoleCustomPermissionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateDefinitionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateDefinitionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplatePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplatePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeThemePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeThemePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTopicPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTopicPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTopicRefreshRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTopicRefreshResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTopicRefreshScheduleRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTopicRefreshScheduleResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTopicRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTopicResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeUserRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeUserResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeVpcConnectionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeVpcConnectionResponse;
import software.amazon.awssdk.services.quicksight.model.DomainNotWhitelistedException;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForAnonymousUserRequest;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForAnonymousUserResponse;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForRegisteredUserRequest;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForRegisteredUserResponse;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForRegisteredUserWithIdentityRequest;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForRegisteredUserWithIdentityResponse;
import software.amazon.awssdk.services.quicksight.model.GetDashboardEmbedUrlRequest;
import software.amazon.awssdk.services.quicksight.model.GetDashboardEmbedUrlResponse;
import software.amazon.awssdk.services.quicksight.model.GetFlowMetadataRequest;
import software.amazon.awssdk.services.quicksight.model.GetFlowMetadataResponse;
import software.amazon.awssdk.services.quicksight.model.GetFlowPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.GetFlowPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.GetSessionEmbedUrlRequest;
import software.amazon.awssdk.services.quicksight.model.GetSessionEmbedUrlResponse;
import software.amazon.awssdk.services.quicksight.model.IdentityTypeNotSupportedException;
import software.amazon.awssdk.services.quicksight.model.InternalFailureException;
import software.amazon.awssdk.services.quicksight.model.InternalServerException;
import software.amazon.awssdk.services.quicksight.model.InvalidDataSetParameterValueException;
import software.amazon.awssdk.services.quicksight.model.InvalidNextTokenException;
import software.amazon.awssdk.services.quicksight.model.InvalidParameterValueException;
import software.amazon.awssdk.services.quicksight.model.InvalidRequestException;
import software.amazon.awssdk.services.quicksight.model.LimitExceededException;
import software.amazon.awssdk.services.quicksight.model.ListActionConnectorsRequest;
import software.amazon.awssdk.services.quicksight.model.ListActionConnectorsResponse;
import software.amazon.awssdk.services.quicksight.model.ListAnalysesRequest;
import software.amazon.awssdk.services.quicksight.model.ListAnalysesResponse;
import software.amazon.awssdk.services.quicksight.model.ListAssetBundleExportJobsRequest;
import software.amazon.awssdk.services.quicksight.model.ListAssetBundleExportJobsResponse;
import software.amazon.awssdk.services.quicksight.model.ListAssetBundleImportJobsRequest;
import software.amazon.awssdk.services.quicksight.model.ListAssetBundleImportJobsResponse;
import software.amazon.awssdk.services.quicksight.model.ListBrandsRequest;
import software.amazon.awssdk.services.quicksight.model.ListBrandsResponse;
import software.amazon.awssdk.services.quicksight.model.ListCustomPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListCustomPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDashboardsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDashboardsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDataSetsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.quicksight.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.quicksight.model.ListFlowsRequest;
import software.amazon.awssdk.services.quicksight.model.ListFlowsResponse;
import software.amazon.awssdk.services.quicksight.model.ListFolderMembersRequest;
import software.amazon.awssdk.services.quicksight.model.ListFolderMembersResponse;
import software.amazon.awssdk.services.quicksight.model.ListFoldersForResourceRequest;
import software.amazon.awssdk.services.quicksight.model.ListFoldersForResourceResponse;
import software.amazon.awssdk.services.quicksight.model.ListFoldersRequest;
import software.amazon.awssdk.services.quicksight.model.ListFoldersResponse;
import software.amazon.awssdk.services.quicksight.model.ListGroupMembershipsRequest;
import software.amazon.awssdk.services.quicksight.model.ListGroupMembershipsResponse;
import software.amazon.awssdk.services.quicksight.model.ListGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsForUserRequest;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsForUserResponse;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsRequest;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsResponse;
import software.amazon.awssdk.services.quicksight.model.ListIdentityPropagationConfigsRequest;
import software.amazon.awssdk.services.quicksight.model.ListIdentityPropagationConfigsResponse;
import software.amazon.awssdk.services.quicksight.model.ListIngestionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListIngestionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListNamespacesRequest;
import software.amazon.awssdk.services.quicksight.model.ListNamespacesResponse;
import software.amazon.awssdk.services.quicksight.model.ListRefreshSchedulesRequest;
import software.amazon.awssdk.services.quicksight.model.ListRefreshSchedulesResponse;
import software.amazon.awssdk.services.quicksight.model.ListRoleMembershipsRequest;
import software.amazon.awssdk.services.quicksight.model.ListRoleMembershipsResponse;
import software.amazon.awssdk.services.quicksight.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.quicksight.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesResponse;
import software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListTemplatesRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplatesResponse;
import software.amazon.awssdk.services.quicksight.model.ListThemeAliasesRequest;
import software.amazon.awssdk.services.quicksight.model.ListThemeAliasesResponse;
import software.amazon.awssdk.services.quicksight.model.ListThemeVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListThemeVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListThemesRequest;
import software.amazon.awssdk.services.quicksight.model.ListThemesResponse;
import software.amazon.awssdk.services.quicksight.model.ListTopicRefreshSchedulesRequest;
import software.amazon.awssdk.services.quicksight.model.ListTopicRefreshSchedulesResponse;
import software.amazon.awssdk.services.quicksight.model.ListTopicReviewedAnswersRequest;
import software.amazon.awssdk.services.quicksight.model.ListTopicReviewedAnswersResponse;
import software.amazon.awssdk.services.quicksight.model.ListTopicsRequest;
import software.amazon.awssdk.services.quicksight.model.ListTopicsResponse;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.ListUsersRequest;
import software.amazon.awssdk.services.quicksight.model.ListUsersResponse;
import software.amazon.awssdk.services.quicksight.model.ListVpcConnectionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListVpcConnectionsResponse;
import software.amazon.awssdk.services.quicksight.model.PreconditionNotMetException;
import software.amazon.awssdk.services.quicksight.model.PredictQaResultsRequest;
import software.amazon.awssdk.services.quicksight.model.PredictQaResultsResponse;
import software.amazon.awssdk.services.quicksight.model.PutDataSetRefreshPropertiesRequest;
import software.amazon.awssdk.services.quicksight.model.PutDataSetRefreshPropertiesResponse;
import software.amazon.awssdk.services.quicksight.model.QuickSightException;
import software.amazon.awssdk.services.quicksight.model.QuickSightUserNotFoundException;
import software.amazon.awssdk.services.quicksight.model.RegisterUserRequest;
import software.amazon.awssdk.services.quicksight.model.RegisterUserResponse;
import software.amazon.awssdk.services.quicksight.model.ResourceExistsException;
import software.amazon.awssdk.services.quicksight.model.ResourceNotFoundException;
import software.amazon.awssdk.services.quicksight.model.ResourceUnavailableException;
import software.amazon.awssdk.services.quicksight.model.RestoreAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.RestoreAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.SearchActionConnectorsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchActionConnectorsResponse;
import software.amazon.awssdk.services.quicksight.model.SearchAnalysesRequest;
import software.amazon.awssdk.services.quicksight.model.SearchAnalysesResponse;
import software.amazon.awssdk.services.quicksight.model.SearchDashboardsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchDashboardsResponse;
import software.amazon.awssdk.services.quicksight.model.SearchDataSetsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchDataSetsResponse;
import software.amazon.awssdk.services.quicksight.model.SearchDataSourcesRequest;
import software.amazon.awssdk.services.quicksight.model.SearchDataSourcesResponse;
import software.amazon.awssdk.services.quicksight.model.SearchFlowsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchFlowsResponse;
import software.amazon.awssdk.services.quicksight.model.SearchFoldersRequest;
import software.amazon.awssdk.services.quicksight.model.SearchFoldersResponse;
import software.amazon.awssdk.services.quicksight.model.SearchGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.SearchTopicsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchTopicsResponse;
import software.amazon.awssdk.services.quicksight.model.SessionLifetimeInMinutesInvalidException;
import software.amazon.awssdk.services.quicksight.model.StartAssetBundleExportJobRequest;
import software.amazon.awssdk.services.quicksight.model.StartAssetBundleExportJobResponse;
import software.amazon.awssdk.services.quicksight.model.StartAssetBundleImportJobRequest;
import software.amazon.awssdk.services.quicksight.model.StartAssetBundleImportJobResponse;
import software.amazon.awssdk.services.quicksight.model.StartDashboardSnapshotJobRequest;
import software.amazon.awssdk.services.quicksight.model.StartDashboardSnapshotJobResponse;
import software.amazon.awssdk.services.quicksight.model.StartDashboardSnapshotJobScheduleRequest;
import software.amazon.awssdk.services.quicksight.model.StartDashboardSnapshotJobScheduleResponse;
import software.amazon.awssdk.services.quicksight.model.TagResourceRequest;
import software.amazon.awssdk.services.quicksight.model.TagResourceResponse;
import software.amazon.awssdk.services.quicksight.model.ThrottlingException;
import software.amazon.awssdk.services.quicksight.model.UnsupportedPricingPlanException;
import software.amazon.awssdk.services.quicksight.model.UnsupportedUserEditionException;
import software.amazon.awssdk.services.quicksight.model.UntagResourceRequest;
import software.amazon.awssdk.services.quicksight.model.UntagResourceResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountCustomPermissionRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountCustomPermissionResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountSettingsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountSettingsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateActionConnectorPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateActionConnectorPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateActionConnectorRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateActionConnectorResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateApplicationWithTokenExchangeGrantRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateApplicationWithTokenExchangeGrantResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateBrandAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateBrandAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateBrandPublishedVersionRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateBrandPublishedVersionResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateBrandRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateBrandResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateCustomPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateCustomPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardLinksRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardLinksResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPublishedVersionRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPublishedVersionResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardsQaConfigurationRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardsQaConfigurationResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourcePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourcePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDefaultQBusinessApplicationRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDefaultQBusinessApplicationResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateFlowPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateFlowPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateFolderPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateFolderPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateFolderRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateFolderResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateGroupRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateGroupResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateIdentityPropagationConfigRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateIdentityPropagationConfigResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateIpRestrictionRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateIpRestrictionResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateKeyRegistrationRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateKeyRegistrationResponse;
import software.amazon.awssdk.services.quicksight.model.UpdatePublicSharingSettingsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdatePublicSharingSettingsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateQPersonalizationConfigurationRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateQPersonalizationConfigurationResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateQuickSightQSearchConfigurationRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateQuickSightQSearchConfigurationResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateRefreshScheduleRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateRefreshScheduleResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateRoleCustomPermissionRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateRoleCustomPermissionResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateSpiceCapacityConfigurationRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateSpiceCapacityConfigurationResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplatePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplatePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateThemePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateThemePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTopicPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTopicPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTopicRefreshScheduleRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTopicRefreshScheduleResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTopicRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTopicResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateUserCustomPermissionRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateUserCustomPermissionResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateUserRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateUserResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateVpcConnectionRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateVpcConnectionResponse;
import software.amazon.awssdk.services.quicksight.transform.BatchCreateTopicReviewedAnswerRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.BatchDeleteTopicReviewedAnswerRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CancelIngestionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateAccountCustomizationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateAccountSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateActionConnectorRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateBrandRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateCustomPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateDashboardRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateDataSetRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateFolderMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateFolderRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateGroupMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateIamPolicyAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateIngestionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateNamespaceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateRefreshScheduleRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateRoleMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateTemplateAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateTemplateRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateThemeAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateThemeRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateTopicRefreshScheduleRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateTopicRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateVpcConnectionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteAccountCustomPermissionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteAccountCustomizationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteAccountSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteActionConnectorRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteBrandAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteBrandRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteCustomPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteDashboardRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteDataSetRefreshPropertiesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteDataSetRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteDataSourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteDefaultQBusinessApplicationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteFolderMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteFolderRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteGroupMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteIamPolicyAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteIdentityPropagationConfigRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteNamespaceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteRefreshScheduleRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteRoleCustomPermissionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteRoleMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteTemplateAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteTemplateRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteThemeAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteThemeRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteTopicRefreshScheduleRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteTopicRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteUserByPrincipalIdRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteUserCustomPermissionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteVpcConnectionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAccountCustomPermissionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAccountCustomizationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAccountSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeActionConnectorPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeActionConnectorRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAnalysisDefinitionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAnalysisPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAssetBundleExportJobRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAssetBundleImportJobRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeBrandAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeBrandPublishedVersionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeBrandRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeCustomPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDashboardDefinitionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDashboardPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDashboardRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDashboardSnapshotJobRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDashboardSnapshotJobResultRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDashboardsQaConfigurationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDataSetPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDataSetRefreshPropertiesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDataSetRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDataSourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDataSourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDefaultQBusinessApplicationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeFolderPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeFolderRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeFolderResolvedPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeGroupMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeIamPolicyAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeIngestionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeIpRestrictionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeKeyRegistrationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeNamespaceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeQPersonalizationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeQuickSightQSearchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeRefreshScheduleRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeRoleCustomPermissionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTemplateAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTemplateDefinitionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTemplatePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTemplateRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeThemeAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeThemePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeThemeRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTopicPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTopicRefreshRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTopicRefreshScheduleRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTopicRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeVpcConnectionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GenerateEmbedUrlForAnonymousUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GenerateEmbedUrlForRegisteredUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GenerateEmbedUrlForRegisteredUserWithIdentityRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GetDashboardEmbedUrlRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GetFlowMetadataRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GetFlowPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GetSessionEmbedUrlRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListActionConnectorsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListAnalysesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListAssetBundleExportJobsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListAssetBundleImportJobsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListBrandsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListCustomPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListDashboardVersionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListDashboardsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListDataSetsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListFlowsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListFolderMembersRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListFoldersForResourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListFoldersRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListGroupMembershipsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListIamPolicyAssignmentsForUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListIamPolicyAssignmentsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListIdentityPropagationConfigsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListIngestionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListNamespacesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListRefreshSchedulesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListRoleMembershipsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTemplateAliasesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTemplatesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListThemeAliasesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListThemeVersionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListThemesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTopicRefreshSchedulesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTopicReviewedAnswersRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTopicsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListUserGroupsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListVpcConnectionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.PredictQaResultsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.PutDataSetRefreshPropertiesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.RegisterUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.RestoreAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchActionConnectorsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchAnalysesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchDashboardsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchDataSetsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchFlowsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchFoldersRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchGroupsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchTopicsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.StartAssetBundleExportJobRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.StartAssetBundleImportJobRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.StartDashboardSnapshotJobRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.StartDashboardSnapshotJobScheduleRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateAccountCustomPermissionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateAccountCustomizationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateActionConnectorPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateActionConnectorRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateAnalysisPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateApplicationWithTokenExchangeGrantRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateBrandAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateBrandPublishedVersionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateBrandRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateCustomPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDashboardLinksRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDashboardPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDashboardPublishedVersionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDashboardRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDashboardsQaConfigurationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDataSetPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDataSetRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDataSourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDefaultQBusinessApplicationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateFlowPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateFolderPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateFolderRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateIamPolicyAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateIdentityPropagationConfigRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateIpRestrictionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateKeyRegistrationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdatePublicSharingSettingsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateQPersonalizationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateQuickSightQSearchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateRefreshScheduleRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateRoleCustomPermissionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateSpiceCapacityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateTemplateAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateTemplatePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateTemplateRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateThemeAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateThemePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateThemeRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateTopicPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateTopicRefreshScheduleRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateTopicRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateUserCustomPermissionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateVpcConnectionRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link QuickSightClient}.
 *
 * @see QuickSightClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultQuickSightClient implements QuickSightClient {
    private static final Logger log = Logger.loggerFor(DefaultQuickSightClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultQuickSightClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "QuickSight" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates new reviewed answers for a Q Topic.
     * </p>
     *
     * @param batchCreateTopicReviewedAnswerRequest
     * @return Result of the BatchCreateTopicReviewedAnswer operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.BatchCreateTopicReviewedAnswer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/BatchCreateTopicReviewedAnswer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchCreateTopicReviewedAnswerResponse batchCreateTopicReviewedAnswer(
            BatchCreateTopicReviewedAnswerRequest batchCreateTopicReviewedAnswerRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, ResourceNotFoundException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchCreateTopicReviewedAnswerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchCreateTopicReviewedAnswerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchCreateTopicReviewedAnswerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchCreateTopicReviewedAnswerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchCreateTopicReviewedAnswer");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchCreateTopicReviewedAnswerRequest, BatchCreateTopicReviewedAnswerResponse>()
                            .withOperationName("BatchCreateTopicReviewedAnswer").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchCreateTopicReviewedAnswerRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchCreateTopicReviewedAnswerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes reviewed answers for Q Topic.
     * </p>
     *
     * @param batchDeleteTopicReviewedAnswerRequest
     * @return Result of the BatchDeleteTopicReviewedAnswer operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.BatchDeleteTopicReviewedAnswer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/BatchDeleteTopicReviewedAnswer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchDeleteTopicReviewedAnswerResponse batchDeleteTopicReviewedAnswer(
            BatchDeleteTopicReviewedAnswerRequest batchDeleteTopicReviewedAnswerRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, ResourceNotFoundException, ConflictException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeleteTopicReviewedAnswerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDeleteTopicReviewedAnswerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteTopicReviewedAnswerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDeleteTopicReviewedAnswerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteTopicReviewedAnswer");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteTopicReviewedAnswerRequest, BatchDeleteTopicReviewedAnswerResponse>()
                            .withOperationName("BatchDeleteTopicReviewedAnswer").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchDeleteTopicReviewedAnswerRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchDeleteTopicReviewedAnswerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels an ongoing ingestion of data into SPICE.
     * </p>
     *
     * @param cancelIngestionRequest
     * @return Result of the CancelIngestion operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CancelIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CancelIngestion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CancelIngestionResponse cancelIngestion(CancelIngestionRequest cancelIngestionRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, ResourceExistsException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelIngestionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CancelIngestionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelIngestionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelIngestionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelIngestion");

            return clientHandler.execute(new ClientExecutionParams<CancelIngestionRequest, CancelIngestionResponse>()
                    .withOperationName("CancelIngestion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelIngestionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelIngestionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates Amazon Quick Sight customizations. Currently, you can add a custom default theme by using the
     * <code>CreateAccountCustomization</code> or <code>UpdateAccountCustomization</code> API operation. To further
     * customize Amazon Quick Sight by removing Amazon Quick Sight sample assets and videos for all new users, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html">Customizing Quick Sight</a>
     * in the <i>Amazon Quick Sight User Guide.</i>
     * </p>
     * <p>
     * You can create customizations for your Amazon Web Services account or, if you specify a namespace, for a Quick
     * Sight namespace instead. Customizations that apply to a namespace always override customizations that apply to an
     * Amazon Web Services account. To find out which customizations apply, use the
     * <code>DescribeAccountCustomization</code> API operation.
     * </p>
     * <p>
     * Before you use the <code>CreateAccountCustomization</code> API operation to add a theme as the namespace default,
     * make sure that you first share the theme with the namespace. If you don't share it with the namespace, the theme
     * isn't visible to your users even if you make it the default theme. To check if the theme is shared, view the
     * current permissions by using the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemePermissions.html">DescribeThemePermissions</a> </code>
     * API operation. To share the theme, grant permissions by using the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemePermissions.html">UpdateThemePermissions</a> </code>
     * API operation.
     * </p>
     *
     * @param createAccountCustomizationRequest
     * @return Result of the CreateAccountCustomization operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateAccountCustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAccountCustomizationResponse createAccountCustomization(
            CreateAccountCustomizationRequest createAccountCustomizationRequest) throws AccessDeniedException, ConflictException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAccountCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAccountCustomizationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAccountCustomizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccountCustomizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccountCustomization");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAccountCustomizationRequest, CreateAccountCustomizationResponse>()
                            .withOperationName("CreateAccountCustomization").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createAccountCustomizationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAccountCustomizationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Quick Sight account, or subscribes to Amazon Quick Sight Q.
     * </p>
     * <p>
     * The Amazon Web Services Region for the account is derived from what is configured in the CLI or SDK.
     * </p>
     * <p>
     * Before you use this operation, make sure that you can connect to an existing Amazon Web Services account. If you
     * don't have an Amazon Web Services account, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/setting-up-aws-sign-up.html">Sign up for Amazon Web
     * Services</a> in the <i>Amazon Quick Sight User Guide</i>. The person who signs up for Amazon Quick Sight needs to
     * have the correct Identity and Access Management (IAM) permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/iam-policy-examples.html">IAM Policy Examples for Amazon
     * Quick Sight</a> in the <i>Amazon Quick Sight User Guide</i>.
     * </p>
     * <p>
     * If your IAM policy includes both the <code>Subscribe</code> and <code>CreateAccountSubscription</code> actions,
     * make sure that both actions are set to <code>Allow</code>. If either action is set to <code>Deny</code>, the
     * <code>Deny</code> action prevails and your API call fails.
     * </p>
     * <p>
     * You can't pass an existing IAM role to access other Amazon Web Services services using this API operation. To
     * pass your existing IAM role to Amazon Quick Sight, see <a href=
     * "https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html#security-create-iam-role"
     * >Passing IAM roles to Amazon Quick Sight</a> in the <i>Amazon Quick Sight User Guide</i>.
     * </p>
     * <p>
     * You can't set default resource access on the new account from the Amazon Quick Sight API. Instead, add default
     * resource access from the Amazon Quick Sight console. For more information about setting default resource access
     * to Amazon Web Services services, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/scoping-policies-defaults.html">Setting default resource
     * access to Amazon Web Services services</a> in the <i>Amazon Quick Sight User Guide</i>.
     * </p>
     *
     * @param createAccountSubscriptionRequest
     * @return Result of the CreateAccountSubscription operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateAccountSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAccountSubscriptionResponse createAccountSubscription(
            CreateAccountSubscriptionRequest createAccountSubscriptionRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, ResourceExistsException,
            PreconditionNotMetException, ConflictException, InternalFailureException, ResourceUnavailableException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAccountSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAccountSubscriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAccountSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccountSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccountSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAccountSubscriptionRequest, CreateAccountSubscriptionResponse>()
                            .withOperationName("CreateAccountSubscription").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createAccountSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAccountSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an action connector that enables Amazon Quick Sight to connect to external services and perform actions.
     * Action connectors support various authentication methods and can be configured with specific actions from
     * supported connector types like Amazon S3, Salesforce, JIRA.
     * </p>
     *
     * @param createActionConnectorRequest
     * @return Result of the CreateActionConnector operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateActionConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateActionConnector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateActionConnectorResponse createActionConnector(CreateActionConnectorRequest createActionConnectorRequest)
            throws ThrottlingException, ResourceExistsException, InvalidParameterValueException, InternalFailureException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateActionConnectorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateActionConnectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createActionConnectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createActionConnectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateActionConnector");

            return clientHandler.execute(new ClientExecutionParams<CreateActionConnectorRequest, CreateActionConnectorResponse>()
                    .withOperationName("CreateActionConnector").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createActionConnectorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateActionConnectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an analysis in Amazon Quick Sight. Analyses can be created either from a template or from an
     * <code>AnalysisDefinition</code>.
     * </p>
     *
     * @param createAnalysisRequest
     * @return Result of the CreateAnalysis operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAnalysis" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAnalysisResponse createAnalysis(CreateAnalysisRequest createAnalysisRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, ThrottlingException, ResourceExistsException, ConflictException,
            UnsupportedUserEditionException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAnalysisResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAnalysisResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAnalysisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAnalysis");

            return clientHandler.execute(new ClientExecutionParams<CreateAnalysisRequest, CreateAnalysisResponse>()
                    .withOperationName("CreateAnalysis").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createAnalysisRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAnalysisRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Quick Sight brand.
     * </p>
     *
     * @param createBrandRequest
     * @return Result of the CreateBrand operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidRequestException
     *         You don't have this feature activated for your account. To fix this issue, contact Amazon Web Services
     *         support.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InternalServerException
     *         An internal service exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateBrand
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateBrand" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateBrandResponse createBrand(CreateBrandRequest createBrandRequest) throws ThrottlingException,
            InvalidRequestException, LimitExceededException, ConflictException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBrandResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBrandResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBrandRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBrandRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBrand");

            return clientHandler.execute(new ClientExecutionParams<CreateBrandRequest, CreateBrandResponse>()
                    .withOperationName("CreateBrand").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createBrandRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBrandRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a custom permissions profile.
     * </p>
     *
     * @param createCustomPermissionsRequest
     * @return Result of the CreateCustomPermissions operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateCustomPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateCustomPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCustomPermissionsResponse createCustomPermissions(CreateCustomPermissionsRequest createCustomPermissionsRequest)
            throws ConflictException, AccessDeniedException, ResourceNotFoundException, ResourceExistsException,
            InvalidParameterValueException, ThrottlingException, PreconditionNotMetException, LimitExceededException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCustomPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCustomPermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCustomPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCustomPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomPermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCustomPermissionsRequest, CreateCustomPermissionsResponse>()
                            .withOperationName("CreateCustomPermissions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createCustomPermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCustomPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a dashboard from either a template or directly with a <code>DashboardDefinition</code>. To first create a
     * template, see the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> </code>
     * API operation.
     * </p>
     * <p>
     * A dashboard is an entity in Amazon Quick Sight that identifies Amazon Quick Sight reports, created from analyses.
     * You can share Amazon Quick Sight dashboards. With the right permissions, you can create scheduled email reports
     * from them. If you have the correct permissions, you can create a dashboard from a template that exists in a
     * different Amazon Web Services account.
     * </p>
     *
     * @param createDashboardRequest
     * @return Result of the CreateDashboard operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDashboardResponse createDashboard(CreateDashboardRequest createDashboardRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, ThrottlingException, ResourceExistsException,
            ConflictException, UnsupportedUserEditionException, LimitExceededException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDashboardResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDashboardResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDashboardRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDashboard");

            return clientHandler.execute(new ClientExecutionParams<CreateDashboardRequest, CreateDashboardResponse>()
                    .withOperationName("CreateDashboard").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDashboardRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDashboardRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a dataset. This operation doesn't support datasets that include uploaded files as a source.
     * </p>
     *
     * @param createDataSetRequest
     * @return Result of the CreateDataSet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InvalidDataSetParameterValueException
     *         An exception thrown when an invalid parameter value is provided for dataset operations.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDataSetResponse createDataSet(CreateDataSetRequest createDataSetRequest) throws AccessDeniedException,
            ConflictException, InvalidParameterValueException, LimitExceededException, ResourceExistsException,
            ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException,
            InvalidDataSetParameterValueException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDataSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDataSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDataSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataSet");

            return clientHandler.execute(new ClientExecutionParams<CreateDataSetRequest, CreateDataSetResponse>()
                    .withOperationName("CreateDataSet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDataSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDataSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a data source.
     * </p>
     *
     * @param createDataSourceRequest
     * @return Result of the CreateDataSource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws CustomerManagedKeyUnavailableException
     *         The customer managed key that is registered to your Amazon Quick Sight account is unavailable.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDataSourceResponse createDataSource(CreateDataSourceRequest createDataSourceRequest)
            throws AccessDeniedException, ConflictException, InvalidParameterValueException, LimitExceededException,
            ResourceNotFoundException, ResourceExistsException, ThrottlingException, CustomerManagedKeyUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDataSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataSource");

            return clientHandler.execute(new ClientExecutionParams<CreateDataSourceRequest, CreateDataSourceResponse>()
                    .withOperationName("CreateDataSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDataSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDataSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an empty shared folder.
     * </p>
     *
     * @param createFolderRequest
     * @return Result of the CreateFolder operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolder" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateFolderResponse createFolder(CreateFolderRequest createFolderRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, ThrottlingException, ResourceExistsException, ConflictException,
            UnsupportedUserEditionException, AccessDeniedException, LimitExceededException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFolderResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateFolderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFolderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFolderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFolder");

            return clientHandler.execute(new ClientExecutionParams<CreateFolderRequest, CreateFolderResponse>()
                    .withOperationName("CreateFolder").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createFolderRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFolderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds an asset, such as a dashboard, analysis, or dataset into a folder.
     * </p>
     *
     * @param createFolderMembershipRequest
     * @return Result of the CreateFolderMembership operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateFolderMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolderMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateFolderMembershipResponse createFolderMembership(CreateFolderMembershipRequest createFolderMembershipRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ResourceExistsException,
            ThrottlingException, LimitExceededException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFolderMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateFolderMembershipResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFolderMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFolderMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFolderMembership");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateFolderMembershipRequest, CreateFolderMembershipResponse>()
                            .withOperationName("CreateFolderMembership").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createFolderMembershipRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateFolderMembershipRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use the <code>CreateGroup</code> operation to create a group in Quick Sight. You can create up to 10,000 groups
     * in a namespace. If you want to create more than 10,000 groups in a namespace, contact Amazon Web Services
     * Support.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:&lt;your-region&gt;:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>
     * .
     * </p>
     * <p>
     * The response is a group object.
     * </p>
     *
     * @param createGroupRequest
     *        The request object for this operation.
     * @return Result of the CreateGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateGroupResponse createGroup(CreateGroupRequest createGroupRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, LimitExceededException, InternalFailureException, ResourceUnavailableException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateGroupRequest, CreateGroupResponse>()
                    .withOperationName("CreateGroup").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds an Amazon Quick Sight user to an Amazon Quick Sight group.
     * </p>
     *
     * @param createGroupMembershipRequest
     * @return Result of the CreateGroupMembership operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateGroupMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateGroupMembershipResponse createGroupMembership(CreateGroupMembershipRequest createGroupMembershipRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateGroupMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateGroupMembershipResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGroupMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGroupMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGroupMembership");

            return clientHandler.execute(new ClientExecutionParams<CreateGroupMembershipRequest, CreateGroupMembershipResponse>()
                    .withOperationName("CreateGroupMembership").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createGroupMembershipRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateGroupMembershipRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an assignment with one specified IAM policy, identified by its Amazon Resource Name (ARN). This policy
     * assignment is attached to the specified groups or users of Amazon Quick Sight. Assignment names are unique per
     * Amazon Web Services account. To avoid overwriting rules in other namespaces, use assignment names that are
     * unique.
     * </p>
     *
     * @param createIamPolicyAssignmentRequest
     * @return Result of the CreateIAMPolicyAssignment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConcurrentUpdatingException
     *         A resource is already in a state that indicates an operation is happening that must complete before a new
     *         update can be applied.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateIAMPolicyAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateIamPolicyAssignmentResponse createIAMPolicyAssignment(
            CreateIamPolicyAssignmentRequest createIamPolicyAssignmentRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            ConcurrentUpdatingException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIamPolicyAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateIamPolicyAssignmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIamPolicyAssignmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIamPolicyAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIAMPolicyAssignment");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateIamPolicyAssignmentRequest, CreateIamPolicyAssignmentResponse>()
                            .withOperationName("CreateIAMPolicyAssignment").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createIamPolicyAssignmentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateIamPolicyAssignmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates and starts a new SPICE ingestion for a dataset. You can manually refresh datasets in an Enterprise
     * edition account 32 times in a 24-hour period. You can manually refresh datasets in a Standard edition account 8
     * times in a 24-hour period. Each 24-hour period is measured starting 24 hours before the current date and time.
     * </p>
     * <p>
     * Any ingestions operating on tagged datasets inherit the same tags automatically for use in access control. For an
     * example, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/">How do I
     * create an IAM policy to control access to Amazon EC2 resources using tags?</a> in the Amazon Web Services
     * Knowledge Center. Tags are visible on the tagged dataset, but not on the ingestion resource.
     * </p>
     *
     * @param createIngestionRequest
     * @return Result of the CreateIngestion operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIngestion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateIngestionResponse createIngestion(CreateIngestionRequest createIngestionRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, LimitExceededException,
            ResourceExistsException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIngestionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateIngestionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIngestionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIngestionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIngestion");

            return clientHandler.execute(new ClientExecutionParams<CreateIngestionRequest, CreateIngestionResponse>()
                    .withOperationName("CreateIngestion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createIngestionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateIngestionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * (Enterprise edition only) Creates a new namespace for you to use with Amazon Quick Sight.
     * </p>
     * <p>
     * A namespace allows you to isolate the Quick Sight users and groups that are registered for that namespace. Users
     * that access the namespace can share assets only with other users or groups in the same namespace. They can't see
     * users and groups in other namespaces. You can create a namespace after your Amazon Web Services account is
     * subscribed to Quick Sight. The namespace must be unique within the Amazon Web Services account. By default, there
     * is a limit of 100 namespaces per Amazon Web Services account. To increase your limit, create a ticket with Amazon
     * Web Services Support.
     * </p>
     *
     * @param createNamespaceRequest
     * @return Result of the CreateNamespace operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateNamespaceResponse createNamespace(CreateNamespaceRequest createNamespaceRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, LimitExceededException,
            ResourceExistsException, PreconditionNotMetException, ConflictException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateNamespaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNamespaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNamespace");

            return clientHandler.execute(new ClientExecutionParams<CreateNamespaceRequest, CreateNamespaceResponse>()
                    .withOperationName("CreateNamespace").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createNamespaceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateNamespaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a refresh schedule for a dataset. You can create up to 5 different schedules for a single dataset.
     * </p>
     *
     * @param createRefreshScheduleRequest
     * @return Result of the CreateRefreshSchedule operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateRefreshSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateRefreshSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateRefreshScheduleResponse createRefreshSchedule(CreateRefreshScheduleRequest createRefreshScheduleRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            LimitExceededException, ResourceExistsException, PreconditionNotMetException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRefreshScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateRefreshScheduleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRefreshScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRefreshScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRefreshSchedule");

            return clientHandler.execute(new ClientExecutionParams<CreateRefreshScheduleRequest, CreateRefreshScheduleResponse>()
                    .withOperationName("CreateRefreshSchedule").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createRefreshScheduleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRefreshScheduleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use <code>CreateRoleMembership</code> to add an existing Quick Sight group to an existing role.
     * </p>
     *
     * @param createRoleMembershipRequest
     * @return Result of the CreateRoleMembership operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateRoleMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateRoleMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateRoleMembershipResponse createRoleMembership(CreateRoleMembershipRequest createRoleMembershipRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRoleMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateRoleMembershipResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRoleMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRoleMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRoleMembership");

            return clientHandler.execute(new ClientExecutionParams<CreateRoleMembershipRequest, CreateRoleMembershipResponse>()
                    .withOperationName("CreateRoleMembership").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createRoleMembershipRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRoleMembershipRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a template either from a <code>TemplateDefinition</code> or from an existing Quick Sight analysis or
     * template. You can use the resulting template to create additional dashboards, templates, or analyses.
     * </p>
     * <p>
     * A <i>template</i> is an entity in Quick Sight that encapsulates the metadata required to create an analysis and
     * that you can use to create s dashboard. A template adds a layer of abstraction by using placeholders to replace
     * the dataset associated with the analysis. You can use templates to create dashboards by replacing dataset
     * placeholders with datasets that follow the same schema that was used to create the source analysis and template.
     * </p>
     *
     * @param createTemplateRequest
     * @return Result of the CreateTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateTemplateResponse createTemplate(CreateTemplateRequest createTemplateRequest)
            throws InvalidParameterValueException, AccessDeniedException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, LimitExceededException, UnsupportedUserEditionException, ConflictException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTemplate");

            return clientHandler.execute(new ClientExecutionParams<CreateTemplateRequest, CreateTemplateResponse>()
                    .withOperationName("CreateTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a template alias for a template.
     * </p>
     *
     * @param createTemplateAliasRequest
     * @return Result of the CreateTemplateAlias operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateTemplateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplateAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTemplateAliasResponse createTemplateAlias(CreateTemplateAliasRequest createTemplateAliasRequest)
            throws ThrottlingException, ResourceNotFoundException, ConflictException, ResourceExistsException,
            LimitExceededException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTemplateAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateTemplateAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTemplateAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTemplateAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTemplateAlias");

            return clientHandler.execute(new ClientExecutionParams<CreateTemplateAliasRequest, CreateTemplateAliasResponse>()
                    .withOperationName("CreateTemplateAlias").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createTemplateAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTemplateAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a theme.
     * </p>
     * <p>
     * A <i>theme</i> is set of configuration options for color and layout. Themes apply to analyses and dashboards. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using Themes in Amazon Quick
     * Sight</a> in the <i>Amazon Quick Sight User Guide</i>.
     * </p>
     *
     * @param createThemeRequest
     * @return Result of the CreateTheme operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTheme" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateThemeResponse createTheme(CreateThemeRequest createThemeRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateThemeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateThemeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createThemeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createThemeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTheme");

            return clientHandler.execute(new ClientExecutionParams<CreateThemeRequest, CreateThemeResponse>()
                    .withOperationName("CreateTheme").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createThemeRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateThemeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a theme alias for a theme.
     * </p>
     *
     * @param createThemeAliasRequest
     * @return Result of the CreateThemeAlias operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateThemeAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateThemeAliasResponse createThemeAlias(CreateThemeAliasRequest createThemeAliasRequest) throws ConflictException,
            InvalidParameterValueException, LimitExceededException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateThemeAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateThemeAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createThemeAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createThemeAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateThemeAlias");

            return clientHandler.execute(new ClientExecutionParams<CreateThemeAliasRequest, CreateThemeAliasResponse>()
                    .withOperationName("CreateThemeAlias").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createThemeAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateThemeAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new Q topic.
     * </p>
     *
     * @param createTopicRequest
     * @return Result of the CreateTopic operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTopic" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateTopicResponse createTopic(CreateTopicRequest createTopicRequest) throws AccessDeniedException,
            ConflictException, InvalidParameterValueException, LimitExceededException, ResourceNotFoundException,
            ResourceExistsException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTopicResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTopicResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTopicRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTopicRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTopic");

            return clientHandler.execute(new ClientExecutionParams<CreateTopicRequest, CreateTopicResponse>()
                    .withOperationName("CreateTopic").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createTopicRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTopicRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a topic refresh schedule.
     * </p>
     *
     * @param createTopicRefreshScheduleRequest
     * @return Result of the CreateTopicRefreshSchedule operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateTopicRefreshSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTopicRefreshSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTopicRefreshScheduleResponse createTopicRefreshSchedule(
            CreateTopicRefreshScheduleRequest createTopicRefreshScheduleRequest) throws AccessDeniedException, ConflictException,
            InvalidParameterValueException, LimitExceededException, ResourceNotFoundException, ResourceExistsException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTopicRefreshScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateTopicRefreshScheduleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTopicRefreshScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTopicRefreshScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTopicRefreshSchedule");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTopicRefreshScheduleRequest, CreateTopicRefreshScheduleResponse>()
                            .withOperationName("CreateTopicRefreshSchedule").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createTopicRefreshScheduleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTopicRefreshScheduleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new VPC connection.
     * </p>
     *
     * @param createVpcConnectionRequest
     * @return Result of the CreateVPCConnection operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateVPCConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateVPCConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateVpcConnectionResponse createVPCConnection(CreateVpcConnectionRequest createVpcConnectionRequest)
            throws AccessDeniedException, ConflictException, InvalidParameterValueException, LimitExceededException,
            ResourceExistsException, ThrottlingException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateVpcConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateVpcConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpcConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVPCConnection");

            return clientHandler.execute(new ClientExecutionParams<CreateVpcConnectionRequest, CreateVpcConnectionResponse>()
                    .withOperationName("CreateVPCConnection").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createVpcConnectionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateVpcConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Unapplies a custom permissions profile from an account.
     * </p>
     *
     * @param deleteAccountCustomPermissionRequest
     * @return Result of the DeleteAccountCustomPermission operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteAccountCustomPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountCustomPermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAccountCustomPermissionResponse deleteAccountCustomPermission(
            DeleteAccountCustomPermissionRequest deleteAccountCustomPermissionRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAccountCustomPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAccountCustomPermissionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccountCustomPermissionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteAccountCustomPermissionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountCustomPermission");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountCustomPermissionRequest, DeleteAccountCustomPermissionResponse>()
                            .withOperationName("DeleteAccountCustomPermission").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteAccountCustomPermissionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAccountCustomPermissionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <important>
     * <p>
     * This API permanently deletes all Quick Sight customizations for the specified Amazon Web Services account and
     * namespace. When you delete account customizations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * All customizations are removed including themes, branding, and visual settings
     * </p>
     * </li>
     * <li>
     * <p>
     * This action cannot be undone through the API
     * </p>
     * </li>
     * <li>
     * <p>
     * Users will see default Quick Sight styling after customizations are deleted
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Before proceeding:</b> Ensure you have backups of any custom themes or branding elements you may want to
     * recreate.
     * </p>
     * </important>
     * <p>
     * Deletes all Amazon Quick Sight customizations for the specified Amazon Web Services account and Quick Sight
     * namespace.
     * </p>
     *
     * @param deleteAccountCustomizationRequest
     * @return Result of the DeleteAccountCustomization operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteAccountCustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAccountCustomizationResponse deleteAccountCustomization(
            DeleteAccountCustomizationRequest deleteAccountCustomizationRequest) throws AccessDeniedException, ConflictException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, LimitExceededException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAccountCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAccountCustomizationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccountCustomizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccountCustomizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountCustomization");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountCustomizationRequest, DeleteAccountCustomizationResponse>()
                            .withOperationName("DeleteAccountCustomization").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteAccountCustomizationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAccountCustomizationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <important>
     * <p>
     * Deleting your Quick Sight account subscription has permanent, irreversible consequences across all Amazon Web
     * Services regions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Global deletion – Running this operation from any single region will delete your Quick Sight account and all data
     * in every Amazon Web Services region where you have Quick Sight resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * Complete data loss – All dashboards, analyses, datasets, data sources, and custom visuals will be permanently
     * deleted across all regions.
     * </p>
     * </li>
     * <li>
     * <p>
     * Embedded content failure – All embedded dashboards and visuals in your applications will immediately stop working
     * and display errors to end users.
     * </p>
     * </li>
     * <li>
     * <p>
     * Shared resources removed – All shared dashboards, folders, and resources will become inaccessible to other users
     * and external recipients.
     * </p>
     * </li>
     * <li>
     * <p>
     * User access terminated – All Quick Sight users in your account will lose access immediately, including authors,
     * readers, and administrators.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>No recovery possible</b> – Once deleted, your Quick Sight account and all associated data cannot be restored.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Consider exporting critical dashboards and data before proceeding with account deletion.
     * </p>
     * </important>
     * <p>
     * Use the <code>DeleteAccountSubscription</code> operation to delete an Quick Sight account. This operation will
     * result in an error message if you have configured your account termination protection settings to
     * <code>True</code>. To change this setting and delete your account, call the <code>UpdateAccountSettings</code>
     * API and set the value of the <code>TerminationProtectionEnabled</code> parameter to <code>False</code>, then make
     * another call to the <code>DeleteAccountSubscription</code> API.
     * </p>
     *
     * @param deleteAccountSubscriptionRequest
     * @return Result of the DeleteAccountSubscription operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteAccountSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAccountSubscriptionResponse deleteAccountSubscription(
            DeleteAccountSubscriptionRequest deleteAccountSubscriptionRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAccountSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAccountSubscriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccountSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccountSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountSubscriptionRequest, DeleteAccountSubscriptionResponse>()
                            .withOperationName("DeleteAccountSubscription").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteAccountSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAccountSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Hard deletes an action connector, making it unrecoverable. This operation removes the connector and all its
     * associated configurations. Any resources currently using this action connector will no longer be able to perform
     * actions through it.
     * </p>
     *
     * @param deleteActionConnectorRequest
     * @return Result of the DeleteActionConnector operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteActionConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteActionConnector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteActionConnectorResponse deleteActionConnector(DeleteActionConnectorRequest deleteActionConnectorRequest)
            throws ThrottlingException, InvalidParameterValueException, InternalFailureException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteActionConnectorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteActionConnectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteActionConnectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteActionConnectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteActionConnector");

            return clientHandler.execute(new ClientExecutionParams<DeleteActionConnectorRequest, DeleteActionConnectorResponse>()
                    .withOperationName("DeleteActionConnector").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteActionConnectorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteActionConnectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an analysis from Amazon Quick Sight. You can optionally include a recovery window during which you can
     * restore the analysis. If you don't specify a recovery window value, the operation defaults to 30 days. Amazon
     * Quick Sight attaches a <code>DeletionTime</code> stamp to the response that specifies the end of the recovery
     * window. At the end of the recovery window, Amazon Quick Sight deletes the analysis permanently.
     * </p>
     * <p>
     * At any time before recovery window ends, you can use the <code>RestoreAnalysis</code> API operation to remove the
     * <code>DeletionTime</code> stamp and cancel the deletion of the analysis. The analysis remains visible in the API
     * until it's deleted, so you can describe it but you can't make a template from it.
     * </p>
     * <p>
     * An analysis that's scheduled for deletion isn't accessible in the Amazon Quick Sight console. To access it in the
     * console, restore it. Deleting an analysis doesn't delete the dashboards that you publish from it.
     * </p>
     *
     * @param deleteAnalysisRequest
     * @return Result of the DeleteAnalysis operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAnalysis" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAnalysisResponse deleteAnalysis(DeleteAnalysisRequest deleteAnalysisRequest) throws ThrottlingException,
            InvalidParameterValueException, ConflictException, ResourceNotFoundException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAnalysisResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAnalysisResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAnalysisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAnalysis");

            return clientHandler.execute(new ClientExecutionParams<DeleteAnalysisRequest, DeleteAnalysisResponse>()
                    .withOperationName("DeleteAnalysis").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAnalysisRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAnalysisRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <important>
     * <p>
     * This API permanently deletes the specified Quick Sight brand. When you delete a brand:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The brand and all its associated branding elements are permanently removed
     * </p>
     * </li>
     * <li>
     * <p>
     * Any applications or dashboards using this brand will revert to default styling
     * </p>
     * </li>
     * <li>
     * <p>
     * This action cannot be undone through the API
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Before proceeding:</b> Verify that the brand is no longer needed and consider the impact on any applications
     * currently using this brand.
     * </p>
     * </important>
     * <p>
     * Deletes an Quick Sight brand.
     * </p>
     *
     * @param deleteBrandRequest
     * @return Result of the DeleteBrand operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidRequestException
     *         You don't have this feature activated for your account. To fix this issue, contact Amazon Web Services
     *         support.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InternalServerException
     *         An internal service exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteBrand
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteBrand" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteBrandResponse deleteBrand(DeleteBrandRequest deleteBrandRequest) throws ThrottlingException,
            InvalidRequestException, ResourceNotFoundException, ConflictException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBrandResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBrandResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBrandRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBrandRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBrand");

            return clientHandler.execute(new ClientExecutionParams<DeleteBrandRequest, DeleteBrandResponse>()
                    .withOperationName("DeleteBrand").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteBrandRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBrandRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a brand assignment.
     * </p>
     *
     * @param deleteBrandAssignmentRequest
     * @return Result of the DeleteBrandAssignment operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidRequestException
     *         You don't have this feature activated for your account. To fix this issue, contact Amazon Web Services
     *         support.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InternalServerException
     *         An internal service exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteBrandAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteBrandAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteBrandAssignmentResponse deleteBrandAssignment(DeleteBrandAssignmentRequest deleteBrandAssignmentRequest)
            throws ThrottlingException, InvalidRequestException, ResourceNotFoundException, ConflictException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBrandAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteBrandAssignmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBrandAssignmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBrandAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBrandAssignment");

            return clientHandler.execute(new ClientExecutionParams<DeleteBrandAssignmentRequest, DeleteBrandAssignmentResponse>()
                    .withOperationName("DeleteBrandAssignment").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBrandAssignmentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBrandAssignmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a custom permissions profile.
     * </p>
     *
     * @param deleteCustomPermissionsRequest
     * @return Result of the DeleteCustomPermissions operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteCustomPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteCustomPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCustomPermissionsResponse deleteCustomPermissions(DeleteCustomPermissionsRequest deleteCustomPermissionsRequest)
            throws ConflictException, AccessDeniedException, ResourceNotFoundException, ResourceExistsException,
            InvalidParameterValueException, ThrottlingException, PreconditionNotMetException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCustomPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCustomPermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCustomPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCustomPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomPermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomPermissionsRequest, DeleteCustomPermissionsResponse>()
                            .withOperationName("DeleteCustomPermissions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteCustomPermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCustomPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a dashboard.
     * </p>
     *
     * @param deleteDashboardRequest
     * @return Result of the DeleteDashboard operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDashboardResponse deleteDashboard(DeleteDashboardRequest deleteDashboardRequest) throws ThrottlingException,
            InvalidParameterValueException, ConflictException, ResourceNotFoundException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDashboardResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDashboardResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDashboardRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDashboard");

            return clientHandler.execute(new ClientExecutionParams<DeleteDashboardRequest, DeleteDashboardResponse>()
                    .withOperationName("DeleteDashboard").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDashboardRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDashboardRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a dataset.
     * </p>
     *
     * @param deleteDataSetRequest
     * @return Result of the DeleteDataSet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDataSetResponse deleteDataSet(DeleteDataSetRequest deleteDataSetRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, ResourceNotFoundException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDataSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDataSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDataSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataSet");

            return clientHandler.execute(new ClientExecutionParams<DeleteDataSetRequest, DeleteDataSetResponse>()
                    .withOperationName("DeleteDataSet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDataSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDataSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the dataset refresh properties of the dataset.
     * </p>
     *
     * @param deleteDataSetRefreshPropertiesRequest
     * @return Result of the DeleteDataSetRefreshProperties operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteDataSetRefreshProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSetRefreshProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDataSetRefreshPropertiesResponse deleteDataSetRefreshProperties(
            DeleteDataSetRefreshPropertiesRequest deleteDataSetRefreshPropertiesRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, LimitExceededException,
            ConflictException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDataSetRefreshPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDataSetRefreshPropertiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDataSetRefreshPropertiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDataSetRefreshPropertiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataSetRefreshProperties");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDataSetRefreshPropertiesRequest, DeleteDataSetRefreshPropertiesResponse>()
                            .withOperationName("DeleteDataSetRefreshProperties").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteDataSetRefreshPropertiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDataSetRefreshPropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the data source permanently. This operation breaks all the datasets that reference the deleted data
     * source.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return Result of the DeleteDataSource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDataSourceResponse deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest)
            throws AccessDeniedException, InvalidParameterValueException, ThrottlingException, ResourceNotFoundException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDataSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataSource");

            return clientHandler.execute(new ClientExecutionParams<DeleteDataSourceRequest, DeleteDataSourceResponse>()
                    .withOperationName("DeleteDataSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDataSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDataSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a linked Amazon Q Business application from an Quick Sight account
     * </p>
     *
     * @param deleteDefaultQBusinessApplicationRequest
     * @return Result of the DeleteDefaultQBusinessApplication operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteDefaultQBusinessApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDefaultQBusinessApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDefaultQBusinessApplicationResponse deleteDefaultQBusinessApplication(
            DeleteDefaultQBusinessApplicationRequest deleteDefaultQBusinessApplicationRequest) throws AccessDeniedException,
            ConflictException, ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDefaultQBusinessApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDefaultQBusinessApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDefaultQBusinessApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDefaultQBusinessApplicationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDefaultQBusinessApplication");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDefaultQBusinessApplicationRequest, DeleteDefaultQBusinessApplicationResponse>()
                            .withOperationName("DeleteDefaultQBusinessApplication").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteDefaultQBusinessApplicationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDefaultQBusinessApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an empty folder.
     * </p>
     *
     * @param deleteFolderRequest
     * @return Result of the DeleteFolder operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolder" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteFolderResponse deleteFolder(DeleteFolderRequest deleteFolderRequest) throws InvalidParameterValueException,
            PreconditionNotMetException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            ThrottlingException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFolderResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteFolderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFolderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFolderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFolder");

            return clientHandler.execute(new ClientExecutionParams<DeleteFolderRequest, DeleteFolderResponse>()
                    .withOperationName("DeleteFolder").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteFolderRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFolderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes an asset, such as a dashboard, analysis, or dataset, from a folder.
     * </p>
     *
     * @param deleteFolderMembershipRequest
     * @return Result of the DeleteFolderMembership operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteFolderMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolderMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFolderMembershipResponse deleteFolderMembership(DeleteFolderMembershipRequest deleteFolderMembershipRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFolderMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteFolderMembershipResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFolderMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFolderMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFolderMembership");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteFolderMembershipRequest, DeleteFolderMembershipResponse>()
                            .withOperationName("DeleteFolderMembership").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteFolderMembershipRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteFolderMembershipRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a user group from Amazon Quick Sight.
     * </p>
     *
     * @param deleteGroupRequest
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                    .withOperationName("DeleteGroup").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a user from a group so that the user is no longer a member of the group.
     * </p>
     *
     * @param deleteGroupMembershipRequest
     * @return Result of the DeleteGroupMembership operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteGroupMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteGroupMembershipResponse deleteGroupMembership(DeleteGroupMembershipRequest deleteGroupMembershipRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGroupMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteGroupMembershipResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGroupMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroupMembership");

            return clientHandler.execute(new ClientExecutionParams<DeleteGroupMembershipRequest, DeleteGroupMembershipResponse>()
                    .withOperationName("DeleteGroupMembership").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteGroupMembershipRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGroupMembershipRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing IAM policy assignment.
     * </p>
     *
     * @param deleteIamPolicyAssignmentRequest
     * @return Result of the DeleteIAMPolicyAssignment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConcurrentUpdatingException
     *         A resource is already in a state that indicates an operation is happening that must complete before a new
     *         update can be applied.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteIAMPolicyAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteIamPolicyAssignmentResponse deleteIAMPolicyAssignment(
            DeleteIamPolicyAssignmentRequest deleteIamPolicyAssignmentRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            ConcurrentUpdatingException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIamPolicyAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteIamPolicyAssignmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIamPolicyAssignmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIamPolicyAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIAMPolicyAssignment");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteIamPolicyAssignmentRequest, DeleteIamPolicyAssignmentResponse>()
                            .withOperationName("DeleteIAMPolicyAssignment").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteIamPolicyAssignmentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteIamPolicyAssignmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes all access scopes and authorized targets that are associated with a service from the Quick Sight IAM
     * Identity Center application.
     * </p>
     * <p>
     * This operation is only supported for Quick Sight accounts that use IAM Identity Center.
     * </p>
     *
     * @param deleteIdentityPropagationConfigRequest
     * @return Result of the DeleteIdentityPropagationConfig operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteIdentityPropagationConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIdentityPropagationConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteIdentityPropagationConfigResponse deleteIdentityPropagationConfig(
            DeleteIdentityPropagationConfigRequest deleteIdentityPropagationConfigRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIdentityPropagationConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteIdentityPropagationConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIdentityPropagationConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteIdentityPropagationConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIdentityPropagationConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteIdentityPropagationConfigRequest, DeleteIdentityPropagationConfigResponse>()
                            .withOperationName("DeleteIdentityPropagationConfig").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteIdentityPropagationConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteIdentityPropagationConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a namespace and the users and groups that are associated with the namespace. This is an asynchronous
     * process. Assets including dashboards, analyses, datasets and data sources are not deleted. To delete these
     * assets, you use the API operations for the relevant asset.
     * </p>
     *
     * @param deleteNamespaceRequest
     * @return Result of the DeleteNamespace operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteNamespaceResponse deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteNamespaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNamespaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNamespace");

            return clientHandler.execute(new ClientExecutionParams<DeleteNamespaceRequest, DeleteNamespaceResponse>()
                    .withOperationName("DeleteNamespace").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteNamespaceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteNamespaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a refresh schedule from a dataset.
     * </p>
     *
     * @param deleteRefreshScheduleRequest
     * @return Result of the DeleteRefreshSchedule operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteRefreshSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteRefreshSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRefreshScheduleResponse deleteRefreshSchedule(DeleteRefreshScheduleRequest deleteRefreshScheduleRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRefreshScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRefreshScheduleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRefreshScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRefreshScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRefreshSchedule");

            return clientHandler.execute(new ClientExecutionParams<DeleteRefreshScheduleRequest, DeleteRefreshScheduleResponse>()
                    .withOperationName("DeleteRefreshSchedule").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteRefreshScheduleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRefreshScheduleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes custom permissions from the role.
     * </p>
     *
     * @param deleteRoleCustomPermissionRequest
     * @return Result of the DeleteRoleCustomPermission operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteRoleCustomPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteRoleCustomPermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRoleCustomPermissionResponse deleteRoleCustomPermission(
            DeleteRoleCustomPermissionRequest deleteRoleCustomPermissionRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRoleCustomPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRoleCustomPermissionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRoleCustomPermissionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRoleCustomPermissionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRoleCustomPermission");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteRoleCustomPermissionRequest, DeleteRoleCustomPermissionResponse>()
                            .withOperationName("DeleteRoleCustomPermission").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteRoleCustomPermissionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteRoleCustomPermissionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a group from a role.
     * </p>
     *
     * @param deleteRoleMembershipRequest
     * @return Result of the DeleteRoleMembership operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteRoleMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteRoleMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRoleMembershipResponse deleteRoleMembership(DeleteRoleMembershipRequest deleteRoleMembershipRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRoleMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRoleMembershipResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRoleMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRoleMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRoleMembership");

            return clientHandler.execute(new ClientExecutionParams<DeleteRoleMembershipRequest, DeleteRoleMembershipResponse>()
                    .withOperationName("DeleteRoleMembership").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteRoleMembershipRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRoleMembershipRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a template.
     * </p>
     *
     * @param deleteTemplateRequest
     * @return Result of the DeleteTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteTemplateResponse deleteTemplate(DeleteTemplateRequest deleteTemplateRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, ConflictException,
            LimitExceededException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTemplate");

            return clientHandler.execute(new ClientExecutionParams<DeleteTemplateRequest, DeleteTemplateResponse>()
                    .withOperationName("DeleteTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the item that the specified template alias points to. If you provide a specific alias, you delete the
     * version of the template that the alias points to.
     * </p>
     *
     * @param deleteTemplateAliasRequest
     * @return Result of the DeleteTemplateAlias operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteTemplateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplateAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTemplateAliasResponse deleteTemplateAlias(DeleteTemplateAliasRequest deleteTemplateAliasRequest)
            throws ThrottlingException, ResourceNotFoundException, UnsupportedUserEditionException, ConflictException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTemplateAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteTemplateAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTemplateAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTemplateAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTemplateAlias");

            return clientHandler.execute(new ClientExecutionParams<DeleteTemplateAliasRequest, DeleteTemplateAliasResponse>()
                    .withOperationName("DeleteTemplateAlias").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteTemplateAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTemplateAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a theme.
     * </p>
     *
     * @param deleteThemeRequest
     * @return Result of the DeleteTheme operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTheme" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteThemeResponse deleteTheme(DeleteThemeRequest deleteThemeRequest) throws AccessDeniedException,
            ConflictException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteThemeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteThemeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteThemeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteThemeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTheme");

            return clientHandler.execute(new ClientExecutionParams<DeleteThemeRequest, DeleteThemeResponse>()
                    .withOperationName("DeleteTheme").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteThemeRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteThemeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the version of the theme that the specified theme alias points to. If you provide a specific alias, you
     * delete the version of the theme that the alias points to.
     * </p>
     *
     * @param deleteThemeAliasRequest
     * @return Result of the DeleteThemeAlias operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteThemeAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteThemeAliasResponse deleteThemeAlias(DeleteThemeAliasRequest deleteThemeAliasRequest) throws ConflictException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteThemeAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteThemeAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteThemeAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteThemeAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteThemeAlias");

            return clientHandler.execute(new ClientExecutionParams<DeleteThemeAliasRequest, DeleteThemeAliasResponse>()
                    .withOperationName("DeleteThemeAlias").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteThemeAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteThemeAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a topic.
     * </p>
     *
     * @param deleteTopicRequest
     * @return Result of the DeleteTopic operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTopic" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteTopicResponse deleteTopic(DeleteTopicRequest deleteTopicRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, ResourceNotFoundException, ConflictException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTopicResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTopicResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTopicRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTopicRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTopic");

            return clientHandler.execute(new ClientExecutionParams<DeleteTopicRequest, DeleteTopicResponse>()
                    .withOperationName("DeleteTopic").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteTopicRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTopicRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a topic refresh schedule.
     * </p>
     *
     * @param deleteTopicRefreshScheduleRequest
     * @return Result of the DeleteTopicRefreshSchedule operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteTopicRefreshSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTopicRefreshSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTopicRefreshScheduleResponse deleteTopicRefreshSchedule(
            DeleteTopicRefreshScheduleRequest deleteTopicRefreshScheduleRequest) throws AccessDeniedException, ConflictException,
            InvalidParameterValueException, LimitExceededException, ResourceNotFoundException, ResourceExistsException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTopicRefreshScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteTopicRefreshScheduleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTopicRefreshScheduleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTopicRefreshScheduleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTopicRefreshSchedule");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTopicRefreshScheduleRequest, DeleteTopicRefreshScheduleResponse>()
                            .withOperationName("DeleteTopicRefreshSchedule").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteTopicRefreshScheduleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTopicRefreshScheduleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the Amazon Quick Sight user that is associated with the identity of the IAM user or role that's making
     * the call. The IAM user isn't deleted as a result of this call.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUser");

            return clientHandler.execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>()
                    .withOperationName("DeleteUser").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteUserRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a user identified by its principal ID.
     * </p>
     *
     * @param deleteUserByPrincipalIdRequest
     * @return Result of the DeleteUserByPrincipalId operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteUserByPrincipalId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserByPrincipalId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteUserByPrincipalIdResponse deleteUserByPrincipalId(DeleteUserByPrincipalIdRequest deleteUserByPrincipalIdRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUserByPrincipalIdResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteUserByPrincipalIdResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserByPrincipalIdRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserByPrincipalIdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserByPrincipalId");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteUserByPrincipalIdRequest, DeleteUserByPrincipalIdResponse>()
                            .withOperationName("DeleteUserByPrincipalId").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteUserByPrincipalIdRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteUserByPrincipalIdRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a custom permissions profile from a user.
     * </p>
     *
     * @param deleteUserCustomPermissionRequest
     * @return Result of the DeleteUserCustomPermission operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteUserCustomPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserCustomPermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteUserCustomPermissionResponse deleteUserCustomPermission(
            DeleteUserCustomPermissionRequest deleteUserCustomPermissionRequest) throws ConflictException, AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUserCustomPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteUserCustomPermissionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserCustomPermissionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserCustomPermissionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserCustomPermission");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteUserCustomPermissionRequest, DeleteUserCustomPermissionResponse>()
                            .withOperationName("DeleteUserCustomPermission").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteUserCustomPermissionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteUserCustomPermissionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a VPC connection.
     * </p>
     *
     * @param deleteVpcConnectionRequest
     * @return Result of the DeleteVPCConnection operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteVPCConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteVPCConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteVpcConnectionResponse deleteVPCConnection(DeleteVpcConnectionRequest deleteVpcConnectionRequest)
            throws AccessDeniedException, ConflictException, InvalidParameterValueException, ThrottlingException,
            ResourceNotFoundException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteVpcConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteVpcConnectionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVpcConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVpcConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVPCConnection");

            return clientHandler.execute(new ClientExecutionParams<DeleteVpcConnectionRequest, DeleteVpcConnectionResponse>()
                    .withOperationName("DeleteVPCConnection").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteVpcConnectionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteVpcConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the custom permissions profile that is applied to an account.
     * </p>
     *
     * @param describeAccountCustomPermissionRequest
     * @return Result of the DescribeAccountCustomPermission operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAccountCustomPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountCustomPermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccountCustomPermissionResponse describeAccountCustomPermission(
            DescribeAccountCustomPermissionRequest describeAccountCustomPermissionRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccountCustomPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAccountCustomPermissionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountCustomPermissionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAccountCustomPermissionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountCustomPermission");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountCustomPermissionRequest, DescribeAccountCustomPermissionResponse>()
                            .withOperationName("DescribeAccountCustomPermission").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAccountCustomPermissionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAccountCustomPermissionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the customizations associated with the provided Amazon Web Services account and Amazon Quick Sight
     * namespace. The Quick Sight console evaluates which customizations to apply by running this API operation with the
     * <code>Resolved</code> flag included.
     * </p>
     * <p>
     * To determine what customizations display when you run this command, it can help to visualize the relationship of
     * the entities involved.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Amazon Web Services account</code> - The Amazon Web Services account exists at the top of the hierarchy. It
     * has the potential to use all of the Amazon Web Services Regions and Amazon Web Services Services. When you
     * subscribe to Quick Sight, you choose one Amazon Web Services Region to use as your home Region. That's where your
     * free SPICE capacity is located. You can use Quick Sight in any supported Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Amazon Web Services Region</code> - You can sign in to Quick Sight in any Amazon Web Services Region. If
     * you have a user directory, it resides in us-east-1, which is US East (N. Virginia). Generally speaking, these
     * users have access to Quick Sight in any Amazon Web Services Region, unless they are constrained to a namespace.
     * </p>
     * <p>
     * To run the command in a different Amazon Web Services Region, you change your Region settings. If you're using
     * the CLI, you can use one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-options.html">command line
     * options</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html">named profiles</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Run <code>aws configure</code> to change your default Amazon Web Services Region. Use Enter to key the same
     * settings for your keys. For more information, see <a
     * href="https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html">Configuring the CLI</a>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>Namespace</code> - A Quick Sight namespace is a partition that contains users and assets (data sources,
     * datasets, dashboards, and so on). To access assets that are in a specific namespace, users and groups must also
     * be part of the same namespace. People who share a namespace are completely isolated from users and assets in
     * other namespaces, even if they are in the same Amazon Web Services account and Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Applied customizations</code> - Quick Sight customizations can apply to an Amazon Web Services account or
     * to a namespace. Settings that you apply to a namespace override settings that you apply to an Amazon Web Services
     * account.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeAccountCustomizationRequest
     * @return Result of the DescribeAccountCustomization operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAccountCustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccountCustomizationResponse describeAccountCustomization(
            DescribeAccountCustomizationRequest describeAccountCustomizationRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccountCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAccountCustomizationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountCustomizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountCustomizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountCustomization");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountCustomizationRequest, DescribeAccountCustomizationResponse>()
                            .withOperationName("DescribeAccountCustomization").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAccountCustomizationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAccountCustomizationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the settings that were used when your Quick Sight subscription was first created in this Amazon Web
     * Services account.
     * </p>
     *
     * @param describeAccountSettingsRequest
     * @return Result of the DescribeAccountSettings operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccountSettingsResponse describeAccountSettings(DescribeAccountSettingsRequest describeAccountSettingsRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccountSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAccountSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountSettingsRequest, DescribeAccountSettingsResponse>()
                            .withOperationName("DescribeAccountSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAccountSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAccountSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use the DescribeAccountSubscription operation to receive a description of an Quick Sight account's subscription.
     * A successful API call returns an <code>AccountInfo</code> object that includes an account's name, subscription
     * status, authentication type, edition, and notification email address.
     * </p>
     *
     * @param describeAccountSubscriptionRequest
     * @return Result of the DescribeAccountSubscription operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAccountSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccountSubscriptionResponse describeAccountSubscription(
            DescribeAccountSubscriptionRequest describeAccountSubscriptionRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccountSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAccountSubscriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountSubscriptionRequest, DescribeAccountSubscriptionResponse>()
                            .withOperationName("DescribeAccountSubscription").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAccountSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAccountSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves detailed information about an action connector, including its configuration, authentication settings,
     * enabled actions, and current status.
     * </p>
     *
     * @param describeActionConnectorRequest
     * @return Result of the DescribeActionConnector operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeActionConnector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeActionConnector"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeActionConnectorResponse describeActionConnector(DescribeActionConnectorRequest describeActionConnectorRequest)
            throws ThrottlingException, InvalidParameterValueException, InternalFailureException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeActionConnectorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeActionConnectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeActionConnectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeActionConnectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeActionConnector");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeActionConnectorRequest, DescribeActionConnectorResponse>()
                            .withOperationName("DescribeActionConnector").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeActionConnectorRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeActionConnectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the permissions configuration for an action connector, showing which users, groups, and namespaces have
     * access and what operations they can perform.
     * </p>
     *
     * @param describeActionConnectorPermissionsRequest
     * @return Result of the DescribeActionConnectorPermissions operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeActionConnectorPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeActionConnectorPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeActionConnectorPermissionsResponse describeActionConnectorPermissions(
            DescribeActionConnectorPermissionsRequest describeActionConnectorPermissionsRequest) throws ThrottlingException,
            InvalidParameterValueException, InternalFailureException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeActionConnectorPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeActionConnectorPermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeActionConnectorPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeActionConnectorPermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeActionConnectorPermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeActionConnectorPermissionsRequest, DescribeActionConnectorPermissionsResponse>()
                            .withOperationName("DescribeActionConnectorPermissions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeActionConnectorPermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeActionConnectorPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a summary of the metadata for an analysis.
     * </p>
     *
     * @param describeAnalysisRequest
     * @return Result of the DescribeAnalysis operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysis" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeAnalysisResponse describeAnalysis(DescribeAnalysisRequest describeAnalysisRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAnalysisResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeAnalysisResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAnalysisRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAnalysisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAnalysis");

            return clientHandler.execute(new ClientExecutionParams<DescribeAnalysisRequest, DescribeAnalysisResponse>()
                    .withOperationName("DescribeAnalysis").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeAnalysisRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAnalysisRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a detailed description of the definition of an analysis.
     * </p>
     * <note>
     * <p>
     * If you do not need to know details about the content of an Analysis, for instance if you are trying to check the
     * status of a recently created or updated Analysis, use the <a
     * href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAnalysis.html">
     * <code>DescribeAnalysis</code> </a> instead.
     * </p>
     * </note>
     *
     * @param describeAnalysisDefinitionRequest
     * @return Result of the DescribeAnalysisDefinition operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAnalysisDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysisDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAnalysisDefinitionResponse describeAnalysisDefinition(
            DescribeAnalysisDefinitionRequest describeAnalysisDefinitionRequest) throws InvalidParameterValueException,
            AccessDeniedException, ResourceExistsException, ResourceNotFoundException, ThrottlingException, ConflictException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAnalysisDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAnalysisDefinitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAnalysisDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAnalysisDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAnalysisDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAnalysisDefinitionRequest, DescribeAnalysisDefinitionResponse>()
                            .withOperationName("DescribeAnalysisDefinition").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAnalysisDefinitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAnalysisDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides the read and write permissions for an analysis.
     * </p>
     *
     * @param describeAnalysisPermissionsRequest
     * @return Result of the DescribeAnalysisPermissions operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAnalysisPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysisPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAnalysisPermissionsResponse describeAnalysisPermissions(
            DescribeAnalysisPermissionsRequest describeAnalysisPermissionsRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAnalysisPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAnalysisPermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAnalysisPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAnalysisPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAnalysisPermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAnalysisPermissionsRequest, DescribeAnalysisPermissionsResponse>()
                            .withOperationName("DescribeAnalysisPermissions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAnalysisPermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAnalysisPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes an existing export job.
     * </p>
     * <p>
     * Poll job descriptions after a job starts to know the status of the job. When a job succeeds, a URL is provided to
     * download the exported assets' data from. Download URLs are valid for five minutes after they are generated. You
     * can call the <code>DescribeAssetBundleExportJob</code> API for a new download URL as needed.
     * </p>
     * <p>
     * Job descriptions are available for 14 days after the job starts.
     * </p>
     *
     * @param describeAssetBundleExportJobRequest
     * @return Result of the DescribeAssetBundleExportJob operation returned by the service.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAssetBundleExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAssetBundleExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAssetBundleExportJobResponse describeAssetBundleExportJob(
            DescribeAssetBundleExportJobRequest describeAssetBundleExportJobRequest) throws UnsupportedUserEditionException,
            ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAssetBundleExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAssetBundleExportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAssetBundleExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAssetBundleExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAssetBundleExportJob");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAssetBundleExportJobRequest, DescribeAssetBundleExportJobResponse>()
                            .withOperationName("DescribeAssetBundleExportJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAssetBundleExportJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAssetBundleExportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes an existing import job.
     * </p>
     * <p>
     * Poll job descriptions after starting a job to know when it has succeeded or failed. Job descriptions are
     * available for 14 days after job starts.
     * </p>
     *
     * @param describeAssetBundleImportJobRequest
     * @return Result of the DescribeAssetBundleImportJob operation returned by the service.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAssetBundleImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAssetBundleImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAssetBundleImportJobResponse describeAssetBundleImportJob(
            DescribeAssetBundleImportJobRequest describeAssetBundleImportJobRequest) throws UnsupportedUserEditionException,
            ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAssetBundleImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAssetBundleImportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAssetBundleImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAssetBundleImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAssetBundleImportJob");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAssetBundleImportJobRequest, DescribeAssetBundleImportJobResponse>()
                            .withOperationName("DescribeAssetBundleImportJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAssetBundleImportJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAssetBundleImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a brand.
     * </p>
     *
     * @param describeBrandRequest
     * @return Result of the DescribeBrand operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidRequestException
     *         You don't have this feature activated for your account. To fix this issue, contact Amazon Web Services
     *         support.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InternalServerException
     *         An internal service exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeBrand
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeBrand" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeBrandResponse describeBrand(DescribeBrandRequest describeBrandRequest) throws ThrottlingException,
            InvalidRequestException, ResourceNotFoundException, ConflictException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeBrandResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeBrandResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBrandRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBrandRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBrand");

            return clientHandler.execute(new ClientExecutionParams<DescribeBrandRequest, DescribeBrandResponse>()
                    .withOperationName("DescribeBrand").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeBrandRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeBrandRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a brand assignment.
     * </p>
     *
     * @param describeBrandAssignmentRequest
     * @return Result of the DescribeBrandAssignment operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidRequestException
     *         You don't have this feature activated for your account. To fix this issue, contact Amazon Web Services
     *         support.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InternalServerException
     *         An internal service exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeBrandAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeBrandAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeBrandAssignmentResponse describeBrandAssignment(DescribeBrandAssignmentRequest describeBrandAssignmentRequest)
            throws ThrottlingException, InvalidRequestException, ResourceNotFoundException, ConflictException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeBrandAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeBrandAssignmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBrandAssignmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBrandAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBrandAssignment");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeBrandAssignmentRequest, DescribeBrandAssignmentResponse>()
                            .withOperationName("DescribeBrandAssignment").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeBrandAssignmentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeBrandAssignmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the published version of the brand.
     * </p>
     *
     * @param describeBrandPublishedVersionRequest
     * @return Result of the DescribeBrandPublishedVersion operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidRequestException
     *         You don't have this feature activated for your account. To fix this issue, contact Amazon Web Services
     *         support.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InternalServerException
     *         An internal service exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeBrandPublishedVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeBrandPublishedVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeBrandPublishedVersionResponse describeBrandPublishedVersion(
            DescribeBrandPublishedVersionRequest describeBrandPublishedVersionRequest) throws ThrottlingException,
            InvalidRequestException, ResourceNotFoundException, ConflictException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeBrandPublishedVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeBrandPublishedVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBrandPublishedVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeBrandPublishedVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBrandPublishedVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeBrandPublishedVersionRequest, DescribeBrandPublishedVersionResponse>()
                            .withOperationName("DescribeBrandPublishedVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeBrandPublishedVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeBrandPublishedVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a custom permissions profile.
     * </p>
     *
     * @param describeCustomPermissionsRequest
     * @return Result of the DescribeCustomPermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeCustomPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeCustomPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeCustomPermissionsResponse describeCustomPermissions(
            DescribeCustomPermissionsRequest describeCustomPermissionsRequest) throws AccessDeniedException,
            ResourceNotFoundException, InvalidParameterValueException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeCustomPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeCustomPermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCustomPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCustomPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCustomPermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeCustomPermissionsRequest, DescribeCustomPermissionsResponse>()
                            .withOperationName("DescribeCustomPermissions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeCustomPermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeCustomPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a summary for a dashboard.
     * </p>
     *
     * @param describeDashboardRequest
     * @return Result of the DescribeDashboard operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDashboardResponse describeDashboard(DescribeDashboardRequest describeDashboardRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDashboardResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeDashboardResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDashboardRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDashboard");

            return clientHandler.execute(new ClientExecutionParams<DescribeDashboardRequest, DescribeDashboardResponse>()
                    .withOperationName("DescribeDashboard").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDashboardRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDashboardRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a detailed description of the definition of a dashboard.
     * </p>
     * <note>
     * <p>
     * If you do not need to know details about the content of a dashboard, for instance if you are trying to check the
     * status of a recently created or updated dashboard, use the <a
     * href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDashboard.html">
     * <code>DescribeDashboard</code> </a> instead.
     * </p>
     * </note>
     *
     * @param describeDashboardDefinitionRequest
     * @return Result of the DescribeDashboardDefinition operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDashboardDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDashboardDefinitionResponse describeDashboardDefinition(
            DescribeDashboardDefinitionRequest describeDashboardDefinitionRequest) throws InvalidParameterValueException,
            AccessDeniedException, ResourceExistsException, ResourceNotFoundException, ThrottlingException, ConflictException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDashboardDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDashboardDefinitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDashboardDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDashboardDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDashboardDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDashboardDefinitionRequest, DescribeDashboardDefinitionResponse>()
                            .withOperationName("DescribeDashboardDefinition").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDashboardDefinitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDashboardDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes read and write permissions for a dashboard.
     * </p>
     *
     * @param describeDashboardPermissionsRequest
     * @return Result of the DescribeDashboardPermissions operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDashboardPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDashboardPermissionsResponse describeDashboardPermissions(
            DescribeDashboardPermissionsRequest describeDashboardPermissionsRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDashboardPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDashboardPermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDashboardPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDashboardPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDashboardPermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDashboardPermissionsRequest, DescribeDashboardPermissionsResponse>()
                            .withOperationName("DescribeDashboardPermissions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDashboardPermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDashboardPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes an existing snapshot job.
     * </p>
     * <p>
     * Poll job descriptions after a job starts to know the status of the job. For information on available status
     * codes, see <code>JobStatus</code>.
     * </p>
     *
     * @param describeDashboardSnapshotJobRequest
     * @return Result of the DescribeDashboardSnapshotJob operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDashboardSnapshotJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDashboardSnapshotJobResponse describeDashboardSnapshotJob(
            DescribeDashboardSnapshotJobRequest describeDashboardSnapshotJobRequest) throws AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDashboardSnapshotJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDashboardSnapshotJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDashboardSnapshotJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDashboardSnapshotJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDashboardSnapshotJob");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDashboardSnapshotJobRequest, DescribeDashboardSnapshotJobResponse>()
                            .withOperationName("DescribeDashboardSnapshotJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDashboardSnapshotJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDashboardSnapshotJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the result of an existing snapshot job that has finished running.
     * </p>
     * <p>
     * A finished snapshot job will return a <code>COMPLETED</code> or <code>FAILED</code> status when you poll the job
     * with a <code>DescribeDashboardSnapshotJob</code> API call.
     * </p>
     * <p>
     * If the job has not finished running, this operation returns a message that says
     * <code>Dashboard Snapshot Job with id &lt;SnapshotjobId&gt; has not reached a terminal state.</code>.
     * </p>
     *
     * @param describeDashboardSnapshotJobResultRequest
     * @return Result of the DescribeDashboardSnapshotJobResult operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon Quick Suite subscription where the
     *         edition doesn't include support for that operation. Amazon Quick Suite currently has Standard Edition and
     *         Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDashboardSnapshotJobResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardSnapshotJobResult"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDashboardSnapshotJobResultResponse describeDashboardSnapshotJobResult(
            DescribeDashboardSnapshotJobResultRequest describeDashboardSnapshotJobResultRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException,
            PreconditionNotMetException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDashboardSnapshotJobResultResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDashboardSnapshotJobResultResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDashboardSnapshotJobResultRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDashboardSnapshotJobResultRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDashboardSnapshotJobResult");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDashboardSnapshotJobResultRequest, DescribeDashboardSnapshotJobResultResponse>()
                            .withOperationName("DescribeDashboardSnapshotJobResult").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDashboardSnapshotJobResultRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDashboardSnapshotJobResultRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes an existing dashboard QA configuration.
     * </p>
     *
     * @param describeDashboardsQaConfigurationRequest
     * @return Result of the DescribeDashboardsQAConfiguration operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDashboardsQAConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardsQAConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDashboardsQaConfigurationResponse describeDashboardsQAConfiguration(
            DescribeDashboardsQaConfigurationRequest describeDashboardsQaConfigurationRequest) throws AccessDeniedException,
            ConflictException, InvalidParameterValueException, ThrottlingException, ResourceNotFoundException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDashboardsQaConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDashboardsQaConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDashboardsQaConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDashboardsQaConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDashboardsQAConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDashboardsQaConfigurationRequest, DescribeDashboardsQaConfigurationResponse>()
                            .withOperationName("DescribeDashboardsQAConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDashboardsQaConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDashboardsQaConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a dataset. This operation doesn't support datasets that include uploaded files as a source.
     * </p>
     *
     * @param describeDataSetRequest
     * @return Result of the DescribeDataSet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDataSetResponse describeDataSet(DescribeDataSetRequest describeDataSetRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, ResourceNotFoundException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDataSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeDataSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDataSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDataSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSet");

            return clientHandler.execute(new ClientExecutionParams<DescribeDataSetRequest, DescribeDataSetResponse>()
                    .withOperationName("DescribeDataSet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDataSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDataSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the permissions on a dataset.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.
     * </p>
     *
     * @param describeDataSetPermissionsRequest
     * @return Result of the DescribeDataSetPermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDataSetPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDataSetPermissionsResponse describeDataSetPermissions(
            DescribeDataSetPermissionsRequest describeDataSetPermissionsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, ResourceNotFoundException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDataSetPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDataSetPermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDataSetPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDataSetPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSetPermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDataSetPermissionsRequest, DescribeDataSetPermissionsResponse>()
                            .withOperationName("DescribeDataSetPermissions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDataSetPermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDataSetPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the refresh properties of a dataset.
     * </p>
     *
     * @param describeDataSetRefreshPropertiesRequest
     * @return Result of the DescribeDataSetRefreshProperties operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDataSetRefreshProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetRefreshProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDataSetRefreshPropertiesResponse describeDataSetRefreshProperties(
            DescribeDataSetRefreshPropertiesRequest describeDataSetRefreshPropertiesRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, LimitExceededException,
            PreconditionNotMetException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDataSetRefreshPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDataSetRefreshPropertiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDataSetRefreshPropertiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDataSetRefreshPropertiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSetRefreshProperties");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDataSetRefreshPropertiesRequest, DescribeDataSetRefreshPropertiesResponse>()
                            .withOperationName("DescribeDataSetRefreshProperties").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDataSetRefreshPropertiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDataSetRefreshPropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a data source.
     * </p>
     *
     * @param describeDataSourceRequest
     * @return Result of the DescribeDataSource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDataSourceResponse describeDataSource(DescribeDataSourceRequest describeDataSourceRequest)
            throws AccessDeniedException, InvalidParameterValueException, ThrottlingException, ResourceNotFoundException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDataSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "QuickSightUserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).build());
            case "SessionLifetimeInMinutesInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(503)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidDataSetParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDataSetParameterValueException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDataSetParameterValueException::builder).build());
            case "InvalidParameterValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(409)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "IdentityTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).build());
            case "PreconditionNotMetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionNotMetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PreconditionNotMetException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(401)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "ResourceExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceExistsException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceExistsException::builder).build());
            case "ConcurrentUpdatingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).build());
            case "InternalFailureException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalFailureException::builder).build());
            case "DomainNotWhitelistedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).build());
            case "CustomerManagedKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CustomerManagedKeyUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CustomerManagedKeyUnavailableException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "UnsupportedPricingPlanException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).build());
            case "UnsupportedUserEditionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException").httpStatusCode(403)
                        .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSource");

            return clientHandler.execute(new ClientExecutionParams<DescribeDataSourceRequest, DescribeDataSourceResponse>()
                    .withOperationName("DescribeDataSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDataSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDataSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the resource permissions for a data source.
     * </p>
     *
     * @param describeDataSourcePermissionsRequest
     * @return Result of the DescribeDataSourcePermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon Quick
     *         Sight service, that your policies have the correct permissions, and that you are using the correct
     *         credentials.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDataSou