/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A transform operation that groups rows by specified columns and applies aggregation functions to calculate summary
 * values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregateOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregateOperation.Builder, AggregateOperation> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(AggregateOperation::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<TransformOperationSource> SOURCE_FIELD = SdkField
            .<TransformOperationSource> builder(MarshallingType.SDK_POJO).memberName("Source")
            .getter(getter(AggregateOperation::source)).setter(setter(Builder::source))
            .constructor(TransformOperationSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<List<String>> GROUP_BY_COLUMN_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GroupByColumnNames")
            .getter(getter(AggregateOperation::groupByColumnNames))
            .setter(setter(Builder::groupByColumnNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByColumnNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Aggregation>> AGGREGATIONS_FIELD = SdkField
            .<List<Aggregation>> builder(MarshallingType.LIST)
            .memberName("Aggregations")
            .getter(getter(AggregateOperation::aggregations))
            .setter(setter(Builder::aggregations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Aggregation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Aggregation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, SOURCE_FIELD,
            GROUP_BY_COLUMN_NAMES_FIELD, AGGREGATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String alias;

    private final TransformOperationSource source;

    private final List<String> groupByColumnNames;

    private final List<Aggregation> aggregations;

    private AggregateOperation(BuilderImpl builder) {
        this.alias = builder.alias;
        this.source = builder.source;
        this.groupByColumnNames = builder.groupByColumnNames;
        this.aggregations = builder.aggregations;
    }

    /**
     * <p>
     * Alias for this operation.
     * </p>
     * 
     * @return Alias for this operation.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The source transform operation that provides input data for the aggregation.
     * </p>
     * 
     * @return The source transform operation that provides input data for the aggregation.
     */
    public final TransformOperationSource source() {
        return source;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupByColumnNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupByColumnNames() {
        return groupByColumnNames != null && !(groupByColumnNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of column names to group by when performing the aggregation. Rows with the same values in these columns
     * will be grouped together.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupByColumnNames} method.
     * </p>
     * 
     * @return The list of column names to group by when performing the aggregation. Rows with the same values in these
     *         columns will be grouped together.
     */
    public final List<String> groupByColumnNames() {
        return groupByColumnNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the Aggregations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAggregations() {
        return aggregations != null && !(aggregations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of aggregation functions to apply to the grouped data, such as <code>SUM</code>, <code>COUNT</code>, or
     * <code>AVERAGE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregations} method.
     * </p>
     * 
     * @return The list of aggregation functions to apply to the grouped data, such as <code>SUM</code>,
     *         <code>COUNT</code>, or <code>AVERAGE</code>.
     */
    public final List<Aggregation> aggregations() {
        return aggregations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupByColumnNames() ? groupByColumnNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregations() ? aggregations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateOperation)) {
            return false;
        }
        AggregateOperation other = (AggregateOperation) obj;
        return Objects.equals(alias(), other.alias()) && Objects.equals(source(), other.source())
                && hasGroupByColumnNames() == other.hasGroupByColumnNames()
                && Objects.equals(groupByColumnNames(), other.groupByColumnNames())
                && hasAggregations() == other.hasAggregations() && Objects.equals(aggregations(), other.aggregations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregateOperation").add("Alias", alias()).add("Source", source())
                .add("GroupByColumnNames", hasGroupByColumnNames() ? groupByColumnNames() : null)
                .add("Aggregations", hasAggregations() ? aggregations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "GroupByColumnNames":
            return Optional.ofNullable(clazz.cast(groupByColumnNames()));
        case "Aggregations":
            return Optional.ofNullable(clazz.cast(aggregations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Alias", ALIAS_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("GroupByColumnNames", GROUP_BY_COLUMN_NAMES_FIELD);
        map.put("Aggregations", AGGREGATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregateOperation, T> g) {
        return obj -> g.apply((AggregateOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregateOperation> {
        /**
         * <p>
         * Alias for this operation.
         * </p>
         * 
         * @param alias
         *        Alias for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The source transform operation that provides input data for the aggregation.
         * </p>
         * 
         * @param source
         *        The source transform operation that provides input data for the aggregation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(TransformOperationSource source);

        /**
         * <p>
         * The source transform operation that provides input data for the aggregation.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransformOperationSource.Builder}
         * avoiding the need to create one manually via {@link TransformOperationSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransformOperationSource.Builder#build()} is called immediately
         * and its result is passed to {@link #source(TransformOperationSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link TransformOperationSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(TransformOperationSource)
         */
        default Builder source(Consumer<TransformOperationSource.Builder> source) {
            return source(TransformOperationSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The list of column names to group by when performing the aggregation. Rows with the same values in these
         * columns will be grouped together.
         * </p>
         * 
         * @param groupByColumnNames
         *        The list of column names to group by when performing the aggregation. Rows with the same values in
         *        these columns will be grouped together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByColumnNames(Collection<String> groupByColumnNames);

        /**
         * <p>
         * The list of column names to group by when performing the aggregation. Rows with the same values in these
         * columns will be grouped together.
         * </p>
         * 
         * @param groupByColumnNames
         *        The list of column names to group by when performing the aggregation. Rows with the same values in
         *        these columns will be grouped together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByColumnNames(String... groupByColumnNames);

        /**
         * <p>
         * The list of aggregation functions to apply to the grouped data, such as <code>SUM</code>, <code>COUNT</code>,
         * or <code>AVERAGE</code>.
         * </p>
         * 
         * @param aggregations
         *        The list of aggregation functions to apply to the grouped data, such as <code>SUM</code>,
         *        <code>COUNT</code>, or <code>AVERAGE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregations(Collection<Aggregation> aggregations);

        /**
         * <p>
         * The list of aggregation functions to apply to the grouped data, such as <code>SUM</code>, <code>COUNT</code>,
         * or <code>AVERAGE</code>.
         * </p>
         * 
         * @param aggregations
         *        The list of aggregation functions to apply to the grouped data, such as <code>SUM</code>,
         *        <code>COUNT</code>, or <code>AVERAGE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregations(Aggregation... aggregations);

        /**
         * <p>
         * The list of aggregation functions to apply to the grouped data, such as <code>SUM</code>, <code>COUNT</code>,
         * or <code>AVERAGE</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.Aggregation.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.Aggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.Aggregation.Builder#build()} is called immediately
         * and its result is passed to {@link #aggregations(List<Aggregation>)}.
         * 
         * @param aggregations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.Aggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregations(java.util.Collection<Aggregation>)
         */
        Builder aggregations(Consumer<Aggregation.Builder>... aggregations);
    }

    static final class BuilderImpl implements Builder {
        private String alias;

        private TransformOperationSource source;

        private List<String> groupByColumnNames = DefaultSdkAutoConstructList.getInstance();

        private List<Aggregation> aggregations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateOperation model) {
            alias(model.alias);
            source(model.source);
            groupByColumnNames(model.groupByColumnNames);
            aggregations(model.aggregations);
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final TransformOperationSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(TransformOperationSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(TransformOperationSource source) {
            this.source = source;
            return this;
        }

        public final Collection<String> getGroupByColumnNames() {
            if (groupByColumnNames instanceof SdkAutoConstructList) {
                return null;
            }
            return groupByColumnNames;
        }

        public final void setGroupByColumnNames(Collection<String> groupByColumnNames) {
            this.groupByColumnNames = GroupByColumnNameListCopier.copy(groupByColumnNames);
        }

        @Override
        public final Builder groupByColumnNames(Collection<String> groupByColumnNames) {
            this.groupByColumnNames = GroupByColumnNameListCopier.copy(groupByColumnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByColumnNames(String... groupByColumnNames) {
            groupByColumnNames(Arrays.asList(groupByColumnNames));
            return this;
        }

        public final List<Aggregation.Builder> getAggregations() {
            List<Aggregation.Builder> result = AggregationListCopier.copyToBuilder(this.aggregations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregations(Collection<Aggregation.BuilderImpl> aggregations) {
            this.aggregations = AggregationListCopier.copyFromBuilder(aggregations);
        }

        @Override
        public final Builder aggregations(Collection<Aggregation> aggregations) {
            this.aggregations = AggregationListCopier.copy(aggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregations(Aggregation... aggregations) {
            aggregations(Arrays.asList(aggregations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregations(Consumer<Aggregation.Builder>... aggregations) {
            aggregations(Stream.of(aggregations).map(c -> Aggregation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AggregateOperation build() {
            return new AggregateOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
