/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines an aggregation function to be applied to grouped data, creating a new column with the calculated result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Aggregation implements SdkPojo, Serializable, ToCopyableBuilder<Aggregation.Builder, Aggregation> {
    private static final SdkField<DataPrepAggregationFunction> AGGREGATION_FUNCTION_FIELD = SdkField
            .<DataPrepAggregationFunction> builder(MarshallingType.SDK_POJO).memberName("AggregationFunction")
            .getter(getter(Aggregation::aggregationFunction)).setter(setter(Builder::aggregationFunction))
            .constructor(DataPrepAggregationFunction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunction").build())
            .build();

    private static final SdkField<String> NEW_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewColumnName").getter(getter(Aggregation::newColumnName)).setter(setter(Builder::newColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewColumnName").build()).build();

    private static final SdkField<String> NEW_COLUMN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewColumnId").getter(getter(Aggregation::newColumnId)).setter(setter(Builder::newColumnId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewColumnId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_FUNCTION_FIELD,
            NEW_COLUMN_NAME_FIELD, NEW_COLUMN_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataPrepAggregationFunction aggregationFunction;

    private final String newColumnName;

    private final String newColumnId;

    private Aggregation(BuilderImpl builder) {
        this.aggregationFunction = builder.aggregationFunction;
        this.newColumnName = builder.newColumnName;
        this.newColumnId = builder.newColumnId;
    }

    /**
     * <p>
     * The aggregation function to apply, such as <code>SUM</code>, <code>COUNT</code>, <code>AVERAGE</code>,
     * <code>MIN</code>, <code>MAX</code>
     * </p>
     * 
     * @return The aggregation function to apply, such as <code>SUM</code>, <code>COUNT</code>, <code>AVERAGE</code>,
     *         <code>MIN</code>, <code>MAX</code>
     */
    public final DataPrepAggregationFunction aggregationFunction() {
        return aggregationFunction;
    }

    /**
     * <p>
     * The name for the new column that will contain the aggregated values.
     * </p>
     * 
     * @return The name for the new column that will contain the aggregated values.
     */
    public final String newColumnName() {
        return newColumnName;
    }

    /**
     * <p>
     * A unique identifier for the new column that will contain the aggregated values.
     * </p>
     * 
     * @return A unique identifier for the new column that will contain the aggregated values.
     */
    public final String newColumnId() {
        return newColumnId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aggregationFunction());
        hashCode = 31 * hashCode + Objects.hashCode(newColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(newColumnId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Aggregation)) {
            return false;
        }
        Aggregation other = (Aggregation) obj;
        return Objects.equals(aggregationFunction(), other.aggregationFunction())
                && Objects.equals(newColumnName(), other.newColumnName()) && Objects.equals(newColumnId(), other.newColumnId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Aggregation").add("AggregationFunction", aggregationFunction())
                .add("NewColumnName", newColumnName()).add("NewColumnId", newColumnId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AggregationFunction":
            return Optional.ofNullable(clazz.cast(aggregationFunction()));
        case "NewColumnName":
            return Optional.ofNullable(clazz.cast(newColumnName()));
        case "NewColumnId":
            return Optional.ofNullable(clazz.cast(newColumnId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AggregationFunction", AGGREGATION_FUNCTION_FIELD);
        map.put("NewColumnName", NEW_COLUMN_NAME_FIELD);
        map.put("NewColumnId", NEW_COLUMN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Aggregation, T> g) {
        return obj -> g.apply((Aggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Aggregation> {
        /**
         * <p>
         * The aggregation function to apply, such as <code>SUM</code>, <code>COUNT</code>, <code>AVERAGE</code>,
         * <code>MIN</code>, <code>MAX</code>
         * </p>
         * 
         * @param aggregationFunction
         *        The aggregation function to apply, such as <code>SUM</code>, <code>COUNT</code>, <code>AVERAGE</code>,
         *        <code>MIN</code>, <code>MAX</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationFunction(DataPrepAggregationFunction aggregationFunction);

        /**
         * <p>
         * The aggregation function to apply, such as <code>SUM</code>, <code>COUNT</code>, <code>AVERAGE</code>,
         * <code>MIN</code>, <code>MAX</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link DataPrepAggregationFunction.Builder}
         * avoiding the need to create one manually via {@link DataPrepAggregationFunction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataPrepAggregationFunction.Builder#build()} is called
         * immediately and its result is passed to {@link #aggregationFunction(DataPrepAggregationFunction)}.
         * 
         * @param aggregationFunction
         *        a consumer that will call methods on {@link DataPrepAggregationFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregationFunction(DataPrepAggregationFunction)
         */
        default Builder aggregationFunction(Consumer<DataPrepAggregationFunction.Builder> aggregationFunction) {
            return aggregationFunction(DataPrepAggregationFunction.builder().applyMutation(aggregationFunction).build());
        }

        /**
         * <p>
         * The name for the new column that will contain the aggregated values.
         * </p>
         * 
         * @param newColumnName
         *        The name for the new column that will contain the aggregated values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newColumnName(String newColumnName);

        /**
         * <p>
         * A unique identifier for the new column that will contain the aggregated values.
         * </p>
         * 
         * @param newColumnId
         *        A unique identifier for the new column that will contain the aggregated values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newColumnId(String newColumnId);
    }

    static final class BuilderImpl implements Builder {
        private DataPrepAggregationFunction aggregationFunction;

        private String newColumnName;

        private String newColumnId;

        private BuilderImpl() {
        }

        private BuilderImpl(Aggregation model) {
            aggregationFunction(model.aggregationFunction);
            newColumnName(model.newColumnName);
            newColumnId(model.newColumnId);
        }

        public final DataPrepAggregationFunction.Builder getAggregationFunction() {
            return aggregationFunction != null ? aggregationFunction.toBuilder() : null;
        }

        public final void setAggregationFunction(DataPrepAggregationFunction.BuilderImpl aggregationFunction) {
            this.aggregationFunction = aggregationFunction != null ? aggregationFunction.build() : null;
        }

        @Override
        public final Builder aggregationFunction(DataPrepAggregationFunction aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
            return this;
        }

        public final String getNewColumnName() {
            return newColumnName;
        }

        public final void setNewColumnName(String newColumnName) {
            this.newColumnName = newColumnName;
        }

        @Override
        public final Builder newColumnName(String newColumnName) {
            this.newColumnName = newColumnName;
            return this;
        }

        public final String getNewColumnId() {
            return newColumnId;
        }

        public final void setNewColumnId(String newColumnId) {
            this.newColumnId = newColumnId;
        }

        @Override
        public final Builder newColumnId(String newColumnId) {
            this.newColumnId = newColumnId;
            return this;
        }

        @Override
        public Aggregation build() {
            return new Aggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
