/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of Amazon Q feature configurations in an embedded Quick Sight dashboard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmazonQInQuickSightDashboardConfigurations implements SdkPojo, Serializable,
        ToCopyableBuilder<AmazonQInQuickSightDashboardConfigurations.Builder, AmazonQInQuickSightDashboardConfigurations> {
    private static final SdkField<ExecutiveSummaryConfigurations> EXECUTIVE_SUMMARY_FIELD = SdkField
            .<ExecutiveSummaryConfigurations> builder(MarshallingType.SDK_POJO).memberName("ExecutiveSummary")
            .getter(getter(AmazonQInQuickSightDashboardConfigurations::executiveSummary))
            .setter(setter(Builder::executiveSummary)).constructor(ExecutiveSummaryConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutiveSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTIVE_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ExecutiveSummaryConfigurations executiveSummary;

    private AmazonQInQuickSightDashboardConfigurations(BuilderImpl builder) {
        this.executiveSummary = builder.executiveSummary;
    }

    /**
     * <p>
     * A generated executive summary of an embedded Quick Sight dashboard.
     * </p>
     * 
     * @return A generated executive summary of an embedded Quick Sight dashboard.
     */
    public final ExecutiveSummaryConfigurations executiveSummary() {
        return executiveSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executiveSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonQInQuickSightDashboardConfigurations)) {
            return false;
        }
        AmazonQInQuickSightDashboardConfigurations other = (AmazonQInQuickSightDashboardConfigurations) obj;
        return Objects.equals(executiveSummary(), other.executiveSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmazonQInQuickSightDashboardConfigurations").add("ExecutiveSummary", executiveSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutiveSummary":
            return Optional.ofNullable(clazz.cast(executiveSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExecutiveSummary", EXECUTIVE_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AmazonQInQuickSightDashboardConfigurations, T> g) {
        return obj -> g.apply((AmazonQInQuickSightDashboardConfigurations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmazonQInQuickSightDashboardConfigurations> {
        /**
         * <p>
         * A generated executive summary of an embedded Quick Sight dashboard.
         * </p>
         * 
         * @param executiveSummary
         *        A generated executive summary of an embedded Quick Sight dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executiveSummary(ExecutiveSummaryConfigurations executiveSummary);

        /**
         * <p>
         * A generated executive summary of an embedded Quick Sight dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutiveSummaryConfigurations.Builder}
         * avoiding the need to create one manually via {@link ExecutiveSummaryConfigurations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutiveSummaryConfigurations.Builder#build()} is called
         * immediately and its result is passed to {@link #executiveSummary(ExecutiveSummaryConfigurations)}.
         * 
         * @param executiveSummary
         *        a consumer that will call methods on {@link ExecutiveSummaryConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executiveSummary(ExecutiveSummaryConfigurations)
         */
        default Builder executiveSummary(Consumer<ExecutiveSummaryConfigurations.Builder> executiveSummary) {
            return executiveSummary(ExecutiveSummaryConfigurations.builder().applyMutation(executiveSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ExecutiveSummaryConfigurations executiveSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonQInQuickSightDashboardConfigurations model) {
            executiveSummary(model.executiveSummary);
        }

        public final ExecutiveSummaryConfigurations.Builder getExecutiveSummary() {
            return executiveSummary != null ? executiveSummary.toBuilder() : null;
        }

        public final void setExecutiveSummary(ExecutiveSummaryConfigurations.BuilderImpl executiveSummary) {
            this.executiveSummary = executiveSummary != null ? executiveSummary.build() : null;
        }

        @Override
        public final Builder executiveSummary(ExecutiveSummaryConfigurations executiveSummary) {
            this.executiveSummary = executiveSummary;
            return this;
        }

        @Override
        public AmazonQInQuickSightDashboardConfigurations build() {
            return new AmazonQInQuickSightDashboardConfigurations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
