/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AnalysisSummaryListCopier {
    static List<AnalysisSummary> copy(Collection<? extends AnalysisSummary> analysisSummaryListParam) {
        List<AnalysisSummary> list;
        if (analysisSummaryListParam == null || analysisSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AnalysisSummary> modifiableList = new ArrayList<>(analysisSummaryListParam.size());
            analysisSummaryListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AnalysisSummary> copyFromBuilder(Collection<? extends AnalysisSummary.Builder> analysisSummaryListParam) {
        List<AnalysisSummary> list;
        if (analysisSummaryListParam == null || analysisSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AnalysisSummary> modifiableList = new ArrayList<>(analysisSummaryListParam.size());
            analysisSummaryListParam.forEach(entry -> {
                AnalysisSummary member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AnalysisSummary.Builder> copyToBuilder(Collection<? extends AnalysisSummary> analysisSummaryListParam) {
        List<AnalysisSummary.Builder> list;
        if (analysisSummaryListParam == null || analysisSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AnalysisSummary.Builder> modifiableList = new ArrayList<>(analysisSummaryListParam.size());
            analysisSummaryListParam.forEach(entry -> {
                AnalysisSummary.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
