/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A transform operation that combines rows from two data sources by stacking them vertically (union operation).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppendOperation implements SdkPojo, Serializable, ToCopyableBuilder<AppendOperation.Builder, AppendOperation> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(AppendOperation::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<TransformOperationSource> FIRST_SOURCE_FIELD = SdkField
            .<TransformOperationSource> builder(MarshallingType.SDK_POJO).memberName("FirstSource")
            .getter(getter(AppendOperation::firstSource)).setter(setter(Builder::firstSource))
            .constructor(TransformOperationSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstSource").build()).build();

    private static final SdkField<TransformOperationSource> SECOND_SOURCE_FIELD = SdkField
            .<TransformOperationSource> builder(MarshallingType.SDK_POJO).memberName("SecondSource")
            .getter(getter(AppendOperation::secondSource)).setter(setter(Builder::secondSource))
            .constructor(TransformOperationSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondSource").build()).build();

    private static final SdkField<List<AppendedColumn>> APPENDED_COLUMNS_FIELD = SdkField
            .<List<AppendedColumn>> builder(MarshallingType.LIST)
            .memberName("AppendedColumns")
            .getter(getter(AppendOperation::appendedColumns))
            .setter(setter(Builder::appendedColumns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppendedColumns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppendedColumn> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppendedColumn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD,
            FIRST_SOURCE_FIELD, SECOND_SOURCE_FIELD, APPENDED_COLUMNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String alias;

    private final TransformOperationSource firstSource;

    private final TransformOperationSource secondSource;

    private final List<AppendedColumn> appendedColumns;

    private AppendOperation(BuilderImpl builder) {
        this.alias = builder.alias;
        this.firstSource = builder.firstSource;
        this.secondSource = builder.secondSource;
        this.appendedColumns = builder.appendedColumns;
    }

    /**
     * <p>
     * Alias for this operation.
     * </p>
     * 
     * @return Alias for this operation.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The first data source to be included in the append operation.
     * </p>
     * 
     * @return The first data source to be included in the append operation.
     */
    public final TransformOperationSource firstSource() {
        return firstSource;
    }

    /**
     * <p>
     * The second data source to be appended to the first source.
     * </p>
     * 
     * @return The second data source to be appended to the first source.
     */
    public final TransformOperationSource secondSource() {
        return secondSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppendedColumns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAppendedColumns() {
        return appendedColumns != null && !(appendedColumns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of columns to include in the appended result, mapping columns from both sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppendedColumns} method.
     * </p>
     * 
     * @return The list of columns to include in the appended result, mapping columns from both sources.
     */
    public final List<AppendedColumn> appendedColumns() {
        return appendedColumns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(firstSource());
        hashCode = 31 * hashCode + Objects.hashCode(secondSource());
        hashCode = 31 * hashCode + Objects.hashCode(hasAppendedColumns() ? appendedColumns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppendOperation)) {
            return false;
        }
        AppendOperation other = (AppendOperation) obj;
        return Objects.equals(alias(), other.alias()) && Objects.equals(firstSource(), other.firstSource())
                && Objects.equals(secondSource(), other.secondSource()) && hasAppendedColumns() == other.hasAppendedColumns()
                && Objects.equals(appendedColumns(), other.appendedColumns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppendOperation").add("Alias", alias()).add("FirstSource", firstSource())
                .add("SecondSource", secondSource()).add("AppendedColumns", hasAppendedColumns() ? appendedColumns() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "FirstSource":
            return Optional.ofNullable(clazz.cast(firstSource()));
        case "SecondSource":
            return Optional.ofNullable(clazz.cast(secondSource()));
        case "AppendedColumns":
            return Optional.ofNullable(clazz.cast(appendedColumns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Alias", ALIAS_FIELD);
        map.put("FirstSource", FIRST_SOURCE_FIELD);
        map.put("SecondSource", SECOND_SOURCE_FIELD);
        map.put("AppendedColumns", APPENDED_COLUMNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppendOperation, T> g) {
        return obj -> g.apply((AppendOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppendOperation> {
        /**
         * <p>
         * Alias for this operation.
         * </p>
         * 
         * @param alias
         *        Alias for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The first data source to be included in the append operation.
         * </p>
         * 
         * @param firstSource
         *        The first data source to be included in the append operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstSource(TransformOperationSource firstSource);

        /**
         * <p>
         * The first data source to be included in the append operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransformOperationSource.Builder}
         * avoiding the need to create one manually via {@link TransformOperationSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransformOperationSource.Builder#build()} is called immediately
         * and its result is passed to {@link #firstSource(TransformOperationSource)}.
         * 
         * @param firstSource
         *        a consumer that will call methods on {@link TransformOperationSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firstSource(TransformOperationSource)
         */
        default Builder firstSource(Consumer<TransformOperationSource.Builder> firstSource) {
            return firstSource(TransformOperationSource.builder().applyMutation(firstSource).build());
        }

        /**
         * <p>
         * The second data source to be appended to the first source.
         * </p>
         * 
         * @param secondSource
         *        The second data source to be appended to the first source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondSource(TransformOperationSource secondSource);

        /**
         * <p>
         * The second data source to be appended to the first source.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransformOperationSource.Builder}
         * avoiding the need to create one manually via {@link TransformOperationSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransformOperationSource.Builder#build()} is called immediately
         * and its result is passed to {@link #secondSource(TransformOperationSource)}.
         * 
         * @param secondSource
         *        a consumer that will call methods on {@link TransformOperationSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondSource(TransformOperationSource)
         */
        default Builder secondSource(Consumer<TransformOperationSource.Builder> secondSource) {
            return secondSource(TransformOperationSource.builder().applyMutation(secondSource).build());
        }

        /**
         * <p>
         * The list of columns to include in the appended result, mapping columns from both sources.
         * </p>
         * 
         * @param appendedColumns
         *        The list of columns to include in the appended result, mapping columns from both sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appendedColumns(Collection<AppendedColumn> appendedColumns);

        /**
         * <p>
         * The list of columns to include in the appended result, mapping columns from both sources.
         * </p>
         * 
         * @param appendedColumns
         *        The list of columns to include in the appended result, mapping columns from both sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appendedColumns(AppendedColumn... appendedColumns);

        /**
         * <p>
         * The list of columns to include in the appended result, mapping columns from both sources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AppendedColumn.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.AppendedColumn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AppendedColumn.Builder#build()} is called immediately
         * and its result is passed to {@link #appendedColumns(List<AppendedColumn>)}.
         * 
         * @param appendedColumns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AppendedColumn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appendedColumns(java.util.Collection<AppendedColumn>)
         */
        Builder appendedColumns(Consumer<AppendedColumn.Builder>... appendedColumns);
    }

    static final class BuilderImpl implements Builder {
        private String alias;

        private TransformOperationSource firstSource;

        private TransformOperationSource secondSource;

        private List<AppendedColumn> appendedColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppendOperation model) {
            alias(model.alias);
            firstSource(model.firstSource);
            secondSource(model.secondSource);
            appendedColumns(model.appendedColumns);
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final TransformOperationSource.Builder getFirstSource() {
            return firstSource != null ? firstSource.toBuilder() : null;
        }

        public final void setFirstSource(TransformOperationSource.BuilderImpl firstSource) {
            this.firstSource = firstSource != null ? firstSource.build() : null;
        }

        @Override
        public final Builder firstSource(TransformOperationSource firstSource) {
            this.firstSource = firstSource;
            return this;
        }

        public final TransformOperationSource.Builder getSecondSource() {
            return secondSource != null ? secondSource.toBuilder() : null;
        }

        public final void setSecondSource(TransformOperationSource.BuilderImpl secondSource) {
            this.secondSource = secondSource != null ? secondSource.build() : null;
        }

        @Override
        public final Builder secondSource(TransformOperationSource secondSource) {
            this.secondSource = secondSource;
            return this;
        }

        public final List<AppendedColumn.Builder> getAppendedColumns() {
            List<AppendedColumn.Builder> result = AppendedColumnListCopier.copyToBuilder(this.appendedColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppendedColumns(Collection<AppendedColumn.BuilderImpl> appendedColumns) {
            this.appendedColumns = AppendedColumnListCopier.copyFromBuilder(appendedColumns);
        }

        @Override
        public final Builder appendedColumns(Collection<AppendedColumn> appendedColumns) {
            this.appendedColumns = AppendedColumnListCopier.copy(appendedColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appendedColumns(AppendedColumn... appendedColumns) {
            appendedColumns(Arrays.asList(appendedColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appendedColumns(Consumer<AppendedColumn.Builder>... appendedColumns) {
            appendedColumns(Stream.of(appendedColumns).map(c -> AppendedColumn.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AppendOperation build() {
            return new AppendOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
