/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Union type containing authentication metadata for different authentication methods.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticationMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthenticationMetadata.Builder, AuthenticationMetadata> {
    private static final SdkField<AuthorizationCodeGrantMetadata> AUTHORIZATION_CODE_GRANT_METADATA_FIELD = SdkField
            .<AuthorizationCodeGrantMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("AuthorizationCodeGrantMetadata")
            .getter(getter(AuthenticationMetadata::authorizationCodeGrantMetadata))
            .setter(setter(Builder::authorizationCodeGrantMetadata))
            .constructor(AuthorizationCodeGrantMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationCodeGrantMetadata")
                    .build()).build();

    private static final SdkField<ClientCredentialsGrantMetadata> CLIENT_CREDENTIALS_GRANT_METADATA_FIELD = SdkField
            .<ClientCredentialsGrantMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("ClientCredentialsGrantMetadata")
            .getter(getter(AuthenticationMetadata::clientCredentialsGrantMetadata))
            .setter(setter(Builder::clientCredentialsGrantMetadata))
            .constructor(ClientCredentialsGrantMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCredentialsGrantMetadata")
                    .build()).build();

    private static final SdkField<BasicAuthConnectionMetadata> BASIC_AUTH_CONNECTION_METADATA_FIELD = SdkField
            .<BasicAuthConnectionMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("BasicAuthConnectionMetadata")
            .getter(getter(AuthenticationMetadata::basicAuthConnectionMetadata))
            .setter(setter(Builder::basicAuthConnectionMetadata))
            .constructor(BasicAuthConnectionMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasicAuthConnectionMetadata")
                    .build()).build();

    private static final SdkField<APIKeyConnectionMetadata> API_KEY_CONNECTION_METADATA_FIELD = SdkField
            .<APIKeyConnectionMetadata> builder(MarshallingType.SDK_POJO).memberName("ApiKeyConnectionMetadata")
            .getter(getter(AuthenticationMetadata::apiKeyConnectionMetadata)).setter(setter(Builder::apiKeyConnectionMetadata))
            .constructor(APIKeyConnectionMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiKeyConnectionMetadata").build())
            .build();

    private static final SdkField<NoneConnectionMetadata> NONE_CONNECTION_METADATA_FIELD = SdkField
            .<NoneConnectionMetadata> builder(MarshallingType.SDK_POJO).memberName("NoneConnectionMetadata")
            .getter(getter(AuthenticationMetadata::noneConnectionMetadata)).setter(setter(Builder::noneConnectionMetadata))
            .constructor(NoneConnectionMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoneConnectionMetadata").build())
            .build();

    private static final SdkField<IAMConnectionMetadata> IAM_CONNECTION_METADATA_FIELD = SdkField
            .<IAMConnectionMetadata> builder(MarshallingType.SDK_POJO).memberName("IamConnectionMetadata")
            .getter(getter(AuthenticationMetadata::iamConnectionMetadata)).setter(setter(Builder::iamConnectionMetadata))
            .constructor(IAMConnectionMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamConnectionMetadata").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTHORIZATION_CODE_GRANT_METADATA_FIELD, CLIENT_CREDENTIALS_GRANT_METADATA_FIELD,
            BASIC_AUTH_CONNECTION_METADATA_FIELD, API_KEY_CONNECTION_METADATA_FIELD, NONE_CONNECTION_METADATA_FIELD,
            IAM_CONNECTION_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AuthorizationCodeGrantMetadata authorizationCodeGrantMetadata;

    private final ClientCredentialsGrantMetadata clientCredentialsGrantMetadata;

    private final BasicAuthConnectionMetadata basicAuthConnectionMetadata;

    private final APIKeyConnectionMetadata apiKeyConnectionMetadata;

    private final NoneConnectionMetadata noneConnectionMetadata;

    private final IAMConnectionMetadata iamConnectionMetadata;

    private final Type type;

    private AuthenticationMetadata(BuilderImpl builder) {
        this.authorizationCodeGrantMetadata = builder.authorizationCodeGrantMetadata;
        this.clientCredentialsGrantMetadata = builder.clientCredentialsGrantMetadata;
        this.basicAuthConnectionMetadata = builder.basicAuthConnectionMetadata;
        this.apiKeyConnectionMetadata = builder.apiKeyConnectionMetadata;
        this.noneConnectionMetadata = builder.noneConnectionMetadata;
        this.iamConnectionMetadata = builder.iamConnectionMetadata;
        this.type = builder.type;
    }

    /**
     * <p>
     * OAuth 2.0 authorization code grant authentication metadata.
     * </p>
     * 
     * @return OAuth 2.0 authorization code grant authentication metadata.
     */
    public final AuthorizationCodeGrantMetadata authorizationCodeGrantMetadata() {
        return authorizationCodeGrantMetadata;
    }

    /**
     * <p>
     * OAuth 2.0 client credentials grant authentication metadata.
     * </p>
     * 
     * @return OAuth 2.0 client credentials grant authentication metadata.
     */
    public final ClientCredentialsGrantMetadata clientCredentialsGrantMetadata() {
        return clientCredentialsGrantMetadata;
    }

    /**
     * <p>
     * Basic authentication metadata using username and password.
     * </p>
     * 
     * @return Basic authentication metadata using username and password.
     */
    public final BasicAuthConnectionMetadata basicAuthConnectionMetadata() {
        return basicAuthConnectionMetadata;
    }

    /**
     * <p>
     * API key authentication metadata.
     * </p>
     * 
     * @return API key authentication metadata.
     */
    public final APIKeyConnectionMetadata apiKeyConnectionMetadata() {
        return apiKeyConnectionMetadata;
    }

    /**
     * <p>
     * No authentication metadata for services that don't require authentication.
     * </p>
     * 
     * @return No authentication metadata for services that don't require authentication.
     */
    public final NoneConnectionMetadata noneConnectionMetadata() {
        return noneConnectionMetadata;
    }

    /**
     * <p>
     * IAM role-based authentication metadata for Amazon Web Services services.
     * </p>
     * 
     * @return IAM role-based authentication metadata for Amazon Web Services services.
     */
    public final IAMConnectionMetadata iamConnectionMetadata() {
        return iamConnectionMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizationCodeGrantMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(clientCredentialsGrantMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(basicAuthConnectionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(apiKeyConnectionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(noneConnectionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(iamConnectionMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationMetadata)) {
            return false;
        }
        AuthenticationMetadata other = (AuthenticationMetadata) obj;
        return Objects.equals(authorizationCodeGrantMetadata(), other.authorizationCodeGrantMetadata())
                && Objects.equals(clientCredentialsGrantMetadata(), other.clientCredentialsGrantMetadata())
                && Objects.equals(basicAuthConnectionMetadata(), other.basicAuthConnectionMetadata())
                && Objects.equals(apiKeyConnectionMetadata(), other.apiKeyConnectionMetadata())
                && Objects.equals(noneConnectionMetadata(), other.noneConnectionMetadata())
                && Objects.equals(iamConnectionMetadata(), other.iamConnectionMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthenticationMetadata").add("AuthorizationCodeGrantMetadata", authorizationCodeGrantMetadata())
                .add("ClientCredentialsGrantMetadata", clientCredentialsGrantMetadata())
                .add("BasicAuthConnectionMetadata", basicAuthConnectionMetadata())
                .add("ApiKeyConnectionMetadata", apiKeyConnectionMetadata())
                .add("NoneConnectionMetadata", noneConnectionMetadata()).add("IamConnectionMetadata", iamConnectionMetadata())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthorizationCodeGrantMetadata":
            return Optional.ofNullable(clazz.cast(authorizationCodeGrantMetadata()));
        case "ClientCredentialsGrantMetadata":
            return Optional.ofNullable(clazz.cast(clientCredentialsGrantMetadata()));
        case "BasicAuthConnectionMetadata":
            return Optional.ofNullable(clazz.cast(basicAuthConnectionMetadata()));
        case "ApiKeyConnectionMetadata":
            return Optional.ofNullable(clazz.cast(apiKeyConnectionMetadata()));
        case "NoneConnectionMetadata":
            return Optional.ofNullable(clazz.cast(noneConnectionMetadata()));
        case "IamConnectionMetadata":
            return Optional.ofNullable(clazz.cast(iamConnectionMetadata()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #authorizationCodeGrantMetadata()} initialized to the given value.
     *
     * <p>
     * OAuth 2.0 authorization code grant authentication metadata.
     * </p>
     * 
     * @param authorizationCodeGrantMetadata
     *        OAuth 2.0 authorization code grant authentication metadata.
     */
    public static AuthenticationMetadata fromAuthorizationCodeGrantMetadata(
            AuthorizationCodeGrantMetadata authorizationCodeGrantMetadata) {
        return builder().authorizationCodeGrantMetadata(authorizationCodeGrantMetadata).build();
    }

    /**
     * Create an instance of this class with {@link #authorizationCodeGrantMetadata()} initialized to the given value.
     *
     * <p>
     * OAuth 2.0 authorization code grant authentication metadata.
     * </p>
     * 
     * @param authorizationCodeGrantMetadata
     *        OAuth 2.0 authorization code grant authentication metadata.
     */
    public static AuthenticationMetadata fromAuthorizationCodeGrantMetadata(
            Consumer<AuthorizationCodeGrantMetadata.Builder> authorizationCodeGrantMetadata) {
        AuthorizationCodeGrantMetadata.Builder builder = AuthorizationCodeGrantMetadata.builder();
        authorizationCodeGrantMetadata.accept(builder);
        return fromAuthorizationCodeGrantMetadata(builder.build());
    }

    /**
     * Create an instance of this class with {@link #clientCredentialsGrantMetadata()} initialized to the given value.
     *
     * <p>
     * OAuth 2.0 client credentials grant authentication metadata.
     * </p>
     * 
     * @param clientCredentialsGrantMetadata
     *        OAuth 2.0 client credentials grant authentication metadata.
     */
    public static AuthenticationMetadata fromClientCredentialsGrantMetadata(
            ClientCredentialsGrantMetadata clientCredentialsGrantMetadata) {
        return builder().clientCredentialsGrantMetadata(clientCredentialsGrantMetadata).build();
    }

    /**
     * Create an instance of this class with {@link #clientCredentialsGrantMetadata()} initialized to the given value.
     *
     * <p>
     * OAuth 2.0 client credentials grant authentication metadata.
     * </p>
     * 
     * @param clientCredentialsGrantMetadata
     *        OAuth 2.0 client credentials grant authentication metadata.
     */
    public static AuthenticationMetadata fromClientCredentialsGrantMetadata(
            Consumer<ClientCredentialsGrantMetadata.Builder> clientCredentialsGrantMetadata) {
        ClientCredentialsGrantMetadata.Builder builder = ClientCredentialsGrantMetadata.builder();
        clientCredentialsGrantMetadata.accept(builder);
        return fromClientCredentialsGrantMetadata(builder.build());
    }

    /**
     * Create an instance of this class with {@link #basicAuthConnectionMetadata()} initialized to the given value.
     *
     * <p>
     * Basic authentication metadata using username and password.
     * </p>
     * 
     * @param basicAuthConnectionMetadata
     *        Basic authentication metadata using username and password.
     */
    public static AuthenticationMetadata fromBasicAuthConnectionMetadata(BasicAuthConnectionMetadata basicAuthConnectionMetadata) {
        return builder().basicAuthConnectionMetadata(basicAuthConnectionMetadata).build();
    }

    /**
     * Create an instance of this class with {@link #basicAuthConnectionMetadata()} initialized to the given value.
     *
     * <p>
     * Basic authentication metadata using username and password.
     * </p>
     * 
     * @param basicAuthConnectionMetadata
     *        Basic authentication metadata using username and password.
     */
    public static AuthenticationMetadata fromBasicAuthConnectionMetadata(
            Consumer<BasicAuthConnectionMetadata.Builder> basicAuthConnectionMetadata) {
        BasicAuthConnectionMetadata.Builder builder = BasicAuthConnectionMetadata.builder();
        basicAuthConnectionMetadata.accept(builder);
        return fromBasicAuthConnectionMetadata(builder.build());
    }

    /**
     * Create an instance of this class with {@link #apiKeyConnectionMetadata()} initialized to the given value.
     *
     * <p>
     * API key authentication metadata.
     * </p>
     * 
     * @param apiKeyConnectionMetadata
     *        API key authentication metadata.
     */
    public static AuthenticationMetadata fromApiKeyConnectionMetadata(APIKeyConnectionMetadata apiKeyConnectionMetadata) {
        return builder().apiKeyConnectionMetadata(apiKeyConnectionMetadata).build();
    }

    /**
     * Create an instance of this class with {@link #apiKeyConnectionMetadata()} initialized to the given value.
     *
     * <p>
     * API key authentication metadata.
     * </p>
     * 
     * @param apiKeyConnectionMetadata
     *        API key authentication metadata.
     */
    public static AuthenticationMetadata fromApiKeyConnectionMetadata(
            Consumer<APIKeyConnectionMetadata.Builder> apiKeyConnectionMetadata) {
        APIKeyConnectionMetadata.Builder builder = APIKeyConnectionMetadata.builder();
        apiKeyConnectionMetadata.accept(builder);
        return fromApiKeyConnectionMetadata(builder.build());
    }

    /**
     * Create an instance of this class with {@link #noneConnectionMetadata()} initialized to the given value.
     *
     * <p>
     * No authentication metadata for services that don't require authentication.
     * </p>
     * 
     * @param noneConnectionMetadata
     *        No authentication metadata for services that don't require authentication.
     */
    public static AuthenticationMetadata fromNoneConnectionMetadata(NoneConnectionMetadata noneConnectionMetadata) {
        return builder().noneConnectionMetadata(noneConnectionMetadata).build();
    }

    /**
     * Create an instance of this class with {@link #noneConnectionMetadata()} initialized to the given value.
     *
     * <p>
     * No authentication metadata for services that don't require authentication.
     * </p>
     * 
     * @param noneConnectionMetadata
     *        No authentication metadata for services that don't require authentication.
     */
    public static AuthenticationMetadata fromNoneConnectionMetadata(
            Consumer<NoneConnectionMetadata.Builder> noneConnectionMetadata) {
        NoneConnectionMetadata.Builder builder = NoneConnectionMetadata.builder();
        noneConnectionMetadata.accept(builder);
        return fromNoneConnectionMetadata(builder.build());
    }

    /**
     * Create an instance of this class with {@link #iamConnectionMetadata()} initialized to the given value.
     *
     * <p>
     * IAM role-based authentication metadata for Amazon Web Services services.
     * </p>
     * 
     * @param iamConnectionMetadata
     *        IAM role-based authentication metadata for Amazon Web Services services.
     */
    public static AuthenticationMetadata fromIamConnectionMetadata(IAMConnectionMetadata iamConnectionMetadata) {
        return builder().iamConnectionMetadata(iamConnectionMetadata).build();
    }

    /**
     * Create an instance of this class with {@link #iamConnectionMetadata()} initialized to the given value.
     *
     * <p>
     * IAM role-based authentication metadata for Amazon Web Services services.
     * </p>
     * 
     * @param iamConnectionMetadata
     *        IAM role-based authentication metadata for Amazon Web Services services.
     */
    public static AuthenticationMetadata fromIamConnectionMetadata(Consumer<IAMConnectionMetadata.Builder> iamConnectionMetadata) {
        IAMConnectionMetadata.Builder builder = IAMConnectionMetadata.builder();
        iamConnectionMetadata.accept(builder);
        return fromIamConnectionMetadata(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuthorizationCodeGrantMetadata", AUTHORIZATION_CODE_GRANT_METADATA_FIELD);
        map.put("ClientCredentialsGrantMetadata", CLIENT_CREDENTIALS_GRANT_METADATA_FIELD);
        map.put("BasicAuthConnectionMetadata", BASIC_AUTH_CONNECTION_METADATA_FIELD);
        map.put("ApiKeyConnectionMetadata", API_KEY_CONNECTION_METADATA_FIELD);
        map.put("NoneConnectionMetadata", NONE_CONNECTION_METADATA_FIELD);
        map.put("IamConnectionMetadata", IAM_CONNECTION_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationMetadata, T> g) {
        return obj -> g.apply((AuthenticationMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthenticationMetadata> {
        /**
         * <p>
         * OAuth 2.0 authorization code grant authentication metadata.
         * </p>
         * 
         * @param authorizationCodeGrantMetadata
         *        OAuth 2.0 authorization code grant authentication metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationCodeGrantMetadata(AuthorizationCodeGrantMetadata authorizationCodeGrantMetadata);

        /**
         * <p>
         * OAuth 2.0 authorization code grant authentication metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthorizationCodeGrantMetadata.Builder}
         * avoiding the need to create one manually via {@link AuthorizationCodeGrantMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthorizationCodeGrantMetadata.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #authorizationCodeGrantMetadata(AuthorizationCodeGrantMetadata)}.
         * 
         * @param authorizationCodeGrantMetadata
         *        a consumer that will call methods on {@link AuthorizationCodeGrantMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizationCodeGrantMetadata(AuthorizationCodeGrantMetadata)
         */
        default Builder authorizationCodeGrantMetadata(
                Consumer<AuthorizationCodeGrantMetadata.Builder> authorizationCodeGrantMetadata) {
            return authorizationCodeGrantMetadata(AuthorizationCodeGrantMetadata.builder()
                    .applyMutation(authorizationCodeGrantMetadata).build());
        }

        /**
         * <p>
         * OAuth 2.0 client credentials grant authentication metadata.
         * </p>
         * 
         * @param clientCredentialsGrantMetadata
         *        OAuth 2.0 client credentials grant authentication metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCredentialsGrantMetadata(ClientCredentialsGrantMetadata clientCredentialsGrantMetadata);

        /**
         * <p>
         * OAuth 2.0 client credentials grant authentication metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientCredentialsGrantMetadata.Builder}
         * avoiding the need to create one manually via {@link ClientCredentialsGrantMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientCredentialsGrantMetadata.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #clientCredentialsGrantMetadata(ClientCredentialsGrantMetadata)}.
         * 
         * @param clientCredentialsGrantMetadata
         *        a consumer that will call methods on {@link ClientCredentialsGrantMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientCredentialsGrantMetadata(ClientCredentialsGrantMetadata)
         */
        default Builder clientCredentialsGrantMetadata(
                Consumer<ClientCredentialsGrantMetadata.Builder> clientCredentialsGrantMetadata) {
            return clientCredentialsGrantMetadata(ClientCredentialsGrantMetadata.builder()
                    .applyMutation(clientCredentialsGrantMetadata).build());
        }

        /**
         * <p>
         * Basic authentication metadata using username and password.
         * </p>
         * 
         * @param basicAuthConnectionMetadata
         *        Basic authentication metadata using username and password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthConnectionMetadata(BasicAuthConnectionMetadata basicAuthConnectionMetadata);

        /**
         * <p>
         * Basic authentication metadata using username and password.
         * </p>
         * This is a convenience method that creates an instance of the {@link BasicAuthConnectionMetadata.Builder}
         * avoiding the need to create one manually via {@link BasicAuthConnectionMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BasicAuthConnectionMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #basicAuthConnectionMetadata(BasicAuthConnectionMetadata)}.
         * 
         * @param basicAuthConnectionMetadata
         *        a consumer that will call methods on {@link BasicAuthConnectionMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #basicAuthConnectionMetadata(BasicAuthConnectionMetadata)
         */
        default Builder basicAuthConnectionMetadata(Consumer<BasicAuthConnectionMetadata.Builder> basicAuthConnectionMetadata) {
            return basicAuthConnectionMetadata(BasicAuthConnectionMetadata.builder().applyMutation(basicAuthConnectionMetadata)
                    .build());
        }

        /**
         * <p>
         * API key authentication metadata.
         * </p>
         * 
         * @param apiKeyConnectionMetadata
         *        API key authentication metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeyConnectionMetadata(APIKeyConnectionMetadata apiKeyConnectionMetadata);

        /**
         * <p>
         * API key authentication metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link APIKeyConnectionMetadata.Builder}
         * avoiding the need to create one manually via {@link APIKeyConnectionMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link APIKeyConnectionMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #apiKeyConnectionMetadata(APIKeyConnectionMetadata)}.
         * 
         * @param apiKeyConnectionMetadata
         *        a consumer that will call methods on {@link APIKeyConnectionMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiKeyConnectionMetadata(APIKeyConnectionMetadata)
         */
        default Builder apiKeyConnectionMetadata(Consumer<APIKeyConnectionMetadata.Builder> apiKeyConnectionMetadata) {
            return apiKeyConnectionMetadata(APIKeyConnectionMetadata.builder().applyMutation(apiKeyConnectionMetadata).build());
        }

        /**
         * <p>
         * No authentication metadata for services that don't require authentication.
         * </p>
         * 
         * @param noneConnectionMetadata
         *        No authentication metadata for services that don't require authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noneConnectionMetadata(NoneConnectionMetadata noneConnectionMetadata);

        /**
         * <p>
         * No authentication metadata for services that don't require authentication.
         * </p>
         * This is a convenience method that creates an instance of the {@link NoneConnectionMetadata.Builder} avoiding
         * the need to create one manually via {@link NoneConnectionMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NoneConnectionMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #noneConnectionMetadata(NoneConnectionMetadata)}.
         * 
         * @param noneConnectionMetadata
         *        a consumer that will call methods on {@link NoneConnectionMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noneConnectionMetadata(NoneConnectionMetadata)
         */
        default Builder noneConnectionMetadata(Consumer<NoneConnectionMetadata.Builder> noneConnectionMetadata) {
            return noneConnectionMetadata(NoneConnectionMetadata.builder().applyMutation(noneConnectionMetadata).build());
        }

        /**
         * <p>
         * IAM role-based authentication metadata for Amazon Web Services services.
         * </p>
         * 
         * @param iamConnectionMetadata
         *        IAM role-based authentication metadata for Amazon Web Services services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamConnectionMetadata(IAMConnectionMetadata iamConnectionMetadata);

        /**
         * <p>
         * IAM role-based authentication metadata for Amazon Web Services services.
         * </p>
         * This is a convenience method that creates an instance of the {@link IAMConnectionMetadata.Builder} avoiding
         * the need to create one manually via {@link IAMConnectionMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IAMConnectionMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #iamConnectionMetadata(IAMConnectionMetadata)}.
         * 
         * @param iamConnectionMetadata
         *        a consumer that will call methods on {@link IAMConnectionMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamConnectionMetadata(IAMConnectionMetadata)
         */
        default Builder iamConnectionMetadata(Consumer<IAMConnectionMetadata.Builder> iamConnectionMetadata) {
            return iamConnectionMetadata(IAMConnectionMetadata.builder().applyMutation(iamConnectionMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AuthorizationCodeGrantMetadata authorizationCodeGrantMetadata;

        private ClientCredentialsGrantMetadata clientCredentialsGrantMetadata;

        private BasicAuthConnectionMetadata basicAuthConnectionMetadata;

        private APIKeyConnectionMetadata apiKeyConnectionMetadata;

        private NoneConnectionMetadata noneConnectionMetadata;

        private IAMConnectionMetadata iamConnectionMetadata;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationMetadata model) {
            authorizationCodeGrantMetadata(model.authorizationCodeGrantMetadata);
            clientCredentialsGrantMetadata(model.clientCredentialsGrantMetadata);
            basicAuthConnectionMetadata(model.basicAuthConnectionMetadata);
            apiKeyConnectionMetadata(model.apiKeyConnectionMetadata);
            noneConnectionMetadata(model.noneConnectionMetadata);
            iamConnectionMetadata(model.iamConnectionMetadata);
        }

        public final AuthorizationCodeGrantMetadata.Builder getAuthorizationCodeGrantMetadata() {
            return authorizationCodeGrantMetadata != null ? authorizationCodeGrantMetadata.toBuilder() : null;
        }

        public final void setAuthorizationCodeGrantMetadata(
                AuthorizationCodeGrantMetadata.BuilderImpl authorizationCodeGrantMetadata) {
            Object oldValue = this.authorizationCodeGrantMetadata;
            this.authorizationCodeGrantMetadata = authorizationCodeGrantMetadata != null ? authorizationCodeGrantMetadata.build()
                    : null;
            handleUnionValueChange(Type.AUTHORIZATION_CODE_GRANT_METADATA, oldValue, this.authorizationCodeGrantMetadata);
        }

        @Override
        public final Builder authorizationCodeGrantMetadata(AuthorizationCodeGrantMetadata authorizationCodeGrantMetadata) {
            Object oldValue = this.authorizationCodeGrantMetadata;
            this.authorizationCodeGrantMetadata = authorizationCodeGrantMetadata;
            handleUnionValueChange(Type.AUTHORIZATION_CODE_GRANT_METADATA, oldValue, this.authorizationCodeGrantMetadata);
            return this;
        }

        public final ClientCredentialsGrantMetadata.Builder getClientCredentialsGrantMetadata() {
            return clientCredentialsGrantMetadata != null ? clientCredentialsGrantMetadata.toBuilder() : null;
        }

        public final void setClientCredentialsGrantMetadata(
                ClientCredentialsGrantMetadata.BuilderImpl clientCredentialsGrantMetadata) {
            Object oldValue = this.clientCredentialsGrantMetadata;
            this.clientCredentialsGrantMetadata = clientCredentialsGrantMetadata != null ? clientCredentialsGrantMetadata.build()
                    : null;
            handleUnionValueChange(Type.CLIENT_CREDENTIALS_GRANT_METADATA, oldValue, this.clientCredentialsGrantMetadata);
        }

        @Override
        public final Builder clientCredentialsGrantMetadata(ClientCredentialsGrantMetadata clientCredentialsGrantMetadata) {
            Object oldValue = this.clientCredentialsGrantMetadata;
            this.clientCredentialsGrantMetadata = clientCredentialsGrantMetadata;
            handleUnionValueChange(Type.CLIENT_CREDENTIALS_GRANT_METADATA, oldValue, this.clientCredentialsGrantMetadata);
            return this;
        }

        public final BasicAuthConnectionMetadata.Builder getBasicAuthConnectionMetadata() {
            return basicAuthConnectionMetadata != null ? basicAuthConnectionMetadata.toBuilder() : null;
        }

        public final void setBasicAuthConnectionMetadata(BasicAuthConnectionMetadata.BuilderImpl basicAuthConnectionMetadata) {
            Object oldValue = this.basicAuthConnectionMetadata;
            this.basicAuthConnectionMetadata = basicAuthConnectionMetadata != null ? basicAuthConnectionMetadata.build() : null;
            handleUnionValueChange(Type.BASIC_AUTH_CONNECTION_METADATA, oldValue, this.basicAuthConnectionMetadata);
        }

        @Override
        public final Builder basicAuthConnectionMetadata(BasicAuthConnectionMetadata basicAuthConnectionMetadata) {
            Object oldValue = this.basicAuthConnectionMetadata;
            this.basicAuthConnectionMetadata = basicAuthConnectionMetadata;
            handleUnionValueChange(Type.BASIC_AUTH_CONNECTION_METADATA, oldValue, this.basicAuthConnectionMetadata);
            return this;
        }

        public final APIKeyConnectionMetadata.Builder getApiKeyConnectionMetadata() {
            return apiKeyConnectionMetadata != null ? apiKeyConnectionMetadata.toBuilder() : null;
        }

        public final void setApiKeyConnectionMetadata(APIKeyConnectionMetadata.BuilderImpl apiKeyConnectionMetadata) {
            Object oldValue = this.apiKeyConnectionMetadata;
            this.apiKeyConnectionMetadata = apiKeyConnectionMetadata != null ? apiKeyConnectionMetadata.build() : null;
            handleUnionValueChange(Type.API_KEY_CONNECTION_METADATA, oldValue, this.apiKeyConnectionMetadata);
        }

        @Override
        public final Builder apiKeyConnectionMetadata(APIKeyConnectionMetadata apiKeyConnectionMetadata) {
            Object oldValue = this.apiKeyConnectionMetadata;
            this.apiKeyConnectionMetadata = apiKeyConnectionMetadata;
            handleUnionValueChange(Type.API_KEY_CONNECTION_METADATA, oldValue, this.apiKeyConnectionMetadata);
            return this;
        }

        public final NoneConnectionMetadata.Builder getNoneConnectionMetadata() {
            return noneConnectionMetadata != null ? noneConnectionMetadata.toBuilder() : null;
        }

        public final void setNoneConnectionMetadata(NoneConnectionMetadata.BuilderImpl noneConnectionMetadata) {
            Object oldValue = this.noneConnectionMetadata;
            this.noneConnectionMetadata = noneConnectionMetadata != null ? noneConnectionMetadata.build() : null;
            handleUnionValueChange(Type.NONE_CONNECTION_METADATA, oldValue, this.noneConnectionMetadata);
        }

        @Override
        public final Builder noneConnectionMetadata(NoneConnectionMetadata noneConnectionMetadata) {
            Object oldValue = this.noneConnectionMetadata;
            this.noneConnectionMetadata = noneConnectionMetadata;
            handleUnionValueChange(Type.NONE_CONNECTION_METADATA, oldValue, this.noneConnectionMetadata);
            return this;
        }

        public final IAMConnectionMetadata.Builder getIamConnectionMetadata() {
            return iamConnectionMetadata != null ? iamConnectionMetadata.toBuilder() : null;
        }

        public final void setIamConnectionMetadata(IAMConnectionMetadata.BuilderImpl iamConnectionMetadata) {
            Object oldValue = this.iamConnectionMetadata;
            this.iamConnectionMetadata = iamConnectionMetadata != null ? iamConnectionMetadata.build() : null;
            handleUnionValueChange(Type.IAM_CONNECTION_METADATA, oldValue, this.iamConnectionMetadata);
        }

        @Override
        public final Builder iamConnectionMetadata(IAMConnectionMetadata iamConnectionMetadata) {
            Object oldValue = this.iamConnectionMetadata;
            this.iamConnectionMetadata = iamConnectionMetadata;
            handleUnionValueChange(Type.IAM_CONNECTION_METADATA, oldValue, this.iamConnectionMetadata);
            return this;
        }

        @Override
        public AuthenticationMetadata build() {
            return new AuthenticationMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AuthenticationMetadata#type()
     */
    public enum Type {
        AUTHORIZATION_CODE_GRANT_METADATA,

        CLIENT_CREDENTIALS_GRANT_METADATA,

        BASIC_AUTH_CONNECTION_METADATA,

        API_KEY_CONNECTION_METADATA,

        NONE_CONNECTION_METADATA,

        IAM_CONNECTION_METADATA,

        UNKNOWN_TO_SDK_VERSION
    }
}
