/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for OAuth 2.0 authorization code grant credentials.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizationCodeGrantCredentialsDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthorizationCodeGrantCredentialsDetails.Builder, AuthorizationCodeGrantCredentialsDetails> {
    private static final SdkField<AuthorizationCodeGrantDetails> AUTHORIZATION_CODE_GRANT_DETAILS_FIELD = SdkField
            .<AuthorizationCodeGrantDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AuthorizationCodeGrantDetails")
            .getter(getter(AuthorizationCodeGrantCredentialsDetails::authorizationCodeGrantDetails))
            .setter(setter(Builder::authorizationCodeGrantDetails))
            .constructor(AuthorizationCodeGrantDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationCodeGrantDetails")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AUTHORIZATION_CODE_GRANT_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AuthorizationCodeGrantDetails authorizationCodeGrantDetails;

    private final Type type;

    private AuthorizationCodeGrantCredentialsDetails(BuilderImpl builder) {
        this.authorizationCodeGrantDetails = builder.authorizationCodeGrantDetails;
        this.type = builder.type;
    }

    /**
     * <p>
     * The authorization code grant configuration details.
     * </p>
     * 
     * @return The authorization code grant configuration details.
     */
    public final AuthorizationCodeGrantDetails authorizationCodeGrantDetails() {
        return authorizationCodeGrantDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizationCodeGrantDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizationCodeGrantCredentialsDetails)) {
            return false;
        }
        AuthorizationCodeGrantCredentialsDetails other = (AuthorizationCodeGrantCredentialsDetails) obj;
        return Objects.equals(authorizationCodeGrantDetails(), other.authorizationCodeGrantDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthorizationCodeGrantCredentialsDetails")
                .add("AuthorizationCodeGrantDetails", authorizationCodeGrantDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthorizationCodeGrantDetails":
            return Optional.ofNullable(clazz.cast(authorizationCodeGrantDetails()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #authorizationCodeGrantDetails()} initialized to the given value.
     *
     * <p>
     * The authorization code grant configuration details.
     * </p>
     * 
     * @param authorizationCodeGrantDetails
     *        The authorization code grant configuration details.
     */
    public static AuthorizationCodeGrantCredentialsDetails fromAuthorizationCodeGrantDetails(
            AuthorizationCodeGrantDetails authorizationCodeGrantDetails) {
        return builder().authorizationCodeGrantDetails(authorizationCodeGrantDetails).build();
    }

    /**
     * Create an instance of this class with {@link #authorizationCodeGrantDetails()} initialized to the given value.
     *
     * <p>
     * The authorization code grant configuration details.
     * </p>
     * 
     * @param authorizationCodeGrantDetails
     *        The authorization code grant configuration details.
     */
    public static AuthorizationCodeGrantCredentialsDetails fromAuthorizationCodeGrantDetails(
            Consumer<AuthorizationCodeGrantDetails.Builder> authorizationCodeGrantDetails) {
        AuthorizationCodeGrantDetails.Builder builder = AuthorizationCodeGrantDetails.builder();
        authorizationCodeGrantDetails.accept(builder);
        return fromAuthorizationCodeGrantDetails(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuthorizationCodeGrantDetails", AUTHORIZATION_CODE_GRANT_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthorizationCodeGrantCredentialsDetails, T> g) {
        return obj -> g.apply((AuthorizationCodeGrantCredentialsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthorizationCodeGrantCredentialsDetails> {
        /**
         * <p>
         * The authorization code grant configuration details.
         * </p>
         * 
         * @param authorizationCodeGrantDetails
         *        The authorization code grant configuration details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationCodeGrantDetails(AuthorizationCodeGrantDetails authorizationCodeGrantDetails);

        /**
         * <p>
         * The authorization code grant configuration details.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthorizationCodeGrantDetails.Builder}
         * avoiding the need to create one manually via {@link AuthorizationCodeGrantDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthorizationCodeGrantDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #authorizationCodeGrantDetails(AuthorizationCodeGrantDetails)}.
         * 
         * @param authorizationCodeGrantDetails
         *        a consumer that will call methods on {@link AuthorizationCodeGrantDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizationCodeGrantDetails(AuthorizationCodeGrantDetails)
         */
        default Builder authorizationCodeGrantDetails(
                Consumer<AuthorizationCodeGrantDetails.Builder> authorizationCodeGrantDetails) {
            return authorizationCodeGrantDetails(AuthorizationCodeGrantDetails.builder()
                    .applyMutation(authorizationCodeGrantDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AuthorizationCodeGrantDetails authorizationCodeGrantDetails;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizationCodeGrantCredentialsDetails model) {
            authorizationCodeGrantDetails(model.authorizationCodeGrantDetails);
        }

        public final AuthorizationCodeGrantDetails.Builder getAuthorizationCodeGrantDetails() {
            return authorizationCodeGrantDetails != null ? authorizationCodeGrantDetails.toBuilder() : null;
        }

        public final void setAuthorizationCodeGrantDetails(AuthorizationCodeGrantDetails.BuilderImpl authorizationCodeGrantDetails) {
            Object oldValue = this.authorizationCodeGrantDetails;
            this.authorizationCodeGrantDetails = authorizationCodeGrantDetails != null ? authorizationCodeGrantDetails.build()
                    : null;
            handleUnionValueChange(Type.AUTHORIZATION_CODE_GRANT_DETAILS, oldValue, this.authorizationCodeGrantDetails);
        }

        @Override
        public final Builder authorizationCodeGrantDetails(AuthorizationCodeGrantDetails authorizationCodeGrantDetails) {
            Object oldValue = this.authorizationCodeGrantDetails;
            this.authorizationCodeGrantDetails = authorizationCodeGrantDetails;
            handleUnionValueChange(Type.AUTHORIZATION_CODE_GRANT_DETAILS, oldValue, this.authorizationCodeGrantDetails);
            return this;
        }

        @Override
        public AuthorizationCodeGrantCredentialsDetails build() {
            return new AuthorizationCodeGrantCredentialsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AuthorizationCodeGrantCredentialsDetails#type()
     */
    public enum Type {
        AUTHORIZATION_CODE_GRANT_DETAILS,

        UNKNOWN_TO_SDK_VERSION
    }
}
