/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for OAuth 2.0 client credentials grant authentication, including client ID, client secret, token
 * endpoint, and optional scopes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientCredentialsGrantMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientCredentialsGrantMetadata.Builder, ClientCredentialsGrantMetadata> {
    private static final SdkField<String> BASE_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseEndpoint").getter(getter(ClientCredentialsGrantMetadata::baseEndpoint))
            .setter(setter(Builder::baseEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseEndpoint").build()).build();

    private static final SdkField<String> CLIENT_CREDENTIALS_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientCredentialsSource")
            .getter(getter(ClientCredentialsGrantMetadata::clientCredentialsSourceAsString))
            .setter(setter(Builder::clientCredentialsSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCredentialsSource").build())
            .build();

    private static final SdkField<ClientCredentialsDetails> CLIENT_CREDENTIALS_DETAILS_FIELD = SdkField
            .<ClientCredentialsDetails> builder(MarshallingType.SDK_POJO).memberName("ClientCredentialsDetails")
            .getter(getter(ClientCredentialsGrantMetadata::clientCredentialsDetails))
            .setter(setter(Builder::clientCredentialsDetails)).constructor(ClientCredentialsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCredentialsDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_ENDPOINT_FIELD,
            CLIENT_CREDENTIALS_SOURCE_FIELD, CLIENT_CREDENTIALS_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String baseEndpoint;

    private final String clientCredentialsSource;

    private final ClientCredentialsDetails clientCredentialsDetails;

    private ClientCredentialsGrantMetadata(BuilderImpl builder) {
        this.baseEndpoint = builder.baseEndpoint;
        this.clientCredentialsSource = builder.clientCredentialsSource;
        this.clientCredentialsDetails = builder.clientCredentialsDetails;
    }

    /**
     * <p>
     * The base endpoint URL for the external service.
     * </p>
     * 
     * @return The base endpoint URL for the external service.
     */
    public final String baseEndpoint() {
        return baseEndpoint;
    }

    /**
     * <p>
     * The source of the client credentials configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #clientCredentialsSource} will return {@link ClientCredentialsSource#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #clientCredentialsSourceAsString}.
     * </p>
     * 
     * @return The source of the client credentials configuration.
     * @see ClientCredentialsSource
     */
    public final ClientCredentialsSource clientCredentialsSource() {
        return ClientCredentialsSource.fromValue(clientCredentialsSource);
    }

    /**
     * <p>
     * The source of the client credentials configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #clientCredentialsSource} will return {@link ClientCredentialsSource#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #clientCredentialsSourceAsString}.
     * </p>
     * 
     * @return The source of the client credentials configuration.
     * @see ClientCredentialsSource
     */
    public final String clientCredentialsSourceAsString() {
        return clientCredentialsSource;
    }

    /**
     * <p>
     * The detailed client credentials configuration including client ID, client secret, and token endpoint.
     * </p>
     * 
     * @return The detailed client credentials configuration including client ID, client secret, and token endpoint.
     */
    public final ClientCredentialsDetails clientCredentialsDetails() {
        return clientCredentialsDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(clientCredentialsSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientCredentialsDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientCredentialsGrantMetadata)) {
            return false;
        }
        ClientCredentialsGrantMetadata other = (ClientCredentialsGrantMetadata) obj;
        return Objects.equals(baseEndpoint(), other.baseEndpoint())
                && Objects.equals(clientCredentialsSourceAsString(), other.clientCredentialsSourceAsString())
                && Objects.equals(clientCredentialsDetails(), other.clientCredentialsDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientCredentialsGrantMetadata").add("BaseEndpoint", baseEndpoint())
                .add("ClientCredentialsSource", clientCredentialsSourceAsString())
                .add("ClientCredentialsDetails", clientCredentialsDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaseEndpoint":
            return Optional.ofNullable(clazz.cast(baseEndpoint()));
        case "ClientCredentialsSource":
            return Optional.ofNullable(clazz.cast(clientCredentialsSourceAsString()));
        case "ClientCredentialsDetails":
            return Optional.ofNullable(clazz.cast(clientCredentialsDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BaseEndpoint", BASE_ENDPOINT_FIELD);
        map.put("ClientCredentialsSource", CLIENT_CREDENTIALS_SOURCE_FIELD);
        map.put("ClientCredentialsDetails", CLIENT_CREDENTIALS_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClientCredentialsGrantMetadata, T> g) {
        return obj -> g.apply((ClientCredentialsGrantMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientCredentialsGrantMetadata> {
        /**
         * <p>
         * The base endpoint URL for the external service.
         * </p>
         * 
         * @param baseEndpoint
         *        The base endpoint URL for the external service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseEndpoint(String baseEndpoint);

        /**
         * <p>
         * The source of the client credentials configuration.
         * </p>
         * 
         * @param clientCredentialsSource
         *        The source of the client credentials configuration.
         * @see ClientCredentialsSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientCredentialsSource
         */
        Builder clientCredentialsSource(String clientCredentialsSource);

        /**
         * <p>
         * The source of the client credentials configuration.
         * </p>
         * 
         * @param clientCredentialsSource
         *        The source of the client credentials configuration.
         * @see ClientCredentialsSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientCredentialsSource
         */
        Builder clientCredentialsSource(ClientCredentialsSource clientCredentialsSource);

        /**
         * <p>
         * The detailed client credentials configuration including client ID, client secret, and token endpoint.
         * </p>
         * 
         * @param clientCredentialsDetails
         *        The detailed client credentials configuration including client ID, client secret, and token endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCredentialsDetails(ClientCredentialsDetails clientCredentialsDetails);

        /**
         * <p>
         * The detailed client credentials configuration including client ID, client secret, and token endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientCredentialsDetails.Builder}
         * avoiding the need to create one manually via {@link ClientCredentialsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientCredentialsDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #clientCredentialsDetails(ClientCredentialsDetails)}.
         * 
         * @param clientCredentialsDetails
         *        a consumer that will call methods on {@link ClientCredentialsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientCredentialsDetails(ClientCredentialsDetails)
         */
        default Builder clientCredentialsDetails(Consumer<ClientCredentialsDetails.Builder> clientCredentialsDetails) {
            return clientCredentialsDetails(ClientCredentialsDetails.builder().applyMutation(clientCredentialsDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String baseEndpoint;

        private String clientCredentialsSource;

        private ClientCredentialsDetails clientCredentialsDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientCredentialsGrantMetadata model) {
            baseEndpoint(model.baseEndpoint);
            clientCredentialsSource(model.clientCredentialsSource);
            clientCredentialsDetails(model.clientCredentialsDetails);
        }

        public final String getBaseEndpoint() {
            return baseEndpoint;
        }

        public final void setBaseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
        }

        @Override
        public final Builder baseEndpoint(String baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
            return this;
        }

        public final String getClientCredentialsSource() {
            return clientCredentialsSource;
        }

        public final void setClientCredentialsSource(String clientCredentialsSource) {
            this.clientCredentialsSource = clientCredentialsSource;
        }

        @Override
        public final Builder clientCredentialsSource(String clientCredentialsSource) {
            this.clientCredentialsSource = clientCredentialsSource;
            return this;
        }

        @Override
        public final Builder clientCredentialsSource(ClientCredentialsSource clientCredentialsSource) {
            this.clientCredentialsSource(clientCredentialsSource == null ? null : clientCredentialsSource.toString());
            return this;
        }

        public final ClientCredentialsDetails.Builder getClientCredentialsDetails() {
            return clientCredentialsDetails != null ? clientCredentialsDetails.toBuilder() : null;
        }

        public final void setClientCredentialsDetails(ClientCredentialsDetails.BuilderImpl clientCredentialsDetails) {
            this.clientCredentialsDetails = clientCredentialsDetails != null ? clientCredentialsDetails.build() : null;
        }

        @Override
        public final Builder clientCredentialsDetails(ClientCredentialsDetails clientCredentialsDetails) {
            this.clientCredentialsDetails = clientCredentialsDetails;
            return this;
        }

        @Override
        public ClientCredentialsGrantMetadata build() {
            return new ClientCredentialsGrantMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
