/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a column to be unpivoted, transforming it from a column into rows with associated values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnToUnpivot implements SdkPojo, Serializable, ToCopyableBuilder<ColumnToUnpivot.Builder, ColumnToUnpivot> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnName").getter(getter(ColumnToUnpivot::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()).build();

    private static final SdkField<String> NEW_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewValue").getter(getter(ColumnToUnpivot::newValue)).setter(setter(Builder::newValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD,
            NEW_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final String newValue;

    private ColumnToUnpivot(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.newValue = builder.newValue;
    }

    /**
     * <p>
     * The name of the column to unpivot from the source data.
     * </p>
     * 
     * @return The name of the column to unpivot from the source data.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * The value to assign to this column in the unpivoted result, typically the column name or a descriptive label.
     * </p>
     * 
     * @return The value to assign to this column in the unpivoted result, typically the column name or a descriptive
     *         label.
     */
    public final String newValue() {
        return newValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(newValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnToUnpivot)) {
            return false;
        }
        ColumnToUnpivot other = (ColumnToUnpivot) obj;
        return Objects.equals(columnName(), other.columnName()) && Objects.equals(newValue(), other.newValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnToUnpivot").add("ColumnName", columnName()).add("NewValue", newValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "NewValue":
            return Optional.ofNullable(clazz.cast(newValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ColumnName", COLUMN_NAME_FIELD);
        map.put("NewValue", NEW_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColumnToUnpivot, T> g) {
        return obj -> g.apply((ColumnToUnpivot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnToUnpivot> {
        /**
         * <p>
         * The name of the column to unpivot from the source data.
         * </p>
         * 
         * @param columnName
         *        The name of the column to unpivot from the source data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * The value to assign to this column in the unpivoted result, typically the column name or a descriptive label.
         * </p>
         * 
         * @param newValue
         *        The value to assign to this column in the unpivoted result, typically the column name or a descriptive
         *        label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newValue(String newValue);
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private String newValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnToUnpivot model) {
            columnName(model.columnName);
            newValue(model.newValue);
        }

        public final String getColumnName() {
            return columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final String getNewValue() {
            return newValue;
        }

        public final void setNewValue(String newValue) {
            this.newValue = newValue;
        }

        @Override
        public final Builder newValue(String newValue) {
            this.newValue = newValue;
            return this;
        }

        @Override
        public ColumnToUnpivot build() {
            return new ColumnToUnpivot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
