/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters that are required to connect to a Confluence data source
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfluenceParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfluenceParameters.Builder, ConfluenceParameters> {
    private static final SdkField<String> CONFLUENCE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfluenceUrl").getter(getter(ConfluenceParameters::confluenceUrl))
            .setter(setter(Builder::confluenceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfluenceUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFLUENCE_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String confluenceUrl;

    private ConfluenceParameters(BuilderImpl builder) {
        this.confluenceUrl = builder.confluenceUrl;
    }

    /**
     * <p>
     * The URL of the Confluence site to connect to.
     * </p>
     * 
     * @return The URL of the Confluence site to connect to.
     */
    public final String confluenceUrl() {
        return confluenceUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(confluenceUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfluenceParameters)) {
            return false;
        }
        ConfluenceParameters other = (ConfluenceParameters) obj;
        return Objects.equals(confluenceUrl(), other.confluenceUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfluenceParameters").add("ConfluenceUrl", confluenceUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfluenceUrl":
            return Optional.ofNullable(clazz.cast(confluenceUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfluenceUrl", CONFLUENCE_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfluenceParameters, T> g) {
        return obj -> g.apply((ConfluenceParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfluenceParameters> {
        /**
         * <p>
         * The URL of the Confluence site to connect to.
         * </p>
         * 
         * @param confluenceUrl
         *        The URL of the Confluence site to connect to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confluenceUrl(String confluenceUrl);
    }

    static final class BuilderImpl implements Builder {
        private String confluenceUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfluenceParameters model) {
            confluenceUrl(model.confluenceUrl);
        }

        public final String getConfluenceUrl() {
            return confluenceUrl;
        }

        public final void setConfluenceUrl(String confluenceUrl) {
            this.confluenceUrl = confluenceUrl;
        }

        @Override
        public final Builder confluenceUrl(String confluenceUrl) {
            this.confluenceUrl = confluenceUrl;
            return this;
        }

        @Override
        public ConfluenceParameters build() {
            return new ConfluenceParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
