/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateActionConnectorRequest extends QuickSightRequest implements
        ToCopyableBuilder<CreateActionConnectorRequest.Builder, CreateActionConnectorRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(CreateActionConnectorRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> ACTION_CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionConnectorId").getter(getter(CreateActionConnectorRequest::actionConnectorId))
            .setter(setter(Builder::actionConnectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionConnectorId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateActionConnectorRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CreateActionConnectorRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<AuthConfig> AUTHENTICATION_CONFIG_FIELD = SdkField
            .<AuthConfig> builder(MarshallingType.SDK_POJO).memberName("AuthenticationConfig")
            .getter(getter(CreateActionConnectorRequest::authenticationConfig)).setter(setter(Builder::authenticationConfig))
            .constructor(AuthConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationConfig").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateActionConnectorRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(CreateActionConnectorRequest::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcConnectionArn").getter(getter(CreateActionConnectorRequest::vpcConnectionArn))
            .setter(setter(Builder::vpcConnectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConnectionArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateActionConnectorRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            ACTION_CONNECTOR_ID_FIELD, NAME_FIELD, TYPE_FIELD, AUTHENTICATION_CONFIG_FIELD, DESCRIPTION_FIELD, PERMISSIONS_FIELD,
            VPC_CONNECTION_ARN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String awsAccountId;

    private final String actionConnectorId;

    private final String name;

    private final String type;

    private final AuthConfig authenticationConfig;

    private final String description;

    private final List<ResourcePermission> permissions;

    private final String vpcConnectionArn;

    private final List<Tag> tags;

    private CreateActionConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.actionConnectorId = builder.actionConnectorId;
        this.name = builder.name;
        this.type = builder.type;
        this.authenticationConfig = builder.authenticationConfig;
        this.description = builder.description;
        this.permissions = builder.permissions;
        this.vpcConnectionArn = builder.vpcConnectionArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the action connector.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the action connector.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * A unique identifier for the action connector. This ID must be unique within the Amazon Web Services account. The
     * <code>ActionConnectorId</code> must not start with the prefix <code>quicksuite-</code>
     * </p>
     * 
     * @return A unique identifier for the action connector. This ID must be unique within the Amazon Web Services
     *         account. The <code>ActionConnectorId</code> must not start with the prefix <code>quicksuite-</code>
     */
    public final String actionConnectorId() {
        return actionConnectorId;
    }

    /**
     * <p>
     * A descriptive name for the action connector.
     * </p>
     * 
     * @return A descriptive name for the action connector.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of action connector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ActionConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of action connector.
     * @see ActionConnectorType
     */
    public final ActionConnectorType type() {
        return ActionConnectorType.fromValue(type);
    }

    /**
     * <p>
     * The type of action connector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ActionConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of action connector.
     * @see ActionConnectorType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The authentication configuration for connecting to the external service. This includes the authentication type,
     * base URL, and authentication metadata such as client credentials or API keys.
     * </p>
     * 
     * @return The authentication configuration for connecting to the external service. This includes the authentication
     *         type, base URL, and authentication metadata such as client credentials or API keys.
     */
    public final AuthConfig authenticationConfig() {
        return authenticationConfig;
    }

    /**
     * <p>
     * An optional description of the action connector.
     * </p>
     * 
     * @return An optional description of the action connector.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permissions configuration that defines which users, groups, or namespaces can access this action connector
     * and what operations they can perform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The permissions configuration that defines which users, groups, or namespaces can access this action
     *         connector and what operations they can perform.
     */
    public final List<ResourcePermission> permissions() {
        return permissions;
    }

    /**
     * <p>
     * The ARN of the VPC connection to use for secure connectivity to the external service.
     * </p>
     * 
     * @return The ARN of the VPC connection to use for secure connectivity to the external service.
     */
    public final String vpcConnectionArn() {
        return vpcConnectionArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to apply to the action connector for resource management and organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to apply to the action connector for resource management and organization.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(actionConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateActionConnectorRequest)) {
            return false;
        }
        CreateActionConnectorRequest other = (CreateActionConnectorRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(actionConnectorId(), other.actionConnectorId()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(authenticationConfig(), other.authenticationConfig())
                && Objects.equals(description(), other.description()) && hasPermissions() == other.hasPermissions()
                && Objects.equals(permissions(), other.permissions())
                && Objects.equals(vpcConnectionArn(), other.vpcConnectionArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateActionConnectorRequest").add("AwsAccountId", awsAccountId())
                .add("ActionConnectorId", actionConnectorId())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString())
                .add("AuthenticationConfig", authenticationConfig())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Permissions", hasPermissions() ? permissions() : null).add("VpcConnectionArn", vpcConnectionArn())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "ActionConnectorId":
            return Optional.ofNullable(clazz.cast(actionConnectorId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "AuthenticationConfig":
            return Optional.ofNullable(clazz.cast(authenticationConfig()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "VpcConnectionArn":
            return Optional.ofNullable(clazz.cast(vpcConnectionArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("ActionConnectorId", ACTION_CONNECTOR_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("AuthenticationConfig", AUTHENTICATION_CONFIG_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("VpcConnectionArn", VPC_CONNECTION_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateActionConnectorRequest, T> g) {
        return obj -> g.apply((CreateActionConnectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateActionConnectorRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID associated with the action connector.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID associated with the action connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * A unique identifier for the action connector. This ID must be unique within the Amazon Web Services account.
         * The <code>ActionConnectorId</code> must not start with the prefix <code>quicksuite-</code>
         * </p>
         * 
         * @param actionConnectorId
         *        A unique identifier for the action connector. This ID must be unique within the Amazon Web Services
         *        account. The <code>ActionConnectorId</code> must not start with the prefix <code>quicksuite-</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionConnectorId(String actionConnectorId);

        /**
         * <p>
         * A descriptive name for the action connector.
         * </p>
         * 
         * @param name
         *        A descriptive name for the action connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of action connector.
         * </p>
         * 
         * @param type
         *        The type of action connector.
         * @see ActionConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionConnectorType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of action connector.
         * </p>
         * 
         * @param type
         *        The type of action connector.
         * @see ActionConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionConnectorType
         */
        Builder type(ActionConnectorType type);

        /**
         * <p>
         * The authentication configuration for connecting to the external service. This includes the authentication
         * type, base URL, and authentication metadata such as client credentials or API keys.
         * </p>
         * 
         * @param authenticationConfig
         *        The authentication configuration for connecting to the external service. This includes the
         *        authentication type, base URL, and authentication metadata such as client credentials or API keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationConfig(AuthConfig authenticationConfig);

        /**
         * <p>
         * The authentication configuration for connecting to the external service. This includes the authentication
         * type, base URL, and authentication metadata such as client credentials or API keys.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthConfig.Builder} avoiding the need to
         * create one manually via {@link AuthConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #authenticationConfig(AuthConfig)}.
         * 
         * @param authenticationConfig
         *        a consumer that will call methods on {@link AuthConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationConfig(AuthConfig)
         */
        default Builder authenticationConfig(Consumer<AuthConfig.Builder> authenticationConfig) {
            return authenticationConfig(AuthConfig.builder().applyMutation(authenticationConfig).build());
        }

        /**
         * <p>
         * An optional description of the action connector.
         * </p>
         * 
         * @param description
         *        An optional description of the action connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The permissions configuration that defines which users, groups, or namespaces can access this action
         * connector and what operations they can perform.
         * </p>
         * 
         * @param permissions
         *        The permissions configuration that defines which users, groups, or namespaces can access this action
         *        connector and what operations they can perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<ResourcePermission> permissions);

        /**
         * <p>
         * The permissions configuration that defines which users, groups, or namespaces can access this action
         * connector and what operations they can perform.
         * </p>
         * 
         * @param permissions
         *        The permissions configuration that defines which users, groups, or namespaces can access this action
         *        connector and what operations they can perform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(ResourcePermission... permissions);

        /**
         * <p>
         * The permissions configuration that defines which users, groups, or namespaces can access this action
         * connector and what operations they can perform.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission.Builder#build()} is called
         * immediately and its result is passed to {@link #permissions(List<ResourcePermission>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(java.util.Collection<ResourcePermission>)
         */
        Builder permissions(Consumer<ResourcePermission.Builder>... permissions);

        /**
         * <p>
         * The ARN of the VPC connection to use for secure connectivity to the external service.
         * </p>
         * 
         * @param vpcConnectionArn
         *        The ARN of the VPC connection to use for secure connectivity to the external service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnectionArn(String vpcConnectionArn);

        /**
         * <p>
         * A list of tags to apply to the action connector for resource management and organization.
         * </p>
         * 
         * @param tags
         *        A list of tags to apply to the action connector for resource management and organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to apply to the action connector for resource management and organization.
         * </p>
         * 
         * @param tags
         *        A list of tags to apply to the action connector for resource management and organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to apply to the action connector for resource management and organization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.quicksight.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String actionConnectorId;

        private String name;

        private String type;

        private AuthConfig authenticationConfig;

        private String description;

        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();

        private String vpcConnectionArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateActionConnectorRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            actionConnectorId(model.actionConnectorId);
            name(model.name);
            type(model.type);
            authenticationConfig(model.authenticationConfig);
            description(model.description);
            permissions(model.permissions);
            vpcConnectionArn(model.vpcConnectionArn);
            tags(model.tags);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getActionConnectorId() {
            return actionConnectorId;
        }

        public final void setActionConnectorId(String actionConnectorId) {
            this.actionConnectorId = actionConnectorId;
        }

        @Override
        public final Builder actionConnectorId(String actionConnectorId) {
            this.actionConnectorId = actionConnectorId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ActionConnectorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final AuthConfig.Builder getAuthenticationConfig() {
            return authenticationConfig != null ? authenticationConfig.toBuilder() : null;
        }

        public final void setAuthenticationConfig(AuthConfig.BuilderImpl authenticationConfig) {
            this.authenticationConfig = authenticationConfig != null ? authenticationConfig.build() : null;
        }

        @Override
        public final Builder authenticationConfig(AuthConfig authenticationConfig) {
            this.authenticationConfig = authenticationConfig;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<ResourcePermission.Builder> getPermissions() {
            List<ResourcePermission.Builder> result = ResourcePermissionListCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = ResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        @Override
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = ResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(ResourcePermission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getVpcConnectionArn() {
            return vpcConnectionArn;
        }

        public final void setVpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
        }

        @Override
        public final Builder vpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateActionConnectorRequest build() {
            return new CreateActionConnectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
