/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRoleMembershipRequest extends QuickSightRequest implements
        ToCopyableBuilder<CreateRoleMembershipRequest.Builder, CreateRoleMembershipRequest> {
    private static final SdkField<String> MEMBER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberName").getter(getter(CreateRoleMembershipRequest::memberName)).setter(setter(Builder::memberName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("MemberName").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(CreateRoleMembershipRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(CreateRoleMembershipRequest::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Namespace").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(CreateRoleMembershipRequest::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Role").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_NAME_FIELD,
            AWS_ACCOUNT_ID_FIELD, NAMESPACE_FIELD, ROLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String memberName;

    private final String awsAccountId;

    private final String namespace;

    private final String role;

    private CreateRoleMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.memberName = builder.memberName;
        this.awsAccountId = builder.awsAccountId;
        this.namespace = builder.namespace;
        this.role = builder.role;
    }

    /**
     * <p>
     * The name of the group that you want to add to the role.
     * </p>
     * 
     * @return The name of the group that you want to add to the role.
     */
    public final String memberName() {
        return memberName;
    }

    /**
     * <p>
     * The ID for the Amazon Web Services account that you want to create a group in. The Amazon Web Services account ID
     * that you provide must be the same Amazon Web Services account that contains your Amazon Quick Sight account.
     * </p>
     * 
     * @return The ID for the Amazon Web Services account that you want to create a group in. The Amazon Web Services
     *         account ID that you provide must be the same Amazon Web Services account that contains your Amazon Quick
     *         Sight account.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The namespace that the role belongs to.
     * </p>
     * 
     * @return The namespace that the role belongs to.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The role that you want to add a group to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link Role#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role that you want to add a group to.
     * @see Role
     */
    public final Role role() {
        return Role.fromValue(role);
    }

    /**
     * <p>
     * The role that you want to add a group to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link Role#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role that you want to add a group to.
     * @see Role
     */
    public final String roleAsString() {
        return role;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(memberName());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoleMembershipRequest)) {
            return false;
        }
        CreateRoleMembershipRequest other = (CreateRoleMembershipRequest) obj;
        return Objects.equals(memberName(), other.memberName()) && Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(namespace(), other.namespace()) && Objects.equals(roleAsString(), other.roleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRoleMembershipRequest").add("MemberName", memberName())
                .add("AwsAccountId", awsAccountId()).add("Namespace", namespace()).add("Role", roleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MemberName":
            return Optional.ofNullable(clazz.cast(memberName()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MemberName", MEMBER_NAME_FIELD);
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("Namespace", NAMESPACE_FIELD);
        map.put("Role", ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRoleMembershipRequest, T> g) {
        return obj -> g.apply((CreateRoleMembershipRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRoleMembershipRequest> {
        /**
         * <p>
         * The name of the group that you want to add to the role.
         * </p>
         * 
         * @param memberName
         *        The name of the group that you want to add to the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberName(String memberName);

        /**
         * <p>
         * The ID for the Amazon Web Services account that you want to create a group in. The Amazon Web Services
         * account ID that you provide must be the same Amazon Web Services account that contains your Amazon Quick
         * Sight account.
         * </p>
         * 
         * @param awsAccountId
         *        The ID for the Amazon Web Services account that you want to create a group in. The Amazon Web Services
         *        account ID that you provide must be the same Amazon Web Services account that contains your Amazon
         *        Quick Sight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The namespace that the role belongs to.
         * </p>
         * 
         * @param namespace
         *        The namespace that the role belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The role that you want to add a group to.
         * </p>
         * 
         * @param role
         *        The role that you want to add a group to.
         * @see Role
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Role
         */
        Builder role(String role);

        /**
         * <p>
         * The role that you want to add a group to.
         * </p>
         * 
         * @param role
         *        The role that you want to add a group to.
         * @see Role
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Role
         */
        Builder role(Role role);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String memberName;

        private String awsAccountId;

        private String namespace;

        private String role;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRoleMembershipRequest model) {
            super(model);
            memberName(model.memberName);
            awsAccountId(model.awsAccountId);
            namespace(model.namespace);
            role(model.role);
        }

        public final String getMemberName() {
            return memberName;
        }

        public final void setMemberName(String memberName) {
            this.memberName = memberName;
        }

        @Override
        public final Builder memberName(String memberName) {
            this.memberName = memberName;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(Role role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRoleMembershipRequest build() {
            return new CreateRoleMembershipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
